(ns org.euandre.http.interceptors
  (:require [clojure.spec.alpha :as s]
            [io.pedestal.http.body-params :as body-params]
            [io.pedestal.interceptor :as i]
            [io.pedestal.interceptor.chain :as i.chain]
            [org.euandre.http.exception :as exception]))

(defn- terminate-with [context response]
  (i.chain/terminate (assoc context :response response)))

(def valid-query?
  (i/interceptor
   {:name  ::valid-query?
    :enter (fn valid-query?-fn [{{:keys [edn-params]} :request :as context}]
             (if-let [error-reason (cond
                                     (not (map? edn-params))         "Body isn't an edn map."
                                     (not (vector? (:q edn-params))) "[:q] in body isn't an edn vector.")]
               (exception/invalid-input! {:exception/reason     ::bad-query
                                          :exception/reason-str error-reason
                                          :exception/body       edn-params})
               context))}))

(def body-params
  (body-params/body-params
   (body-params/default-parser-map
     :edn-options {:readers (merge default-data-readers *data-readers*)})))

(def catch
  (i/interceptor
   {:name  ::catch
    :error (fn [{:keys [debug? env] :as context} error]
             (let [{:exception/keys [msg reason-str status-code] :keys [exception]} (ex-data error)]
               (println exception)
               (terminate-with context {:status status-code
                                        :body   {:error  (or msg "Server Error")
                                                 :reason reason-str}})))}))
