(ns ttt-clojure.participants.human
  (:require [ttt-clojure.ui.command-line :as command-line :refer :all]
            [ttt-clojure.board :as board :refer :all]))

(defn take-turn [board]
  (writeln "Please make a move: ")
  (loop []
    (let [move (read-int)]
      (cond
        (>= 0 move) 
        (do 
          (writeln "Move too low, try again: ")
          (recur))
        (< (count board) move) 
        (do 
          (writeln "Move too high, try again: ")
          (recur))
        (taken? board move) 
        (do 
          (writeln "Move taken, try again: ")
          (recur))
        :else move))))

