(ns s3sync.misc
  (:require clojure.edn [clojure.java.io :as io]))

(defmacro write-safe [writer & msgs]
  `(when ~writer
     (.write ~writer (str ~@msgs))
     (.flush ~writer)))

(defmacro debug-wrap [writer msg & forms]
  `(do (write-safe ~writer ~msg "... ")
     (let [r# (do ~@forms)]
       (write-safe ~writer "Done\n")
       r#)))

(defmacro debug-result [writer msg & forms]
  `(do (write-safe ~writer ~msg "... ")
     (let [r# (do ~@forms)]
       (write-safe ~writer r# "\n")
       r#)))

(defn read-resource
  "Reads an EDN resource from the classpath."
  [r]
  (-> r io/resource io/reader java.io.PushbackReader. clojure.edn/read))

(defn runmap [& args]
 (dorun (apply map args))) 
