/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScroller;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    NSScrollView scrollView;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    boolean accessibilityIsIgnored(int n, int n2) {
        if (this.scrollView != null && n == this.scrollView.id) {
            return true;
        }
        return super.accessibilityIsIgnored(n, n2);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.scrollView != null) {
            NSSize nSSize = new NSSize();
            nSSize.width = n3;
            nSSize.height = n4;
            int n5 = this.hasBorder() ? 2 : 0;
            nSSize = NSScrollView.frameSizeForContentSize(nSSize, (this.style & 0x100) != 0, (this.style & 0x200) != 0, n5);
            n3 = (int)nSSize.width;
            n4 = (int)nSSize.height;
            NSRect nSRect = this.scrollView.contentView().frame();
            n = (int)((float)n - nSRect.x);
            n2 = (int)((float)n2 - nSRect.y);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    ScrollBar createScrollBar(int n) {
        int n2;
        if (this.scrollView == null) {
            return null;
        }
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.parent = this;
        scrollBar.style = n;
        scrollBar.display = this.display;
        NSRect nSRect = new NSRect();
        if ((n & 0x100) != 0) {
            nSRect.width = 1.0f;
        } else {
            nSRect.height = 1.0f;
        }
        NSScroller nSScroller = (NSScroller)new SWTScroller().alloc();
        nSScroller.initWithFrame(nSRect);
        if ((n & 0x100) != 0) {
            this.scrollView.setHorizontalScroller(nSScroller);
            n2 = OS.sel_sendHorizontalSelection;
        } else {
            this.scrollView.setVerticalScroller(nSScroller);
            n2 = OS.sel_sendVerticalSelection;
        }
        scrollBar.view = nSScroller;
        scrollBar.createJNIRef();
        scrollBar.register();
        if ((this.state & 2) == 0) {
            scrollBar.target = nSScroller.target();
            scrollBar.actionSelector = nSScroller.action();
        }
        nSScroller.setTarget(this.scrollView);
        nSScroller.setAction(n2);
        if ((this.state & 2) != 0) {
            scrollBar.updateBar(0, 0, 100, 10);
        }
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.scrollView != null) {
            NSSize nSSize = this.scrollView.contentSize();
            NSClipView nSClipView = this.scrollView.contentView();
            NSRect nSRect = nSClipView.bounds();
            return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSSize.width, (int)nSSize.height);
        }
        NSRect nSRect = this.view.bounds();
        return new Rectangle(0, 0, (int)nSRect.width, (int)nSRect.height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    boolean isEventView(int n) {
        return n == this.eventView().id;
    }

    boolean isTrim(NSView nSView) {
        if (this.scrollView != null) {
            if (this.scrollView.id == nSView.id) {
                return true;
            }
            if (this.horizontalBar != null && this.horizontalBar.view.id == nSView.id) {
                return true;
            }
            if (this.verticalBar != null && this.verticalBar.view.id == nSView.id) {
                return true;
            }
        }
        return super.isTrim(nSView);
    }

    void register() {
        super.register();
        if (this.scrollView != null) {
            this.display.addWidget(this.scrollView, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.scrollView != null) {
            this.scrollView.release();
        }
        this.scrollView = null;
    }

    void releaseChildren(boolean bl) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl);
    }

    void sendHorizontalSelection() {
        if ((this.state & 2) == 0 && this.scrollView != null && this.visibleRgn == 0) {
            this.scrollView.contentView().setCopiesOnScroll(!this.isObscured());
        }
        this.horizontalBar.sendSelection();
    }

    void sendVerticalSelection() {
        if ((this.state & 2) == 0 && this.scrollView != null && this.visibleRgn == 0) {
            this.scrollView.contentView().setCopiesOnScroll(!this.isObscured());
        }
        this.verticalBar.sendSelection();
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (this.horizontalBar != null) {
            this.horizontalBar.enableWidget(bl);
        }
        if (this.verticalBar != null) {
            this.verticalBar.enableWidget(bl);
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        if (this.scrollView == null) {
            return false;
        }
        if ((this.state & 2) == 0) {
            return false;
        }
        if (bl) {
            if ((scrollBar.state & 0x10) == 0) {
                return false;
            }
            scrollBar.state &= 0xFFFFFFEF;
        } else {
            if ((scrollBar.state & 0x10) != 0) {
                return false;
            }
            scrollBar.state |= 0x10;
        }
        if ((scrollBar.style & 0x100) != 0) {
            this.scrollView.setHasHorizontalScroller(bl);
        } else {
            this.scrollView.setHasVerticalScroller(bl);
        }
        scrollBar.sendEvent(bl ? 22 : 23);
        this.sendEvent(11);
        return true;
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    NSView topView() {
        if (this.scrollView != null) {
            return this.scrollView;
        }
        return super.topView();
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(bl, this.scrollView);
        NSClipView nSClipView = this.scrollView.contentView();
        this.updateCursorRects(bl, nSClipView);
    }
}

