/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Library {
    static int MAJOR_VERSION = 3;
    static int MINOR_VERSION = 557;
    static int REVISION = 0;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    static final String SEPARATOR;
    static boolean IS_64;
    static final String SUFFIX_64 = "-64";
    static final String SWTDIR_32 = "swtlib-32";
    static final String SWTDIR_64 = "swtlib-64";
    static /* synthetic */ Class class$0;

    static {
        IS_64 = false;
        SEPARATOR = System.getProperty("file.separator");
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }

    static int parseVersion(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n2 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n3 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return Library.JAVA_VERSION(n, n2, n3);
    }

    public static int JAVA_VERSION(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    public static int SWT_VERSION(int n, int n2) {
        return n * 1000 + n2;
    }

    static boolean extract(String string, String string2) {
        block19: {
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            File file = new File(string);
            boolean bl = false;
            try {
                if (!file.exists()) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.swt.internal.Library");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((inputStream = clazz.getResourceAsStream("/" + string2)) != null) {
                        int n;
                        bl = true;
                        byte[] byArray = new byte[4096];
                        fileOutputStream = new FileOutputStream(string);
                        while ((n = inputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        fileOutputStream.close();
                        inputStream.close();
                        if (!"cocoa".equals("win32")) {
                            try {
                                Runtime.getRuntime().exec(new String[]{"chmod", "755", string}).waitFor();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                if (Library.load(string)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                if (!bl || !file.exists()) break block19;
                file.delete();
            }
        }
        return false;
    }

    static boolean load(String string) {
        try {
            if (string.indexOf(SEPARATOR) != -1) {
                System.load(string);
            } else {
                System.loadLibrary(string);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static void loadLibrary(String string) {
        Library.loadLibrary(string, true);
    }

    public static void loadLibrary(String string, boolean bl) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = System.getProperty("sun.arch.data.model");
        if (string7 == null) {
            string7 = System.getProperty("com.ibm.vm.bitmode");
        }
        if (string7 != null) {
            if ("32".equals(string7) && IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
            }
            if ("64".equals(string7) && !IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 32-bit SWT libraries on 64-bit JVM");
            }
        }
        if (bl) {
            string6 = System.getProperty("swt.version");
            if (string6 == null) {
                string6 = "" + MAJOR_VERSION;
                if (MINOR_VERSION < 10) {
                    string6 = String.valueOf(string6) + "00";
                } else if (MINOR_VERSION < 100) {
                    string6 = String.valueOf(string6) + "0";
                }
                string6 = String.valueOf(string6) + MINOR_VERSION;
                if (REVISION > 0) {
                    string6 = String.valueOf(string6) + "r" + REVISION;
                }
            }
            string5 = String.valueOf(string) + "-" + "cocoa" + "-" + string6;
            string4 = String.valueOf(string) + "-" + "cocoa";
            string3 = Library.mapLibraryName(string5);
            string2 = Library.mapLibraryName(string4);
        } else {
            string3 = string2 = string;
            string4 = string2;
            string5 = string2;
        }
        string6 = System.getProperty("swt.library.path");
        if (string6 != null) {
            if (Library.load(String.valueOf(string6 = new File(string6).getAbsolutePath()) + SEPARATOR + string3)) {
                return;
            }
            if (bl && Library.load(String.valueOf(string6) + SEPARATOR + string2)) {
                return;
            }
        }
        if (Library.load(string5)) {
            return;
        }
        if (bl && Library.load(string4)) {
            return;
        }
        String string8 = string3;
        String string9 = string2;
        if (string6 == null) {
            string6 = System.getProperty("java.io.tmpdir");
            File file = new File(string6, IS_64 ? SWTDIR_64 : SWTDIR_32);
            boolean bl2 = false;
            if (file.exists() && file.isDirectory() || (bl2 = file.mkdir())) {
                string6 = file.getAbsolutePath();
                if (bl2 && !"cocoa".equals("win32")) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "777", string6}).waitFor();
                    }
                    catch (Throwable throwable) {}
                }
            } else if (IS_64) {
                string8 = Library.mapLibraryName(String.valueOf(string5) + SUFFIX_64);
                string9 = Library.mapLibraryName(String.valueOf(string4) + SUFFIX_64);
            }
            if (Library.load(String.valueOf(string6) + SEPARATOR + string8)) {
                return;
            }
            if (bl && Library.load(String.valueOf(string6) + SEPARATOR + string9)) {
                return;
            }
        }
        if (string6 != null) {
            if (Library.extract(String.valueOf(string6) + SEPARATOR + string8, string3)) {
                return;
            }
            if (bl && Library.extract(String.valueOf(string6) + SEPARATOR + string9, string2)) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + string5 + " or " + string4 + " in swt.library.path, java.library.path or the jar file");
    }

    static String mapLibraryName(String string) {
        String string2;
        if ((string = System.mapLibraryName(string)).endsWith(string2 = ".dylib")) {
            string = String.valueOf(string.substring(0, string.length() - string2.length())) + ".jnilib";
        }
        return string;
    }
}

