/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class PartialMatchReport {
    Module module;
    List<Match> matches;
    Map<Rule, List<PartialMatchInfo>> infos = new HashMap<Rule, List<PartialMatchInfo>>();

    public Map<Rule, List<PartialMatchInfo>> getInfos() {
        return this.infos;
    }

    public PartialMatchReport(Module module, List<Match> matches) {
        this.module = module;
        this.matches = matches;
    }

    public Module getModule() {
        return this.module;
    }

    public String getReport() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("============================\n");
        buffer.append("Partial match statistics\n");
        if (this.infos.isEmpty()) {
            buffer.append("No matches were found.\n");
        } else {
            for (Rule rule : this.infos.keySet()) {
                for (PartialMatchInfo partialMatchInfo : this.infos.get(rule)) {
                    if (partialMatchInfo.isComplete()) {
                        buffer.append("============================\n");
                        buffer.append("This is a complete match for " + rule.getName() + "\n");
                        buffer.append(String.valueOf(partialMatchInfo.getMatch().toString()) + "\n");
                        continue;
                    }
                    buffer.append("============================\n");
                    buffer.append("This is a partial match for " + rule.getName() + "\n");
                    buffer.append(String.valueOf(partialMatchInfo.getMatch().toString()) + "\n");
                    buffer.append("----------------------------------\n");
                    buffer.append("Deltas are:\n");
                    buffer.append(String.valueOf(partialMatchInfo.getDelta().toString()) + "\n");
                    for (Node node : partialMatchInfo.getDelta().getNodes()) {
                        buffer.append(String.valueOf(node.toString()) + "\n");
                    }
                    for (Edge edge : partialMatchInfo.getDelta().getEdges()) {
                        buffer.append(String.valueOf(edge.toString()) + "\n");
                    }
                }
            }
        }
        buffer.append("============================\n");
        return buffer.toString();
    }

    public void collectPartialMatchInfos(Rule originalRule, List<Match> matches) {
        for (Match match : matches) {
            if (!this.infos.containsKey(originalRule)) {
                this.infos.put(originalRule, new ArrayList());
            }
            PartialMatchInfo info = new PartialMatchInfo();
            info.setMatch(match);
            info.setDelta(this.computeDelta(originalRule, match, info));
            if (info.getDelta().getNodes().isEmpty() && info.getDelta().getEdges().isEmpty()) {
                info.setComplete(true);
            }
            double coverage = 1.0 - (double)(info.getDelta().getNodes().size() + info.getDelta().getEdges().size()) / (double)(originalRule.getLhs().getNodes().size() + originalRule.getLhs().getEdges().size());
            coverage = (double)Math.round(100.0 * coverage) / 100.0;
            info.setCoverage(coverage);
            this.infos.get(originalRule).add(info);
        }
    }

    private Graph computeDelta(Rule originalRule, Match match, PartialMatchInfo info) {
        Graph delta = HenshinFactory.eINSTANCE.createGraph("Partial match delta for " + originalRule.getName());
        HashMap<Node, Node> originalRuleNodes2deltaNodes = new HashMap<Node, Node>();
        for (Node originalRuleNode : originalRule.getLhs().getNodes()) {
            Node deltaNode = HenshinFactory.eINSTANCE.createNode(delta, originalRuleNode.getType(), originalRuleNode.getName());
            info.deltaNodes2originalRuleNodes.put(deltaNode, originalRuleNode);
            originalRuleNodes2deltaNodes.put(originalRuleNode, deltaNode);
        }
        for (Edge edge : originalRule.getLhs().getEdges()) {
            HenshinFactory.eINSTANCE.createEdge((Node)originalRuleNodes2deltaNodes.get(edge.getSource()), (Node)originalRuleNodes2deltaNodes.get(edge.getTarget()), edge.getType());
        }
        Rule matchingRule = match.getRule();
        for (Node nodeInMatchingRule : matchingRule.getLhs().getNodes()) {
            Node nodeToRemove = null;
            for (Node nodeInDelta : delta.getNodes()) {
                if (!nodeInMatchingRule.getType().equals(nodeInDelta.getType()) || nodeInMatchingRule.getName() != nodeInDelta.getName()) continue;
                nodeToRemove = nodeInDelta;
                break;
            }
            delta.removeNode(nodeToRemove);
            info.deltaNodes2originalRuleNodes.remove(nodeToRemove);
        }
        info.setDelta(delta);
        return delta;
    }

    public double getCoverage() {
        double coverage = 0.0;
        if (!this.infos.isEmpty()) {
            for (Rule rule : this.infos.keySet()) {
                for (PartialMatchInfo info : this.infos.get(rule)) {
                    coverage += info.getCoverage();
                }
            }
            coverage /= (double)this.infos.keySet().size();
        }
        return coverage;
    }

    public class PartialMatchInfo {
        Match match;
        Graph delta;
        private Map<Node, Node> deltaNodes2originalRuleNodes = new HashMap<Node, Node>();
        boolean isComplete = false;
        double coverage;

        public Map<Node, Node> getDeltaNodes2originalRuleNodes() {
            return this.deltaNodes2originalRuleNodes;
        }

        public double getCoverage() {
            return this.coverage;
        }

        public void setCoverage(double coverage) {
            this.coverage = coverage;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public void setComplete(boolean isComplete) {
            this.isComplete = isComplete;
        }

        public Match getMatch() {
            return this.match;
        }

        public void setMatch(Match match) {
            this.match = match;
        }

        public Graph getDelta() {
            return this.delta;
        }

        public void setDelta(Graph delta) {
            this.delta = delta;
        }
    }
}

