;; Compiled from src/funcgo/codegen.go
(ns
 funcgo.codegen
 (:gen-class)
 (:require
  [clojure.string :as s]
  [instaparse.core :as insta]
  [funcgo.symboltable :as symbols]))

(set! *warn-on-reflection* true)

(defn-
 code-generator
 [symbol-table goscript?]
 (do
  (defn- no-dot [^String s] (not (re-find #"\." s)))
  (defn-
   java-class?
   [clazz]
   (try (Class/forName clazz) true (catch Exception e false)))
  (defn-
   has-type
   [^String typ]
   (or
    (or
     (symbols/Has-type symbol-table typ)
     (and goscript? (. typ (startsWith "js."))))
    (and
     (and (not goscript?) (no-dot typ))
     (java-class? (str "java.lang." typ)))))
  (defn- list-str [& item] (str "(" (s/join " " item) ")"))
  (defn- blank-join [& xs] (s/join " " xs))
  (defn- vec-str [& item] (str "[" (s/join " " item) "]"))
  (defn-
   infix
   ([expression] expression)
   ([left operator right] (list-str operator left right)))
  (defn-
   public?
   [identifier]
   (or (re-find #"^[A-Z]" identifier) (= identifier "main")))
  (defn- constant-func [s] (fn [] s))
  (defn-
   split-path
   [^String path]
   (let
    [slash
     (. path (lastIndexOf (long \/)))
     before-slash
     (subs path 0 (+ slash 1))
     after-slash
     (subs path (+ slash 1))]
    [(s/replace before-slash \/ \.)
     (s/replace after-slash #"\.gos?$" "")]))
  (defn-
   decl-block-func
   [typ]
   (fn
    [& xs]
    (let
     [consts (butlast xs) expressions (last xs)]
     (str "(" typ " [" (s/join " " consts) "] " expressions ")"))))
  (defn-
   import-spec
   ([imported] (import-spec (last (s/split imported #"\.")) imported))
   ([identifier imported]
    (do
     (symbols/Package-imported symbol-table identifier)
     (vec-str imported ":as" identifier))))
  (defn-
   extern-import-spec
   [identifier]
   (do (symbols/Package-imported symbol-table identifier) ""))
  (defn-
   vardecl
   ([identifier expression]
    (if
     (public? identifier)
     (list-str "def" identifier expression)
     (list-str "def" "^:private" identifier expression)))
   ([identifier typ expression]
    (if
     (public? identifier)
     (list-str "def" (str "^" typ) identifier expression)
     (list-str
      "def"
      "^:private"
      (str "^" typ)
      identifier
      expression))))
  {:javafield
   (fn [expression identifier] (list-str "." expression identifier)),
   :hexdigit identity,
   :mulop identity,
   :symbol
   (fn
    ([identifier] identifier)
    ([pkg identifier]
     (do
      (when
       (not (symbols/Has-package symbol-table pkg))
       (throw
        (Exception.
         (format
          "package \"%s\" in %s.%s does not appear in imports %s"
          pkg
          pkg
          identifier
          (symbols/Packages symbol-table)))))
      (str pkg "/" identifier)))),
   :deref (fn* [p1__26#] (str "@" p1__26#)),
   :typepackageimportspec (fn* [& rest__7#] (s/join "." rest__7#)),
   :vecdestruct vec-str,
   :sourcefile (fn [header body] (str header " " body)),
   :typedidentifiers
   (fn
    [& args]
    (let
     [typ
      (last args)
      identifiers
      (butlast args)
      decls
      (for [identifier identifiers] (str "^" typ " " identifier))]
     (apply blank-join decls))),
   :catches blank-join,
   :identifier
   (fn
    [string]
    (s/replace
     string
     #"\p{Ll}\p{Lu}"
     (fn*
      [p1__19#]
      (str (first p1__19#) "-" (s/lower-case (last p1__19#)))))),
   :bitxor (constant-func "bit-xor"),
   :forrange
   (fn
    [identifier seq expressions]
    (str "(doseq [" identifier " " seq "] " expressions ")")),
   :shortfunctionlit
   (fn
    [expr]
    (if
     (and (= (first expr) \() (= (last expr) \)))
     (str "#" expr)
     (list-str "fn" "[]" expr))),
   :exponent str,
   :octaldigit identity,
   :topwithconst (decl-block-func "let"),
   :decimals identity,
   :associtem blank-join,
   :constantlist (fn ([c] c) ([c0 & c] (apply list-str c0 c))),
   :addop identity,
   :constcaseclause blank-join,
   :assoc (fn [symbol & items] (apply list-str "assoc" symbol items)),
   :spacechar (constant-func "\\space"),
   :letconstswitch
   (fn
    [lhs rhs expr & clauses]
    (str
     "(let ["
     lhs
     " "
     rhs
     "] "
     (apply list-str "case" expr clauses)
     ")")),
   :string (constant-func "String"),
   :interpretedstringlit
   (fn* [& rest__22#] (str "\"" (apply str rest__22#) "\"")),
   :withconst (decl-block-func "let"),
   :regex
   (fn*
    [& rest__21#]
    (str "#\"" (s/escape (apply str rest__21#) {\" "\\\""}) "\"")),
   :javastatic (fn* [& rest__30#] (s/join "/" rest__30#)),
   :structspec
   (fn
    [java-identifier & fields]
    (do
     (symbols/Type-created symbol-table java-identifier)
     (list-str
      "defrecord"
      java-identifier
      (apply vec-str fields)
      (if
       (empty? fields)
       ""
       (let
        [fs
         (s/split (nth fields 0) #" +")
         fs-only
         (filter (fn [^String s] (not (. s (startsWith "^")))) fs)]
        (str
         "Object (toString [this] "
         (list-str "str" "\"{\"" (s/join " \" \" " fs-only) "\"}\"")
         ")")))))),
   :associn
   (fn [symbol path value] (list-str "assoc-in" symbol path value)),
   :syntaxquote (fn* [p1__27#] (str "`" p1__27#)),
   :typedidentifier (fn [identifier typ] (str "^" typ " " identifier)),
   :typename
   (fn
    [& segments]
    (let
     [typ (s/join "." segments)]
     (when
      (not (has-type typ))
      (throw
       (Exception.
        (format
         "type \"%s\" does not appear in type imports %s"
         typ
         (symbols/Types symbol-table)))))
     typ)),
   :functionpart0
   (fn
    ([expression] (str "[] " expression))
    ([typ expression] (str "^" typ " [] " expression))),
   :littleuvalue (fn [d1 d2 d3 d4] (str "\\u" d1 d2 d3 d4)),
   :percent (constant-func "%"),
   :methodparameters blank-join,
   :javamethodcall
   (fn
    ([expression identifier]
     (str "(. " expression " (" identifier "))"))
    ([expression identifier call]
     (str "(. " expression " (" identifier " " call "))"))),
   :typeclassesimportspec blank-join,
   :functioncall
   (fn
    ([function] (list-str function))
    ([function call] (list-str function call))),
   :expressionlist blank-join,
   :block
   (fn
    ([expr] expr)
    ([expr0 & expr-rest]
     (str "(do " (s/join " " (cons expr0 expr-rest)) ")"))),
   :importspec import-spec,
   :const (fn [identifier expression] (str identifier " " expression)),
   :boolcaseclause blank-join,
   :or (constant-func "or"),
   :shiftleft (constant-func "bit-shift-left"),
   :typeimportdecl
   (fn
    ([] "")
    ([& import-specs] (apply list-str ":import" import-specs))),
   :variadicdestruct (fn* [p1__11#] (str "& " p1__11#)),
   :functionparts
   (fn* [& rest__14#] (str "(" (s/join ") (" rest__14#) ")")),
   :vfunctionpart0
   (fn
    ([variadic expression] (str "[" variadic "] " expression))
    ([variadic typ expression]
     (str "^" typ " [" variadic "] " expression))),
   :unquotesplicing (fn* [p1__29#] (str "~@" p1__29#)),
   :dictdestructelem (fn [destruct label] (str destruct " " label)),
   :expressions blank-join,
   :precedence0 infix,
   :forlazy
   (fn
    ([identifier seq expressions]
     (str "(for [" identifier " " seq "] " expressions ")"))
    ([identifier seq condition expressions]
     (str
      "(for ["
      identifier
      " "
      seq
      " :when "
      condition
      "] "
      expressions
      ")"))),
   :shiftright (constant-func "bit-shift-right"),
   :voidmethodspec
   (fn
    ([java-identifier] (list-str java-identifier "[this]"))
    ([java-identifier methodparams]
     (list-str java-identifier (str "[this " methodparams "]")))),
   :implements
   (fn
    [protocol concrete & methodimpls]
    (do
     (symbols/Type-created symbol-table concrete)
     (apply
      list-str
      (concat (list "extend-type" concrete protocol) methodimpls)))),
   :precedence1 infix,
   :escapedslash (constant-func "/"),
   :tryexpr
   (fn
    ([expressions catches] (list-str "try" expressions catches))
    ([expressions catches finally]
     (list-str "try" expressions catches finally))),
   :unicodechar (fn* [p1__23#] (str "\\" p1__23#)),
   :rawstringlit
   (fn*
    [p1__24#]
    (str "\"" (s/escape p1__24# char-escape-string) "\"")),
   :functionlit (fn* [p1__12#] (list-str "fn" p1__12#)),
   :equals (constant-func "="),
   :noteq (constant-func "not="),
   :untypedmethodimpl
   (fn
    ([name block] (list-str name (str "[this]") block))
    ([name params block]
     (list-str name (str "[this " params "]") block))),
   :arrayvardecl
   (fn
    [identifier number typ]
    (let
     [elements
      (apply blank-join (dotimes [_ (read-string number)] "nil"))]
     (list-str "def" identifier (list-str "vector" elements)))),
   :percentvaradic (constant-func "%&"),
   :clojureescape identity,
   :squotechar (constant-func "\\'"),
   :precedence5 infix,
   :vardecl2
   (fn
    ([identifier1 identifier2 expression1 expression2]
     (blank-join
      (vardecl identifier1 expression1)
      (vardecl identifier2 expression2)))
    ([identifier1 identifier2 typ expression1 expression2]
     (blank-join
      (vardecl identifier1 typ expression1)
      (vardecl identifier2 typ expression2)))),
   :typedmethodimpl
   (fn
    ([name typ block]
     (list-str (str "^" typ) name (str "[this]") block))
    ([name params typ block]
     (list-str (str "^" typ) name (str "[this " params "]") block))),
   :tabchar (constant-func "\\tab"),
   :escapedidentifier identity,
   :methodimpl
   (fn [java-identifier function] (list-str java-identifier function)),
   :externimportspec extern-import-spec,
   :precedence4 infix,
   :vardecl1 vardecl,
   :and (constant-func "and"),
   :parameters blank-join,
   :constswitch
   (fn [expr & clauses] (apply list-str "case" expr clauses)),
   :newlinechar (constant-func "\\newline"),
   :typeswitch
   (fn
    [x & args]
    (do
     (defn-
      recursing
      [acc remaining]
      (do
       (defn-
        type-case
        []
        (let
         [typ (first remaining) expr (second remaining)]
         (str acc " " (list-str "instance?" typ x) " " expr)))
       (case
        (count remaining)
        1
        (let [[expr] remaining] (str acc " :else " expr ")"))
        2
        (str (type-case) ")")
        (recur (type-case) (drop 2 remaining)))))
     (recursing "(cond" args))),
   :unquote (fn* [p1__28#] (str "~" p1__28#)),
   :functionpartn
   (fn
    ([parameters expression] (str "[" parameters "] " expression))
    ([parameters typ expression]
     (str "^" typ " [" parameters "] " expression))),
   :precedence3 infix,
   :finally (fn* [p1__8#] (list-str "finally" p1__8#)),
   :veclit vec-str,
   :dquotechar (constant-func "\\\""),
   :shortvardecl
   (fn
    [identifier expression]
    (if
     (public? identifier)
     (list-str "def" identifier expression)
     (list-str "def" "^:private" identifier expression))),
   :backspacechar (constant-func "\\backspace"),
   :functiondecl
   (fn
    [identifier function]
    (let
     [defn (if (public? identifier) "defn" "defn-")]
     (list-str defn identifier function))),
   :precedence2 infix,
   :mod (constant-func "mod"),
   :dashidentifier (fn* [p1__25#] (str "-" p1__25#)),
   :catch
   (fn
    [typ exception expressions]
    (list-str "catch" typ exception expressions)),
   :double (constant-func "double"),
   :dictelement (fn [key value] (str key " " value " ")),
   :floatlit str,
   :bigfloatlit str,
   :returnchar (constant-func "\\return"),
   :typedmethodspec
   (fn
    ([java-identifier typ]
     (list-str (str "^" typ) java-identifier "[this]"))
    ([java-identifier methodparams typ]
     (list-str
      (str "^" typ)
      java-identifier
      (str "[this " methodparams "]")))),
   :constswitchcase (fn ([] "") ([cond] cond)),
   :fortimes
   (fn
    [identifier count expressions]
    (str "(dotimes [" identifier " " count "] " expressions ")")),
   :relop identity,
   :typeconversion list-str,
   :imported (fn* [& rest__20#] (s/join "." rest__20#)),
   :importdecls blank-join,
   :dissoc
   (fn [symbol & items] (apply list-str "dissoc" symbol items)),
   :not (constant-func "not"),
   :isidentifier
   (fn
    [initial identifier]
    (str (s/lower-case initial) identifier "?")),
   :fields blank-join,
   :boolswitch (fn [& clauses] (apply list-str "cond" clauses)),
   :associnpath vec-str,
   :variadic (fn* [p1__15#] (str "& " p1__15#)),
   :funclikedecl
   (fn
    [funclike identifier function]
    (list-str funclike identifier function)),
   :underscorejavaidentifier (fn* [p1__31#] (str "-" p1__31#)),
   :percentnum (fn* [p1__13#] (str "%" p1__13#)),
   :methodparam
   (fn ([symbol] symbol) ([symbol typ] (str "^" typ " " symbol))),
   :ifelseexpr
   (fn
    ([condition exprs] (list-str "when" condition exprs))
    ([condition block1 block2]
     (list-str "if" condition block1 block2))),
   :backslashchar (constant-func "\\\\"),
   :dictlit (fn* [& rest__16#] (apply str rest__16#)),
   :dictdestruct
   (fn* [& rest__10#] (str \{ (s/join " " rest__10#) "}")),
   :vfunctionpartn
   (fn
    ([parameters variadic expression]
     (str "[" parameters " " variadic "] " expression))
    ([parameters variadic typ expression]
     (str "^" typ " [" parameters " " variadic "] " expression))),
   :new (fn* [p1__9#] (str p1__9# ".")),
   :interfacespec
   (fn
    [& args]
    (do
     (symbols/Type-created symbol-table (first args))
     (apply list-str "defprotocol" args))),
   :boolswitchcase (fn ([] ":else") ([cond] cond)),
   :label
   (fn*
    [p1__18#]
    (str ":" (s/replace (s/lower-case p1__18#) #"_" "-"))),
   :importdecl
   (fn
    ([] "")
    ([& import-specs] (apply list-str ":require" import-specs))),
   :binaryop identity,
   :mutidentifier
   (fn
    [initial identifier]
    (str (s/lower-case initial) identifier "!")),
   :setlit (fn* [& rest__17#] (str "#{" (s/join " " rest__17#) "}")),
   :structlit (fn [typ & exprs] (apply list-str (str typ ".") exprs)),
   :bigintlit str,
   :macroimportdecl
   (fn
    ([] "")
    ([& import-specs]
     (apply list-str ":require-macros" import-specs))),
   :long (constant-func "long"),
   :letifelseexpr
   (fn
    ([lhs rhs condition exprs]
     (str
      "(let ["
      lhs
      " "
      rhs
      "] "
      (list-str "when" condition exprs)
      ")"))
    ([lhs rhs condition block1 block2]
     (str
      "(let ["
      lhs
      " "
      rhs
      "] "
      (list-str "if" condition block1 block2)
      ")"))),
   :indexed (fn [xs i] (list-str "nth" xs i)),
   :decimallit identity,
   :bitnot (constant-func "bit-not"),
   :consts blank-join,
   :typeimportspec
   (fn
    [typepackage & typeclasses]
    (do
     (doseq
      [typeclass typeclasses]
      (symbols/Type-imported symbol-table typeclass))
     (apply list-str typepackage typeclasses))),
   :variadiccall
   (fn [function & params] (apply list-str "apply" function params)),
   :loop (decl-block-func "loop"),
   :primarrayvardecl
   (fn
    [identifier number primtype]
    (let
     [elements
      (apply blank-join (dotimes [_ (read-string number)] "0"))]
     (list-str
      "def"
      identifier
      (list-str "vector-of" (str ":" primtype) elements)))),
   :octalbytevalue (fn [d1 d2 d3] (str "\\o" d1 d2 d3)),
   :unaryexpr
   (fn [operator expression] (list-str operator expression))}))

(defn-
 packageclause-func
 [symbol-table ^String path goscript?]
 (let
  [[parent name] (split-path path)]
  (when goscript? (symbols/Package-created symbol-table "js"))
  (fn
   [imported import-decls]
   (let
    [full-imported (str parent imported)]
    (when
     (not= imported name)
     (throw
      (Exception.
       (str
        "Got package \""
        imported
        "\" instead of expected \""
        name
        "\" in \""
        path
        "\""))))
    (if
     goscript?
     (list-str "ns" full-imported import-decls)
     (str
      (list-str "ns" full-imported "(:gen-class)" import-decls)
      " (set! *warn-on-reflection* true)"))))))

(defn
 Generate
 [^String path parsed]
 (let
  [symbol-table
   (symbols/New)
   goscript?
   (. path (endsWith ".gos"))
   code-gen
   (assoc
    (code-generator symbol-table goscript?)
    :packageclause
    (packageclause-func symbol-table path goscript?))
   clj
   (insta/transform code-gen parsed)]
  (symbols/Check-all-used symbol-table)
  clj))

