;; Compiled from src/fmt.go
(ns
 fmt
 (:gen-class)
 (:require [clojure.string :as string])
 (:import (clojure.lang PersistentVector)))

(set! *warn-on-reflection* true)

(def Printf printf)

(defn-
 strip-zero-after-decimal
 [s]
 (string/replace (str s) #"^([1-9][0-9]*)\.0$" "$1"))

(defn-
 to-string-like-go
 [x]
 (cond
  (instance? String x)
  x
  (instance? Number x)
  (strip-zero-after-decimal x)
  (instance? PersistentVector x)
  (str "[" (string/join " " (map to-string-like-go x)) "]")
  :else
  (str x)))

(defn
 Println
 [& args]
 (let
  [as (map (fn* [p1__77#] (to-string-like-go p1__77#)) args)]
  (println (string/join " " as))))

