/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.ArraySeq;
import clojure.lang.Counted;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.Obj;
import clojure.lang.RT;
import clojure.lang.RestFn;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class PersistentList
extends ASeq
implements IPersistentList,
IReduce,
List,
Counted {
    private final Object _first;
    private final IPersistentList _rest;
    private final int _count;
    public static IFn creator = new RestFn(){

        @Override
        public final int getRequiredArity() {
            return 0;
        }

        @Override
        protected final Object doInvoke(Object args) {
            if (args instanceof ArraySeq) {
                Object[] argsarray = ((ArraySeq)args).array;
                IPersistentList ret = EMPTY;
                for (int i = argsarray.length - 1; i >= ((ArraySeq)args).i; --i) {
                    ret = (IPersistentList)ret.cons(argsarray[i]);
                }
                return ret;
            }
            LinkedList<Object> list = new LinkedList<Object>();
            for (ISeq s = RT.seq(args); s != null; s = s.next()) {
                list.add(s.first());
            }
            return PersistentList.create(list);
        }

        @Override
        public IObj withMeta(IPersistentMap meta) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IPersistentMap meta() {
            return null;
        }
    };
    public static final EmptyList EMPTY = new EmptyList(null);

    public PersistentList(Object first) {
        this._first = first;
        this._rest = null;
        this._count = 1;
    }

    PersistentList(IPersistentMap meta, Object _first, IPersistentList _rest, int _count) {
        super(meta);
        this._first = _first;
        this._rest = _rest;
        this._count = _count;
    }

    public static IPersistentList create(List init) {
        IPersistentList ret = EMPTY;
        ListIterator i = init.listIterator(init.size());
        while (i.hasPrevious()) {
            ret = (IPersistentList)ret.cons(i.previous());
        }
        return ret;
    }

    @Override
    public Object first() {
        return this._first;
    }

    @Override
    public ISeq next() {
        if (this._count == 1) {
            return null;
        }
        return (ISeq)((Object)this._rest);
    }

    @Override
    public Object peek() {
        return this.first();
    }

    @Override
    public IPersistentList pop() {
        if (this._rest == null) {
            return EMPTY.withMeta(this._meta);
        }
        return this._rest;
    }

    @Override
    public int count() {
        return this._count;
    }

    @Override
    public PersistentList cons(Object o) {
        return new PersistentList(this.meta(), o, this, this._count + 1);
    }

    @Override
    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentList withMeta(IPersistentMap meta) {
        if (meta != this._meta) {
            return new PersistentList(meta, this._first, this._rest, this._count);
        }
        return this;
    }

    @Override
    public Object reduce(IFn f) {
        Object ret = this.first();
        for (ISeq s = this.next(); s != null; s = s.next()) {
            if (!RT.isReduced(ret = f.invoke(ret, s.first()))) continue;
            return ((IDeref)ret).deref();
        }
        return ret;
    }

    @Override
    public Object reduce(IFn f, Object start) {
        Object ret = f.invoke(start, this.first());
        for (ISeq s = this.next(); s != null; s = s.next()) {
            if (RT.isReduced(ret)) {
                return ((IDeref)ret).deref();
            }
            ret = f.invoke(ret, s.first());
        }
        if (RT.isReduced(ret)) {
            return ((IDeref)ret).deref();
        }
        return ret;
    }

    public static class EmptyList
    extends Obj
    implements IPersistentList,
    List,
    ISeq,
    Counted,
    IHashEq {
        static final int hasheq = Murmur3.hashOrdered(Collections.EMPTY_LIST);

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public int hasheq() {
            return hasheq;
        }

        @Override
        public boolean equals(Object o) {
            return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
        }

        @Override
        public boolean equiv(Object o) {
            return this.equals(o);
        }

        EmptyList(IPersistentMap meta) {
            super(meta);
        }

        @Override
        public Object first() {
            return null;
        }

        @Override
        public ISeq next() {
            return null;
        }

        @Override
        public ISeq more() {
            return this;
        }

        @Override
        public PersistentList cons(Object o) {
            return new PersistentList(this.meta(), o, null, 1);
        }

        @Override
        public IPersistentCollection empty() {
            return this;
        }

        @Override
        public EmptyList withMeta(IPersistentMap meta) {
            if (meta != this.meta()) {
                return new EmptyList(meta);
            }
            return this;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public IPersistentList pop() {
            throw new IllegalStateException("Can't pop empty list");
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public ISeq seq() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return RT.EMPTY_ARRAY;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray(Object[] objects) {
            if (objects.length > 0) {
                objects[0] = null;
            }
            return objects;
        }

        private List reify() {
            return Collections.unmodifiableList(new ArrayList(this));
        }

        public List subList(int fromIndex, int toIndex) {
            return this.reify().subList(fromIndex, toIndex);
        }

        public Object set(int index2, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            ISeq s = this.seq();
            int i = 0;
            while (s != null) {
                if (Util.equiv(s.first(), o)) {
                    return i;
                }
                s = s.next();
                ++i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.reify().lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.reify().listIterator();
        }

        public ListIterator listIterator(int index2) {
            return this.reify().listIterator(index2);
        }

        public Object get(int index2) {
            return RT.nth(this, index2);
        }

        public void add(int index2, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index2, Collection c) {
            throw new UnsupportedOperationException();
        }
    }
}

