# Duct Test [![Build Status](https://github.com/duct-framework/test/actions/workflows/test.yml/badge.svg)](https://github.com/duct-framework/test/actions/workflows/test.yml)

A library for running [Duct][] applications in a test environment.

[duct]: https://duct-framework.org


## Installation

Add the following dependency to your deps.edn file:

    org.duct-framework/test {:mvn/version "0.1.0"}

Or to your Leiningen project file:

    [org.duct-framework/test "0.1.0"]

## Usage

The `duct.test/run` function will start your Duct application using the
`:test` profile. You can combine this with `duct.test/with-system` to
ensure that your system is halted after your tests complete.

```clojure
(ns example.test
  (:require [clojure.test :refer [deftest is]]
            [duct.test :as t]))

(deftest a-test
  (t/with-system [sys (t/run)]
    ;; test the system
    ))
```

You can pass a map of options to `run` in order to customize it further.
The following options are supported:

- `:config`   - the config map to use (default loads from `duct.edn`)
- `:keys`     - only run this collection of keys (default is all keys)
- `:profiles` - use these profiles (default is `[:test]`)
- `:vars`     - bind vars to this map of symbols to values

## License

Copyright © 2025 James Reeves

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
