(ns org.dthume.data.set
  (:require [clojure.set]))

(defprotocol SetAlgebra
  (set-union [lhs rhs])
  (set-intersection [lhs rhs])
  (set-difference [lhs rhs]))

(extend-protocol SetAlgebra
  clojure.lang.PersistentHashSet
  (set-union [lhs rhs]
    (clojure.set/union lhs rhs))
  (set-intersection [lhs rhs]
    (clojure.set/intersection lhs rhs))
  (set-difference [lhs rhs]
    (clojure.set/difference lhs rhs))

  clojure.lang.PersistentTreeSet
  (set-union [lhs rhs]
    (clojure.set/union lhs rhs))
  (set-intersection [lhs rhs]
    (clojure.set/intersection lhs rhs))
  (set-difference [lhs rhs]
    (clojure.set/difference lhs rhs)))

(defn union
  ([] #{})
  ([s1] s1)
  ([s1 s2]
     (set-union s1 s2))
  ([s1 s2 & sets]
     (reduce set-union (union s1 s2) sets)))

(defn intersection
  ([s1] s1)
  ([s1 s2]
     (set-intersection s1 s2))
  ([s1 s2 & sets]
     (reduce set-intersection (intersection s1 s2) sets)))

(defn difference
  ([s1] s1)
  ([s1 s2]
     (set-difference s1 s2))
  ([s1 s2 & sets]
     (reduce set-difference (difference s1 s2) sets)))
