/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.system;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.common.model.User;
import org.dstorerdb.common.system.SysInfo;
import org.dstorerdb.encryptor.encryptor.Encryptor;
import org.dstorerdb.server.config.ConfigManager;
import org.dstorerdb.server.net.Server;
import org.dstorerdb.server.system.UserList;
import org.mpizutil.electrolist.structure.ElectroList;

public class UserManager {
    private final User user;
    private final File folderUser;
    private final ElectroList<UserList> listArchives;
    private final ConfigManager cnfManager;

    public static boolean create(User user) {
        File userFolder = new File(SysInfo.DEFAULT_USERS_DIR, user.getNick());
        if (userFolder.exists()) {
            return false;
        }
        userFolder.mkdir();
        Encryptor srvEncryptor = Server.SYS_ENCRYPTOR;
        ConfigManager cnfManager = new ConfigManager(new File(userFolder, "config.xml"));
        cnfManager.setConfigValue("nick", user.getNick());
        cnfManager.setConfigValue("passw", user.getPassword());
        return true;
    }

    public UserManager(User user, boolean create) {
        this.folderUser = new File(SysInfo.DEFAULT_USERS_DIR, user.getNick());
        if (create) {
            this.folderUser.mkdir();
        } else if (!this.folderUser.exists()) {
            this.throwFNFException("La carpeta usuario de nombre " + this.folderUser.getName() + " no existe");
        }
        this.user = user;
        this.listArchives = new ElectroList();
        this.cnfManager = new ConfigManager(new File(this.folderUser, "config.xml"));
        this.loadLists();
    }

    public UserManager(User user, File folderUser) {
        if (!folderUser.exists()) {
            this.throwFNFException("La carpeta usuario de nombre " + folderUser.getName() + " no existe");
        }
        this.user = user;
        this.folderUser = folderUser;
        this.listArchives = new ElectroList();
        this.cnfManager = new ConfigManager(new File(folderUser, "config.xml"));
        this.loadLists();
    }

    public UserManager(User user) {
        this(user, new File(SysInfo.DEFAULT_USERS_DIR, user.getNick()));
    }

    private void throwFNFException(String msg) {
        try {
            throw new FileNotFoundException(msg);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(UserManager.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
    }

    private void loadLists() {
        File[] fileLists = this.folderUser.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() && !pathname.getName().endsWith(".xml");
            }
        });
        if (fileLists != null) {
            for (int i = 0; i < fileLists.length; ++i) {
                this.listArchives.add((Object)new UserList(fileLists[i]));
            }
        }
    }

    public int getListsCount() {
        return this.listArchives.size();
    }

    public File getFolderUser() {
        return this.folderUser;
    }

    public void addUserList(String name) {
        this.listArchives.add((Object)new UserList(this.folderUser, name));
    }

    public ElectroList<UserList> getListArchives() {
        return this.listArchives;
    }

    public ConfigManager getCnfManager() {
        return this.cnfManager;
    }

    public UserList getListBy(String name) {
        System.out.println("Cantidad de listas cargadas: " + this.listArchives.size());
        return (UserList)this.listArchives.findFirst(list -> list.getName().equals(name));
    }

    public boolean clearAll() {
        if (this.listArchives.isEmpty()) {
            return false;
        }
        if (this.listArchives.allMatch(ul -> ul.getListData().isEmpty())) {
            return false;
        }
        for (UserList ul2 : this.listArchives) {
            ul2.clearAll();
        }
        return true;
    }

    public void add(String data, String listName, int index) {
        UserList list = this.getListBy(listName);
        if (index == -1) {
            list.add(data);
        } else {
            list.add(index, data);
        }
    }

    public void add(String[] data, String listName, int index) {
        UserList list = this.getListBy(listName);
        if (index == -1) {
            list.add(data);
        } else {
            list.add(index, data);
        }
    }

    public boolean clearAll(String listName) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return false;
        }
        list.clearAll();
        return true;
    }

    public boolean create(String listName) {
        UserList newList = this.getListBy(listName);
        System.out.println(newList);
        if (newList != null) {
            return false;
        }
        newList = new UserList(this.folderUser, listName, OPEN_LIST_OPTION.CREATE);
        this.listArchives.add((Object)newList);
        return true;
    }

    public void deleteAll() {
        for (UserList userList : this.listArchives) {
            userList.delete();
        }
        this.listArchives.clear();
    }

    public void deleteList(String listName) {
        int listIndex = 0;
        for (UserList userList : this.listArchives) {
            if (userList.getName().equals(listName)) {
                userList.delete();
                break;
            }
            ++listIndex;
        }
        this.listArchives.remove(listIndex);
    }

    public boolean deleteInIndex(String listName, int index) {
        UserList list = this.getListBy(listName);
        return list == null ? true : list.deleteInIndex(index);
    }

    public boolean deleteIf(String listName, String filter, String symbol) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return false;
        }
        return list.deleteIf(filter, symbol);
    }

    public int getSizeOfAll() {
        int sizeOf = 0;
        sizeOf = this.listArchives.stream().map(list -> list.getSizeOf()).reduce(sizeOf, Integer::sum);
        return sizeOf;
    }

    public int getSizeOf(String listName) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return -1;
        }
        return list.getSizeOf();
    }

    public String getAllFrom(String listName) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return "NULL";
        }
        return list.getAll();
    }

    public String getByRangeFrom(String listName, int start, int end) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return "NULL";
        }
        if (start > end || start < 0 || end < 0) {
            return "BAD_RANGE";
        }
        return list.getByRange(start, end);
    }

    public String getByIndexFrom(String listName, int index) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return "NULL";
        }
        return list.getByIndex(index);
    }

    public boolean setPassw(String oldPassw, String newPassw) {
        boolean isOldPass = this.cnfManager.getConfigValue("passw").equals(oldPassw);
        if (isOldPass) {
            this.cnfManager.setConfigValue("passw", newPassw);
        }
        return isOldPass;
    }

    public boolean setListname(String oldName, String newName) {
        UserList list = this.getListBy(oldName);
        if (list == null) {
            return false;
        }
        list.setName(newName);
        return true;
    }

    public boolean setAll(String listName, String data) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return false;
        }
        list.setAllTo(data);
        return true;
    }

    public boolean setElement(String listName, int index, String data) {
        UserList list = this.getListBy(listName);
        if (list == null) {
            return false;
        }
        return list.setElement(index, listName);
    }

    public static enum OPEN_LIST_OPTION {
        CREATE,
        OPEN_ONLY;

    }
}

