/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.common.model.User;
import org.dstorerdb.common.streams.StringInputStream;
import org.dstorerdb.common.streams.StringOutputStream;
import org.dstorerdb.encryptor.encryptor.Encryptor;
import org.dstorerdb.server.config.ConfigManager;
import org.dstorerdb.server.config.InfoManager;
import org.dstorerdb.server.net.Client;
import org.dstorerdb.server.net.thread.TClient;
import org.dstorerdb.server.net.thread.TRequestManager;
import org.mpizutil.electrolist.structure.ElectroList;

public class Server
extends Thread {
    private final ServerSocket serverSock = new ServerSocket(4200);
    private final ElectroList<TClient> listClientsConnected = new ElectroList();
    private final ConfigManager configManager = new ConfigManager();
    private final InfoManager infoManager = new InfoManager();
    private static Server thisObj;
    public static final Encryptor SYS_ENCRYPTOR;

    public static Server getServer() {
        return thisObj;
    }

    public static void newInstance() {
        try {
            thisObj = new Server();
        }
        catch (IOException ex) {
            Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Server() throws IOException {
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public InfoManager getInfoManager() {
        return this.infoManager;
    }

    public void addClient(Client client) {
        TClient newCli = new TClient(client);
        newCli.start();
        this.listClientsConnected.add((Object)newCli);
    }

    public void addClient(User user, Socket sock, StringOutputStream os, StringInputStream is) {
        TClient newCli = new TClient(new Client(user, sock, os, is));
        newCli.start();
        this.listClientsConnected.add((Object)newCli);
    }

    public void disconnectAll() {
        for (TClient client : this.listClientsConnected) {
            client.disconnectClient();
        }
    }

    public void disconnectClient(long threadId) {
        int idClient = 0;
        for (TClient tClient : this.listClientsConnected) {
            if (tClient.getId() == threadId) {
                tClient.closeConnection();
                break;
            }
            ++idClient;
        }
        this.listClientsConnected.remove(idClient);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    System.out.println("Antes del nuevo cliente!");
                    new TRequestManager(this.serverSock.accept()).start();
                    System.out.println("Cliente conectado!");
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Server.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        Server.newInstance();
        Server.getServer().start();
    }

    static {
        SYS_ENCRYPTOR = new Encryptor("super");
    }
}

