/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.net;

import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.cmdintepreter.cmd.Interpreter;
import org.dstorerdb.cmdintepreter.interfaces.InterpreterListener;
import org.dstorerdb.common.interfaces.Communicable;
import org.dstorerdb.common.model.User;
import org.dstorerdb.common.streams.StringInputStream;
import org.dstorerdb.common.streams.StringOutputStream;
import org.dstorerdb.encryptor.exceptions.InvalidTextException;
import org.dstorerdb.server.system.UserList;
import org.dstorerdb.server.system.UserManager;

public class Client
implements Communicable {
    private final User user;
    private final UserManager userManager;
    private final Socket socket;
    private final StringOutputStream outputStream;
    private final StringInputStream inputStream;
    private final Interpreter interpreter;
    private boolean connected;
    private static final StringBuilder sBuild = new StringBuilder();

    public Client(User user, Socket socket) throws IOException {
        this(user, socket, new StringOutputStream(socket.getOutputStream()), new StringInputStream(socket.getInputStream()));
    }

    public Client(User user, Socket socket, StringOutputStream buffWriter, StringInputStream buffReader) {
        this.user = user;
        this.userManager = new UserManager(user);
        this.socket = socket;
        this.outputStream = buffWriter;
        this.inputStream = buffReader;
        this.interpreter = new Interpreter(this.getInterListener());
        this.connected = true;
    }

    private InterpreterListener getInterListener() {
        return cmd -> {
            String cmdOrder = cmd.getOrder();
            int optCount = cmd.getOptionsCount();
            block15 : switch (cmdOrder) {
                case "add": {
                    if (optCount == 3 || optCount == 6) {
                        String data = cmd.getOptionAt(0);
                        boolean rightData = data.startsWith("'") && data.endsWith("'") || data.startsWith("\"") && data.endsWith("\"") || cmd.hasNumberID(data);
                        System.out.println("RightData: " + rightData);
                        if (rightData) {
                            if (optCount == 3) {
                                boolean isTo = cmd.getOptionAt(1).equals("to");
                                if (isTo) {
                                    String listName = cmd.getOptionAt(2);
                                    UserList list = this.userManager.getListBy(listName);
                                    if (list == null) {
                                        this.buildMessage("errparam", "La lista seleccionada no existe");
                                        break;
                                    }
                                    list.add(data);
                                    this.buildMessage("OK", "Dato agregado correctamente");
                                    break;
                                }
                                this.buildMessage("errparam", "Opcion desconocida");
                                break;
                            }
                            boolean isIn = cmd.getOptionAt(1).equals("in");
                            boolean isIndex = cmd.getOptionAt(2).equals("index");
                            if (isIn && isIndex) {
                                try {
                                    Long.parseLong(cmd.getOptionAt(3));
                                    int index = Integer.parseInt(cmd.getOptionAt(3));
                                    if (index >= 0) {
                                        boolean isTo = cmd.getOptionAt(4).equals("to");
                                        if (isTo) {
                                            UserList list = this.userManager.getListBy(cmd.getOptionAt(5));
                                            if (list == null) {
                                                this.buildMessage("err", "La lista seleccionada no existe");
                                                break;
                                            }
                                            list.add(index, data);
                                            this.buildMessage("OK", "Dato agregado correctamente");
                                            break;
                                        }
                                        this.buildMessage("errparam", "Opcion incorrecta");
                                        break;
                                    }
                                    this.buildMessage("errparam", "El indice debe ser igual o mayor a cero");
                                }
                                catch (NumberFormatException e) {
                                    this.buildMessage("errparam", "El indice debe ser un valor numerico");
                                }
                                break;
                            }
                            this.buildMessage("errparam", "Opcion(es) incorrecta(s)");
                            break;
                        }
                        this.buildMessage("errparam", "Tipo de dato desconocido");
                        break;
                    }
                    this.buildMessage("errparam", "Cantidad de opciones invalida");
                    break;
                }
                case "close": {
                    if (optCount == 0) {
                        this.buildMessage("OK", "Conexion cerrada con exito");
                        this.connected = false;
                        break;
                    }
                    this.buildMessage("errparam", "Este comando no posee parametros");
                    break;
                }
                case "clear": {
                    if (optCount == 1 || optCount == 2) {
                        String firstOpt;
                        switch (firstOpt = cmd.getOptionAt(0)) {
                            case "all": {
                                boolean rightCmd;
                                boolean bl = rightCmd = optCount == 1 || optCount == 2 && cmd.getOptionAt(1).equals("lists");
                                if (rightCmd) {
                                    boolean clear = this.userManager.clearAll();
                                    if (clear) {
                                        this.buildMessage("OK", "Listas vaciadas correctamente");
                                        break block15;
                                    }
                                    this.buildMessage("warning", "Listas vacias");
                                    break block15;
                                }
                                this.buildMessage("errparam", "Opcion invalida: " + cmd.getOptionAt(1));
                                break block15;
                            }
                            case "list": {
                                String listName = cmd.getOptionAt(1);
                                boolean cleared = this.userManager.clearAll(listName);
                                if (cleared) {
                                    this.buildMessage("OK", "Lista vaciada correctamente: " + listName);
                                    break block15;
                                }
                                this.buildMessage("err", "La lista seleccionada no existe");
                                break block15;
                            }
                        }
                        this.buildMessage("errparam", "Opcion invalida: " + firstOpt);
                        break;
                    }
                    this.buildMessage("errparam", "Cantidad de opciones invalida");
                    break;
                }
                case "create": {
                    if (optCount == 1) {
                        if (this.userManager.create(cmd.getOptionAt(0))) {
                            this.buildMessage("OK", "Lista creada correctamente");
                            break;
                        }
                        this.buildMessage("err", "Lista ya existe");
                        break;
                    }
                    this.buildMessage("errparam", "Cantidad de opciones invalida");
                    break;
                }
                case "del": {
                    switch (optCount) {
                        case 2: {
                            String firtsOp = cmd.getOptionAt(0);
                            if (firtsOp.equals("all") && cmd.getOptionAt(1).equals("lists")) {
                                this.userManager.deleteAll();
                                this.buildMessage("OK", "Listas eliminadas correctamente");
                                break;
                            }
                            if (firtsOp.equals("list")) {
                                this.userManager.deleteList(cmd.getOptionAt(1));
                                this.buildMessage("OK", "Lista eliminada " + cmd.getOptionAt(1) + " correctamente");
                                break;
                            }
                            this.buildMessage("errparam", "Una de las opciones es incrrecta");
                            break;
                        }
                        case 4: {
                            boolean wrongThird;
                            String firstOpt = cmd.getOptionAt(0);
                            String thirdOpt = cmd.getOptionAt(2);
                            boolean wrongFirst = !firstOpt.equals("index");
                            boolean bl = wrongThird = !thirdOpt.equals("from");
                            if (!wrongFirst && !wrongThird) {
                                try {
                                    int index = Integer.parseInt(cmd.getOptionAt(1));
                                    boolean deleted = this.userManager.deleteInIndex(cmd.getOptionAt(3), index);
                                    if (deleted) {
                                        this.buildMessage("OK", "Dato eliminado con exito");
                                        break;
                                    }
                                    this.buildMessage("err", "El dato o la lista a  que se intenta acceder no existe");
                                }
                                catch (NumberFormatException e) {
                                    this.buildMessage("errparam", "El indice debe ser un valor numerico");
                                }
                                break;
                            }
                            this.buildMessage("errparam", wrongFirst && wrongThird ? "No se reconoce la opcion index y from" : (wrongFirst ? "No se reconoce opcion index" : "No se reconoce opcion from"));
                            break;
                        }
                        case 6: {
                            boolean rightOpts;
                            String fOpt = cmd.getOptionAt(0);
                            String tOpt = cmd.getOptionAt(2);
                            boolean wrongF = !fOpt.equals("in");
                            boolean wrongT = !tOpt.equals("where");
                            boolean bl = rightOpts = !wrongF && !wrongT;
                            if (rightOpts) {
                                String operatorSymbol = cmd.getOptionAt(4);
                                String listName = cmd.getOptionAt(1);
                                String condition = cmd.getOptionAt(5);
                                if (operatorSymbol.equals("=") || operatorSymbol.equals("=%")) {
                                    if (this.userManager.deleteIf(listName, condition, operatorSymbol)) {
                                        this.buildMessage("OK", "Eliminacion correcta");
                                        break;
                                    }
                                    this.buildMessage("err", "La lista seleccionada no existe");
                                    break;
                                }
                                this.buildMessage("errparam", "Se desconoce el operador");
                                break;
                            }
                            this.buildMessage("errparam", wrongF && wrongT ? "No se reconoce la opcion in y where" : (wrongF ? "No se reconoce opcion in" : "No se reconoce opcion where"));
                        }
                    }
                    break;
                }
                case "get": {
                    switch (optCount) {
                        case 2: {
                            String firstOp = cmd.getOptionAt(0);
                            String secondOp = cmd.getOptionAt(1);
                            if (firstOp.equals("sizeof")) {
                                int sizeOf = 0;
                                if (secondOp.equals("all")) {
                                    sizeOf = this.userManager.getSizeOfAll();
                                    this.buildMessage("GET", sizeOf);
                                    break block15;
                                }
                                sizeOf = this.userManager.getSizeOf(secondOp);
                                if (sizeOf < 0) {
                                    this.buildMessage("err", "La lista seleccionada no existe");
                                    break block15;
                                }
                                this.buildMessage("GET", sizeOf);
                                break block15;
                            }
                            this.buildMessage("errparam", "La opcion " + firstOp + " es invalida");
                            break block15;
                        }
                        case 3: {
                            String firstO = cmd.getOptionAt(0);
                            int index = -2;
                            if (firstO.equals("all") && cmd.getOptionAt(1).equals("from")) {
                                String elements = this.userManager.getAllFrom(cmd.getOptionAt(2));
                                if (elements.equals("NULL")) {
                                    this.buildMessage("err", "La lista seleccionada no existe");
                                    break block15;
                                }
                                this.buildMessage("GET", elements);
                                break block15;
                            }
                            index = cmd.getOptionAsNumber(0);
                            if (index > -1) {
                                String element;
                                switch (element = this.userManager.getByIndexFrom(cmd.getOptionAt(2), index)) {
                                    case "BAD_RANGE": {
                                        this.buildMessage("BAD_RANGE", "El indice ingresado no es valido");
                                        break block15;
                                    }
                                    case "NULL": {
                                        this.buildMessage("errord", "La lista seleccionada no existe");
                                        break block15;
                                    }
                                }
                                this.buildMessage("GET", element);
                                break block15;
                            }
                            this.buildMessage("errparam", "La(s) opcion(es) ingresada(s) no es(son) valida(s)");
                            break block15;
                        }
                        case 4: {
                            boolean rightOp1 = false;
                            try {
                                int start = Integer.parseInt(cmd.getOptionAt(0));
                                rightOp1 = true;
                                int end = Integer.parseInt(cmd.getOptionAt(1));
                                if (cmd.getOptionAt(2).equals("from")) {
                                    String results;
                                    String listName = cmd.getOptionAt(3);
                                    switch (results = this.userManager.getByRangeFrom(listName, start, end)) {
                                        case "BAD_RANGE": {
                                            this.buildMessage("BAD_RANGE", "El(los) indice(s) no es(son) valido(s)");
                                            break block15;
                                        }
                                        case "NULL": {
                                            this.buildMessage("errord", "La lista seleccionada no existe");
                                            break block15;
                                        }
                                    }
                                    this.buildMessage("OK", results);
                                    break block15;
                                }
                                this.buildMessage("errparam", "No se reconoce opcion from");
                            }
                            catch (NumberFormatException e) {
                                if (!rightOp1) {
                                    try {
                                        Integer.parseInt(cmd.getOptionAt(1));
                                        this.buildMessage("errparam", "La opcion 1 no es un valor entero");
                                    }
                                    catch (NumberFormatException e2) {
                                        this.buildMessage("errparam", "La opcion 1 y 2 no son un valor entero");
                                    }
                                    break block15;
                                }
                                this.buildMessage("errparam", "La opcion 2 no es un valor entero");
                            }
                            break block15;
                        }
                        case 5: {
                            String firstOpt;
                            switch (firstOpt = cmd.getOptionAt(0)) {
                                case "typeof": {
                                    break block15;
                                }
                                case "count": {
                                    break block15;
                                }
                            }
                            this.buildMessage("errparam", "La debe especificar una opcion typeof o count");
                            break block15;
                        }
                        case 7: {
                            break block15;
                        }
                    }
                    this.buildMessage("errparam", "Numero de opciones invalido");
                    break;
                }
                case "help": {
                    break;
                }
                case "set": {
                    switch (optCount) {
                        case 3: {
                            String newName;
                            if (cmd.getOptionAt(0).equals("passw")) {
                                String newPass;
                                String oldPass = cmd.getOptionAt(1);
                                boolean changed = this.userManager.setPassw(oldPass, newPass = cmd.getOptionAt(2));
                                if (changed) {
                                    this.buildMessage("OK", "La contrase\u00f1a ha sido modificada correctamente");
                                    break;
                                }
                                this.buildMessage("errparam", "La contrase\u00f1a antigua no es valida");
                                break;
                            }
                            String oldName = cmd.getOptionAt(1);
                            boolean changed = this.userManager.setListname(oldName, newName = cmd.getOptionAt(2));
                            if (changed) {
                                this.buildMessage("OK", "El nombre de la lista ha sido modificado correctamente");
                                break;
                            }
                            this.buildMessage("errparam", "La lista seleccionada no existe");
                            break;
                        }
                        case 5: {
                            if (cmd.getOptionAt(0).equals("all") && cmd.getOptionAt(1).equals("in") && cmd.getOptionAt(3).equals("to")) {
                                boolean seted = this.userManager.setAll(cmd.getOptionAt(2), cmd.getOptionAt(4));
                                if (seted) {
                                    this.buildMessage("OK", "Todos los elementos de la lista han sido modificados");
                                    break;
                                }
                                this.buildMessage("errparam", "La lista seleccionada no existe");
                                break;
                            }
                            this.buildMessage("errparam", "Una o mas de las opciones ingresadas es incorrecta");
                            break;
                        }
                        case 6: {
                            if (!cmd.getOptionAt(0).equals("index") || !cmd.getOptionAt(2).equals("to") || !cmd.getOptionAt(4).equals("to")) break;
                            try {
                                int index = Integer.parseInt(cmd.getOptionAt(1));
                                String data = cmd.getOptionAt(3);
                                String listName = cmd.getOptionAt(5);
                                boolean set = this.userManager.setElement(listName, index, data);
                                if (set) {
                                    this.buildMessage("OK", "El elemento ha sido modificado exitosamente");
                                    break;
                                }
                                this.buildMessage("err", "La modificacion no se pudo realizar, es posible que deba revisar\nel indice, o que la lista este vacia, o que esta no exista");
                                break;
                            }
                            catch (NumberFormatException e) {
                                this.buildMessage("errparam", "El indice ingresado no corresponde a un valor numerico");
                            }
                        }
                    }
                    break;
                }
                default: {
                    this.buildMessage("errord", "Orden no valida");
                }
            }
        };
    }

    private void buildMessage(String header, Object msg) {
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append(header).append('-').append(msg.toString()).append("/002");
        this.interpreter.setResponseMsg(sbMsg.toString());
        System.out.println("Client: InterpreterMessage: " + this.interpreter.getResponseMsg());
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public void closeStreams() {
        try {
            this.socket.shutdownOutput();
            this.socket.shutdownInput();
        }
        catch (IOException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeConnection() {
        this.closeStreams();
        this.closeSocket();
    }

    public User getUser() {
        return this.user;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void sendData(String data) {
        try {
            System.out.println("Texto en sendData: " + data);
            this.outputStream.writeString(data);
        }
        catch (IOException | InvalidTextException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getReceivData() {
        try {
            return this.inputStream.readString();
        }
        catch (IOException | InvalidTextException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

