/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.config;

import java.io.File;
import java.io.FileFilter;
import org.dstorerdb.common.system.SysInfo;
import org.dstorerdb.server.config.ConfigManager;
import org.mpizutil.electrolist.structure.ElectroList;

public class InfoManager {
    private final File sysUsersDirs = SysInfo.DEFAULT_USERS_DIR;
    private static final FileFilter userDirFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    private File[] getUserDirs() {
        return this.sysUsersDirs.listFiles(userDirFilter);
    }

    public int getUsersCount() {
        File[] listFiles = this.getUserDirs();
        return listFiles == null ? 0 : listFiles.length;
    }

    public boolean existsUser(String nick, String passw) {
        File[] userDirFilter = this.sysUsersDirs.listFiles(pathname -> pathname.isDirectory() && pathname.getName().equals(nick));
        if (userDirFilter == null || userDirFilter.length == 0) {
            return false;
        }
        File configFile = this.getConfigFileFrom(userDirFilter[0]);
        ConfigManager configManager = new ConfigManager(configFile);
        String realNick = configManager.getConfigValue("nick");
        String realPassw = configManager.getConfigValue("passw");
        return nick.equals(realNick) && passw.equals(realPassw);
    }

    private File getConfigFileFrom(File userDir) {
        File[] dirFiles = userDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() && pathname.getName().equals("config.xml");
            }
        });
        return dirFiles == null || dirFiles.length == 0 ? null : dirFiles[0];
    }

    public ElectroList<String> getUserNames() {
        File[] userDirs = this.getUserDirs();
        ElectroList listUserNames = new ElectroList();
        if (userDirs != null) {
            int udLen = userDirs.length;
            for (int i = 0; i < udLen; ++i) {
                listUserNames.add((Object)userDirs[i].getName());
            }
        }
        return listUserNames;
    }
}

