/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.common.system.SysInfo;

public final class ConfigManager {
    private final File fileConf;
    private final Properties proper;

    public ConfigManager() {
        this.fileConf = new File(SysInfo.DEFUALT_PATH, "config.xml");
        this.proper = new Properties();
        if (this.fileConf.exists()) {
            this.loadChanges();
        } else {
            this.saveChanges();
        }
    }

    public ConfigManager(File fileConf) {
        this.fileConf = fileConf;
        this.proper = new Properties();
        if (fileConf.exists()) {
            this.loadChanges();
        } else {
            this.saveChanges();
        }
    }

    public String getConfigValue(String name) {
        return this.proper.getProperty(name);
    }

    public void setConfigValue(String name, String value) {
        this.proper.setProperty(name, value);
        this.saveChanges();
    }

    public void saveChanges() {
        try {
            this.proper.storeToXML(new FileOutputStream(this.fileConf), "DataStorer Config File");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ConfigManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadChanges() {
        try {
            this.proper.loadFromXML(new FileInputStream(this.fileConf));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ConfigManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ConfigManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

