/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.logger;

import java.io.IOException;
import org.dstorerdb.logger.SystemUtil;
import org.dstorerdb.logger.Time;

public class Log {
    private static final String INFO_COLOR = "\u001b[32m";
    private static final String WARNING_COLOR = "\u001b[33m";
    private static final String ERROR_COLOR = "\u001b[31m";
    private static final String RAW_COLOR = "\u001b[0m";
    private final String className;

    public static Log getLog(Class clazz) {
        return new Log(clazz.getName());
    }

    public static Log getLog(Object obj) {
        return new Log(obj);
    }

    public static Log getLog(String className) {
        return new Log(className);
    }

    public Log(Class clazz) {
        this.className = clazz == null ? "null" : clazz.getName();
    }

    public Log(Object obj) {
        this.className = obj == null ? "null" : obj.getClass().getName();
    }

    public Log(String className) {
        this.className = className;
    }

    private String getMessageColor(LogType type) {
        switch (type) {
            case INFO: {
                return INFO_COLOR;
            }
            case ERROR: {
                return ERROR_COLOR;
            }
            case WARNING: {
                return WARNING_COLOR;
            }
        }
        return RAW_COLOR;
    }

    private void appendMsg(StringBuilder sbMsg, String[] msgSplit, LogType logType) {
        String toAppend;
        switch (logType) {
            case INFO: {
                toAppend = "info\n---- INFO: ";
                break;
            }
            case ERROR: {
                toAppend = "error\n---- ERROR: ";
                break;
            }
            case WARNING: {
                toAppend = "warning\n---- WARN: ";
                break;
            }
            default: {
                toAppend = "raw\n---- ";
            }
        }
        String[] toAppSplit = toAppend.split("\n");
        sbMsg.append(toAppSplit[0]).append('\n');
        toAppend = toAppSplit[1];
        for (int i = 0; i < msgSplit.length; ++i) {
            sbMsg.append(toAppend).append(msgSplit[i]).append('\n');
        }
    }

    private String getMsg(String msg, LogType logType) {
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append(ERROR_COLOR);
        sbMsg.append('[');
        sbMsg.append(Time.getCurrentTime()).append("] ").append(RAW_COLOR).append(this.className).append(' ').append(this.getMessageColor(logType));
        this.appendMsg(sbMsg, msg.split("\n"), logType);
        sbMsg.append(RAW_COLOR);
        return sbMsg.toString();
    }

    private void println(String str) {
        try {
            SystemUtil.getStdout().write(str.concat("\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void print(String str) {
        try {
            SystemUtil.getStdout().write(str.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void error(String msg) {
        this.println(this.getMsg(msg, LogType.ERROR));
    }

    public void info(String msg) {
        this.println(this.getMsg(msg, LogType.INFO));
    }

    public void warning(String msg) {
        this.println(this.getMsg(msg, LogType.WARNING));
    }

    public void raw(String msg) {
        this.println(this.getMsg(msg, LogType.RAW));
    }

    public static void main(String[] args) {
        Log.getLog(Log.class).warning("linea1\nlinea2");
    }

    public static enum LogType {
        INFO,
        WARNING,
        ERROR,
        RAW;

    }
}

