/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.client.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.client.net.Receiver;
import org.dstorerdb.client.net.Sender;

public class Client {
    private Socket sockClient;
    private Sender sender;
    private Receiver receiver;

    public Client() throws IOException {
        this.sockClient = new Socket();
        this.connectSocket();
        this.sender = new Sender(this.sockClient.getOutputStream());
        this.receiver = new Receiver(this.sockClient.getInputStream());
    }

    public Client(String host) throws IOException {
        this(host, 4200);
    }

    public Client(String host, int port) throws IOException {
        this.sockClient = new Socket(host, port);
        this.sender = new Sender(this.sockClient.getOutputStream());
        this.receiver = new Receiver(this.sockClient.getInputStream());
    }

    private void connectSocket() {
        try {
            this.sockClient.connect(new InetSocketAddress("192.168.1.3", 4200));
        }
        catch (IOException ex) {
            try {
                this.sockClient = new Socket();
                this.sockClient.connect(new InetSocketAddress("localhost", 4200));
            }
            catch (IOException ex1) {
                Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    public void reconnect() {
        try {
            this.closeConnection();
            this.sockClient = new Socket();
            this.connectSocket();
            this.sender = new Sender(this.sockClient.getOutputStream());
            this.receiver = new Receiver(this.sockClient.getInputStream());
        }
        catch (IOException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeConnection() throws IOException {
        this.sockClient.shutdownOutput();
        this.sockClient.shutdownInput();
        this.sockClient.close();
    }

    public void sendMsg(String data) {
        this.sender.sendData(data);
    }

    public String getReceivMsg() {
        return this.receiver.getReceivData();
    }
}

