(ns mathdoc.process.transform.headerslide
  (:require [taoensso.timbre :as log]
            [clojure.walk :as walk]
            [clojure.spec :as s]
            [clojure.core.match :as m]
            [clojure.set :as set]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat :data (s/keys :req-un [::msp/ast]))
        :ret ::msp/ast)

;;; implementation

(defn skip
  [skip-pred f]
  (fn [v]
    (if (skip-pred v)
      v
      (f v))))

(defn header-div
  [v]
  (and (map? v)
       (= :Div (:type v))
       (= 1 (-> v :content :attr :data-map :section))))

(defn wrap-div [attr elems]
  {:type :Div
   :content
   {:attr attr
    :elems elems}})

(defn get-level [m]
  (some-> m :content :level))

(defn- get-presection
  [m]
  (some-> m :content :attr :data-map :presection))

(defn- get-section
  [m]
  (some-> m :content :attr :data-map :section))

(defn- get-divtag
  [m]
  (some-> m :content :attr :data-map :data-divtag))

(defn slide-section [m]
  (and (get-section m)
       (< (get-section m) 4)
       (not (get-divtag m))))

(defn- titleslide
  [attr title-elems rest-elems]
  (wrap-div
   attr
   (apply
    vector
    (wrap-div
     {:class    ["titleslide"]
      :data-map {:data-divtag "section"}}
     title-elems)
    rest-elems)))

(defn process-header-div
  [m]
  #_(log/info (some-> m :content :elems first :content :attr :id))
  (m/match
   [m]
    [{:type :Div
      :content
      {:attr attr
       :elems [(header :guard (comp #{1} get-level))
               & elems]}}]
    (titleslide attr
                (apply vector header (take-while (complement slide-section) elems))
                (vec (drop-while (complement slide-section) elems)))))

(defn process-ast [ast]
  (walk/postwalk
   (skip (complement header-div)
         process-header-div)
   ast))

(defn process [{:keys [ast logger]}]
  (duct/log logger :info :process)
  (process-ast ast))


;;; integrant

(defmethod ig/init-key
  :mathdoc.process.transform/headerslide
  [_ v]
  (process v))


;; tests

#_(-> reloaded.repl/system :igrunner (integrant/run "eth.md") :ig/pause process-ast)
#_ (def init-keys
     (-> reloaded.repl/system :igrunner :config keys set (set/difference #{:ig/html})))
#_ (-> reloaded.repl/system :igrunner (integrant/run "eth.md" init-keys)
       :ig/headerslide)
#_ (-> reloaded.repl/system :igrunner (integrant/run "eth.md"))

#_(-> reloaded.repl/system :igrunner (integrant/run "eth.md") :ig/headerslide)
#_(-> reloaded.repl/system :igrunner (integrant/run "eth.md") :ig/html)
#_ (do
     (-> reloaded.repl/system
        :igrunner
        (integrant/run "lecture1.md")
        :ig/pause)
     nil)
