(ns mathdoc.process.inlineinclude
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [medley.core :as med]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct])
  (:import java.io.File))

;;; specs

(s/fdef process
        :args (s/cat
               :data (s/and
                      (s/keys
                       :req-un [::msp/meta
                                ::dir
                                :mathdoc/root])
                      (comp
                       (partial s/valid? (s/nilable map?))
                       :inline-includes
                       :meta)))
        :ret map?)

(s/def ::dir string?)

;;; implementation

(defn- maybe-slurp [f]
  (when (.exists ^File (io/file f))
    (slurp f)))

(defn- process-data [includes dir]
  (->> includes
       (med/map-vals
        (comp
         (partial apply str)
         (partial map maybe-slurp)
         (partial map (partial str dir "/"))))))

(defn process [{:keys [meta logger dir root]}]
  (duct/log logger :info :process)
  (let [{:keys [inline-includes]} meta]
    (process-data inline-includes (str root "/" dir))))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process/inlineinclude
  [_ v]
  (process v))


;;; tests

#_(process-data
   {:head ["_katex.html" "_mathjaxconfig.html"]
    :css ["_style.css"]
    :js ["_revealjsconfig.js"]}
   "../soslectures/html-slides")

#_(maybe-slurp "../soslectures/html-slides/_katex.html")
