(ns mathdoc.process.write.reagent
  (:require [integrant.core :as ig]
            [clojure.pprint :as pp]
            [clojure.java.io :as io]
            [clojure.string :as str]))

(defn get-file [{:keys [root inputfile] :as v}]
  (io/file root "cljs" "talk" "content"
           (str (str/replace inputfile ".md" "") ".cljs")))

(defmethod ig/init-key
  :mathdoc.process.write/reagent
  [_ {:keys [html root inputfile] :as v}]
  (io/make-parents
   (get-file v))
  (spit
   (get-file v)
   (format
    "(ns talk.content.%s)\n(defn c []\n %s)"
    (str/replace inputfile ".md" "")
    (with-out-str
      (pp/pprint
       html)))))
