// Compiled by ClojureScript 1.9.494 {}
goog.provide('mathdoc.cljs.drawmenu');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('hickory.core');
goog.require('hickory.render');
goog.require('dommy.core');
goog.require('clojure.walk');
mathdoc.cljs.drawmenu.colors = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"yellow","yellow",-881035449),"#b58900",new cljs.core.Keyword(null,"orange","orange",73816386),"#cb4b16",new cljs.core.Keyword(null,"red","red",-969428204),"#dc322f",new cljs.core.Keyword(null,"magenta","magenta",1687937081),"#d33682",new cljs.core.Keyword(null,"violet","violet",-1351470549),"#6c71c4",new cljs.core.Keyword(null,"blue","blue",-622100620),"#268bd2",new cljs.core.Keyword(null,"cyan","cyan",1118839274),"#2aa198",new cljs.core.Keyword(null,"green","green",-945526839),"#859900"], null);
mathdoc.cljs.drawmenu.listen_id_color = (function mathdoc$cljs$drawmenu$listen_id_color(id,color){
var temp__6753__auto__ = document.querySelector(dommy.core.selector.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("#"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)].join('')));
if(cljs.core.truth_(temp__6753__auto__)){
var elem = temp__6753__auto__;
(elem["style"]["color"] = color);

return dommy.core.listen_BANG_.call(null,elem,new cljs.core.Keyword(null,"click","click",1912301393),((function (elem,temp__6753__auto__){
return (function (){
return (Pen["colors"]["fg"] = color);
});})(elem,temp__6753__auto__))
);
} else {
return null;
}
});
mathdoc.cljs.drawmenu.add_color_listeners = (function mathdoc$cljs$drawmenu$add_color_listeners(){
var seq__90226 = cljs.core.seq.call(null,mathdoc.cljs.drawmenu.colors);
var chunk__90227 = null;
var count__90228 = (0);
var i__90229 = (0);
while(true){
if((i__90229 < count__90228)){
var vec__90230 = cljs.core._nth.call(null,chunk__90227,i__90229);
var colorname = cljs.core.nth.call(null,vec__90230,(0),null);
var color = cljs.core.nth.call(null,vec__90230,(1),null);
mathdoc.cljs.drawmenu.listen_id_color.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("paintbrush-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,colorname))].join(''),color);

var G__90236 = seq__90226;
var G__90237 = chunk__90227;
var G__90238 = count__90228;
var G__90239 = (i__90229 + (1));
seq__90226 = G__90236;
chunk__90227 = G__90237;
count__90228 = G__90238;
i__90229 = G__90239;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__90226);
if(temp__6753__auto__){
var seq__90226__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90226__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__90226__$1);
var G__90240 = cljs.core.chunk_rest.call(null,seq__90226__$1);
var G__90241 = c__67098__auto__;
var G__90242 = cljs.core.count.call(null,c__67098__auto__);
var G__90243 = (0);
seq__90226 = G__90240;
chunk__90227 = G__90241;
count__90228 = G__90242;
i__90229 = G__90243;
continue;
} else {
var vec__90233 = cljs.core.first.call(null,seq__90226__$1);
var colorname = cljs.core.nth.call(null,vec__90233,(0),null);
var color = cljs.core.nth.call(null,vec__90233,(1),null);
mathdoc.cljs.drawmenu.listen_id_color.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("paintbrush-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,colorname))].join(''),color);

var G__90244 = cljs.core.next.call(null,seq__90226__$1);
var G__90245 = null;
var G__90246 = (0);
var G__90247 = (0);
seq__90226 = G__90244;
chunk__90227 = G__90245;
count__90228 = G__90246;
i__90229 = G__90247;
continue;
}
} else {
return null;
}
}
break;
}
});
mathdoc.cljs.drawmenu.clear_board = (function mathdoc$cljs$drawmenu$clear_board(){
return Board.clearMemory();
});
mathdoc.cljs.drawmenu.make_image = (function mathdoc$cljs$drawmenu$make_image(src){
var G__90249 = (new Image());
(G__90249["src"] = src);

return G__90249;
});
mathdoc.cljs.drawmenu.draw_image = (function mathdoc$cljs$drawmenu$draw_image(img){
var canvas = document.getElementById("board");
var ratio = (canvas.height / img.height);
var shift = (0.5 * (canvas.width - (ratio * img.width)));
return canvas.getContext("2d").drawImage(img,(0),(0),img.width,img.height,shift,(0),(ratio * img.width),(ratio * img.height));
});
mathdoc.cljs.drawmenu.load_image = (function mathdoc$cljs$drawmenu$load_image(src){
var img = mathdoc.cljs.drawmenu.make_image.call(null,src);
return (img["onload"] = ((function (img){
return (function (){
mathdoc.cljs.drawmenu.clear_board.call(null);

return mathdoc.cljs.drawmenu.draw_image.call(null,img);
});})(img))
);
});
mathdoc.cljs.drawmenu.load_elem_image = (function mathdoc$cljs$drawmenu$load_elem_image(elem){
var temp__6753__auto__ = dommy.core.attr.call(null,elem,"data-canvas-src");
if(cljs.core.truth_(temp__6753__auto__)){
var src = temp__6753__auto__;
var board = document.getElementById("board");
return mathdoc.cljs.drawmenu.load_image.call(null,src);
} else {
return null;
}
});
mathdoc.cljs.drawmenu.load_slide_image_listener = (function mathdoc$cljs$drawmenu$load_slide_image_listener(ev){
return mathdoc.cljs.drawmenu.load_elem_image.call(null,(ev["currentSlide"]));
});
mathdoc.cljs.drawmenu.load_slide_fragment_listener = (function mathdoc$cljs$drawmenu$load_slide_fragment_listener(ev){
return mathdoc.cljs.drawmenu.load_elem_image.call(null,(ev["fragment"]));
});
mathdoc.cljs.drawmenu.get_canvas_data = (function mathdoc$cljs$drawmenu$get_canvas_data(){
return document.getElementById("board").toDataURL();
});
mathdoc.cljs.drawmenu.get_location = (function mathdoc$cljs$drawmenu$get_location(){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((window["location"]))].join('');
});
mathdoc.cljs.drawmenu.post_canvas = (function mathdoc$cljs$drawmenu$post_canvas(){
console.log("post canvas");

return (jQuery.ajax(({"type": "POST", "url": "/__save-canvas", "data": ({"img-base64": mathdoc.cljs.drawmenu.get_canvas_data.call(null), "location": mathdoc.cljs.drawmenu.get_location.call(null)})}))["done"]);
});
mathdoc.cljs.drawmenu.add_trash_listener = (function mathdoc$cljs$drawmenu$add_trash_listener(){
return dommy.core.listen_BANG_.call(null,document.getElementById("trash"),new cljs.core.Keyword(null,"click","click",1912301393),mathdoc.cljs.drawmenu.clear_board);
});
mathdoc.cljs.drawmenu.add_download_listener = (function mathdoc$cljs$drawmenu$add_download_listener(){
return dommy.core.listen_BANG_.call(null,document.getElementById("download"),new cljs.core.Keyword(null,"click","click",1912301393),mathdoc.cljs.drawmenu.post_canvas);
});
mathdoc.cljs.drawmenu.maybe_hide_canvas = (function mathdoc$cljs$drawmenu$maybe_hide_canvas(){
if(cljs.core.truth_(window.location.search.match(/nocanvas/))){
console.log("hide canvas");

return dommy.core.set_style_BANG_.call(null,document.getElementById("board"),"display","none");
} else {
return null;
}
});
mathdoc.cljs.drawmenu.fix_top = (function mathdoc$cljs$drawmenu$fix_top(slide){
if(dommy.core.has_class_QMARK_.call(null,slide,"align-top")){
return dommy.core.set_style_BANG_.call(null,slide,"top","0px");
} else {
return null;
}
});
mathdoc.cljs.drawmenu.maybe_center_slides = (function mathdoc$cljs$drawmenu$maybe_center_slides(){
var seq__90254 = cljs.core.seq.call(null,dommy.utils.__GT_Array.call(null,document.querySelectorAll(".reveal section")));
var chunk__90255 = null;
var count__90256 = (0);
var i__90257 = (0);
while(true){
if((i__90257 < count__90256)){
var slide = cljs.core._nth.call(null,chunk__90255,i__90257);
if(dommy.core.has_class_QMARK_.call(null,slide,"align-top")){
} else {
dommy.core.add_class_BANG_.call(null,slide,"center");
}

var G__90258 = seq__90254;
var G__90259 = chunk__90255;
var G__90260 = count__90256;
var G__90261 = (i__90257 + (1));
seq__90254 = G__90258;
chunk__90255 = G__90259;
count__90256 = G__90260;
i__90257 = G__90261;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__90254);
if(temp__6753__auto__){
var seq__90254__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90254__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__90254__$1);
var G__90262 = cljs.core.chunk_rest.call(null,seq__90254__$1);
var G__90263 = c__67098__auto__;
var G__90264 = cljs.core.count.call(null,c__67098__auto__);
var G__90265 = (0);
seq__90254 = G__90262;
chunk__90255 = G__90263;
count__90256 = G__90264;
i__90257 = G__90265;
continue;
} else {
var slide = cljs.core.first.call(null,seq__90254__$1);
if(dommy.core.has_class_QMARK_.call(null,slide,"align-top")){
} else {
dommy.core.add_class_BANG_.call(null,slide,"center");
}

var G__90266 = cljs.core.next.call(null,seq__90254__$1);
var G__90267 = null;
var G__90268 = (0);
var G__90269 = (0);
seq__90254 = G__90266;
chunk__90255 = G__90267;
count__90256 = G__90268;
i__90257 = G__90269;
continue;
}
} else {
return null;
}
}
break;
}
});
mathdoc.cljs.drawmenu.init = (function mathdoc$cljs$drawmenu$init(){
console.log("drawmenu");

Reveal.addEventListener("slidechanged",cljs.core.juxt.call(null,mathdoc.cljs.drawmenu.load_slide_image_listener,mathdoc.cljs.drawmenu.clear_board));

Reveal.addEventListener("fragmentshown",mathdoc.cljs.drawmenu.load_slide_fragment_listener);

return Reveal.addEventListener("ready",cljs.core.juxt.call(null,mathdoc.cljs.drawmenu.maybe_hide_canvas,mathdoc.cljs.drawmenu.maybe_center_slides,mathdoc.cljs.drawmenu.add_download_listener,mathdoc.cljs.drawmenu.add_trash_listener,mathdoc.cljs.drawmenu.add_color_listeners));
});
goog.exportSymbol('mathdoc.cljs.drawmenu.init', mathdoc.cljs.drawmenu.init);

//# sourceMappingURL=drawmenu.js.map?rel=1489355970631