(ns talk.content.ist)
(defn c []
 [:div.slides
 [:section
  {:data-divtag "section", :class "titleslide"}
  [:h1
   [:span
    {}
    "Quest"
    " "
    "for"
    " "
    "a"
    "<br>"
    [:span
     {:style "font-size:0.9em", :class "brighter"}
     "unified"
     " "
     "theory"
     " "
     "of"
     "<br>"
     "efficient"
     " "
     "optimization:"]]]
  [:p
   [:img
    {:style
     "width:300px;height:250px;position:absolute;top:350px;right:-90px;opacity:1.0;",
     :src "/notebooks/mixture.png"}]]
  [:p
   [:img
    {:style
     "position:absolute;top: 350px;left:-109px;width: 400px;height: 250px;opacity:0.8;",
     :src "/figure/spikes.png"}]]
  "<!-- ![spikes](/figure/spikes-annotated.svg){style=\"width: 331px;position:absolute;top: 349px;left: -186px;\"} -->"
  [:p
   [:span
    {:class "bold bigger cyan bright"}
    "Proofs,"
    " "
    "Beliefs,"
    " "
    "and"
    " "
    "Algorithms"]]
  [:div
   {:id "section"}
   [:p [:em "David" " " "Steurer"]]
   [:p "Cornell" " " "and" " " "IAS"]]
  [:div
   {:id "section-1", :class "small justify"}
   [:p
    "based"
    " "
    "on"
    " "
    "joint"
    " "
    "works"
    " "
    "with"
    "\n"
    "Boaz"
    " "
    "Barak"
    " "
    "(Harvard),"
    "\n"
    "Sam"
    " "
    "Hopkins"
    " "
    "(Cornell),"
    "\n"
    "Jonathan"
    " "
    "Kelner"
    " "
    "(MIT),"
    "\n"
    "James"
    " "
    "Lee"
    " "
    "(Washington),"
    "\n"
    "Tengyu"
    " "
    "Ma"
    " "
    "(Princeton),"
    "\n"
    "Prasad"
    " "
    "Raghavendra"
    " "
    "(Berkeley),"
    "\n"
    "Tselil"
    " "
    "Schramm"
    " "
    "(Berkeley),"
    "\n"
    "Jonathan"
    " "
    "Shi"
    " "
    "(Cornell)"]]
  [:p "IST" " " "Austria," " " "January" " " "2017"]]
 [:section
  {:style "height:800px",
   :section 2,
   :id "section-pearson-1894-dawn-of-data-analysis",
   :class "align-top section level2"}
  [:h2
   "Pearson"
   " "
   "(1894):"
   " "
   "Dawn"
   " "
   "of"
   " "
   "Data"
   " "
   "Analysis"]
  [:div {:id "pearson"}]
  [:div
   {:id "section-2"}
   [:p
    [:img
     {:style
      "position:absolute;width:350px;top:250px;left:10px;z-index:1000000",
      :data-fragment-index "0",
      :class "fragment",
      :src "/figure/crab.png"}]
    "\n"
    [:span {:data-fragment-index "0", :class "fragment"}]
    "\n"
    [:span {:data-fragment-index "1", :class "fragment"}]
    "\n"
    [:span {:data-fragment-index "2", :class "fragment"}]
    "\n"
    [:img
     {:style
      "position:absolute;left:000px;top:100px;z-index:-1000;filter:invert(0.75);width:1000px;height:650px;transition: all .7s ease;",
      :data-fragment-index "2",
      :class "fragment",
      :src "/figure/pearson-data.jpg"}]]]
  [:div
   {:style "position:absolute;margin-left:15px;top:500px;left:0px",
    :data-fragment-index "3",
    :id "section-3",
    :class "brighter big fragment"}
   [:p
    [:span {:class "bold"} [:em "Pearson’s" " " "technique:"]]
    [:br]
    "method"
    " "
    "of"
    " "
    [:strong "(higher-order)" " " "moments"]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-pearsons-crabs-0-130",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "pearson’s" " " "crabs" " " "0-1:30"]
   "<!-- MESSAGE: mean and variance can lead to misleading conclusions about data and in these situations in can help to take higher moments into account -->"
   [:p
    "let"
    " "
    "me"
    " "
    "start"
    " "
    "with"
    " "
    "a"
    " "
    "famous"
    " "
    "and"
    " "
    "very"
    " "
    [:strong
     "interesting"
     " "
     "story"
     " "
     "about"
     " "
     "Karl"
     " "
     "Pearson"]
    " "
    "who"
    " "
    "was"
    " "
    "one"
    " "
    "of"
    " "
    "the"
    " "
    [:strong "founders" " " "of" " " "mathematical" " " "statistics"]]
   [:p
    "he"
    " "
    "was"
    " "
    "interested"
    " "
    "in"
    " "
    "a"
    " "
    [:strong "mathematical" " " "theory" " " "for" " " "evolution"]]
   "<!-- CLICK -->"
   [:p
    "he"
    " "
    "was"
    " "
    [:strong
     "analyzing"
     " "
     "the"
     " "
     "distribution"
     " "
     "of"
     " "
     "forheads"
     " "
     "widths"]
    " "
    "of"
    " "
    "a"
    " "
    "particular"
    " "
    "species"
    " "
    "of"
    " "
    "Crabs"]
   [:p
    "for"
    " "
    "biological"
    " "
    "reasons"
    " "
    "he"
    " "
    [:strong
     "expected"
     " "
     "this"
     " "
     "distribution"
     " "
     "to"
     " "
     "be"
     " "
     "Gaussian"]]
   [:p
    "but"
    " "
    "when"
    " "
    "he"
    " "
    "compared"
    " "
    "the"
    " "
    "distribution"
    " "
    "of"
    " "
    "the"
    " "
    "data"
    " "
    "to"
    " "
    "a"
    " "
    "Gaussian"
    " "
    "with"
    " "
    "the"
    " "
    "same"
    " "
    [:strong "mean" " " "and" " " "the" " " "variance"]
    " "
    "he"
    " "
    "noticed"
    " "
    "that"
    " "
    "the"
    " "
    "distributions"
    " "
    "don’t"
    " "
    "match"
    " "
    "up"]
   [:p
    "in"
    " "
    "particular"
    " "
    [:strong
     "higher"
     " "
     "moments,"
     " "
     "like"
     " "
     "the"
     " "
     "third"
     " "
     "or"
     " "
     "fourth"
     " "
     "moment,"]
    " "
    "of"
    " "
    "the"
    " "
    "distributions"
    " "
    "differed"
    " "
    "significantly"]
   "<!-- CLICK -->"
   [:p
    "the"
    " "
    [:strong
     "explanation"
     " "
     "that"
     " "
     "he"
     " "
     "came"
     " "
     "up"
     " "
     "with"]
    " "
    "is"
    " "
    "that"
    " "
    "the"
    " "
    "distribution"
    " "
    "is"
    " "
    "actually"
    " "
    "a"
    " "
    [:strong
     "mixture"
     " "
     "of"
     " "
     "two"
     " "
     "different"
     " "
     "Gaussian"
     " "
     "distributions"]
    " "
    "corresponding"
    " "
    "to"
    " "
    "two"
    " "
    "subspecies"
    " "
    "of"
    " "
    "crabs"
    " "
    "with"
    " "
    "differently"
    " "
    "distributed"
    " "
    "forehead"
    " "
    "widths"]
   "<!-- CLICK -->"
   [:p
    "JOKE:"
    " "
    "what"
    " "
    "you"
    " "
    "see"
    " "
    "here"
    " "
    "are"
    " "
    "the"
    " "
    "hand-drawn"
    " "
    "plots"
    " "
    "from"
    " "
    "the"
    " "
    "appendix"
    " "
    "of"
    " "
    "Pearson’s"
    " "
    "paper"]
   [:div
    {:section 4,
     :id "section-pearsons-method",
     :class "section level4"}
    [:h4 "pearson’s" " " "method"]
    [:p
     "what’s"
     " "
     "also"
     " "
     "very"
     " "
     "interesting"
     " "
     "about"
     " "
     "Pearson’s"
     " "
     "paper"
     " "
     "is"
     " "
     "the"
     " "
     "method"
     " "
     "that"
     " "
     "he"
     " "
     "used"
     " "
     "to"
     " "
     "come"
     " "
     "up"
     " "
     "with"
     " "
     "the"
     " "
     [:strong "parameters" " " "of" " " "the" " " "mixture"]]
    "<!-- CLICK -->"
    [:p
     "in"
     " "
     "paritcular"
     " "
     "he"
     " "
     "used"
     " "
     [:strong "higher-order" " " "moments"]
     " "
     "of"
     " "
     "the"
     " "
     "distribution"
     " "
     "of"
     " "
     "the"
     " "
     "data"
     " "
     "in"
     " "
     "order"
     " "
     "to"
     " "
     "inform"
     " "
     "the"
     " "
     "choice"
     " "
     "of"
     " "
     "those"
     " "
     "parameters"]
    [:p
     "Pearson’s"
     " "
     "technique"
     " "
     "is"
     " "
     "known"
     " "
     "as"
     " "
     [:strong "method" " " "of" " " "moments"]]]]]
 [:section
  {:data-menu-title "High dimensional data and tensor pca",
   :data-transition "slide-in fade-out",
   :section 2,
   :id "section-section-4",
   :class "align-top section level2"}
  [:h2]
  [:p
   [:em "nowadays:"]
   " "
   "analyze"
   "\n"
   [:strong "high-dimensional"]
   " "
   "data"
   " "
   [:span.math.inline "\\(x_1,\\ldots,x_m \\in {\\mathbf{R}}^d\\)"]
   [:br]
   "for"
   " "
   "example:"
   " "
   "images,"
   " "
   "videos,"
   " "
   "documents,"
   " "
   "…"]
  [:div
   {:data-fragment-index "7",
    :style "margin-bottom:-20px",
    :id "section-5",
    :class "fragment remove"}
   [:p
    [:img
     {:data-svg "/notebooks/singlegaussian.svg",
      :style "width:500px;position:absolute;left:0px;top:100px",
      :id "singlegaussian",
      :src "/notebooks/singlegaussian.png"}]
    "\n"
    [:img
     {:data-svg "/notebooks/mixture.svg",
      :data-fragment-index "1",
      :style
      "width:500px;position:absolute;visibility:visible;left:500px;top:100px",
      :id "mixturegaussian",
      :class "fragment fade-left",
      :src "/notebooks/mixture.png"}]]]
  [:div
   {:style "height:300px",
    :data-fragment-index "7",
    :id "section-6",
    :class "fragment remove"}]
  [:div
   {:data-fragment-index "4",
    :id "section-7",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "0",
     :id "section-8",
     :class "blockquote fragment"}
    [:p
     [:em "classical" " " "tool:"]
     " "
     [:strong "principal" " " "component" " " "analysis" " " "(PCA)"]
     [:br]
     "eigenvectors"
     " "
     "of"
     " "
     "covariance"
     " "
     "/"
     " "
     "second"
     " "
     "moment"
     " "
     "matrix;"
     [:br]
     "directions"
     " "
     "with"
     " "
     "maximum"
     " "
     "second"
     " "
     "moment"
     "\n"
     [:span
      {:data-fragment-index "2", :class "fragment remove-font"}
      [:span.math.inline
       "\\(\\max_{u\\in {\\mathbf{R}}^d,~{\\| u \\|}=1}\\sum_{i=1}^m {\\langle x_i,u \\rangle}^2\\)"]]]]]
  [:div
   {:data-fragment-index "4",
    :id "section-9",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "1", :id "section-10", :class "fragment"}
    [:p
     [:em "limitations" " " "of" " " "method:"]
     " "
     "e.g. can’t"
     " "
     "tell"
     " "
     "single"
     " "
     "Gaussian"
     " "
     "from"
     " "
     "mixture;"
     [:br]
     "covariance"
     " "
     "can"
     " "
     "be"
     " "
     [:span.math.inline "\\(\\approx\\)"]
     " "
     "identity"
     " "
     "matrix"
     " "
     "even"
     " "
     "for"
     " "
     "clustered"
     " "
     "data"]]]
  [:div
   {:data-fragment-index "2",
    :id "section-11",
    :class "fragment transition-delay fade-left bright"}
   [:p
    [:em "solution" " " "in" " " "Pearson’s" " " "spirit:"]
    " "
    [:span
     {:data-fragment-index "3",
      :class "fragment appear-font yellow bright bold"}
     "Tensor "]
    "PCA"
    [:span
     {:data-fragment-index "3",
      :class "fragment remove-font transition-delay"}
     " for"
     " "
     [:strong "higher-order" " " "moments"]]
    [:br]
    [:span
     {:data-fragment-index "4", :class "fragment transition-delay"}
     "find"
     " "
     "directions"
     " "
     "with"
     " "
     "max."
     " "
     "3rd"
     " "
     "moment"
     " "
     [:span
      {:class "bright"}
      [:span.math.inline
       "\\(\\max_{u\\in {\\mathbf{R}}^d,~{\\| u \\|}=1} \\sum_{i=1}^m {\\langle x_i,u \\rangle}^3\\)"]]]]]
  "<!-- >#{.fragment data-fragment-index=4 .transition-delay style=margin-top:-15px} -->"
  [:div
   {:data-fragment-index "5",
    :style "position:relative;top:-130px;left:170px;",
    :id "section-12",
    :class "fragment"}
   [:p
    [:img
     {:style "width:500px;height:300px;margin-left:-500px;",
      :class "floatright",
      :src "/figure/spikes.png"}]
    "\n"
    "<!-- TODO: replace figure so that it has 3 maxima -->"]]
  [:div
   {:data-fragment-index "5", :id "section-13", :class "fragment"}
   [:div
    {:data-fragment-index "6",
     :id "section-14",
     :class "fragment remove"}
    [:p
     [:em "it" " " "turns" " " "out:"]
     " "
     "Tensor"
     " "
     "PCA"
     " "
     "can"
     " "
     "find"
     " "
     "cluster"
     " "
     "centers"
     [:br]
     "even"
     " "
     "if"
     " "
     "classical"
     " "
     "PCA"
     " "
     "cannot"]]]
  [:div
   {:data-fragment-index "6",
    :id "section-15",
    :class "fragment bright"}
   [:p
    [:em "computationally" " " "challenging:"]
    " "
    "NP-hard"
    " "
    "in"
    " "
    "worst"
    " "
    "case"
    [:br]
    [:strong "non-convex" " " "optimization"]
    " "
    [:span
     {:class "small"}
     "(many"
     " "
     "bad"
     " "
     "local"
     " "
     "optima)"]]]
  "<!-- cluster centers appears as directions ... -->"
  "<!-- cluster centers arise as directions ... -->"
  "<!-- cluster centers turn out to be directions ... -->"
  "<!-- TODO: tractable for the kind of instances that arise in many data science applications -->"
  [:div
   {:data-fragment-index "7",
    :style "margin-top:1.2em;padding-bottom:15px",
    :id "section-16",
    :class "blockquote fragment transition-delay"}
   [:p
    [:em "despite" " " "challenges:"]
    " "
    "for"
    " "
    [:span
     {:class "bright"}
     [:strong
      "wide"
      " "
      "range"
      " "
      "of"
      " "
      "data"
      " "
      "analysis"
      " "
      "problems"]]
    ","
    "\n"
    "efficient"
    " "
    "algorithms"
    " "
    "with"
    " "
    [:em "best" " " "provable" " " "guarantees"]
    " "
    "all"
    " "
    "based"
    " "
    "on"]
   [:div
    {:data-anim-id "tensorpca",
     :data-fragment-index "7",
     :style "transition-delay:1.3s",
     :id "tensorpca",
     :class "anim-begin nofadeout fragment fade-left"}
    [:div
     {:style "color:white", :id "section-17", :class "center big bold"}
     [:p "Tensor" " " "PCA"]]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id
    "section-notes-high-dimensional-data-analysis-and-tensor-pca-130-500",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3
    "NOTES:"
    " "
    "high-dimensional"
    " "
    "data"
    " "
    "analysis"
    " "
    "and"
    " "
    "tensor"
    " "
    "pca"
    " "
    "1:30-5:00"]
   "<!-- MESSAGE: for high-dimensional data the same issues as in Pearson example appear and tensor PCA is a promising solution that generalizes principal component analysis by taking higher-order moments into account -->"
   "<!-- TODO: need to make it clear that the colors are not part of the input -->"
   "<!-- TODO: emphasize that we are doing unsupervised learning here -->"
   "<!-- TODO: make it clearer how the cluster centers correspond to the peaks of the function -->"
   [:div
    {:section 4,
     :id "section-high-dimensional-data-and-pca",
     :class "section level4"}
    [:h4 "high" " " "dimensional" " " "data" " " "and" " " "PCA"]
    [:p
     "in"
     " "
     "Pearsons"
     " "
     "case,"
     " "
     "each"
     " "
     [:strong
      "data"
      " "
      "point"
      " "
      "was"
      " "
      "a"
      " "
      "single"
      " "
      "number"]]
    [:p
     "and"
     " "
     [:strong
      "he"
      " "
      "had"
      " "
      "to"
      " "
      "do"
      " "
      "all"
      " "
      "calculations"
      " "
      "by"
      " "
      "hand"]]
    [:p
     "nowadays"
     " "
     "we"
     " "
     "have"
     " "
     "computers"
     " "
     "and"
     " "
     [:strong
      "want"
      " "
      "to"
      " "
      "analyze"
      " "
      "lots"
      " "
      "of"
      " "
      "high-dimensional"
      " "
      "data"]
     ","
     " "
     "which"
     " "
     "can"
     " "
     "be"
     " "
     "anything"
     " "
     "from"
     " "
     "images,"
     " "
     "video,"
     " "
     "documents,"
     " "
     "and"
     " "
     "audio"]
    "<!-- CLICK -->"
    [:p
     "an"
     " "
     [:strong "important" " " "classical" " " "tool"]
     " "
     "is"
     " "
     [:strong "principal" " " "component" " " "analysis"]
     " "
     "(which"
     " "
     "is"
     " "
     "also"
     " "
     "something"
     " "
     "that"
     " "
     "Pearson"
     " "
     "is"
     " "
     "known"
     " "
     "for)"]
    [:p
     "where"
     " "
     "we"
     " "
     "form"
     " "
     "the"
     " "
     [:strong
      "second"
      " "
      "moment"
      " "
      "or"
      " "
      "covariance"
      " "
      "matrix"
      " "
      "of"
      " "
      "our"
      " "
      "data"]
     " "
     "and"
     " "
     "compute"
     " "
     "its"
     " "
     "eigenvectors"]
    [:p
     "equivalently,"
     " "
     "PCA"
     " "
     "finds"
     " "
     [:strong
      "directions"
      " "
      "with"
      " "
      "maximum"
      " "
      "second"
      " "
      "moment"]
     " "
     "under"
     " "
     "the"
     " "
     "distribution"
     " "
     "that"
     " "
     "our"
     " "
     "data"
     " "
     "comes"
     " "
     "from"]
    [:p
     "the"
     " "
     "hope"
     " "
     "is"
     " "
     "that"
     " "
     "those"
     " "
     "directions"
     " "
     "tell"
     " "
     "us"
     " "
     "something"
     " "
     "interesting"
     " "
     "about"
     " "
     "the"
     " "
     "data"]]
   [:div
    {:section 4,
     :id "section-limitations-of-pca",
     :class "section level4"}
    [:h4 "limitations" " " "of" " " "PCA"]
    [:p
     "however,"
     " "
     "this"
     " "
     [:strong "method" " " "has" " " "serious" " " "limitations"]]
    [:p
     "the"
     " "
     "reason"
     " "
     "is"
     " "
     "that"
     " "
     "PCA"
     " "
     [:strong "only"]
     " "
     "take"
     " "
     "the"
     " "
     [:strong "mean" " " "and" " " "the" " " "variance"]
     " "
     "of"
     " "
     "our"
     " "
     "data"
     " "
     "into"
     " "
     "account"]
    [:p
     "as"
     " "
     [:strong "Pearson’s" " " "example"]
     " "
     "shows"
     " "
     "this"
     " "
     "can"
     " "
     "lead"
     " "
     "to"
     " "
     "problems"]
    "<!-- CLICK -->"
    [:p
     "in"
     " "
     "particular"
     " "
     "PCA"
     " "
     "cannot"
     " "
     "distinguish"
     " "
     "between"
     " "
     "the"
     " "
     "case"
     " "
     "that"
     " "
     "the"
     " "
     "data"
     " "
     "comes"
     " "
     "from"
     " "
     "a"
     " "
     [:strong "single" " " "Gaussian"]
     " "
     "or"
     " "
     "from"
     " "
     "a"
     " "
     "mixture"
     " "
     "of"
     " "
     [:strong
      "several"
      " "
      "different"
      " "
      "Gaussian"
      " "
      "distributions"]]
    [:p
     "concretely,"
     " "
     "the"
     " "
     "two"
     " "
     "datasets"
     " "
     "that"
     " "
     "you"
     " "
     "see"
     " "
     "here"
     " "
     "have"
     " "
     "the"
     " "
     "same"
     " "
     "first"
     " "
     "two"
     " "
     "moments"
     " "
     "even"
     " "
     "though"
     " "
     "the"
     " "
     "second"
     " "
     "distribution"
     " "
     "has"
     " "
     "distinct"
     " "
     "clusters"]]
   [:div
    {:section 4, :id "section-tensor-pca", :class "section level4"}
    [:h4 "tensor" " " "PCA"]
    [:p
     [:span
      {:style "color:red"}
      [:strong
       "what"
       " "
       "can"
       " "
       "we"
       " "
       "do"
       " "
       "to"
       " "
       "overcome"
       " "
       "these"
       " "
       "limitations?"]]]
    "<!-- CLICK -->"
    [:p
     [:strong
      "one"
      " "
      "approach"
      " "
      "informed"
      " "
      "by"
      " "
      "Pearson’s"
      " "
      "paper"]
     " "
     "is"
     " "
     "to"
     " "
     "high-dimensional"
     " "
     "component"
     " "
     "analysis"
     " "
     "in"
     " "
     "a"
     " "
     "way"
     " "
     "that"
     " "
     [:strong
      "takes"
      " "
      "higher-order"
      " "
      "moments"
      " "
      "into"
      " "
      "account"]
     " "
     "instead"
     " "
     "of"
     " "
     "just"
     " "
     "the"
     " "
     "first"
     " "
     "two"
     " "
     "moments"]
    "<!-- CLICK -->"
    [:p
     "this"
     " "
     "problem"
     " "
     "is"
     " "
     "also"
     " "
     "known"
     " "
     "as"
     " "
     [:strong "tensor" " " "PCA"]
     " "
     "which"
     " "
     "is"
     " "
     "going"
     " "
     "to"
     " "
     "be"
     " "
     "one"
     " "
     "of"
     " "
     "the"
     " "
     "topics"
     " "
     "of"
     " "
     "this"
     " "
     "talk"]
    "<!-- CLICK -->"
    [:p
     "instead"
     " "
     "of"
     " "
     "finding"
     " "
     "directions"
     " "
     "with"
     " "
     "maximum"
     " "
     "2nd"
     " "
     "moment,"
     " "
     "the"
     " "
     "goal"
     " "
     "is"
     " "
     "to"
     " "
     "find"
     " "
     [:strong
      "directions"
      " "
      "with"
      " "
      "maximum"
      " "
      "3rd"
      " "
      "moment"]]
    [:p
     "it"
     " "
     "turns"
     " "
     "out"
     " "
     "that"
     " "
     "under"
     " "
     [:strong "very" " " "general" " " "conditions"]
     " "
     "these"
     " "
     "directions"
     " "
     "allow"
     " "
     "us"
     " "
     "to"
     " "
     [:strong "identify" " " "cluster" " " "centers"]
     ","
     " "
     "even"
     " "
     "when"
     " "
     "classical"
     " "
     "PCA"
     " "
     "cannot"
     " "
     "identify"
     " "
     "them"]
    "<!-- TODO: annotate cluster centers -->"]
   [:div
    {:section 4,
     :id "section-computational-challenges",
     :class "section level4"}
    [:h4 "computational" " " "challenges"]
    "<!-- CLICK -->"
    [:p
     "on"
     " "
     "the"
     " "
     "other"
     " "
     "hand,"
     " "
     "it"
     " "
     "turns"
     " "
     "out"
     " "
     "that"
     " "
     "tensor"
     " "
     "PCA"
     " "
     "is"
     " "
     "computationally"
     " "
     "challenging"]
    [:p
     "unlike"
     " "
     "classical"
     " "
     "PCA"
     " "
     "which"
     " "
     "has"
     " "
     "general"
     " "
     "polynomial-time"
     " "
     "algorithm,"
     " "
     "Tensor"
     " "
     "PCA"
     " "
     "turns"
     " "
     "out"
     " "
     "to"
     " "
     "be"
     " "
     [:strong "NP-hard" " " "in" " " "the" " " "worst" " " "case"]]
    [:p
     "in"
     " "
     "particular"
     " "
     "tensor"
     " "
     "PCA"
     " "
     "asks"
     " "
     "us"
     " "
     "to"
     " "
     "solve"
     " "
     "a"
     " "
     [:strong "non-convex" " " "optimization" " " "problem"]
     " "
     "that"
     " "
     "can"
     " "
     "have"
     " "
     [:strong "many" " " "bad" " " "local" " " "optima"]]]
   [:div
    {:section 4,
     :id "section-comparison-with-other-approaches",
     :class "section level4"}
    [:h4 "comparison" " " "with" " " "other" " " "approaches"]
    [:p
     "of"
     " "
     "course"
     " "
     "there"
     " "
     "are"
     " "
     [:strong
      "many"
      " "
      "other"
      " "
      "approaches"
      " "
      "that"
      " "
      "try"
      " "
      "to"
      " "
      "overcome"
      " "
      "these"
      " "
      "limitations"]
     " "
     "of"
     " "
     "principal"
     " "
     "component"
     " "
     "analysis"]
    [:p
     "they"
     " "
     "all"
     " "
     "share"
     " "
     "this"
     " "
     "fate"
     " "
     "that"
     " "
     "they"
     " "
     "do"
     " "
     "not"
     " "
     "admit"
     " "
     "the"
     " "
     "same"
     " "
     "kind"
     " "
     "of"
     " "
     "general"
     " "
     "efficient"
     " "
     "algorithms"
     " "
     "as"
     " "
     "for"
     " "
     "PCA"]
    "<!-- CLICK -->"
    [:p
     "however"
     " "
     [:strong "what’s" " " "unique" " " "about" " " "tensor" " " "PCA"]
     " "
     "is"
     " "
     "that"
     " "
     "under"
     " "
     "very"
     " "
     "general"
     " "
     "conditions"
     " "
     "the"
     " "
     "kind"
     " "
     "of"
     " "
     [:strong
      "instances"
      " "
      "that"
      " "
      "arise"
      " "
      "in"
      " "
      "machine"
      " "
      "learning"
      " "
      "applications"]
     " "
     "do"
     " "
     "admit"
     " "
     [:strong "polynomial" " " "time" " " "algorithms"]
     " "
     "with"
     " "
     "strong"
     " "
     "provable"
     " "
     "guarantees"]
    [:p
     "in"
     " "
     "particular,"
     " "
     "for"
     " "
     "a"
     " "
     [:strong
      "wide"
      " "
      "range"
      " "
      "of"
      " "
      "important"
      " "
      "data-analysis"
      " "
      "problems"]
     " "
     "the"
     " "
     "efficient"
     " "
     "algorithms"
     " "
     "with"
     " "
     "best"
     " "
     "known"
     " "
     [:strong "provable" " " "guarantees"]
     " "
     "are"
     " "
     "all"
     " "
     "based"
     " "
     "on"
     " "
     "Tensor"
     " "
     "PCA"]
    "<!-- CLICK -->"
    [:p
     "this"
     " "
     "range"
     " "
     "of"
     " "
     "problems"
     " "
     "includes"
     " "
     "all"
     " "
     "of"
     " "
     "the"
     " "
     "following"
     " "
     "ones"
     " "
     "…"]]]]
 [:section
  {:data-menu-title "animation",
   :data-transition "none",
   :section 2,
   :id "section-section-18",
   :class "align-top section level2"}
  [:h2]
  [:div
   {:data-copy "tensorpca",
    :data-anim-id "tensorpca",
    :id "section-19",
    :class "anim-mid"}]]
 [:section
  {:data-menu-title "Tensor PCA central for data analysis",
   :data-transition "slide-out fade-in",
   :section 2,
   :id "section-section-20",
   :class "align-top nofadein section level2"}
  [:h2]
  [:div
   {:style "transform:scale(1.35,1.3)",
    :id "section-21",
    :class "center"}
   [:p
    [:img
     {:data-fragment-index "1",
      :style
      "margin-top:12px;filter:brightness(0.7);transition-duration:5s;",
      :class "fragment appeargrow",
      :src "/figure/tensormap.png"}]]]
  [:div
   {:data-copy "tensorpca",
    :data-anim-id "tensorpca",
    :style "position:relative;top:-400px;width:100%",
    :id "section-22",
    :class "anim-end"}]
  "<!-- center -->"
  [:div
   {:data-fragment-index "1",
    :style "position:absolute;top:0px;width:100%;transition-delay:1s",
    :id "section-23",
    :class "fragment center"}
   [:p
    [:span
     {:class "bold"}
     [:em "independent" " " "component" " " "analysis"]]
    [:br]
    [:span
     {:style "font-size:75%", :class "small"}
     "[Comon’94,"
     " "
     "Belouchrani-Abed-Meraim-Cardoso-Moulines’97]"]]]
  [:div
   {:data-fragment-index "1",
    :style
    "position:absolute;top:600px;width:100%;transition-delay:0.4s",
    :id "section-24",
    :class "fragment center"}
   [:p
    [:span {:class "bold"} [:em "topic" " " "modeling"]]
    [:br]
    [:span
     {:class "small"}
     "[Anandkumar-Ge-Hsu-Kakade-Telgarsky’14]"]]]
  "<!-- left -->"
  [:div
   {:data-fragment-index "1",
    :style
    "position:absolute;top:150px;left:-30px;width:500px;transition-delay:0.8s",
    :id "section-25",
    :class "fragment center"}
   [:p
    [:span {:class "bold"} [:em "mixture" " " "of" " " "Gaussians"]]
    [:br]
    [:span
     {:class "small"}
     "[Hsu-Kakade’13,"
     " "
     "Ge-Huang-Kakade’15]"]]]
  [:div
   {:data-fragment-index "1",
    :style
    "position:absolute;top:450px;left:-30px;width:500px;transition-delay:0.6s",
    :id "section-26",
    :class "fragment center"}
   [:p
    [:span {:class "bold"} [:em "community" " " "detection"]]
    [:br]
    [:span {:class "small"} "[Anandkumar-Ge-Hsu-Kakade’14]"]]]
  "<!-- right -->"
  [:div
   {:data-fragment-index "1",
    :style
    "position:absolute;top:150px;left:600px;width:500px;transition-delay:1.2s",
    :id "section-27",
    :class "fragment center"}
   [:p
    [:span
     {:class "bold brighter"}
     [:em "sparse" " " "dictionary" " " "learning"]]
    [:br]
    [:span
     {:class "small brighter"}
     "[Barak-Kelner-"
     [:strong "S."]
     "’15]"]
    [:br]
    [:img
     {:style "width:150px;position: relative;top: -275px;left: 136px;",
      :src "/figure/black%20white%20dictionary.png"}]]]
  [:div
   {:data-fragment-index "1",
    :style
    "position:absolute;top:450px;left:600px;width:500px;transition-delay:0.2s",
    :id "section-28",
    :class "fragment center"}
   [:p
    [:span {:class "bold"} [:em "hidden" " " "Markov" " " "models"]]
    [:br]
    [:span {:class "small"} "[Mossel-Roch’05]"]]]
  [:div
   {:data-fragment-index "2",
    :style
    "width:100%;position:absolute;top:355px;left:0px;background:rgba(0,0,0,0.9);",
    :id "section-29",
    :class "fragment blockquote fade-up"}
   [:p
    [:span {:class "italic"} [:strong "results:"]]
    "\n"
    [:span
     {:class "small"}
     "[Barak-Kelner-"
     [:strong "S."]
     " "
     "STOC’15,"
     "\n"
     "Ma-Shi-"
     [:strong "S."]
     " "
     "FOCS’16]"]
    [:br]
    "•"
    " "
    [:em "unified" " " "framework"]
    " "
    "for"
    " "
    "efficient"
    " "
    "Tensor"
    " "
    "PCA"
    " "
    "algorithms"
    [:br]
    "•"
    " "
    "achieves"
    " "
    [:em "strongest" " " "provable" " " "guarantees"]
    [:br]
    [:span
     {:data-fragment-index "3", :class "fragment"}
     "•"
     " "
     [:em "also:"]
     " "
     "fast"
     " "
     "and"
     " "
     "practical"
     " "
     "algorithms"
     " "
     [:span
      {:class "smaller"}
      "[Hopkins-Shi-Schramm-"
      [:strong "S."]
      "STOC’16]"]]]
   [:div
    {:data-fragment-index "4", :id "section-30", :class "fragment"}
    [:p
     [:span
      {:class "italic"}
      [:strong
       "consequences:"
       " "
       [:span
        {:class "brighter"}
        "sparse"
        " "
        "dictionary"
        " "
        "learning"]]]
     [:br]
     [:span
      {:data-fragment-index "4", :class "fragment"}
      [:em "previous" " " "provable" " " "methods:"]
      " "
      "only"
      " "
      "very"
      " "
      "sparse"
      " "
      "models"
      " "
      [:span
       {:class "SMALL block"}
       "[Spielman-Wang-Wright’12;"
       " "
       "Agarwal-Anandkumar-"
       "\n"
       "Jain-Netrapalli-Tandon’14;"
       " "
       "Arora-Ge-Moitra’14]"]]
     "\n"
     [:span
      {:data-fragment-index "5", :class "fragment"}
      [:em "our" " " "work:"]
      " "
      [:strong "full" " " "sparsity" " " "range"]]]]]
  "<!--  .floatright style=width:48%;margin-left:-10px -->"
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id
    "section-notes-tensor-decomposition-central-for-provable-data-analysis-500-700",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3
    "NOTES:"
    " "
    "tensor"
    " "
    "decomposition"
    " "
    "central"
    " "
    "for"
    " "
    "provable"
    " "
    "data"
    " "
    "analysis"
    " "
    "5:00-7:00"]
   "<!-- MESSAGE: tensor decomposition is a central primitive for learning and data analysis and better algorithms for it translate to better algorithms for a wide range of other problems -->"
   "<!-- TODO: make it clearer that we are improving previous works both quantitatively and qualitatively -->"
   "<!-- TODO: emphasize that we are solving sparse dictionary learning essentially best possible  -->"
   [:p
    "each"
    " "
    "of"
    " "
    "these"
    " "
    "problems"
    " "
    "is"
    " "
    [:strong "studied" " " "extensively"]
    " "
    "and"
    " "
    "often"
    " "
    "as"
    " "
    "substantial"
    " "
    "research"
    " "
    "area"
    " "
    "in"
    " "
    "its"
    " "
    "own"
    " "
    "right"]
   [:p
    "therefore"
    " "
    "it"
    " "
    "is"
    " "
    "really"
    " "
    "astounding"
    " "
    "that"
    " "
    [:strong
     "tensor"
     " "
     "PCA"
     " "
     "is"
     " "
     "able"
     " "
     "to"
     " "
     "unify"
     " "
     "all"
     " "
     "of"
     " "
     "these"
     " "
     "problems"]]
   [:div
    {:section 4,
     :id "section-quest-better-algorithms-for-tensor-pca",
     :class "section level4"}
    [:h4
     "quest:"
     " "
     "better"
     " "
     "algorithms"
     " "
     "for"
     " "
     "tensor"
     " "
     "PCA"]
    [:p
     "the"
     " "
     "reductions"
     " "
     "highlight"
     " "
     "the"
     " "
     [:strong
      "goal"
      " "
      "of"
      " "
      "coming"
      " "
      "up"
      " "
      "with"
      " "
      "better"
      " "
      "algorithm"
      " "
      "for"
      " "
      "tensor"]]
    [:p
     "because"
     " "
     "if"
     " "
     "we"
     " "
     "do,"
     " "
     "then"
     " "
     "through"
     " "
     "these"
     " "
     "reduction"
     " "
     "to"
     " "
     "Tensor"
     " "
     "PCA"
     " "
     "we"
     " "
     "get"
     " "
     "better"
     " "
     "algorithms"
     " "
     [:strong "for" " " "all" " " "these" " " "other" " " "problems"]
     " "
     "in"
     " "
     "one"
     " "
     "fell"
     " "
     "swoop"]]
   [:div
    {:section 4, :id "section-our-results", :class "section level4"}
    [:h4 "our" " " "results"]
    [:p
     "in"
     " "
     "a"
     " "
     "sequence"
     " "
     "of"
     " "
     "works"
     " "
     "my"
     " "
     "coauthors"
     " "
     "and"
     " "
     "I"
     " "
     "developed"
     " "
     "a"
     " "
     [:strong
      "unified"
      " "
      "framework"
      " "
      "for"
      " "
      "efficient"
      " "
      "algorithms"
      " "
      "for"
      " "
      "tensor"
      " "
      "PCA"]
     " "
     "and"
     " "
     "related"
     " "
     "problems"]
    [:p
     "our"
     " "
     "framework"
     " "
     "achieves"
     " "
     "the"
     " "
     [:strong "strongest" " " "provable" " " "guarantee"]
     " "
     "for"
     " "
     "all"
     " "
     [:strong
      "versions"
      " "
      "of"
      " "
      "tensor"
      " "
      "PCA"
      " "
      "studied"
      " "
      "in"
      " "
      "the"
      " "
      "literature"]
     " "
     "it"]
    [:p
     "often"
     " "
     "our"
     " "
     "guarantees"
     " "
     "are"
     " "
     [:strong "significantly" " " "stronger"]
     " "
     "than"
     " "
     "previous"
     " "
     "techniques"]
    [:p
     "the"
     " "
     "framework"
     " "
     "is"
     " "
     "also"
     " "
     "flexible"
     " "
     "enough"
     " "
     "to"
     " "
     "allow"
     " "
     "for"
     " "
     [:strong "fast" " " "and" " " "practical" " " "algorithms"]
     " "
     "with"
     " "
     "similar"
     " "
     "provable"
     " "
     "guarantees"]]
   [:div
    {:section 4,
     :id "section-highlight-sparse-dictionary-learning",
     :class "section level4"}
    [:h4 "highlight:" " " "sparse" " " "dictionary" " " "learning"]
    [:p
     "as"
     " "
     "an"
     " "
     "example,"
     " "
     "let’s"
     " "
     "see"
     " "
     "the"
     " "
     [:strong "concrete" " " "consequences"]
     " "
     "of"
     " "
     "our"
     " "
     "framework"
     " "
     "for"
     " "
     [:strong "sparse" " " "dictionary" " " "learning"]]
    [:p
     "this"
     " "
     "is"
     " "
     "a"
     " "
     "basic"
     " "
     "problem"
     " "
     "in"
     " "
     [:strong "deep" " " "learning"]
     " "
     "that"
     " "
     "has"
     " "
     "its"
     " "
     [:strong "origin" " " "in" " " "neuroscience"]
     " "
     "as"
     " "
     "a"
     " "
     "model"
     " "
     "for"
     " "
     "the"
     " "
     "visual"
     " "
     "cortex"]
    [:p
     "here"
     " "
     "an"
     " "
     [:strong
      "inherent"
      " "
      "limitation"
      " "
      "of"
      " "
      "all"
      " "
      "previous"
      " "
      "techniques"]
     " "
     "is"
     " "
     "that"
     " "
     "they"
     " "
     "only"
     " "
     "apply"
     " "
     "to"
     " "
     [:strong "very" " " "sparse" " " "models"]
     " "
     "which"
     " "
     "is"
     " "
     "often"
     " "
     "not"
     " "
     "realistic"]
    [:p
     "in"
     " "
     "contrast"
     " "
     [:strong
      "our"
      " "
      "work"
      " "
      "based"
      " "
      "on"
      " "
      "improved"
      " "
      "algorithms"
      " "
      "for"
      " "
      "tensor"
      " "
      "PCA"]
     " "
     "provides"
     " "
     "provable"
     " "
     "guarantees"
     " "
     "in"
     " "
     "the"
     " "
     [:strong "full" " " "range" " " "of" " " "sparsity"]]]]]
 [:section
  {:data-menu-title "complexity landscape",
   :section 2,
   :id "section-section-31",
   :class "align-top section level2"}
  [:h2]
  [:div {:id "complexitylandscape"}]
  [:p
   [:span {:data-fragment-index "0", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "1", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "2", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "3", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "4", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "5", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "6", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "7", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "8", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "9", :class "fragment"}]
   "\n"
   [:span {:data-fragment-index "10", :class "fragment"}]]
  [:div
   {:data-fragment-index "9",
    :id "section-32",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "5",
     :style "position:absolute;top:350px",
     :id "section-33",
     :class "tbodynoborder fragment"}
    [:table
     [:caption]
     [:thead [:tr [:th "theory"] [:th "practice"]]]
     [:tbody
      [:tr
       [:td "provable" " " "guarantees"]
       [:td
        [:span
         {:data-fragment-index "6", :class "fragment"}
         "empirical"
         " "
         "performance"]]]
      [:tr
       [:td "problem-specific" " " "algorithms"]
       [:td
        [:span
         {:data-fragment-index "6",
          :class "big bold bright yellow fragment"}
         "meta-algorithms"]]]]]]]
  [:div
   {:data-fragment-index "10",
    :id "section-34",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "7",
     :style "position:absolute;top:570px",
     :id "section-35",
     :class "blockquote fragment"}
    [:p
     [:strong "meta-algorithms:"]
     " "
     "apply"
     " "
     "to"
     " "
     "wide"
     " "
     "range"
     " "
     "of"
     " "
     "problems"
     [:br]
     [:em "examples:"]
     " "
     "gradient"
     " "
     "descent,"
     " "
     "belief"
     " "
     "propagation,"
     " "
     "expectation"
     " "
     "maximization,"
     " "
     "SAT"
     " "
     "solvers"
     " "
     [:span
      {:class "small"}
      "(all"
      " "
      "local-search"
      " "
      "based"
      " "
      "heurisitcs)"]]]]
  [:div
   {:data-fragment-index "10",
    :id "section-36",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "8",
     :style
     "position:absolute;top: 0px;width: 600px;background: rgba(0,0,0,0.6);",
     :id "section-37",
     :class "blockquote fragment"}
    [:p
     [:strong "advantages" " " "of" " " "meta-algorithms:"]
     [:br]
     "•"
     " "
     "problems"
     " "
     "often"
     " "
     "change"
     " "
     "/"
     " "
     "negotiable"
     [:br]
     "  "
     [:span.math.inline "\\(\\leadsto\\)"]
     " "
     [:span
      {:class "small"}
      "problem-specific"
      " "
      "methods"
      " "
      "of"
      " "
      "limited"
      " "
      "use"]
     [:br]
     "•"
     " "
     "easy"
     " "
     "to"
     " "
     "use"
     " "
     "for"
     " "
     "non-experts"]]]
  [:div
   {:data-fragment-index "9",
    :style
    "background:rgba(0,0,0,0.5);position:absolute;top: 276px;font-size: 110%;border-width:6px;border-color:yellow",
    :id "section-38",
    :class "blockquote fragment transition-delay fade-right"}
   [:p
    [:em "vision:"]
    "\n"
    [:span {:class "brighter bold"} [:em "unified" " " "theory"]]
    [:br]
    "•"
    " "
    "based"
    " "
    "on"
    " "
    [:strong "new" " " "meta-algorithms"]
    " "
    [:span {:class "small"} "(non-local)"]
    [:br]
    "•"
    " "
    "apply"
    " "
    "to"
    " "
    "equally"
    " "
    [:em "wide" " " "range" " " "of" " " "problems"]
    [:br]
    "•"
    " "
    [:em "best-possible" " " "guarantees"]
    " "
    "among"
    " "
    "all"
    " "
    "efficient"
    " "
    "algorithms"]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-complexity-landscape-700-1100",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "complexity" " " "landscape" " " "7:00-11:00"]
   [:p
    "there"
    " "
    "are"
    " "
    "many"
    " "
    "other"
    " "
    "algorithmic"
    " "
    "problems"
    " "
    "besides"
    " "
    "Tensor"
    " "
    "PCA"
    " "
    "that"
    " "
    "we"
    " "
    "wish"
    " "
    "to"
    " "
    "solve"
    " "
    "because"
    " "
    "they"
    " "
    "enable"
    " "
    "data"
    " "
    "analysis"
    " "
    "or"
    " "
    "other"
    " "
    "computing"
    " "
    "applications"]
   [:p
    "the"
    " "
    "results"
    " "
    "i"
    " "
    "have"
    " "
    "just"
    " "
    "talked"
    " "
    "about"
    " "
    "are"
    " "
    "part"
    " "
    "of"
    " "
    "a"
    " "
    "larger"
    " "
    "research"
    " "
    "effort"
    " "
    "that"
    " "
    "aims"
    " "
    "to"
    " "
    [:strong "develop" " " "efficient" " " "algorithms"]
    " "
    "for"
    " "
    "these"
    " "
    "problems"
    " "
    "and"
    " "
    "show"
    " "
    "that"
    " "
    "they"
    " "
    "are"
    " "
    "tractable"]
   [:p
    "another"
    " "
    "research"
    " "
    "effort"
    " "
    "I"
    " "
    "am"
    " "
    "involved"
    " "
    "in"
    " "
    "is"
    " "
    "to"
    " "
    [:strong
     "understand"
     " "
     "the"
     " "
     "limitations"
     " "
     "of"
     " "
     "efficient"
     " "
     "algorithms"]
    "*."]
   [:p
    "here"
    " "
    "we"
    " "
    "have"
    " "
    [:strong "strong" " " "evidence"]
    " "
    "that"
    " "
    "for"
    " "
    "some"
    " "
    "problems"
    " "
    "no"
    " "
    "efficient"
    " "
    "methods"
    " "
    "exist"
    " "
    "to"
    " "
    "solve"
    " "
    "them"
    " "
    "and"
    " "
    "that"
    " "
    "they"
    " "
    "are"
    " "
    [:strong "intractable"]]
   [:p
    "MAYBE:"
    " "
    "one"
    " "
    "form"
    " "
    "of"
    " "
    "such"
    " "
    "evidence"
    " "
    "is"
    " "
    "NP-hardness"]
   [:p
    "however"
    " "
    "our"
    " "
    [:strong
     "understanding"
     " "
     "of"
     " "
     "this"
     " "
     "picture"
     " "
     "is"
     " "
     "fragmented"]]
   [:p
    "many"
    " "
    "important"
    " "
    "problems"
    " "
    "are"
    " "
    "currently"
    " "
    "beyond"
    " "
    "the"
    " "
    [:strong "frontier"]
    " "
    "of"
    " "
    "what"
    " "
    "we"
    " "
    "know"
    " "
    "to"
    " "
    "be"
    " "
    "tractable"
    " "
    "or"
    " "
    "intractable."]
   [:p
    "The"
    " "
    "overarching"
    " "
    "goal"
    " "
    "of"
    " "
    "my"
    " "
    "research"
    " "
    "is"
    " "
    "to"
    " "
    [:strong "home" " " "in"]
    " "
    "on"
    " "
    "this"
    " "
    [:strong "frontier"]
    " "
    "and"
    " "
    "to"
    " "
    "uncover"
    " "
    "the"
    " "
    [:strong "underlying" " " "principles"]
    " "
    "that"
    " "
    [:strong "separate"]
    " "
    "tractable"
    " "
    "problems"
    " "
    "from"
    " "
    "intractable"
    " "
    "ones."]
   "<!-- remove questions about unified theory -->"
   [:div
    {:section 4,
     :id "section-theory-practice-and-meta-algorithms",
     :class "section level4"}
    [:h4 "theory," " " "practice," " " "and" " " "meta-algorithms"]
    [:p
     "i"
     " "
     "would"
     " "
     "like"
     " "
     "to"
     " "
     "connect"
     " "
     "this"
     " "
     "question"
     " "
     "to"
     " "
     [:strong
      "another"
      " "
      "important"
      " "
      "issue"
      " "
      "about"
      " "
      "efficient"
      " "
      "algorithms"]]
    [:p
     "if"
     " "
     "we"
     " "
     "look"
     " "
     "at"
     " "
     "the"
     " "
     "theory"
     " "
     "and"
     " "
     "practice"
     " "
     "of"
     " "
     "algorithms"
     " "
     "we"
     " "
     "see"
     " "
     [:strong "striking" " " "gaps"]
     " "
     "which"
     " "
     "I"
     " "
     "would"
     " "
     "like"
     " "
     "to"
     " "
     "bridge."]
    [:p
     "on"
     " "
     "the"
     " "
     "theory"
     " "
     "side,"
     " "
     "the"
     " "
     "algorithms"
     " "
     "have"
     " "
     "the"
     " "
     [:strong "strongest" " " "known" " " "provable" " " "guarantees"]
     "."
     "\n"
     "but"
     " "
     "at"
     " "
     "the"
     " "
     "same"
     " "
     "time,"
     " "
     "the"
     " "
     "algorithms"
     " "
     "and"
     " "
     "their"
     " "
     "analyses"
     " "
     "are"
     " "
     "currently"
     " "
     "very"
     " "
     [:strong "problem" " " "specific"]
     "."
     "\n"
     "make"
     " "
     "just"
     " "
     [:strong
      "minor"
      " "
      "changes"
      " "
      "in"
      " "
      "the"
      " "
      "problem"
      " "
      "formulation"]
     " "
     "and"
     " "
     "the"
     " "
     "guarantees"
     " "
     "go"
     " "
     "out"
     " "
     "of"
     " "
     "the"
     " "
     "window."]
    [:p
     "on"
     " "
     "the"
     " "
     "other"
     " "
     "side,"
     " "
     "many"
     " "
     "algorithms"
     " "
     "used"
     " "
     "in"
     " "
     "practice"
     " "
     "come"
     " "
     "from"
     " "
     [:strong "meta-algorithms"]
     "."
     "\n"
     "these"
     " "
     "are"
     " "
     "methods"
     " "
     "that"
     " "
     "are"
     " "
     [:strong
      "not"
      " "
      "tailored"
      " "
      "to"
      " "
      "particular"
      " "
      "problems"]
     " "
     "and"
     " "
     "instead"
     " "
     "apply"
     " "
     "to"
     " "
     "a"
     " "
     [:strong "wide" " " "range" " " "of" " " "problems"]
     "."
     "\n"
     [:strong "examples"]
     " "
     "are"
     " "
     "gradient"
     " "
     "descent,"
     " "
     "expectation"
     " "
     "maximization,"
     " "
     "belief"
     " "
     "propagation,"
     " "
     "and"
     " "
     "sat"
     " "
     "solvers."]
    [:p
     "All"
     " "
     "of"
     " "
     [:strong "these" " " "methods"]
     " "
     "are"
     " "
     "at"
     " "
     "heart"
     " "
     [:strong "based" " " "on" " " "local" " " "search"]
     "."
     "\n"
     "*Unfortunately,"
     [:strong " " "the" " "]
     "guarantees"
     [:strong
      " "
      "we"
      " "
      "can"
      " "
      "prove"
      " "
      "for"
      " "
      "these"
      " "
      "methods"
      " "
      "are"
      " "]
     "very"
     " "
     "weak**."]
    [:p
     "What"
     " "
     "makes"
     " "
     "meta-algorithms"
     " "
     "so"
     " "
     [:strong "appealing"]
     " "
     "is"
     " "
     "that"
     " "
     "in"
     " "
     [:strong "many" " " "applications"]
     " "
     "the"
     " "
     [:strong "problems" " " "we" " " "want" " " "to" " " "solve"]
     " "
     [:strong "change" " " "frequently"]
     " "
     "or"
     " "
     [:strong "their" " " "precise" " " "formulation"]
     " "
     "is"
     " "
     "up"
     " "
     "to"
     " "
     "negotiation."
     "\n"
     "In"
     " "
     "these"
     " "
     "cases,"
     " "
     "problem-specific"
     " "
     "methods"
     " "
     "are"
     " "
     "not"
     " "
     "so"
     " "
     "useful."
     "\n"
     "Another"
     " "
     "advantage"
     " "
     "is"
     " "
     "that"
     " "
     "meta-algorithms"
     " "
     "do"
     " "
     "not"
     " "
     "require"
     " "
     [:strong "domain" " " "knowledge"]
     " "
     "and"
     " "
     "therefore"
     " "
     "are"
     " "
     [:strong "easy" " " "to" " " "use" " " "for" " " "non-experts"]
     "."]]
   [:div
    {:section 4,
     :id "section-unified-theory-via-meta-algorithm",
     :class "section level4"}
    [:h4 "unified" " " "theory" " " "via" " " "meta" " " "algorithm"]
    [:p
     "My"
     " "
     "research"
     " "
     "has"
     " "
     "laid"
     " "
     "the"
     " "
     [:strong "ground" " " "work"]
     " "
     "for"
     " "
     "a"
     " "
     [:strong "unified" " " "theory"]
     " "
     "centered"
     " "
     "around"
     " "
     [:strong "new" " " "kinds" " " "of" " " "meta-algorithms"]
     " "
     "that"
     " "
     "for"
     " "
     "a"
     " "
     "wide"
     " "
     "range"
     " "
     "of"
     " "
     "optimization"
     " "
     "problems,"
     " "
     "achieve"
     " "
     [:strong "best-possible" " " "guarantees"]
     " "
     "among"
     " "
     [:strong "all" " " "efficient" " " "algorithms"]
     "."]
    [:p
     "Such"
     " "
     "a"
     " "
     "unified"
     " "
     "theory"
     " "
     "would"
     " "
     "bridge"
     " "
     "this"
     " "
     "gap"
     " "
     "between"
     " "
     "theory"
     " "
     "and"
     " "
     "practice"
     " "
     "and"
     " "
     "it"
     " "
     "would"
     " "
     "to"
     " "
     "a"
     " "
     "large"
     " "
     "extend"
     " "
     [:strong "complete" " " "our" " " "picture"]
     " "
     "of"
     " "
     "the"
     " "
     [:strong
      "landscape"
      " "
      "between"
      " "
      "tractability"
      " "
      "and"
      " "
      "intractability"]
     "."]]
   [:div
    {:section 4,
     :id "section-recent-developments",
     :class "section level4"}
    [:h4 "recent" " " "developments"]
    [:p
     "Only"
     " "
     "fifteen"
     " "
     "years"
     " "
     "ago,"
     " "
     "this"
     " "
     "kind"
     " "
     "of"
     " "
     "a"
     " "
     "unified"
     " "
     "theory"
     " "
     "would"
     " "
     "have"
     " "
     "been"
     " "
     [:strong "pure" " " "fantasy"]
     "."
     "\n"
     "However,"
     " "
     "there"
     " "
     "are"
     " "
     [:strong "recent" " " "developments"]
     " "
     "that"
     " "
     "for"
     " "
     "the"
     " "
     "first"
     " "
     "time"
     " "
     [:strong "give" " " "hope"]
     " "
     "that"
     " "
     "such"
     " "
     "a"
     " "
     "theory"
     " "
     "is"
     " "
     "not"
     " "
     "fantasy"
     " "
     "but"
     " "
     "within"
     " "
     "reach."
     "\n"
     "These"
     " "
     "developments"
     " "
     "are"
     " "
     "around"
     " "
     "the"
     " "
     [:strong "sum-of-squares"]
     " "
     "method."]
    [:p
     "Taken"
     " "
     "together,"
     " "
     "they"
     " "
     "point"
     " "
     "to"
     " "
     "an"
     " "
     "opportunity"
     " "
     "to"
     " "
     "bring"
     " "
     "a"
     " "
     "kind"
     " "
     "of"
     " "
     [:strong "conceptual" " " "clarity"]
     " "
     "to"
     " "
     "algorithm"
     " "
     "design"
     " "
     "that"
     " "
     "we"
     " "
     "had"
     " "
     [:strong "never" " " "anticipated"]
     "—it"
     " "
     "is"
     " "
     "an"
     " "
     "opportunity"
     " "
     "that"
     " "
     "I"
     " "
     "think"
     " "
     "is"
     " "
     "one"
     " "
     "of"
     " "
     "the"
     " "
     [:strong
      "most"
      " "
      "exciting"
      " "
      "developments"
      " "
      "on"
      " "
      "the"
      " "
      "horizon"]
     " "
     "for"
     " "
     "how"
     " "
     "we"
     " "
     "think"
     " "
     "about"
     " "
     "computing"
     " "
     "in"
     " "
     "general."]]]]
 [:section
  {:data-menu-title "sum-of-squares (SOS)",
   :data-background "/figure/superman-fade.png",
   :section 2,
   :id "section-section-39",
   :class "section level2"}
  [:h2]
  "<!-- data-background=/figure/superman.png -->"
  "<!-- > # {.shadedquote style=\"width:100%;padding:1px 20px 20px 20px;margin-top:300px\"} -->"
  [:div
   {:id "section-40", :class "wrapmargin"}
   [:div
    {:data-fragment-index "1",
     :id "section-41",
     :class "fragment marginremove"}
    [:div {:style "height:350px", :id "section-42"}]
    [:p
     [:span
      {:class "brighter bold big"}
      [:em
       "promising"
       " "
       "candidate"
       " "
       "algorithm"
       " "
       "for"
       " "
       "unified"
       " "
       "theory:"]]]]]
  [:div
   {:id "section-43", :class "wrapmargin"}
   [:div
    {:data-fragment-index "4",
     :id "section-44",
     :class "fragment marginremove"}
    [:div
     {:style "background:rgba(0,0,0,0.5);padding-bottom:15px",
      :id "section-45",
      :class "blockquote"}
     [:p
      [:span
       {:class "big brighter"}
       [:strong "sum-of-squares" " " "(SOS)"]
       " "
       [:span
        {:class "small"}
        "[Shor’85,"
        " "
        "Parrilo’00,"
        " "
        "Lasserre’00]"]]]
     [:ul
      [:li
       "powerful"
       " "
       [:em "efficient" " " "meta-algorithm"]
       " "
       "studied"
       " "
       "by"
       " "
       "many"
       " "
       "disciplines"]
      [:li
       "based"
       " "
       "on"
       " "
       "systematic"
       " "
       "convex"
       " "
       "relaxations"
       " "
       [:span {:class "small"} "(semidefinite" " " "programming)"]]]
     [:div
      {:data-fragment-index "0", :id "section-46", :class "fragment"}
      [:ul
       [:li
        "conjectured"
        " "
        "to"
        " "
        "have"
        " "
        [:span {:class "bright"} [:strong "optimal" " " "guarantees"]]
        " "
        [:span {:class "small"} "[Khot’02," " " "Raghavendra’08]"]
        "\n"
        "for"
        " "
        "many"
        " "
        [:em
         "worst-case"
         " "
         "discrete"
         " "
         "optimization"
         " "
         "problems"]
        "\n"
        [:span
         {:class "small"}
         "(like"
         " "
         "Max"
         " "
         "Cut,"
         " "
         "Sparsest"
         " "
         "Cut,"
         " "
         "Vertex"
         " "
         "Cover)"]
        [:span
         {:class "small bright"}
         "—based"
         " "
         "on"
         " "
         [:strong "Unique" " " "Games" " " "Conjecture"]]]]]]]]
  [:div
   {:style "margin-bottom:30px;margin-top:30px",
    :data-fragment-index "1",
    :id "section-47",
    :class "center fragment transition-delay"}
   [:p
    [:span
     {:class "italic magenta brighter bold big"}
     "for"
     " "
     "what"
     " "
     "range"
     " "
     "of"
     " "
     "problems"
     " "
     "does"
     [:br]
     "SOS"
     " "
     "achieve"
     " "
     "optimal"
     " "
     "guarantees?"]]]
  [:div
   {:data-fragment-index "2",
    :id "section-48",
    :class "big bright fragment"}
   [:p
    [:em "goal:"]
    " "
    "gain"
    " "
    [:strong
     "new"
     " "
     "insights"
     " "
     "at"
     " "
     "frontier"
     " "
     "of"
     " "
     "(in)tractability"]]]
  [:div
   {:data-fragment-index "3",
    :id "section-49",
    :class "big brighter fragment"}
   [:p
    [:em "already:"]
    " "
    "applications"
    " "
    "to"
    " "
    [:span
     {:class "yellow"}
     "machine"
     " "
     "learning,"
     " "
     "quantum"
     " "
     "information,"
     " "
     "and"
     " "
     "convex"
     " "
     "geometry"]]]
  "<!-- style=\"position:absolute; top:400px; background: rgba(0,0,0,0.9)\" -->"
  [:div
   {:data-fragment-index "4",
    :style "background:rgba(0,0,0,0.5)",
    :id "section-50",
    :class "blockquote fragment big fade-up transition-delay"}
   [:p
    [:strong "unconditional" " " "result:"]
    " "
    [:span
     {:style "font-size:65%", :class "small"}
     "[Lee-Raghavendra-"
     [:strong "S."]
     ","
     " "
     [:em "STOC’15" " " "best" " " "paper" " " "award"]
     "]"]
    [:br]
    "SOS"
    " "
    "algorithm"
    " "
    "achieves"
    " "
    [:em "best-possible" " " "guarantees"]
    [:br]
    "for"
    " "
    "rich"
    " "
    "class"
    " "
    "of"
    " "
    "discrete"
    " "
    "optimization"
    " "
    "problems"
    [:br]
    "with"
    " "
    "respect"
    " "
    "to"
    " "
    [:em "powerful" " " "model" " " "of" " " "computation"]
    [:br]
    [:span
     {:style "display:block", :class "small"}
     "(captures"
     " "
     "alg’s"
     " "
     "based"
     " "
     "on"
     " "
     "linear"
     " "
     "and"
     " "
     "semidefinite"
     " "
     "programming)"]
    "\n"
    [:span
     {:style "display:block;font-size:80%",
      :data-fragment-index "5",
      :class "fragment"}
     [:span.math.inline "\\(\\leadsto\\)"]
     " "
     "strongest"
     " "
     [:em "unconditional" " " "lower" " " "bound"]
     " "
     "for"
     " "
     "NP-complete"
     " "
     "problem"]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-sos-1100-1300",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "SOS" " " "11:00-13:00"]
   [:p
    "Over"
    " "
    "the"
    " "
    "last"
    " "
    "couple"
    " "
    "my"
    " "
    "coauthors"
    " "
    "and"
    " "
    "I"
    " "
    "have"
    " "
    "identified"
    " "
    "a"
    " "
    [:strong "promising" " " "candidate" " " "meta-algorithm"]
    " "
    "for"
    " "
    "such"
    " "
    "a"
    " "
    "unified"
    " "
    "theory"]
   [:p
    [:strong "this" " " "sum" " " "of" " " "squares" " " "algorithm"]
    " "
    "is"
    " "
    "a"
    " "
    "very"
    " "
    "powerful"
    " "
    [:strong "polynomial-time" " " "meta-algorithm"]
    " "
    "that"
    " "
    "has"
    " "
    "been"
    " "
    [:strong "studied" " " "extensively"]
    " "
    "by"
    " "
    "many"
    " "
    "discplines"]
   [:p
    "it"
    " "
    "is"
    " "
    "based"
    " "
    "on"
    " "
    "a"
    " "
    [:strong "systematic" " " "way"]
    " "
    "to"
    " "
    "generate"
    " "
    [:strong "convex" " " "programming" " " "relaxations"]
    " "
    "even"
    " "
    "for"
    " "
    "problems"
    " "
    "that"
    " "
    "are"
    " "
    [:strong "non-convex" " " "or" " " "discrete"]]
   [:div
    {:section 4, :id "section-conjectures", :class "section level4"}
    [:h4 "conjectures"]
    [:p
     [:strong "certain" " " "conjectures"]
     " "
     "actually"
     " "
     "imply"
     " "
     "that"
     " "
     "SOS"
     " "
     "achieves"
     " "
     [:strong "optimal" " " "guarantees"]
     " "
     "for"
     " "
     "interesting"
     " "
     "classes"
     " "
     "of"
     " "
     [:strong "worst-case" " " "optimization" " " "problems"]]
    [:p
     "however"
     " "
     "these"
     " "
     [:strong "conjectures" " " "may" " " "be" " " "too" " " "strong"]
     " "
     "and"
     " "
     "it"
     " "
     "is"
     " "
     "plausible"
     " "
     "that"
     " "
     "SOS"
     " "
     "is"
     " "
     "optimal"
     " "
     "even"
     " "
     "if"
     " "
     "these"
     " "
     [:strong
      "conjectures"
      " "
      "turn"
      " "
      "out"
      " "
      "to"
      " "
      "be"
      " "
      "false"]]]
   [:div
    {:section 4,
     :id "section-test-unified-theory",
     :class "section level4"}
    [:h4 "test" " " "unified" " " "theory"]
    [:p
     "a"
     " "
     [:strong "concrete" " " "goal" " " "of" " " "my" " " "research"]
     " "
     "is"
     " "
     "to"
     " "
     "answer"
     " "
     "to"
     " "
     "what"
     " "
     "extent"
     " "
     "a"
     " "
     "unified"
     " "
     "theory"
     " "
     "based"
     " "
     "on"
     " "
     "the"
     " "
     "sum-of-squares"
     " "
     "meta-algorithm"
     " "
     "is"
     " "
     "correct"]
    [:p
     "to"
     " "
     "that"
     " "
     "end"
     " "
     "we"
     " "
     "need"
     " "
     "to"
     " "
     "understand"
     " "
     [:strong "for" " " "what" " " "range" " " "of" " " "problems"]
     " "
     "SOS"
     " "
     "achieves"
     " "
     "optimal"
     " "
     "guarantees"]]
   [:div
    {:section 4, :id "section-bigger-picture", :class "section level4"}
    [:h4 "bigger" " " "picture"]
    [:p
     "But"
     " "
     "the"
     " "
     [:strong "bigger" " " "picture"]
     " "
     "is"
     " "
     "in"
     " "
     "this"
     " "
     "process"
     " "
     "we"
     " "
     "hope"
     " "
     "to"
     " "
     "gain"
     " "
     [:strong "new" " " "insights"]
     " "
     "at"
     " "
     "the"
     " "
     [:strong
      "frontier"
      " "
      "between"
      " "
      "tractability"
      " "
      "and"
      " "
      "intractability"]
     "."]
    [:p
     "In"
     " "
     "fact,"
     " "
     "we"
     " "
     "have"
     " "
     [:strong
      "already"
      " "
      "started"
      " "
      "to"
      " "
      "gain"
      " "
      "such"
      " "
      "insights"]
     " "
     "across"
     " "
     "several"
     " "
     "fields,"
     " "
     "from"
     " "
     [:strong "quantum" " " "information"]
     " "
     "and"
     " "
     [:strong "machine" " " "learning"]
     " "
     "to"
     " "
     [:strong "convex" " " "geometry"]
     "."]]
   [:div
    {:section 4,
     :id "section-unconditional-results",
     :class "section level4"}
    [:h4 "unconditional" " " "results"]
    [:p
     "a"
     " "
     [:strong "concrete" " " "unconditional" " " "result"]
     " "
     "that"
     " "
     "we"
     " "
     "have"
     " "
     "obtained"]
    [:p
     "is"
     " "
     "that"
     " "
     "sum"
     " "
     "of"
     " "
     "squares"
     " "
     "achieves"
     " "
     [:strong
      "best"
      " "
      "possible"
      " "
      "approximation"
      " "
      "guarantees"]
     "\n"
     "for"
     " "
     "a"
     " "
     "rich"
     " "
     "class"
     " "
     "of"
     " "
     "worst-case"
     " "
     "discrete"
     " "
     "optimization"
     " "
     "problems"
     " "
     "like"
     " "
     "Max"
     " "
     "Cut"]
    [:p
     "and"
     " "
     "the"
     " "
     "optimality"
     " "
     "of"
     " "
     "these"
     " "
     "guarantees"
     " "
     "is"
     " "
     "with"
     " "
     "respect"
     " "
     "to"
     " "
     "a"
     " "
     "restricted"
     " "
     "but"
     " "
     "powerful"
     " "
     "model"
     " "
     "of"
     " "
     "computation"
     " "
     "that"
     " "
     "aims"
     " "
     "to"
     " "
     "captures"
     " "
     "general"
     " "
     "algorithms"
     " "
     "based"
     " "
     "on"
     " "
     "linear"
     " "
     "and"
     " "
     "semidefinite"
     " "
     "programming"
     " "
     "relaxations"]]
   [:div
    {:section 4, :id "section-p-vs-np", :class "section level4"}
    [:h4 "P" " " "vs" " " "NP"]
    [:p
     "this"
     " "
     "result"
     " "
     "does"
     " "
     "not"
     " "
     "assume"
     " "
     "that"
     " "
     "P"
     " "
     "is"
     " "
     "different"
     " "
     "from"
     " "
     "NP"
     " "
     "and"
     " "
     "it"
     " "
     "turns"
     " "
     "out"
     " "
     "that"
     " "
     "it"
     " "
     "gives"
     " "
     "the"
     " "
     "by-far"
     " "
     "strongest"
     " "
     "known"
     " "
     "unconditional"
     " "
     "lower"
     " "
     "bound"
     " "
     "for"
     " "
     "NP-complete"
     " "
     "problems"
     " "
     "in"
     " "
     "any"
     " "
     "model"
     " "
     "of"
     " "
     "computation"]]]]
 [:section
  {:section 2, :id "section-talk-plan", :class "section level2"}
  [:h2 "talk" " " "plan"]
  [:div
   {:style "margin-top:1em", :id "section-51"}
   [:p
    [:span
     {:class "big bold yellow bright"}
     "sum-of-squares"
     " "
     "(SOS)"
     " "
     "meta-algorithm"]
    [:br]
    "algorithms"
    " "
    "from"
    " "
    "constructive"
    " "
    "proofs"
    " "
    "&"
    " "
    "new"
    " "
    "kind"
    " "
    "of"
    " "
    "probability"
    [:br]
    [:span
     {:class "small"}
     "[Barak-"
     [:strong "S."]
     "\n"
     "International"
     " "
     "Congress"
     " "
     "of"
     " "
     "Mathematicians’14]"]]]
  [:div
   {:style "margin-top:1em", :id "section-52", :class "fragment"}
   [:p
    [:span
     {:class "big bold yellow bright"}
     "SOS"
     " "
     "lens"
     " "
     "on"
     " "
     [:span
      {:class "bright italic"}
      "Tensor"
      " "
      "PCA"
      " "
      "and"
      " "
      "inference"]]
    [:br]
    "SOS"
    " "
    "gives"
    " "
    "strong"
    " "
    "provable"
    " "
    "guarantees"
    " "
    "and"
    " "
    "practical"
    " "
    "algorithms"
    [:br]
    [:span
     {:class "small"}
     "[Barak-Kelner-"
     [:strong "S."]
     " "
     "STOC’15,"
     " "
     "Hopkins-Schramm-Shi-"
     [:strong "S."]
     " "
     "STOC’16,"
     " "
     "Ma-Shi-"
     [:strong "S."]
     " "
     "FOCS’16]"]]]
  [:div
   {:style "margin-top:1em", :id "section-53", :class "fragment"}
   [:p
    [:span
     {:class "big bold yellow bright"}
     "SOS"
     " "
     "lens"
     " "
     "on"
     " "
     [:span
      {:class "bright italic"}
      "unconditional"
      " "
      "lower"
      " "
      "bounds"]]
    [:br]
    "SOS"
    " "
    "is"
    " "
    "optimal"
    " "
    "in"
    " "
    "restricted"
    " "
    "but"
    " "
    "powerful"
    " "
    "model"
    " "
    "of"
    " "
    "computation"
    [:br]
    [:span
     {:class "small"}
     "[Chan-Lee-Raghavendra-"
     [:strong "S."]
     " "
     [:em "JACM’16"]
     ","
     [:br]
     "Lee-Raghavendra-"
     [:strong "S."]
     ","
     " "
     [:em "STOC’15" " " "best" " " "paper" " " "award"]
     "]"]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-talk-plan-1300-1330",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "talk" " " "plan" " " "13:00-13:30"]
   [:p
    [:strong
     "the"
     " "
     "plan"
     " "
     "for"
     " "
     "the"
     " "
     "rest"
     " "
     "of"
     " "
     "the"
     " "
     "talk"]
    " "
    "is"
    " "
    "that"]
   [:p
    "first"
    " "
    "I"
    " "
    "want"
    " "
    "to"
    " "
    "explain"
    " "
    "the"
    " "
    "ideas"
    " "
    "behind"
    " "
    "the"
    " "
    "SOS"
    " "
    "algorithm"]
   [:p
    "the"
    " "
    "ideas"
    " "
    "turn"
    " "
    "out"
    " "
    "to"
    " "
    "be"
    " "
    [:strong "new" " " "constructive" " " "variants"]
    " "
    "of"
    " "
    "two"
    " "
    [:strong "ancient" " " "and" " " "universal" " " "concepts"]]
   [:p
    "the"
    " "
    "concept"
    " "
    "of"
    " "
    [:strong "proof"]
    " "
    "and"
    " "
    "the"
    " "
    "concept"
    " "
    "of"
    " "
    [:strong "probability"]]
   [:div
    {:section 4, :id "section-tensor-pca-1", :class "section level4"}
    [:h4 "tensor" " " "PCA"]
    [:p
     "then"
     " "
     "I"
     " "
     "want"
     " "
     "to"
     " "
     "show"
     " "
     "you"
     " "
     "how"
     " "
     "to"
     " "
     [:strong "apply" " " "these" " " "concepts"]
     " "
     "in"
     " "
     "order"
     " "
     "to"
     " "
     "obtain"
     " "
     [:strong "strong" " " "provable" " " "guarantees"]
     " "
     "for"
     " "
     [:strong "tensor" " " "PCA"]
     " "
     "and"
     " "
     [:strong "inference" " " "problems" " " "in" " " "general"]]]
   [:div
    {:section 4,
     :id "section-unconditional-lower-bounds",
     :class "section level4"}
    [:h4 "unconditional" " " "lower" " " "bounds"]
    [:p
     "finally"
     " "
     "I"
     " "
     "will"
     " "
     "show"
     " "
     "you"
     " "
     "how"
     " "
     "to"
     " "
     "use"
     " "
     [:strong "those" " " "concepts"]
     " "
     "in"
     " "
     "order"
     " "
     "to"
     " "
     "prove"
     " "
     "strong"
     " "
     "unconditional"
     " "
     "lower"
     " "
     "bounds"]]]]
 [:section
  {:section 2,
   :id "section-two-cultures-of-high-dim-optimization",
   :class "section level2"}
  [:h2
   "two"
   " "
   [:span.quote.double "“" "cultures" "”"]
   " "
   "of"
   " "
   "high-dim"
   " "
   "optimization"]
  "<!-- TODO: animate local minima of function so that they only appear at the right time -->"
  [:div
   {:class "fragment"}
   [:p
    [:img
     {:style "position: absolute;width:300px;left:200px;top: 110px;",
      :src "/notebooks/polynomial.svg"}]]
   [:div
    {:style "width:50%", :id "section-54", :class "floatleft"}
    [:p
     [:img {:style "height:200px", :src "/figure/newton.png"}]
     [:br]
     [:strong "Newton’s" " " "approach"]]
    [:p
     "search"
     " "
     "through"
     " "
     [:em "local" " " "optima"]
     [:br]
     [:span
      {:class "bright"}
      [:em "(local-search" " " "based" " " "heurisitcs)"]]]
    [:div
     {:class "fragment"}
     [:p
      [:strong "but:"]
      " "
      "simple"
      " "
      "non-convex"
      " "
      "functions"
      " "
      "can"
      " "
      "have"
      " "
      [:em
       "exponential"
       " "
       "number"
       " "
       "of"
       " "
       "bad"
       " "
       "local"
       " "
       "optima"]]]]]
  [:div
   {:class "fragment"}
   [:div
    {:style "width:50%", :id "section-55", :class "floatright"}
    [:div
     {:style "width:320px;font-size:100%;padding-top:70px",
      :id "section-56",
      :class "floatright bright"}
     [:p
      [:span.math.inline "\\(P(x)= \\tfrac 32 - \\tfrac 18 (x-1)^2\\)"]
      [:br]
      [:span.math.inline "\\(- (x-1)^2\\cdot (x+1)^2\\)"]]]
    [:p
     [:img {:style "height:200px", :src "/figure/hilbert.png"}]
     [:br]
     [:strong "Hilbert’s" " " "approach"]]
    [:p
     [:em "globally" " " "decompose"]
     " "
     "function"
     " "
     "into"
     " "
     "simple"
     " "
     "pieces"]
    [:div
     {:class "fragment"}
     [:p
      [:strong "sum-of-squares" " " "algorithm:"]
      [:br]
      "find"
      " "
      [:span.quote.double "“" "best" "”"]
      " "
      "decomposition"
      " "
      [:em "efficiently"]
      "\n"
      [:span
       {:class "appear-font fragment bright"}
       [:span.math.inline "\\(\\leadsto\\)"]
       " "
       [:em "strongest" " " "provable" " " "guarantees"]
       " "
       "for"
       " "
       "lots"
       " "
       "of"
       " "
       "problems"]]]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-newton-vs-hilbert-1330-1500",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "newton" " " "vs" " " "hilbert" " " "13:30-15:00"]
   [:p
    "To"
    " "
    "put"
    " "
    "the"
    " "
    [:strong "sum-of-squares" " " "algorithm" " " "into" " " "context"]
    ","
    " "
    "let"
    " "
    "me"
    " "
    "tell"
    " "
    "you"
    " "
    "about"
    " "
    "the"
    " "
    [:strong
     "two"
     " "
     "cultures"
     " "
     "of"
     " "
     "high-dimensional"
     " "
     "optimization"]]
   [:div
    {:section 4,
     :id "section-newton-and-calculus",
     :class "section level4"}
    [:h4 "Newton" " " "and" " " "calculus"]
    [:p
     "The"
     " "
     "most"
     " "
     [:strong
      "widely"
      " "
      "known"
      " "
      "and"
      " "
      "popular"
      " "
      "approach"]
     " "
     "goes"
     " "
     "back"
     " "
     "to"
     " "
     [:strong "Newton"]
     " "
     "and"
     " "
     "the"
     " "
     [:strong "invention" " " "of" " " "calculus"]]
    [:p
     "This"
     " "
     "approach"
     " "
     "searches"
     " "
     "through"
     " "
     [:strong "all" " " "local" " " "optima"]
     " "
     "of"
     " "
     "function"
     " "
     "in"
     " "
     "order"
     " "
     "to"
     " "
     "find"
     " "
     "a"
     " "
     "global"
     " "
     "optimum."
     "\n"
     "This"
     " "
     "approach"
     " "
     "is"
     " "
     "also"
     " "
     "the"
     " "
     "basis"
     " "
     "for"
     " "
     "all"
     " "
     [:strong "local-search" " " "based" " " "heuristics"]
     " "
     "that"
     " "
     "are"
     " "
     "popular"
     " "
     "in"
     " "
     "practice."]]
   [:div
    {:section 4,
     :id "section-trouble-for-local-search",
     :class "section level4"}
    [:h4 "trouble" " " "for" " " "local" " " "search"]
    [:p
     "Unfortunately,"
     " "
     "this"
     " "
     "approach"
     " "
     [:strong "runs" " " "into" " " "trouble"]
     " "
     "if"
     " "
     "the"
     " "
     "number"
     " "
     "of"
     " "
     "local"
     " "
     "optima"
     " "
     "is"
     " "
     [:strong "exponential"]
     " "
     "in"
     " "
     "the"
     " "
     "number"
     " "
     "of"
     " "
     "variables,"
     " "
     "which"
     " "
     "can"
     " "
     "happen"
     " "
     "even"
     " "
     "for"
     " "
     "very"
     " "
     "simple"
     " "
     [:strong "non-convex" " " "functions"]
     "."]
    [:p
     [:strong "for" " " "example"]
     " "
     "if"
     " "
     "the"
     " "
     "function"
     " "
     "has"
     " "
     "the"
     " "
     [:strong
      "form"
      " "
      "above"
      " "
      "with"
      " "
      "respect"
      " "
      "to"
      " "
      "each"
      " "
      "variable"]]]
   [:div
    {:section 4, :id "section-hilbert", :class "section level4"}
    [:h4 "hilbert"]
    [:p
     "To"
     " "
     [:strong "overcome" " " "this" " " "barrier,"]
     " "
     "we"
     " "
     "will"
     " "
     "turn"
     " "
     "to"
     " "
     "a"
     " "
     [:strong "fundamentally" " " "different"]
     " "
     "approach"
     " "
     "going"
     " "
     "back"
     " "
     "to"
     " "
     [:strong "Hilbert"]
     "."
     "\n"
     "This"
     " "
     "approach"
     " "
     "is"
     " "
     "to"
     " "
     [:strong "decompose"]
     " "
     "the"
     " "
     "function"
     " "
     "into"
     " "
     [:strong "simple" " " "pieces"]
     " "
     "so"
     " "
     "that"
     " "
     "the"
     " "
     "optimum"
     " "
     "value"
     " "
     "is"
     " "
     "apparent."
     "\n"
     "This"
     " "
     "approach"
     " "
     "avoids"
     " "
     "the"
     " "
     [:strong "curse" " " "of" " " "local" " " "optima"]
     " "
     "by"
     " "
     "exploiting"
     " "
     [:strong "global" " " "structure"]
     "."]]
   [:div
    {:section 4, :id "section-efficient", :class "section level4"}
    [:h4 "efficient"]
    [:p
     "What’s"
     " "
     "astounding"
     " "
     "is"
     " "
     "that"
     " "
     "Hilbert’s"
     " "
     "approach"
     " "
     "can"
     " "
     "be"
     " "
     "made"
     " "
     [:strong
      "efficient"
      " "
      "almost"
      " "
      "in"
      " "
      "full"
      " "
      "generality"]
     "."]
    [:p
     "and"
     " "
     "that"
     " "
     "is"
     " "
     "what"
     " "
     "the"
     " "
     [:strong "sum-of-squares" " " "algorithm" " " "achieves"]]
    [:p
     "Whenever"
     " "
     "there"
     " "
     "exists"
     " "
     "a"
     " "
     "decomposition"
     " "
     "of"
     " "
     "small"
     " "
     "size,"
     " "
     "the"
     " "
     [:strong "sum-of-squares" " " "method"]
     " "
     "can"
     " "
     "find"
     " "
     "it"
     " "
     "efficiently."]
    [:p
     "Moreover"
     " "
     [:strong
      "these"
      " "
      "decompositions"
      " "
      "capture"
      " "
      "the"
      " "
      "strongest"
      " "
      "provable"
      " "
      "guarantees"]
     " "
     "of"
     " "
     "efficient"
     " "
     "algorithms"
     " "
     "for"
     " "
     "lots"
     " "
     "of"
     " "
     "different"
     " "
     "problems"]]
   [:div
    {:section 4,
     :id "section-maybe-connection",
     :class "section level4"}
    [:h4 "MAYBE:" " " "connection"]
    [:p
     "some"
     " "
     "of"
     " "
     "my"
     " "
     "research"
     " "
     "is"
     " "
     "also"
     " "
     "aimed"
     " "
     "at"
     " "
     "unifying"
     " "
     "these"
     " "
     "approaches"
     " "
     "and"
     " "
     "connecting"
     " "
     "local"
     " "
     "search"
     " "
     "based"
     " "
     "algorithms"
     " "
     "to"
     " "
     "Hilbert’s"
     " "
     "approach"]]]]
 [:section
  {:data-menu-title "SOS proofs",
   :section 2,
   :id "section-section-57",
   :class "section level2"}
  [:h2]
  [:p
   "Hilbert’s"
   " "
   "approach"
   " "
   "to"
   " "
   "high-dimensional"
   " "
   "optimization"
   " "
   "maps"
   " "
   "to"
   [:br]
   [:em "powerful" " " "proof" " " "system"]
   " "
   "for"
   " "
   "polynomial"
   " "
   "ineq’s"
   " "
   "in"
   " "
   "many"
   " "
   "variables"]
  [:div
   {:class "fragment"}
   [:div
    {:id "section-58", :class "blockquote"}
    [:p
     [:strong "Sum-of-Squares" " " "(SOS)" " " "proofs:"]
     " "
     [:span {:class "small"} "(simplified)"]
     [:br]
     [:em "statements:"]
     "\n"
     [:span.quote.double
      "“"
      [:span.math.inline
       "\\(\\forall x\\in {\\mathbf{R}}^d. P(x)\\ge 0\\)"]
      "”"]
     " "
     "for"
     " "
     "polynomial"
     " "
     [:span.math.inline "\\(P\\)"]
     [:br]
     [:em "axioms:"]
     "\n"
     [:span.math.inline "\\(Q^2\\ge 0\\)"]
     " "
     "for"
     " "
     "every"
     " "
     "polynomial"
     " "
     [:span.math.inline "\\(Q\\)"]
     [:br]
     [:em "derivations:"]
     "\n"
     "if"
     " "
     [:span.math.inline "\\(P\\ge 0\\)"]
     " "
     "and"
     " "
     [:span.math.inline "\\(P'\\ge 0\\)"]
     " "
     "then"
     " "
     [:span.math.inline "\\(P\\cdot P'\\ge 0\\)"]
     " "
     "and"
     " "
     [:span.math.inline "\\(P+P'\\ge 0\\)"]]]]
  [:div
   {:class "fragment"}
   [:p
    [:strong
     "solution"
     " "
     "to"
     " "
     "Hilbert’s"
     " "
     "17th"
     " "
     "question:"]
    "\n"
    [:span
     {:class "small"}
     "[Artin’27,"
     " "
     "Krivine’64,"
     " "
     "Stengle’74]"]
    [:br]
    [:em "every" " " "true" " " "polynomial" " " "inequality"]
    " "
    "has"
    " "
    "SOS"
    " "
    "proof"]]
  [:div
   {:class "fragment"}
   [:div
    {:id "section-59", :class "blockquote"}
    [:div
     {:id "section-60", :class "brighter"}
     [:p
      [:strong "♥" " " "of" " " "SOS" " " "algorithm:"]
      " "
      [:span {:class "small"} "[Shor’85,Parrilo’00,Lasserre’00]"]
      "\n"
      "can"
      " "
      "find"
      " "
      "SOS"
      " "
      "proof"
      " "
      "in"
      " "
      "time"
      " "
      [:span.math.inline "\\(d^{O(k)}\\)"]
      " "
      "if"
      " "
      "all"
      " "
      [:em
       "intermediate"
       " "
       "polynomials"
       " "
       "have"
       " "
       "degree"
       " "
       [:span.math.inline "\\(\\le k\\)"]]]]]]
  [:div
   {:class "fragment"}
   [:div
    {:id "section-61", :class "bright"}
    [:p
     "many"
     " "
     [:strong [:span.quote.double "“" "real-world" " " "proofs" "”"]]
     " "
     "captured"
     " "
     "by"
     " "
     "low-deg"
     " "
     "SOS"
     " "
     "proofs,"
     [:br]
     "from"
     " "
     [:em "Cauchy–Schwarz"]
     " "
     "to"
     " "
     [:em "deep" " " "isoperimetric" " " "ineq’s"]
     " "
     [:span {:class "small"} "[BBHK" [:strong "S"] "Z’12]"]]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-sos-proofs-1500-1700",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "sos" " " "proofs" " " "15:00-17:00"]
   [:p
    "a"
    " "
    "useful"
    " "
    "way"
    " "
    "to"
    " "
    "describe"
    " "
    "the"
    " "
    [:strong
     "kinds"
     " "
     "of"
     " "
     "decompositions"
     " "
     "that"
     " "
     "SOS"
     " "
     "aims"
     " "
     "to"
     " "
     "find"]
    " "
    "is"
    " "
    "in"
    " "
    "terms"
    " "
    "of"
    " "
    "a"
    " "
    [:strong
     "proof"
     " "
     "system"
     " "
     "for"
     " "
     "polynomial"
     " "
     "inequalities"
     " "
     "in"
     " "
     "many"
     " "
     "variables"]]
   [:div
    {:section 4, :id "section-define-sos", :class "section level4"}
    [:h4 "define" " " "SOS"]
    [:p
     "suppose"
     " "
     "that"
     " "
     "we"
     " "
     "want"
     " "
     "to"
     " "
     "prove"
     " "
     "statements"
     " "
     "of"
     " "
     "the"
     " "
     "form"
     " "
     "that"
     " "
     "a"
     " "
     "given"
     " "
     "polynomial"
     " "
     "P"
     " "
     "in"
     " "
     "d"
     " "
     "variables"
     " "
     "over"
     " "
     "the"
     " "
     "reals"
     " "
     "only"
     " "
     "takes"
     " "
     "nonnegative"
     " "
     "values"]
    [:p
     "our"
     " "
     "axioms"
     " "
     "consist"
     " "
     "of"
     " "
     "polynomials"
     " "
     "that"
     " "
     "are"
     " "
     "syntactically"
     " "
     "nonnegative"
     " "
     "because"
     " "
     "they"
     " "
     "are"
     " "
     "the"
     " "
     "square"
     " "
     "of"
     " "
     "a"
     " "
     "polynomial"
     " "
     "Q"]
    [:p
     "starting"
     " "
     "from"
     " "
     "these"
     " "
     "axioms"
     " "
     "we"
     " "
     "can"
     " "
     "prove"
     " "
     "that"
     " "
     "the"
     " "
     "nonnegativity"
     " "
     "of"
     " "
     "other"
     " "
     "polynomials"
     " "
     "by"
     " "
     "applying"
     " "
     "operations"
     " "
     "that"
     " "
     "preserve"
     " "
     "nonnegative"
     " "
     "like"
     " "
     "adding"
     " "
     "and"
     " "
     "multiplying"]]
   [:div
    {:section 4, :id "section-completeness", :class "section level4"}
    [:h4 "completeness"]
    [:p
     "this"
     " "
     "proof"
     " "
     "system"
     " "
     "has"
     " "
     "three"
     " "
     [:strong "astounding" " " "properties"]
     ":"]
    [:p
     "answering"
     " "
     [:strong "one" " " "of" " " "Hilbert’s" " " "23" " " "questions"]
     ","
     " "
     "Artin"
     " "
     "and"
     " "
     "others"
     " "
     "showed"
     " "
     "that"
     " "
     [:strong "this" " " "proof" " " "system" " " "is" " " "complete"]
     ","
     " "
     "which"
     " "
     "means"
     " "
     "that"
     " "
     "every"
     " "
     "true"
     " "
     "polynomial"
     " "
     "inequality"
     " "
     "has"
     " "
     "a"
     " "
     "SOS"
     " "
     "proof"]]
   [:div
    {:section 4, :id "section-efficiency", :class "section level4"}
    [:h4 "efficiency"]
    [:p
     "another"
     " "
     [:strong "key" " " "property"]
     " "
     "is"
     " "
     "that"
     " "
     "this"
     " "
     "proof"
     " "
     "system"
     " "
     [:strong "admits" " " "efficient" " " "algorithms"]
     " "
     "in"
     " "
     "the"
     " "
     "sense"
     " "
     "that"
     " "
     "we"
     " "
     [:strong "can" " " "find" " " "SOS" " " "proofs"]
     " "
     "in"
     " "
     "polynomial"
     " "
     "time"
     " "
     "if"
     " "
     "we"
     " "
     [:strong "restrict" " " "the" " " "degrees"]
     " "
     "of"
     " "
     "the"
     " "
     [:strong "intermediates" " " "polynomials"]
     " "
     "in"
     " "
     "the"
     " "
     "proof"
     " "
     "by"
     " "
     "some"
     " "
     "constant"]]
   [:div
    {:section 4, :id "section-usefulness", :class "section level4"}
    [:h4 "usefulness"]
    [:p
     "the"
     " "
     [:strong "most" " " "surprising" " " "property"]
     " "
     "is"
     " "
     "that"
     " "
     [:strong
      "even"
      " "
      "though"
      " "
      "completeness"
      " "
      "is"
      " "
      "lost"]
     " "
     "when"
     " "
     "we"
     " "
     "restrict"
     " "
     "the"
     " "
     "degrees,"
     " "
     "it"
     " "
     "turns"
     " "
     "out"
     " "
     "that"
     " "
     [:strong "many" " " "natural" " " "real-world" " " "proofs"]
     " "
     "are"
     " "
     "in"
     " "
     "fact"
     " "
     "SOS"
     " "
     "proofs"
     " "
     "of"
     " "
     [:strong "low" " " "degree"]
     " "
     "and"
     " "
     "are"
     " "
     "therefore"
     " "
     "captured"
     " "
     "by"
     " "
     "this"
     " "
     [:strong "polynomial-time" " " "algorithm"]]]]]
 [:section
  {:data-divtag "section", :class "titleslide"}
  [:h1
   "SOS"
   " "
   "lens:"
   "<br>"
   [:span {:class "bright"} "Tensor" " " "PCA"]]
  [:div
   {:class "fragment"}
   [:p
    [:span
     {:class "big magenta bright bold"}
     "inefficient"
     " "
     "inference"
     " "
     [:span.math.inline
      "\\(\\stackrel{\\text{SOS proofs}}{\\class{big}{\\longmapsto}}\\)"]
     " "
     "efficient"
     " "
     "inference"]]]
  [:aside
   {:section 2,
    :data-divtag "aside",
    :id "section-notes-sos-lens-on-tensor-pca-and-inference",
    :class "section level2 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h2
    "NOTES:"
    " "
    "SOS"
    " "
    "lens"
    " "
    "on"
    " "
    "Tensor"
    " "
    "PCA"
    " "
    "and"
    " "
    "inference"]
   [:p
    "Next"
    " "
    "I"
    " "
    "will"
    " "
    "show"
    " "
    "you"
    " "
    "how"
    " "
    "the"
    " "
    "notion"
    " "
    "of"
    " "
    "SOS"
    " "
    "proofs"
    " "
    "allows"
    " "
    "us"
    " "
    "to"
    " "
    "convert"
    " "
    "inefficient"
    " "
    "inference"
    " "
    "algorithms"
    " "
    "to"
    " "
    "efficient"
    " "
    "ones"
    " "
    "under"
    " "
    "very"
    " "
    "weak"
    " "
    "conditions"]]]
 [:section
  {:data-menu-title "Inference algorithms from SOS proofs",
   :section 2,
   :id "section-section-62",
   :class "align-top section level2"}
  [:h2]
  "<!-- http://jsfiddle.net/n5XfG/2596/ -->"
  [:p
   [:img
    {:data-fragment-index "3",
     :data-svg "/notebooks/mixture.svg",
     :style
     "position:absolute;left:700px;top:-35px;width:500px;transform:scale(0.7,1);",
     :id "mixturegaussian2",
     :class "fragment fade-out",
     :src "/notebooks/mixture.png"}]]
  [:div
   {:id "section-63", :class "wrapmargin"}
   [:div
    {:data-fragment-index "3",
     :id "section-64",
     :class "fragment marginremove"}
    [:div
     {:style "width:750px", :id "section-65", :class "blockquote"}
     [:p
      [:strong
       "inference"
       " "
       "for"
       " "
       "mixtures"
       " "
       "of"
       " "
       "Gaussian:"]
      [:br]
      [:em "given:"]
      " "
      "small"
      " "
      "sample"
      " "
      "from"
      " "
      "mixture"
      " "
      "of"
      " "
      "Gaussians"
      [:br]
      [:em "goal:"]
      " "
      "recover"
      " "
      "cluster"
      " "
      "centers"]]
    [:div {:style "height:30px", :id "section-66"}]]]
  [:div
   {:data-fragment-index "0",
    :id "section-67",
    :class "wrapmargin fragment"}
   [:div
    {:data-fragment-index "4",
     :id "section-68",
     :class "fragment marginremove"}
    [:p
     [:em "identifiability:"]
     " "
     "sample"
     " "
     "<!-- uniquely  -->"
     "determines"
     " "
     "cluster"
     " "
     "centers"
     " "
     [:span {:class "small"} "(approximately)"]]
    [:p
     [:em "in" " " "general:"]
     " "
     "necessary"
     " "
     "but"
     " "
     "not"
     " "
     "sufficient"
     " "
     "for"
     " "
     [:strong "efficient"]
     " "
     "inference"]]]
  [:div
   {:data-fragment-index "1", :id "section-69", :class "fragment"}
   [:p
    [:em "proof" " " "of" " " "identifiability:"]
    " "
    [:span {:class "small"} "[Hsu-Kakade’13]"]
    " "
    "cluster"
    " "
    "centers"
    " "
    [:span.math.inline "\\(\\approx\\)"]
    [:br]
    "directions"
    " "
    "with"
    " "
    "maximum"
    " "
    "3rd"
    " "
    "moment"
    " "
    [:span {:class "bold yellow bright"} "(Tensor" " " "PCA)"]]
   [:p
    [:img
     {:style
      "position: relative;float: right;margin-left: -1000px;right: -180px;top: -220px;width: 400px;height: 240px;",
      :src "/figure/spikes.png"}]]]
  [:div
   {:data-fragment-index "2",
    :id "section-70",
    :class "blockquote fragment"}
   [:div
    {:id "section-71", :class "big brighter"}
    [:p
     [:strong
      "inference"
      " "
      "algorithms"
      " "
      "from"
      " "
      "SOS"
      " "
      "proofs:"]
     " "
     [:span
      {:class "small"}
      "[BK"
      [:strong "S"]
      "’15,MS"
      [:strong "S"]
      "’16]"]
     [:br]
     "if"
     " "
     [:span {:class "magenta"} "identifiability"]
     " "
     "has"
     " "
     "low-deg"
     " "
     "SOS"
     " "
     "proof,"
     " "
     "then"
     " "
     "SOS"
     " "
     "algorithm"
     " "
     "can"
     " "
     [:span
      {:class "magenta"}
      "efficiently"
      " "
      "recover"
      " "
      "cluster"
      " "
      "centers"]]]]
  [:div
   {:data-fragment-index "3",
    :style "transition-delay:.7s",
    :id "section-72",
    :class "wrapmargin fragment"}
   [:div
    {:data-fragment-index "5",
     :id "section-73",
     :class "fragment marginremove"}
    [:p
     "many"
     " "
     [:span.quote.double "“" "real-world" "”"]
     " "
     "identifi’ty"
     " "
     "proofs"
     " "
     "turn"
     " "
     "out"
     " "
     "to"
     " "
     "be"
     " "
     "low-deg"
     " "
     "SOS"
     [:br]
     [:span.math.inline "\\(\\leadsto\\)"]
     " "
     [:em "automatic"]
     " "
     "conversion"
     " "
     "to"
     " "
     [:span
      {:class "bright"}
      [:strong "efficient" " " "inference" " " "algorithms"]]]]]
  [:div
   {:data-fragment-index "4",
    :style "transition-delay:.7s",
    :id "section-74",
    :class "fragment wrapmargin"}
   [:div
    {:data-fragment-index "5",
     :id "section-75",
     :class "fragment marginremove"}
    [:div
     {:id "section-76", :class "blockquote bright"}
     [:p
      [:strong
       "additional"
       " "
       "benefits"
       " "
       "of"
       " "
       "SOS-based"
       " "
       "inference:"]
      [:br]
      "•"
      " "
      "require"
      " "
      "vastly"
      " "
      [:em "fewer" " " "samples"]
      [:span
       {:class "small"}
       "—especially"
       " "
       "when"
       " "
       "#clusters"
       " "
       [:span.math.inline "\\(\\gg\\)"]
       " "
       "dimension"]
      [:br]
      "•"
      " "
      "tolerate"
      " "
      "far"
      " "
      [:em "higher" " " "systematic" " " "error"]
      " "
      [:span {:class "orange"} "(model" " " "not" " " "exact)"]]]]]
  [:div
   {:data-fragment-index "5",
    :style "transition-delay:0.8s;margin-top:-20px",
    :id "section-77",
    :class "fragment"}
   [:p
    [:em "simplified" " " "identifi’ty" " " "example:"]
    "\n"
    "polynomial"
    " "
    [:span.math.inline "\\(\\color{green}{\\sum_{i} x_i^3}\\)"]
    " "
    "maximized"
    " "
    "over"
    " "
    "unit"
    " "
    "sphere"
    " "
    "by"
    " "
    [:strong "coordinate" " " "basis" " " "vectors"]
    "\n"
    [:span {:class "small"} "(uniquely)"]]]
  [:div
   {:data-fragment-index "6", :id "section-78", :class "fragment"}
   [:p
    [:em "in" " " "terms" " " "of" " " "polynomial" " " "inequalties:"]
    "\n"
    "every"
    " "
    [:span.math.inline "\\(x\\in{\\mathbf{R}}^d\\)"]
    " "
    "with"
    " "
    [:span.math.inline
     "\\(\\color{red}{\\sum_i x_i^2}\\le 1\\le \\color{green}{\\sum_i x_i^3}\\)"]
    " "
    "satisfies"
    " "
    [:span.math.inline "\\(\\color{yellow}{\\sum_i x_i^k}\\ge 1\\)"]
    " "
    "for"
    " "
    "all"
    " "
    [:span.math.inline "\\(k\\ge 4\\)"]]]
  [:div
   {:data-fragment-index "7", :id "section-79", :class "fragment"}
   [:p
    [:em
     "representative"
     " "
     "case"
     " "
     [:span.math.inline "\\(k=4\\)"]
     ":"]
    " "
    [:span
     {:class "small"}
     "(related"
     " "
     "to"
     " "
     "Cauchy–Schwarz"
     " "
     "and"
     " "
     "Hölder)"]
    [:br]
    [:span.math.inline
     "\\(\\tfrac 12 \\color{red}{\\sum_i x_i^2} + \\tfrac 12 \\color{yellow}{\\sum_i x_i^4} - \\color{green}{\\sum_i x_i^3}\\)"]
    "\n"
    [:span
     {:data-fragment-index "8", :class "fragment removefont"}
     [:span.math.inline "\\(\\ge 0\\)"]]
    "\n"
    [:span
     {:data-fragment-index "8", :class "fragment appearfont"}
     [:span.math.inline
      "\\(=\\underbrace{\\color{white}{\\tfrac12 ∑_i (x_i^2 - x_i)^2}}_{\\text{degree-4 SOS proof}}\\)"]]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-inference-via-sos-proofs",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "inference" " " "via" " " "SOS" " " "proofs"]
   [:p
    "let’s"
    " "
    [:strong "recall" " " "the" " " "example" " " "problem"]
    " "
    "from"
    " "
    "the"
    " "
    "beginning"]
   [:p
    "we"
    " "
    "are"
    " "
    "given"
    " "
    "sample"
    " "
    "points"
    " "
    "from"
    " "
    "a"
    " "
    [:strong "mixture" " " "of" " " "Gaussians"]
    " "
    "and"
    " "
    "the"
    " "
    "goal"
    " "
    "is"
    " "
    "to"
    " "
    "recover"
    " "
    "the"
    " "
    "cluster"
    " "
    "centers"]
   [:div
    {:section 4,
     :id "section-identifiability",
     :class "section level4"}
    [:h4 "identifiability"]
    [:p
     "a"
     " "
     [:strong "neceessary" " " "condition"]
     " "
     "for"
     " "
     "us"
     " "
     "to"
     " "
     "be"
     " "
     "able"
     " "
     "to"
     " "
     "recover"
     " "
     "the"
     " "
     "cluster"
     " "
     "centers"
     " "
     "is"
     " "
     [:strong "identifiability"]]
    [:p
     "which"
     " "
     "means"
     " "
     "that"
     " "
     "with"
     " "
     "high"
     " "
     "probability"
     " "
     "the"
     " "
     "sample"
     " "
     [:strong
      "uniquely"
      " "
      "determines"
      " "
      "the"
      " "
      "cluster"
      " "
      "centers"]
     " "
     "up"
     " "
     "to"
     " "
     "some"
     " "
     "small"
     " "
     "errorss"]
    [:p
     "for"
     " "
     "this"
     " "
     "problem"
     " "
     "it"
     " "
     "turns"
     " "
     "out"
     " "
     "that"
     " "
     "a"
     " "
     [:strong
      "polynomial"
      " "
      "number"
      " "
      "of"
      " "
      "sample"
      " "
      "points"]
     " "
     "are"
     " "
     "enough"
     " "
     "to"
     " "
     "ensure"
     " "
     "identifiability"]
    [:p
     "typically"
     " "
     "identifiability"
     " "
     "also"
     " "
     "means"
     " "
     "that"
     " "
     [:strong "there" " " "is" " " "a" " " "method"]
     " "
     "to"
     " "
     "recover"
     " "
     "the"
     " "
     "cluster"
     " "
     "centers"
     " "
     "but"
     " "
     [:strong
      "in"
      " "
      "general"
      " "
      "it"
      " "
      "will"
      " "
      "not"
      " "
      "be"
      " "
      "an"
      " "
      "efficient"
      " "
      "one"]]]
   [:div
    {:section 4,
     :id "section-identifiability-for-gmm",
     :class "section level4"}
    [:h4 "identifiability" " " "for" " " "GMM"]
    [:p
     [:strong "for" " " "our" " " "example" " " "problem"]
     ","
     " "
     "the"
     " "
     "reason"
     " "
     "that"
     " "
     "the"
     " "
     [:strong "cluster" " " "centers"]
     " "
     "are"
     " "
     "identifiable"
     " "
     "is"
     " "
     "that"
     " "
     "they"
     " "
     "turn"
     " "
     "out"
     " "
     "to"
     " "
     "be"
     " "
     "the"
     " "
     [:strong
      "unique"
      " "
      "directions"
      " "
      "with"
      " "
      "maximum"
      " "
      "3rd"
      " "
      "moment"]]
    [:p
     "therefore"
     " "
     "you"
     " "
     "could"
     " "
     "recover"
     " "
     "the"
     " "
     "clusters"
     " "
     "centers"
     " "
     "by"
     " "
     "some"
     " "
     [:strong
      "maximizing"
      " "
      "some"
      " "
      "explicit"
      " "
      "but"
      " "
      "non-convex"
      " "
      "function"]
     " "
     "determined"
     " "
     "by"
     " "
     "the"
     " "
     "sample"]
    [:p
     "however"
     " "
     "this"
     " "
     [:strong
      "does"
      " "
      "not"
      " "
      "say"
      " "
      "anything"
      " "
      "about"
      " "
      "efficient"
      " "
      "inference"]
     " "
     "because"
     " "
     "this"
     " "
     "problem"
     " "
     "is"
     " "
     "in"
     " "
     "NP-hard"
     " "
     "in"
     " "
     "the"
     " "
     "worst"
     " "
     "case"]]
   [:div
    {:section 4,
     :id "section-sos-proof-of-identifiability",
     :class "section level4"}
    [:h4 "SOS" " " "proof" " " "of" " " "identifiability"]
    [:p
     "what"
     " "
     "our"
     " "
     "work"
     " "
     "shows"
     " "
     "is"
     " "
     "that"
     " "
     "there"
     " "
     "is"
     " "
     "in"
     " "
     "fact"
     " "
     "a"
     " "
     [:strong "general" " " "transformation"]
     " "
     "from"
     " "
     [:strong "identifiability" " " "proofs"]
     " "
     "to"
     " "
     [:strong "efficient" " " "inference" " " "algorithms"]]
    [:p
     "the"
     " "
     "only"
     " "
     "condition"
     " "
     "is"
     " "
     "that"
     " "
     "the"
     " "
     "identifiability"
     " "
     "proof"
     " "
     "is"
     " "
     "captured"
     " "
     "by"
     " "
     "the"
     " "
     "SOS"
     " "
     "proof"
     " "
     "system"
     " "
     "at"
     " "
     "a"
     " "
     "low"
     " "
     "degree"]]
   [:div
    {:section 4, :id "section-consequences", :class "section level4"}
    [:h4 "consequences"]
    [:p
     "it"
     " "
     "turns"
     " "
     "out"
     " "
     "that"
     " "
     "this"
     " "
     "condition"
     " "
     "satisfied"
     " "
     "for"
     " "
     "many"
     " "
     "different"
     " "
     "models"]
    [:p
     "even"
     " "
     "for"
     " "
     "models"
     " "
     "where"
     " "
     "didn’t"
     " "
     "know"
     " "
     "efficient"
     " "
     "inference"
     " "
     "algorithm"
     " "
     "before"]]
   [:div
    {:section 4,
     :id "section-further-benefits",
     :class "section level4"}
    [:h4 "further" " " "benefits"]
    [:p
     "this"
     " "
     "result"
     " "
     "not"
     " "
     "only"
     " "
     "unifies"
     " "
     "many"
     " "
     "previous"
     " "
     "inference"
     " "
     "algorithms"
     " "
     "but"
     " "
     "also"
     " "
     "brings"
     " "
     "important"
     " "
     "new"
     " "
     "guarantees"
     " "
     "to"
     " "
     "the"
     " "
     "table"]
    [:p
     "for"
     " "
     "example"
     " "
     "the"
     " "
     "inference"
     " "
     "algorithms"
     " "
     "obtained"
     " "
     "from"
     " "
     "our"
     " "
     "general"
     " "
     "theorem"
     " "
     "tolerate"
     " "
     "far"
     " "
     "higher"
     " "
     "systematic"
     " "
     "errors"
     " "
     "than"
     " "
     "previous"
     " "
     "algorithms"]
    [:p
     "these"
     " "
     "kinds"
     " "
     "of"
     " "
     "errors"
     " "
     "occur"
     " "
     "if"
     " "
     "the"
     " "
     "model"
     " "
     "does"
     " "
     "not"
     " "
     "exactly"
     " "
     "capture"
     " "
     "the"
     " "
     "distribution,"
     " "
     "which"
     " "
     "is"
     " "
     "extremely"
     " "
     "common"
     " "
     "in"
     " "
     "real-world"
     " "
     "applications"]]
   [:div
    {:section 4,
     :id "section-simplified-example",
     :class "section level4"}
    [:h4 "simplified" " " "example"]
    "<!-- TODO -->"]]]
 [:section
  {:data-menu-title "pseudo-probability distributions",
   :section 2,
   :id "section-section-80",
   :class "align-top section level2"}
  [:h2]
  [:div
   {:id "section-81", :class "wrapmargin"}
   [:div
    {:data-fragment-index "4",
     :style "transition-duration:5s",
     :id "section-82",
     :class "fragment marginremove"}
    [:p
     [:span
      {:style "font-size:110%", :class "cyan bold header"}
      "from"
      " "
      "identifiability"
      " "
      "proof"
      " "
      "to"
      " "
      "efficient"
      " "
      "inference"]]
    [:p
     [:span
      {:data-fragment-index "0", :class "fragment"}
      "dual"
      " "
      "objects"
      " "
      "to"
      " "
      "SOS"
      " "
      "proofs:"]]]]
  [:div
   {:data-fragment-index "0",
    :id "section-83",
    :class "wrapmargin fragment"}
   [:div
    {:data-fragment-index "6",
     :id "section-84",
     :class "fragment marginremove"}
    [:div
     {:data-fragment-index "4",
      :style "transition-duration:0.8s",
      :id "section-85",
      :class
      "blockquote big fragment shrink transform-origin-left-top slightly-fade-out"}
     [:p
      [:span {:class "bright"} [:strong "pseudo-distributions:"]]
      [:br]
      "•"
      " "
      "generalize"
      " "
      [:strong "classical" " " "distributions"]
      [:br]
      "•"
      " "
      "model"
      " "
      [:strong "uncertainty"]
      " "
      "from"
      " "
      [:em "computational" " " "difficulty"]
      [:br]
      [:span
       {:data-fragment-index "1", :class "fragment"}
       "•"
       " "
       "admit"
       " "
       [:strong "efficient" " " "search"]
       " "
       "through"
       " "
       "moments"]
      [:br]
      [:span
       {:data-fragment-index "2", :class "fragment"}
       "•"
       " "
       [:em "behave" " " "like" " " "distributions"]
       " "
       "w.r.t."
       " "
       "SOS"
       " "
       "proofs"]]]]]
  [:div
   {:data-fragment-index "3",
    :id "section-86",
    :class "wrapmargin fragment"}
   [:div
    {:data-fragment-index "4",
     :id "section-87",
     :class "fragment marginremove"}
    [:p
     [:em "formally:"]
     "\n"
     [:strong "probabilities"]
     " "
     "may"
     " "
     "be"
     " "
     [:strong "negative"]
     " "
     "but"
     " "
     "polynomials"
     " "
     [:span.math.inline "\\(P\\)"]
     " "
     "have"
     " "
     [:strong "nonnegative" " " "expectation"]
     " "
     "if"
     " "
     [:span.quote.double "“" [:span.math.inline "\\(P\\ge 0\\)"] "”"]
     " "
     "has"
     " "
     [:em "low-deg" " " "SOS" " " "proof"]]]]
  [:div
   {:id "section-88", :class "wrapmargin"}
   [:div
    {:data-fragment-index "6",
     :style "height:100px",
     :id "section-89",
     :class "fragment marginappear fast-transition"}]]
  [:div
   {:data-fragment-index "4",
    :style "margin-top:-100px",
    :id "section-90",
    :class "blockquote fade-left fragment transition-delay"}
   [:p
    [:strong
     "SOS"
     " "
     "algorithm"
     " "
     "to"
     " "
     "recover"
     " "
     "cluster"
     " "
     "centers:"]
    [:br]
    [:span {:class "cyan"} "(1)"]
    " "
    "find"
    " "
    "moments"
    " "
    "of"
    " "
    [:em "pseudo-distribution"]
    " "
    [:span.math.inline "\\(\\mu\\)"]
    " "
    "consistent"
    " "
    "with"
    " "
    "data"
    [:br]
    [:span {:class "cyan"} "(2)"]
    " "
    "run"
    " "
    [:em "classical" " " "data" " " "analysis"]
    " "
    "on"
    " "
    "moments"
    " "
    "of"
    " "
    [:span.math.inline "\\(\\mu\\)"]]]
  [:div
   {:data-fragment-index "5", :id "section-91", :class "fragment"}
   [:p
    [:span
     {:class "bold yellow italic"}
     "analysis"
     " "
     "of"
     " "
     [:span {:class "cyan"} "(1)"]]]
   [:p
    "unlike"
    " "
    "for"
    " "
    "classical"
    " "
    "distributions,"
    " "
    [:span {:class "cyan"} "(1)"]
    " "
    "has"
    " "
    [:em "general" " " "poly-time" " " "alg."]]
   [:p
    "low-deg"
    " "
    "SOS"
    " "
    "identifiability"
    " "
    "proof"
    " "
    [:span.math.inline "\\(\\leadsto\\)"]
    " "
    "pseudo-dist’n"
    " "
    [:span.math.inline "\\(\\mu\\)"]
    " "
    "has"
    " "
    "same"
    " "
    "cluster"
    " "
    "centers"
    " "
    "as"
    " "
    "distribution"
    " "
    "of"
    " "
    "data"]]
  [:div
   {:data-fragment-index "6",
    :id "section-92",
    :class "fragment transition-delay"}
   [:p
    [:span
     {:class "bold yellow italic"}
     "analysis"
     " "
     "of"
     " "
     [:span {:class "cyan"} "(2)"]]]
   [:p
    "if"
    " "
    [:span.math.inline "\\(\\mu\\)"]
    " "
    "was"
    " "
    "actual"
    " "
    "distribution,"
    " "
    [:span {:class "cyan"} "(2)"]
    " "
    "easy"
    " "
    "because"
    " "
    "no"
    " "
    "data"
    " "
    "restrictions"]
   [:p
    [:span
     {:data-fragment-index "7", :class "fragment"}
     [:em "turns" " " "out:"]
     " "
     "classical"
     " "
     "data"
     " "
     "analysis"
     " "
     "algorithms"
     " "
     "also"
     " "
     "work"
     " "
     "for"
     " "
     "moments"
     " "
     "of"
     " "
     "pseudo-distributions"
     " "
     "because"
     " "
     "their"
     " "
     "analysis"
     " "
     "is"
     " "
     "captured"
     " "
     "by"
     " "
     "SOS"
     " "
     "proof"
     " "
     "system"]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-pseudo-probability",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "pseudo-probability"]
   [:p
    "let"
    " "
    "me"
    " "
    "show"
    " "
    "you"
    " "
    "how"
    " "
    "a"
    " "
    "constructive"
    " "
    "identifiability"
    " "
    "proof"
    " "
    "allows"
    " "
    "us"
    " "
    "to"
    " "
    "efficiently"
    " "
    "recover"
    " "
    "the"
    " "
    "cluster"
    " "
    "centers"]
   [:p
    "a"
    " "
    "key"
    " "
    "ingredient"
    " "
    "of"
    " "
    "this"
    " "
    "algorithm"
    " "
    "is"
    " "
    "a"
    " "
    "generalization"
    " "
    "of"
    " "
    "probability"
    " "
    "distributions,"
    " "
    "called"
    " "
    "pseudo-distributions"]
   [:p
    "classical"
    " "
    "distributions"
    " "
    "allow"
    " "
    "us"
    " "
    "to"
    " "
    "model"
    " "
    "the"
    " "
    "kind"
    " "
    "of"
    " "
    "uncertainty"
    " "
    "that"
    " "
    "arises"
    " "
    "from"
    " "
    "a"
    " "
    "lack"
    " "
    "of"
    " "
    "information"]
   [:p
    "however"
    " "
    "another"
    " "
    "important"
    " "
    "source"
    " "
    "of"
    " "
    "uncertainty"
    " "
    "is"
    " "
    "computational"
    " "
    "difficulty"]
   [:p
    "and"
    " "
    "this"
    " "
    "kind"
    " "
    "of"
    " "
    "uncertainty"
    " "
    "is"
    " "
    "what"
    " "
    "pseudo"
    " "
    "distributions"
    " "
    "also"
    " "
    "allow"
    " "
    "us"
    " "
    "to"
    " "
    "model"]
   [:p
    "use"
    " "
    "SOS"
    " "
    "proofs"
    " "
    "to"
    " "
    "tame"
    " "
    "pseudo-distributions"]
   [:div
    {:section 4, :id "section-tensor-pca-2", :class "section level4"}
    [:h4 "tensor" " " "pca"]
    [:p
     "for"
     " "
     "tensor"
     " "
     "PCA,"
     " "
     "the"
     " "
     "first"
     " "
     "step"
     " "
     "actually"
     " "
     "requires"
     " "
     "us"
     " "
     "to"
     " "
     "solve"
     " "
     "another"
     " "
     "instance"
     " "
     "of"
     " "
     "tensor"
     " "
     "PCA"
     " "
     "(for"
     " "
     "the"
     " "
     "moments"
     " "
     "of"
     " "
     "the"
     " "
     "distribution"
     " "
     "we"
     " "
     "found)"]
    [:p
     "the"
     " "
     "key"
     " "
     "difference"
     " "
     "is"
     " "
     "that"
     " "
     "we"
     " "
     "have"
     " "
     "more"
     " "
     "data"
     " "
     "available"
     " "
     "here"
     " "
     "which"
     " "
     "makes"
     " "
     "the"
     " "
     "problem"
     " "
     "easier"
     " "
     "(this"
     " "
     "happens"
     " "
     "often"
     " "
     "for"
     " "
     "data"
     " "
     "analysis"
     " "
     "problems)"]
    [:p "one-two" " " "combo" " " "of" " " "algorithm" " " "analysis"]
    [:p
     "first"
     " "
     "step"
     " "
     "is"
     " "
     "a"
     " "
     "necessary"
     " "
     "for"
     " "
     "coming"
     " "
     "up"
     " "
     "with"
     " "
     "an"
     " "
     "efficient"
     " "
     "algorithm"
     " "
     "and"
     " "
     "technically"
     " "
     "often"
     " "
     "substantially"
     " "
     "simplifer"
     " "
     "than"
     " "
     "coming"
     " "
     "up"
     " "
     "with"
     " "
     "an"
     " "
     "algorithm"
     " "
     "analysis"]
    [:p
     "second"
     " "
     "step"
     " "
     "often"
     " "
     "turns"
     " "
     "out"
     " "
     "to"
     " "
     "be"
     " "
     "technically"
     " "
     "involved"
     " "
     "but"
     " "
     "mechanical;"
     " "
     "there"
     " "
     "is"
     " "
     "a"
     " "
     "growing"
     " "
     "toolkit"
     " "
     "to"
     " "
     "carry"
     " "
     "out"
     " "
     "this"
     " "
     "step"]]]]
 [:section
  {:data-divtag "section", :class "titleslide"}
  [:h1
   "SOS"
   " "
   "lens:"
   "<br>"
   [:span {:class "bright"} "unconditional"]
   "<br>"
   "lower"
   " "
   "bounds"]]
 [:section
  {:data-menu-title "unconditional lower bounds",
   :section 2,
   :id "section-slide-lower",
   :class "align-top section level2"}
  [:h2]
  [:div
   {:id "section-93", :class "wrapmargin"}
   [:div
    {:data-fragment-index "0",
     :style "height:180px",
     :id "section-94",
     :class "fragment marginremove"}]]
  [:div
   {:id "section-95", :class "wrapmargin"}
   [:div
    {:data-fragment-index "2",
     :id "section-96",
     :class "fragment marginremove"}
    [:div
     {:id "section-97", :class "blockquote"}
     [:p
      [:span
       {:class "brighter"}
       "among"
       " "
       "the"
       " "
       [:span
        {:class "bold"}
        [:em "great" " " "intellectual" " " "quests"]]
       " "
       "of"
       " "
       "our"
       " "
       "times:"]]
     [:div
      {:style "font-size:2.5em",
       :id "section-98",
       :class "center bold yellow brighter bigger"}
      [:p "P" " " "versus" " " "NP"]]
     [:p
      [:span
       {:class "bright"}
       [:em "unfortunately:"]
       " "
       "we"
       " "
       "are"
       " "
       "still"
       " "
       "far"
       " "
       "from"
       " "
       "resolving"
       " "
       "it"]]]
    [:div
     {:data-fragment-index "0",
      :id "section-99",
      :class "fragment transition-delay"}
     [:p
      "toward"
      " "
      "better"
      " "
      "understanding"
      " "
      "the"
      " "
      [:span
       {:class "brighter yellow bold"}
       "P"
       " "
       "versus"
       " "
       "NP"
       " "
       "question"]
      ":"]]]]
  [:div
   {:id "section-100", :class "wrapmargin"}
   [:div
    {:data-fragment-index "5",
     :id "section-101",
     :class "fragment marginremove"}
    [:div
     {:data-fragment-index "0",
      :id "section-102",
      :class "blockquote fragment transition-delay"}
     [:p
      [:span
       {:class "yellow bold"}
       [:span
        {:class "big bright"}
        "unconditional"
        " "
        "lower"
        " "
        "bounds"]
       " "
       "for"
       " "
       "NP-complete"
       " "
       "problems"]
      [:br]
      [:span
       {:class "big"}
       [:em "to" " " "prove:"]
       " "
       [:span
        {:class "brighter"}
        "require"
        " "
        [:span {:class "bold"} [:em "super-polynomial"]]
        " "
        "resources"
        [:br]
        "in"
        " "
        [:span
         {:class "bold"}
         [:em "restricted" " " "but" " " "powerful" " " "models"]]
        " "
        "of"
        " "
        "computation"]
       [:br]
       [:em "examples:"]
       " "
       "circuit"
       " "
       "lower"
       " "
       "bounds"]]]]]
  [:div
   {:id "section-103", :class "wrapmargin"}
   [:div
    {:data-fragment-index "5",
     :id "section-104",
     :class "fragment marginremove"}
    [:div
     {:data-fragment-index "1", :id "section-105", :class "fragment"}
     [:p
      "can"
      " "
      "rule"
      " "
      "out"
      " "
      "large"
      " "
      "classes"
      " "
      "of"
      " "
      "potential"
      " "
      "P=NP"
      " "
      "proofs"
      " "
      [:span {:class "small"} "[Yannakakis’88]"]]]]]
  [:div
   {:id "section-106", :class "wrapmargin"}
   [:div
    {:data-fragment-index "5",
     :id "section-107",
     :class "fragment marginremove"}
    [:div
     {:data-fragment-index "2",
      :id "section-108",
      :class "fragment transition-delay bright"}
     [:p
      [:em
       "most"
       " "
       "powerful"
       " "
       "algorithmic"
       " "
       "techniques"
       " "
       "for"
       " "
       "NP-hard"
       " "
       "optimization:"]
      [:br]
      [:strong "linear" " " "programming" " " "(LP)"]
      " "
      "and"
      " "
      [:strong "semidefinite" " " "prog’ing" " " "(SDP)"]]]]]
  [:div
   {:id "section-109", :class "wrapmargin"}
   [:div
    {:data-fragment-index "5",
     :id "section-110",
     :class "fragment marginremove"}
    [:div
     {:data-fragment-index "3",
      :id "section-111",
      :class "fragment bright center"}
     [:p
      [:span
       {:class "bright bold big"}
       [:em
        "can"
        " "
        "we"
        " "
        "prove"
        " "
        "lower"
        " "
        "bounds"
        " "
        "against"
        " "
        "such"
        " "
        "techniques?"]]]]]]
  [:div
   {:data-fragment-index "4",
    :id "section-112",
    :class "blockquote fragment"}
   [:div
    {:id "section-113", :class "brighter"}
    [:p
     [:strong
      "lower"
      " "
      "bounds"
      " "
      "for"
      " "
      "LP"
      " "
      "&"
      " "
      "SDP-based"
      " "
      "algorithms"]
     " "
     [:span
      {:class "smaller"}
      "[Lee-Raghavendra-"
      [:strong "S."]
      "’16]"]
     [:br]
     "•"
     " "
     "many"
     " "
     "NP-hard"
     " "
     "optimization"
     " "
     "problems"
     " "
     [:span
      {:class "smaller"}
      "(Traveling"
      " "
      "Salesman,"
      " "
      "Max"
      " "
      "Cut,"
      " "
      "…)"]
     [:br]
     "•"
     " "
     "require"
     " "
     [:em "exponential"]
     " "
     "resources"]]]
  [:div
   {:id "section-114", :class "wrapmargin"}
   [:div
    {:data-fragment-index "7",
     :id "section-115",
     :class "fragment marginremove"}
    [:div
     {:data-fragment-index "5",
      :id "section-116",
      :class "fragment transition-delay"}
     [:p
      "previous"
      " "
      "lower"
      " "
      "bounds"
      " "
      "only"
      " "
      "apply"
      " "
      "to"
      " "
      [:strong "LP-based" " " "algorithms"]
      [:br]
      "("
      [:em "in" " " "particular:"]
      " "
      "do"
      " "
      "not"
      " "
      "capture"
      " "
      [:strong "SOS"]
      ")"
      "\n"
      [:span
       {:class "smaller"}
       "[Fiorini-Massar-Pokutta-Tiwary"
       " "
       "de"
       " "
       "Wolf’12,"
       "\n"
       "Braun-Pokutta-"
       [:strong "S."]
       ","
       "\n"
       "Braverman-Moitra,"
       "\n"
       "Chan-Lee-Raghavendra-"
       [:strong "S."]
       ","
       "\n"
       "Rothvoß]"]]]]]
  [:div
   {:data-fragment-index "6",
    :style "margin-top:-15px",
    :id "section-117",
    :class "fragment"}
   [:p
    [:strong "proof" " " "strategy:"]
    " "
    [:em "leverage" " " "power" " " "of" " " "SOS"]
    [:br]
    "•"
    " "
    [:em "show:"]
    " "
    "SOS"
    " "
    "is"
    " "
    "optimal"
    " "
    "LP/SDP"
    " "
    "algorithm"
    " "
    [:span
     {:class "small"}
     "(for"
     " "
     "rich"
     " "
     "class"
     " "
     "of"
     " "
     "problems)"]
    [:br]
    "•"
    " "
    [:em "conclude:"]
    " "
    "known"
    " "
    "lower"
    " "
    "bounds"
    " "
    "for"
    " "
    "SOS"
    " "
    "extend"
    " "
    "to"
    " "
    "general"
    " "
    "model"]]
  [:div
   {:data-fragment-index "7",
    :id "section-118",
    :class "blockquote fragment transition-delay"}
   [:p
    [:strong "concrete" " " "consequence:"]
    " "
    [:em "optimality" " " "of" " " "SOS"]
    [:br]
    "for"
    " "
    "rich"
    " "
    "class"
    " "
    "of"
    " "
    "optimization"
    " "
    "problems"
    " "
    "(e.g.,"
    " "
    [:span {:class "bright yellow"} "Max" " " "Cut"]
    "),"
    [:br]
    "SOS"
    " "
    "algorithm"
    " "
    "achieves"
    " "
    [:strong "optimal" " " "approximation" " " "guarantees"]
    [:br]
    "among"
    " "
    [:em "all" " " "polynomial" " " "SDP" " " "algorithms"]]]
  [:div
   {:data-fragment-index "8",
    :id "section-119",
    :class
    "fragment center big bold italic fade-left magenta brighter"}
   [:p
    "first"
    " "
    "unconditional"
    " "
    "evidence"
    " "
    "for"
    [:br]
    [:span {:class "brighter"} "unified" " " "theory"]
    " "
    "around"
    " "
    "SOS"]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-unconditional-lower-bounds",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "unconditional" " " "lower" " " "bounds"]
   [:p
    "our"
    " "
    "ability"
    " "
    "to"
    " "
    "prove"
    " "
    "these"
    " "
    "kinds"
    " "
    "of"
    " "
    "lower"
    " "
    "bounds"
    " "
    "is"
    " "
    "a"
    " "
    "requirement"
    " "
    "for"
    " "
    "eventually"
    " "
    "being"
    " "
    "able"
    " "
    "to"
    " "
    "prove"
    " "
    "that"
    " "
    "P!=P"]
   [:p
    "in"
    " "
    "addition"
    " "
    "these"
    " "
    "kinds"
    " "
    "of"
    " "
    "lower"
    " "
    "bounds"
    " "
    "can"
    " "
    "have"
    " "
    "interesting"
    " "
    "concrete"
    " "
    "consequences"]
   [:p
    "in"
    " "
    "particular,"
    " "
    "if"
    " "
    "the"
    " "
    "model"
    " "
    "of"
    " "
    "computation"
    " "
    "captures"
    " "
    "certain"
    " "
    "kinds"
    " "
    "of"
    " "
    "algorithms,"
    " "
    "then"
    " "
    "such"
    " "
    "a"
    " "
    "lower"
    " "
    "bound"
    " "
    "rules"
    " "
    "out"
    " "
    "P=NP"
    " "
    "proofs"
    " "
    "based"
    " "
    "on"
    " "
    "these"
    " "
    "kinds"
    " "
    "of"
    " "
    "algorithms"]
   [:p
    "this"
    " "
    "motivation"
    " "
    "was"
    " "
    "behind"
    " "
    "a"
    " "
    "very"
    " "
    "influential"
    " "
    "work"
    " "
    "of"
    " "
    "Yannakakis"]
   [:p
    "this"
    " "
    "result"
    " "
    "improves"
    " "
    "of"
    " "
    "previous"
    " "
    "lower"
    " "
    "bounds"
    " "
    "which"
    " "
    "only"
    " "
    "apply"
    " "
    "to"
    " "
    "LP-based"
    " "
    "algorithm"
    " "
    "and"
    " "
    "in"
    " "
    "particular"
    " "
    "do"
    " "
    "not"
    " "
    "capture"
    " "
    "sum"
    " "
    "of"
    " "
    "squares"]
   [:p
    "our"
    " "
    "proof"
    " "
    "builds"
    " "
    "on"
    " "
    "a"
    " "
    "surprising"
    " "
    "connection"
    " "
    "to"
    " "
    "SOS"]
   [:div
    {:section 4, :id "section-old-notes", :class "section level4"}
    [:h4 "old" " " "notes"]
    [:p
     "general"
     " "
     "goal"
     " "
     "in"
     " "
     "theoretical"
     " "
     "computer"
     " "
     "science:"
     "\n"
     "prove"
     " "
     "unconditional"
     " "
     "lower"
     " "
     "bounds"
     " "
     "for"
     " "
     "NP-complete"
     " "
     "problems"
     " "
     "in"
     " "
     "restricted"
     " "
     "but"
     " "
     "powerful"
     " "
     "models"
     " "
     "of"
     " "
     "computation"]
    [:p
     "some"
     " "
     "form"
     " "
     "of"
     " "
     "progress"
     " "
     "toward"
     " "
     "showing"
     " "
     "P"
     " "
     "vs"
     " "
     "NP"]
    [:p
     "if"
     " "
     "model"
     " "
     "captures"
     " "
     "interesting"
     " "
     "algorithmic"
     " "
     "techniques,"
     " "
     "these"
     " "
     "lower"
     " "
     "bounds"
     " "
     "rule"
     " "
     "out"
     " "
     "potential"
     " "
     "P=NP"
     " "
     "proofs"]
    [:p
     "model"
     " "
     "of"
     " "
     "computation"
     " "
     "based"
     " "
     "on"
     " "
     "semidefinite"
     " "
     "programming"]
    [:p
     "captures"
     " "
     "best"
     " "
     "known"
     " "
     "algorithms"
     " "
     "for"
     " "
     "wide"
     " "
     "range"
     " "
     "of"
     " "
     "optimization"
     " "
     "problems,"
     " "
     "including"
     " "
     "sum-of-squares"]]]]
 [:section
  {:data-menu-title "simplifying general algorithms",
   :section 2,
   :id "section-section-120",
   :class "align-top section level2"}
  [:h2]
  [:div
   {:id "section-121", :class "wrapmargin"}
   [:div
    {:data-fragment-index "6",
     :id "section-122",
     :class "fragment marginremove"}
    [:div
     {:id "section-123", :class "blockquote"}
     [:p
      [:em
       "our"
       " "
       "strategy"
       " "
       "for"
       " "
       "showing"
       " "
       "that"
       " "
       "SOS"
       " "
       "is"
       " "
       "optimal"
       " "
       "LP/SDP"
       " "
       "algorithm:"]
      [:br]
      "procedure"
      " "
      "to"
      " "
      "simplify"
      " "
      "general"
      " "
      "polynomial"
      " "
      "LP/SDP"
      " "
      "algorithm"
      " "
      "without"
      " "
      "changing"
      " "
      "guarantees"
      " "
      "such"
      " "
      "that"
      " "
      "it"
      " "
      "is"
      " "
      "captured"
      " "
      "by"
      " "
      "SOS"]]]]
  [:div
   {:data-fragment-index "0", :id "section-124", :class "fragment"}
   [:p
    "this"
    " "
    "simplification"
    " "
    "uses"
    " "
    [:em "physical" " " "representation"]
    " "
    "of"
    " "
    "LP/SDP"
    " "
    "alg’s"]]
  [:div
   {:data-fragment-index "1",
    :id "section-125",
    :class "blockquote fragment padding-bottom"}
   [:p
    [:em "general" " " "polynomial"]
    " "
    [:span
     {:data-fragment-index "7",
      :class "fragment bold italic red brighter appear-font"}
     "SDP/"]
    [:em
     "LP"
     " "
     "alg."
     " "
     "for"
     " "
     "instances"
     " "
     "with"
     " "
     [:span.math.inline "\\(n\\)"]
     " "
     "0/1"
     " "
     "variables:"]]
   [:ul
    [:li
     [:strong "physical" " " "representation:"]
     " "
     [:span
      {:data-fragment-index "7",
       :class "fragment red brighter appear-font"}
      "quantum"
      " "
      "state"
      " "
      [:span.math.inline "\\(\\rho\\)"]]
     [:span
      {:data-fragment-index "7", :class "fragment remove-font"}
      [:em
       "probabilistic"
       " "
       "state"
       " "
       [:span.math.inline "\\(p\\)"]]]
     " "
     "of"
     [:br]
     [:span.math.inline "\\(O(n\\log n)\\)"]
     " "
     [:span
      {:data-fragment-index "7", :class "fragment remove-font"}
      "bits"]
     [:span
      {:data-fragment-index "7",
       :class "fragment red brighter appear-font bold"}
      "qubits"]
     " "
     "and"
     " "
     [:span
      {:data-fragment-index "7", :class "fragment remove-font"}
      [:span.math.inline "\\(p\\)"]]
     [:span
      {:data-fragment-index "7",
       :class "fragment red brighter appear-font"}
      [:span.math.inline "\\(\\rho\\)"]]
     " "
     "has"
     " "
     [:em "tiny" " " "entropy" " " "deficit"]
     " "
     [:span.math.inline "\\(O(\\log n)\\)"]]]
   [:div
    {:data-fragment-index "2", :id "section-126", :class "fragment"}
    [:ul
     [:li
      [:strong "guarantees" " " "of" " " "algorithm:"]
      " "
      [:em "linear" " " "constraints"]
      " "
      [:span
       {:data-fragment-index "7", :class "fragment remove-font"}
       [:span.math.inline
        "\\({\\langle f_i,p \\rangle}\\ge 0~(\\ast)\\)"]]
      " "
      [:span
       {:data-fragment-index "7",
        :class "fragment red brighter appear-font"}
       [:span.math.inline
        "\\(\\mathrm{Tr}( F_i \\rho)\\ge 0~(\\ast)\\)"]]]]]
   [:div
    {:data-fragment-index "3", :id "section-127", :class "fragment"}
    [:ul
     [:li
      [:strong "simplification:"]
      " "
      "find"
      " "
      "maximum"
      " "
      [:span
       {:data-fragment-index "7",
        :class "fragment red brighter appear-font"}
       "quantum"
       " "
       "entropy"
       " "
       [:span.math.inline "\\(\\rho^*\\)"]]
      " "
      [:span
       {:data-fragment-index "7", :class "fragment remove-font"}
       "entropy"
       " "
       [:span.math.inline "\\(p^\\ast\\)"]]
      " "
      "s.t."
      " "
      [:span.math.inline "\\((\\ast)\\)"]]]]
   [:div
    {:data-fragment-index "4", :id "section-128", :class "fragment"}
    [:ul
     [:li
      [:span
       {:data-fragment-index "7",
        :class "fragment bold red brighter appear-font"}
       "matrix-"]
      [:strong "exponential" " " "family:"]
      " "
      [:span
       {:data-fragment-index "7", :class "fragment remove-font"}
       [:span.math.inline
        "\\(p^\\ast\\propto \\exp(\\sum_i c_i \\cdot f_i)\\)"]]
      " "
      [:span
       {:data-fragment-index "7",
        :class "fragment red brighter appear-font"}
       [:span.math.inline
        "\\(\\rho^\\ast\\propto \\exp(\\sum_i c_i \\cdot F_i)\\)"]]]]]
   [:div
    {:data-fragment-index "5", :id "section-129", :class "fragment"}
    [:ul
     [:li
      [:strong
       [:span.quote.double "“" "captured" " " "by" " " "SOS:" "”"]]
      " "
      [:span
       {:data-fragment-index "7", :class "fragment remove-font"}
       [:span.math.inline
        "\\(\\exp(x)\\approx (\\sum_k^{\\le O(\\log n)} \\frac 1{k!}(\\frac x 2)^k)^2\\)"]]
      " "
      [:span
       {:data-fragment-index "7",
        :class "fragment red brighter appear-font"}
       [:span.math.inline
        "\\(\\exp(X)\\approx (\\sum_k^{\\le O(\\log n)} \\frac 1{k!}(\\frac X 2)^k)^2\\)"]]]]]]
  [:div
   {:data-fragment-index "6",
    :id "section-130",
    :class "fragment transition-delay center"}
   [:p
    [:span
     {:class "big red brighter"}
     "simplification"
     " "
     "for"
     " "
     "SDP"
     " "
     "algorithm"
     " "
     "is"
     " "
     "same"
     " "
     "but"
     " "
     "in"
     " "
     [:span {:class "bold brighter"} "quantum" " " "physics"]]]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-simplifying-general-algorithms",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "simplifying" " " "general" " " "algorithms"]
   [:p
    "given"
    " "
    "an"
    " "
    "arbitrary"
    " "
    "polynomial-time"
    " "
    "LP/SDP"
    " "
    "algorithm,"
    " "
    "concrete"
    " "
    "procedure"
    " "
    "to"
    " "
    "find"
    " "
    "the"
    " "
    [:span.quote.double
     "“"
     "simplest"
     " "
     "LP/SDP"
     " "
     "algorithm"
     "”"]
    " "
    "that"
    " "
    "achieves"
    " "
    "the"
    " "
    "same"
    " "
    "guarantees"]
   [:p
    "show"
    " "
    "that"
    " "
    "the"
    " "
    "resulting"
    " "
    "simplified"
    " "
    "LP/SDP"
    " "
    "algorithm"
    " "
    "produced"
    " "
    "by"
    " "
    "this"
    " "
    "procedure"
    " "
    "is"
    " "
    "captured"
    " "
    "by"
    " "
    "SOS"]
   [:p
    "intuition:"
    " "
    "the"
    " "
    "algorithm"
    " "
    "we"
    " "
    "start"
    " "
    "may"
    " "
    "be"
    " "
    "unnecessarily"
    " "
    "complicated"
    " "
    "and"
    " "
    "obfuscate"
    " "
    "its"
    " "
    "actual"
    " "
    "behavior"]
   [:p
    "simplifying"
    " "
    "procedure"
    " "
    "builds"
    " "
    "on"
    " "
    "physical"
    " "
    "representation"
    " "
    "of"
    " "
    "LP/SDP"
    " "
    "algorithms"]
   [:p
    "can"
    " "
    "maybe"
    " "
    "describe"
    " "
    "how"
    " "
    "linear"
    " "
    "programs"
    " "
    "describe"]
   [:p
    "first"
    " "
    "describe"
    " "
    "the"
    " "
    "outline"
    " "
    "for"
    " "
    "linear"
    " "
    "programs"
    " "
    "in"
    " "
    "terms"
    " "
    "of"
    " "
    "classical"
    " "
    "distributions"]
   [:p
    "the"
    " "
    "behavior"
    " "
    "of"
    " "
    "a"
    " "
    "general"
    " "
    "polynomial-time"
    " "
    "SDP"
    " "
    "algorithm"
    " "
    "on"
    " "
    "instances"
    " "
    "with"
    " "
    [:span.math.inline "\\(n\\)"]
    " "
    "variables"
    " "
    "can"
    " "
    "be"
    " "
    "described"
    " "
    "as"
    " "
    "a"
    " "
    "state"
    " "
    "of"
    " "
    "an"
    " "
    [:span.math.inline "\\(O(n\\cdot \\log n)\\)"]
    "-qubit"
    " "
    "quantum"
    " "
    "system"]
   [:p
    "entropy"
    " "
    "distance"
    " "
    "from"
    " "
    "maximally"
    " "
    "mixed"
    " "
    "state"
    " "
    "(uniform"
    " "
    "distributions)"]
   [:p
    "approximation"
    " "
    "guarantees"
    " "
    "correspond"
    " "
    "to"
    " "
    "a"
    " "
    "set"
    " "
    "of"
    " "
    "simple"
    " "
    "linear"
    " "
    "constraints"
    " "
    "on"
    " "
    "the"
    " "
    "quantum"]
   [:p "exponential" " " "family"]]]
 [:section
  {:data-divtag "section", :class "titleslide"}
  [:h1 "conclusion"]]
 [:section
  {:data-menu-title "conclusion",
   :section 2,
   :id "section-section-131",
   :class "align-top section level2"}
  [:h2]
  [:div
   {:id "section-132", :class "blockquote"}
   [:p
    [:span
     {:class "bright big"}
     [:strong
      "new"
      " "
      "paradigm"
      " "
      "for"
      " "
      "analysis"
      " "
      "of"
      " "
      [:span {:class "bright"} "efficient" " " "algorithms"]]]
    [:br]
    [:span
     {:data-fragment-index "1", :class "fragment"}
     "1."
     " "
     "analyze"
     " "
     [:em "inefficient" " " "algorithm"]
     " "
     "based"
     " "
     "on"
     " "
     "optimizing"
     [:br]
     " "
     " "
     " "
     " "
     "over"
     " "
     [:em
      [:span
       {:class "yellow bright"}
       "moments"
       " "
       "of"
       " "
       "distributions"]]]
    [:br]
    [:span
     {:data-fragment-index "2", :class "fragment"}
     "2."
     " "
     "show"
     " "
     "that"
     " "
     "analysis"
     " "
     "extends"
     " "
     "to"
     " "
     "moments"
     " "
     "of"
     [:br]
     " "
     " "
     " "
     " "
     [:span {:class "bright italic"} [:strong "pseudo-distributions"]]
     " "
     "using"
     " "
     [:span {:class "bold bright"} [:em "SOS" " " "proofs"]]]]]
  [:div
   {:data-fragment-index "7",
    :id "section-133",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "3",
     :id "section-134",
     :class "fragment bright"}
    [:p
     [:strong
      "useful"
      " "
      "also"
      " "
      "beyond"
      " "
      [:span {:class "bright"} "Tensor" " " "PCA"]]]]]
  [:div
   {:data-fragment-index "7",
    :id "section-135",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "4", :id "section-136", :class "fragment"}
    [:p
     "•"
     " "
     [:em "other" " " "machine" " " "learning" " " "problems,"]
     " "
     "e.g.,"
     " "
     "finding"
     " "
     "sparse"
     " "
     "vectors"
     " "
     "/"
     " "
     "bases"
     " "
     "in"
     " "
     "subspaces"
     " "
     [:span
      {:class "small"}
      "[Barak-Kelner-"
      [:strong "S."]
      "’14,"
      " "
      "Hopkins-Schramm-Shi-"
      [:strong "S."]
      "’16]"]
     [:br]
     [:span
      {:data-fragment-index "5", :class "fragment"}
      "•"
      " "
      [:em "approximation" " " "algorithms,"]
      " "
      "e.g.,"
      " "
      "Unique"
      " "
      "Games"
      " "
      "Conjecture"
      [:br]
      [:span
       {:class "small"}
       "[Arora-Barak-"
       [:strong "S."]
       "’10,Barak-Raghavendra-"
       [:strong "S."]
       "’11]"]]
     [:br]
     [:span
      {:data-fragment-index "6", :class "fragment"}
      "•"
      " "
      [:em "quantum" " " "information" " " "theory,"]
      " "
      "e.g.,"
      " "
      "efficiently"
      " "
      "approximate"
      " "
      [:span {:class "bright"} [:strong "entanglement"]]
      "\n"
      [:span
       {:class "small"}
       "[Doherty-Parrilo-Spedalieri’04,"
       "\n"
       "Barak-Kothari-"
       [:strong "S."]
       "’16]"]]]]]
  [:div
   {:data-fragment-index "9",
    :id "section-137",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "7",
     :id "section-138",
     :class "fragment transition-delay"}
    [:p
     "emerging"
     " "
     "general"
     " "
     "toolkit"
     " "
     "for"
     " "
     "step"
     " "
     "2.—"
     [:em "not" " " "problem" " " "specific"]]]]
  [:div
   {:data-fragment-index "9",
    :id "section-139",
    :class "fragment remove"}
   [:div
    {:data-fragment-index "8", :id "section-140", :class "fragment"}
    [:p
     [:em "exposition" " " "materials:"]
     " "
     [:span
      {:class "bright url"}
      [:span {:class "yellow"} "sumofsquares.org"]]
     [:br]
     [:span
      {:class "small"}
      "lecture"
      " "
      "notes"
      " "
      "from"
      " "
      "seminars"
      " "
      "and"
      " "
      "workshops"
      " "
      "at"
      " "
      "Princeton,"
      " "
      "Harvard,"
      " "
      "MIT,"
      " "
      "UCSD,"
      " "
      "…"]]]]
  [:div
   {:data-fragment-index "9", :id "section-141", :class "fragment"}
   [:p
    [:span
     {:class "big brighter magenta italic bold"}
     "future"
     " "
     "directions"]
    [:br]
    [:span
     {:data-fragment-index "10", :class "fragment"}
     "•"
     " "
     [:span
      {:class "bright"}
      [:strong
       "expand"
       " "
       "unified"
       " "
       "theory"
       " "
       "to"
       " "
       "inference"
       " "
       "problems"]]
     [:br]
     " "
     " "
     " "
     " "
     "reductions"
     " "
     "to"
     " "
     "optimization"
     " "
     "lose"
     " "
     "in"
     " "
     "sample"
     " "
     "efficiency"
     [:br]
     " "
     " "
     " "
     " "
     [:strong "goal:"]
     " "
     "capture"
     " "
     [:em "belief" " " "propagation"]
     " "
     "and"
     " "
     [:em "threshold" " " "phenomena"]
     " "
     "for"
     [:br]
     " "
     " "
     " "
     " "
     "sample"
     " "
     "complexity"
     " "
     [:span
      {:class "small"}
      "(e.g. for"
      " "
      "stochastic"
      " "
      "block"
      " "
      "model)"]]
    [:br]
    [:span
     {:data-fragment-index "11", :class "fragment"}
     "•"
     " "
     [:span
      {:class "bright"}
      [:strong
       "fast"
       " "
       "practical"
       " "
       "algorithms"
       " "
       "from"
       " "
       "SOS"]]
     [:br]
     " "
     " "
     " "
     " "
     "understand"
     " "
     "connection"
     " "
     "to"
     " "
     [:em "popular" " " "local-search" " " "heuristics"]]]]
  [:div
   {:data-fragment-index "12",
    :id "section-142",
    :class "magenta italic bold big brighter fragment"}
   [:p "Thank" " " "you!"]]
  [:aside
   {:section 3,
    :data-divtag "aside",
    :id "section-notes-conclusion",
    :class "section level3 notes"}
   [:style
    "#current-slide {\n  position: absolute;\n  width: 40%;\n  height: 60%;\n  top: 0;\n  left: 0;\n}\n\n#upcoming-slide {\n  position: absolute;\n  width: 40%;\n  height: 40%;\n  left: 0;\n  top: 60%;\n}\n\n#speaker-controls {\n  position: absolute;\n  top: 0;\n  right: 0;\n  width: 60%;\n  height: 100%;\n  overflow: auto;\n  font-size: 18px;\n}\n\n#speaker-controls, p {\n  margin-top: 0.1em;\n  margin-bottom: 0.1em;\n}"]
   [:h3 "NOTES:" " " "conclusion"]
   "<!-- TODO: need to connect \"new paradigm\" better to previous content -->"
   [:div
    {:section 4, :id "section-last-words", :class "section level4"}
    [:h4 "last" " " "words"]
    [:p
     "The"
     " "
     [:em "applications" " " "of" " " "computing"]
     " "
     "continue"
     " "
     "to"
     " "
     [:em "expand"]
     " "
     "and"
     " "
     [:em
      "impact"
      " "
      "all"
      " "
      "parts"
      " "
      "of"
      " "
      "the"
      " "
      "world"]
     "."
     "\n"
     "With"
     " "
     "this"
     " "
     "expansion,"
     " "
     [:em "there" " " "was" " " "a" " " "period"]
     " "
     "where"
     " "
     "the"
     " "
     "field’s"
     " "
     "hope"
     " "
     "for"
     " "
     "a"
     " "
     [:em "unified" " " "approach"]
     " "
     "to"
     " "
     "algorithm"
     " "
     "design"
     " "
     "had"
     " "
     [:em "correspondingly" " " "begun" " " "to" " " "recede"]
     "."
     "\n"
     "But"
     " "
     "I"
     " "
     "believe"
     " "
     "the"
     " "
     "work"
     " "
     "around"
     " "
     [:em "these" " " "methods"]
     " "
     "has"
     " "
     [:em
      "brought"
      " "
      "this"
      " "
      "hope"
      " "
      "back"
      " "
      "into"
      " "
      "focus"]
     "."
     "\n"
     "It"
     " "
     "points"
     " "
     "to"
     " "
     "a"
     " "
     "very"
     " "
     [:em "exciting" " " "set" " " "of" " " "opportunities"]
     " "
     "going"
     " "
     "forward."]
    [:p "Thank" " " "you."]]]]
 [:script {:src "/js/main.js"}]]
)