// Compiled by ClojureScript 1.9.494 {}
goog.provide('mathdoc.cljs.copynode');
goog.require('cljs.core');
goog.require('hickory.core');
goog.require('hickory.render');
goog.require('dommy.core');
goog.require('clojure.walk');
/**
 * inner html of elem with ids removed
 */
mathdoc.cljs.copynode.sanitized_html = (function mathdoc$cljs$copynode$sanitized_html(elem){
var _ = elem;
var ___$1 = hickory.core.as_hiccup.call(null,_);
var ___$2 = cljs.core.nth.call(null,___$1,(2));
var ___$3 = clojure.walk.prewalk.call(null,cljs.core.comp.call(null,((function (_,___$1,___$2){
return (function (x){
if((cljs.core.vector_QMARK_.call(null,x)) && (cljs.core.map_QMARK_.call(null,cljs.core.second.call(null,x))) && (cljs.core._EQ_.call(null,"math/tex",new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,x))))){
return "";
} else {
return x;
}
});})(_,___$1,___$2))
,((function (_,___$1,___$2){
return (function (x){
var G__74680 = x;
if(cljs.core.map_QMARK_.call(null,x)){
return cljs.core.dissoc.call(null,G__74680,new cljs.core.Keyword(null,"id","id",-1388402092));
} else {
return G__74680;
}
});})(_,___$1,___$2))
),___$2);
var ___$4 = (function (){var x__67250__auto__ = ___$3;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__67250__auto__);
})();
return hickory.render.hiccup_to_html.call(null,___$4);
});
mathdoc.cljs.copynode.get_source = (function mathdoc$cljs$copynode$get_source(elem){
var G__74682 = "data-copy";
var G__74682__$1 = (((G__74682 == null))?null:dommy.core.attr.call(null,elem,G__74682));
var G__74682__$2 = (((G__74682__$1 == null))?null:[cljs.core.str.cljs$core$IFn$_invoke$arity$1("#"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__74682__$1)].join(''));
if((G__74682__$2 == null)){
return null;
} else {
return document.querySelector(dommy.core.selector.call(null,G__74682__$2));
}
});
mathdoc.cljs.copynode.copy = (function mathdoc$cljs$copynode$copy(from,to){
return dommy.core.set_html_BANG_.call(null,to,mathdoc.cljs.copynode.sanitized_html.call(null,from));
});
mathdoc.cljs.copynode.copy_source = (function mathdoc$cljs$copynode$copy_source(to){
var temp__6753__auto__ = mathdoc.cljs.copynode.get_source.call(null,to);
if(cljs.core.truth_(temp__6753__auto__)){
var from = temp__6753__auto__;
return mathdoc.cljs.copynode.copy.call(null,from,to);
} else {
return null;
}
});
mathdoc.cljs.copynode.remove_copies = (function mathdoc$cljs$copynode$remove_copies(){
return cljs.core.dorun.call(null,cljs.core.map.call(null,(function (x){
return dommy.core.set_html_BANG_.call(null,x,"");
}),dommy.utils.__GT_Array.call(null,document.querySelectorAll("[data-copy]"))));
});
mathdoc.cljs.copynode.copy_nodes = (function mathdoc$cljs$copynode$copy_nodes(){
return cljs.core.dorun.call(null,cljs.core.map.call(null,mathdoc.cljs.copynode.copy_source,dommy.utils.__GT_Array.call(null,document.querySelectorAll("[data-copy]"))));
});
mathdoc.cljs.copynode.jq_offset = (function mathdoc$cljs$copynode$jq_offset(var_args){
var args74683 = [];
var len__67537__auto___74686 = arguments.length;
var i__67538__auto___74687 = (0);
while(true){
if((i__67538__auto___74687 < len__67537__auto___74686)){
args74683.push((arguments[i__67538__auto___74687]));

var G__74688 = (i__67538__auto___74687 + (1));
i__67538__auto___74687 = G__74688;
continue;
} else {
}
break;
}

var G__74685 = args74683.length;
switch (G__74685) {
case 2:
return mathdoc.cljs.copynode.jq_offset.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return mathdoc.cljs.copynode.jq_offset.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74683.length)].join('')));

}
});

mathdoc.cljs.copynode.jq_offset.cljs$core$IFn$_invoke$arity$2 = (function (elem,off){
return jQuery(elem).offset(off);
});

mathdoc.cljs.copynode.jq_offset.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return jQuery(elem).offset();
});

mathdoc.cljs.copynode.jq_offset.cljs$lang$maxFixedArity = 2;

mathdoc.cljs.copynode.position = (function mathdoc$cljs$copynode$position(elem){
return cljs.core.js__GT_clj.call(null,mathdoc.cljs.copynode.jq_offset.call(null,elem));
});
/**
 * translation vector between two elems
 */
mathdoc.cljs.copynode.offset = (function mathdoc$cljs$copynode$offset(a,b){
return cljs.core.merge_with.call(null,cljs.core._,mathdoc.cljs.copynode.position.call(null,b),mathdoc.cljs.copynode.position.call(null,a));
});
mathdoc.cljs.copynode.move_to_elem_position = (function mathdoc$cljs$copynode$move_to_elem_position(elem,target_elem){
return mathdoc.cljs.copynode.jq_offset.call(null,elem,mathdoc.cljs.copynode.jq_offset.call(null,target_elem));
});
mathdoc.cljs.copynode.animate = (function mathdoc$cljs$copynode$animate(elem,off){
return jQuery(elem).animate(({"top": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("+="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,off,"top")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''), "left": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("+="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,off,"left","px"))].join('')}));
});
mathdoc.cljs.copynode.animate_id = (function mathdoc$cljs$copynode$animate_id(id){
console.log("anim id",id);

if(cljs.core.truth_(id)){
var begin = document.querySelector(dommy.core.selector.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("[data-anim-id="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),cljs.core.str.cljs$core$IFn$_invoke$arity$1("].anim-begin")].join('')));
var mid = document.querySelector(dommy.core.selector.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("[data-anim-id="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),cljs.core.str.cljs$core$IFn$_invoke$arity$1("].anim-mid")].join('')));
var end = document.querySelector(dommy.core.selector.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("[data-anim-id="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id),cljs.core.str.cljs$core$IFn$_invoke$arity$1("].anim-end")].join('')));
if(cljs.core.truth_((function (){var and__66304__auto__ = begin;
if(cljs.core.truth_(and__66304__auto__)){
var and__66304__auto____$1 = mid;
if(cljs.core.truth_(and__66304__auto____$1)){
return end;
} else {
return and__66304__auto____$1;
}
} else {
return and__66304__auto__;
}
})())){
console.log("anim for real id",id);

mathdoc.cljs.copynode.move_to_elem_position.call(null,mid,begin);

return mathdoc.cljs.copynode.animate.call(null,mid,mathdoc.cljs.copynode.offset.call(null,begin,end));
} else {
return null;
}
} else {
return null;
}
});
mathdoc.cljs.copynode.animate_elems = (function mathdoc$cljs$copynode$animate_elems(prev,cur){
if(cljs.core.truth_((function (){var and__66304__auto__ = prev;
if(cljs.core.truth_(and__66304__auto__)){
return cur;
} else {
return and__66304__auto__;
}
})())){
return cljs.core.dorun.call(null,cljs.core.map.call(null,(function (p1__74690_SHARP_){
return mathdoc.cljs.copynode.animate_id.call(null,(p1__74690_SHARP_["dataset"]["animId"]));
}),dommy.utils.__GT_Array.call(null,prev.getElementsByClassName("anim-begin"))));
} else {
return null;
}
});
mathdoc.cljs.copynode.init = (function mathdoc$cljs$copynode$init(){
Reveal.addEventListener("slidechanged",(function (ev){
return mathdoc.cljs.copynode.animate_elems.call(null,ev.previousSlide,ev.currentSlide);
}));

return Reveal.addEventListener("ready",(function (ev){
return mathdoc.cljs.copynode.copy_nodes.call(null);
}));
});
goog.exportSymbol('mathdoc.cljs.copynode.init', mathdoc.cljs.copynode.init);

//# sourceMappingURL=copynode.js.map