// Compiled by ClojureScript 1.9.494 {}
goog.provide('hickory.render');
goog.require('cljs.core');
goog.require('hickory.hiccup_utils');
goog.require('hickory.utils');
goog.require('clojure.string');
/**
 * Given a map entry m, representing the attribute name and value, returns a
 * string representing that key/value pair as it would be rendered into HTML.
 */
hickory.render.render_hickory_attribute = (function hickory$render$render_hickory_attribute(m){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,cljs.core.key.call(null,m))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("=\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hickory.utils.html_escape.call(null,cljs.core.val.call(null,m))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('');
});
/**
 * Given a hickory HTML DOM map structure (as returned by as-hickory), returns a
 * string containing HTML it represents. Keep in mind this function is not super
 * fast or heavy-duty.
 * 
 * Note that it will NOT in general be the case that
 * 
 *   (= my-html-src (hickory-to-html (as-hickory (parse my-html-src))))
 * 
 * as we do not keep any letter case or whitespace information, any
 * "tag-soupy" elements, attribute quote characters used, etc.
 */
hickory.render.hickory_to_html = (function hickory$render$hickory_to_html(dom){
if(typeof dom === 'string'){
return hickory.utils.html_escape.call(null,dom);
} else {
try{var G__74623 = (((new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(dom) instanceof cljs.core.Keyword))?new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(dom).fqn:null);
switch (G__74623) {
case "document":
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,hickory.render.hickory_to_html,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(dom)));

break;
case "document-type":
return hickory.utils.render_doctype.call(null,cljs.core.get_in.call(null,dom,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"name","name",1843675177)], null)),cljs.core.get_in.call(null,dom,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"publicid","publicid",1557995850)], null)),cljs.core.get_in.call(null,dom,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"systemid","systemid",-2052878192)], null)));

break;
case "element":
if(cljs.core.truth_(hickory.utils.void_element.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("<"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,hickory.render.render_hickory_attribute,new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(dom)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">")].join('');
} else {
if(cljs.core.truth_(hickory.utils.unescapable_content.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("<"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,hickory.render.render_hickory_attribute,new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(dom)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">")].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("<"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,hickory.render.render_hickory_attribute,new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(dom)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,hickory.render.hickory_to_html,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(dom)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">")].join('');

}
}

break;
case "comment":
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("<!--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(dom))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-->")].join('');

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(dom))].join('')));

}
}catch (e74622){if((e74622 instanceof Error)){
var e = e74622;
throw (cljs.core.truth_(hickory.utils.starts_with.call(null,(e["message"]),"No matching clause: "))?cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not a valid node: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,dom))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dom","dom",-1236537922),dom], null)):e);
} else {
throw e74622;

}
}}
});
/**
 * Given a hiccup attribute map, returns a string containing the attributes
 * rendered as they should appear in an HTML tag, right after the tag (including
 * a leading space to separate from the tag, if any attributes present).
 */
hickory.render.render_hiccup_attrs = (function hickory$render$render_hiccup_attrs(attrs){
var attrs_str = clojure.string.join.call(null," ",cljs.core.sort.call(null,cljs.core.filter.call(null,(function (p1__74625_SHARP_){
return !(cljs.core.empty_QMARK_.call(null,p1__74625_SHARP_));
}),(function (){var iter__67178__auto__ = (function hickory$render$render_hiccup_attrs_$_iter__74642(s__74643){
return (new cljs.core.LazySeq(null,(function (){
var s__74643__$1 = s__74643;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__74643__$1);
if(temp__6753__auto__){
var s__74643__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__74643__$2)){
var c__67176__auto__ = cljs.core.chunk_first.call(null,s__74643__$2);
var size__67177__auto__ = cljs.core.count.call(null,c__67176__auto__);
var b__74645 = cljs.core.chunk_buffer.call(null,size__67177__auto__);
if((function (){var i__74644 = (0);
while(true){
if((i__74644 < size__67177__auto__)){
var vec__74652 = cljs.core._nth.call(null,c__67176__auto__,i__74644);
var k = cljs.core.nth.call(null,vec__74652,(0),null);
var v = cljs.core.nth.call(null,vec__74652,(1),null);
cljs.core.chunk_append.call(null,b__74645,((v === true)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k))].join(''):(((v == null))?"":[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hickory.utils.html_escape.call(null,v)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('')
)));

var G__74658 = (i__74644 + (1));
i__74644 = G__74658;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74645),hickory$render$render_hiccup_attrs_$_iter__74642.call(null,cljs.core.chunk_rest.call(null,s__74643__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__74645),null);
}
} else {
var vec__74655 = cljs.core.first.call(null,s__74643__$2);
var k = cljs.core.nth.call(null,vec__74655,(0),null);
var v = cljs.core.nth.call(null,vec__74655,(1),null);
return cljs.core.cons.call(null,((v === true)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k))].join(''):(((v == null))?"":[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,k)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hickory.utils.html_escape.call(null,v)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join('')
)),hickory$render$render_hiccup_attrs_$_iter__74642.call(null,cljs.core.rest.call(null,s__74643__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__67178__auto__.call(null,attrs);
})())));
if(!(cljs.core.empty_QMARK_.call(null,attrs_str))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(attrs_str)].join('');
} else {
return attrs_str;
}
});
/**
 * Given a normalized hiccup element (such as the output of
 * hickory.hiccup-utils/normalize-form; see this function's docstring
 * for more detailed definition of a normalized hiccup element), renders
 * it to HTML and returns it as a string.
 */
hickory.render.render_hiccup_element = (function hickory$render$render_hiccup_element(n_element){
var vec__74662 = n_element;
var seq__74663 = cljs.core.seq.call(null,vec__74662);
var first__74664 = cljs.core.first.call(null,seq__74663);
var seq__74663__$1 = cljs.core.next.call(null,seq__74663);
var tag = first__74664;
var first__74664__$1 = cljs.core.first.call(null,seq__74663__$1);
var seq__74663__$2 = cljs.core.next.call(null,seq__74663__$1);
var attrs = first__74664__$1;
var content = seq__74663__$2;
if(cljs.core.truth_(hickory.utils.void_element.call(null,tag))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("<"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,tag)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hickory.render.render_hiccup_attrs.call(null,attrs)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">")].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("<"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,tag)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hickory.render.render_hiccup_attrs.call(null,attrs)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hickory.render.hiccup_to_html.call(null,content)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,tag)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(">")].join('');
}
});
/**
 * Given a normalized hiccup form (such as the output of
 * hickory.hiccup-utils/normalize-form; see this function's docstring
 * for more detailed definition of a normalized hiccup form), renders
 * it to HTML and returns it as a string.
 */
hickory.render.render_hiccup_form = (function hickory$render$render_hiccup_form(n_form){
if(cljs.core.vector_QMARK_.call(null,n_form)){
return hickory.render.render_hiccup_element.call(null,n_form);
} else {
return n_form;
}
});
/**
 * Given a sequence of hiccup forms (as returned by as-hiccup), returns a
 * string containing HTML it represents. Keep in mind this function is not super
 * fast or heavy-duty, and definitely not a replacement for dedicated hiccup
 * renderers, like hiccup itself, which *is* fast and heavy-duty.
 * 
 * Note that it will NOT in general be the case that
 * 
 *   (= my-html-src (hiccup-to-html (as-hiccup (parse my-html-src))))
 * 
 * as we do not keep any letter case or whitespace information, any
 * "tag-soupy" elements, attribute quote characters used, etc. It will also
 * not generally be the case that this function's output will exactly match
 * hiccup's.
 */
hickory.render.hiccup_to_html = (function hickory$render$hiccup_to_html(hiccup_forms){
return cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (p1__74665_SHARP_){
return hickory.render.render_hiccup_form.call(null,hickory.hiccup_utils.normalize_form.call(null,p1__74665_SHARP_));
}),hiccup_forms));
});

//# sourceMappingURL=render.js.map