(ns talk.mathtest
  (:require [cuerdas.core :as str]
            [garden.core :as garden]
            [garden.stylesheet :as gs]
            [reagent.core :as r]))

(defn mjqueue [& xs]
  (apply js/MathJax.Hub.Queue xs))

(defn mjtypeset [x]
  (mjqueue #js ["Typeset" js/MathJax.Hub x]))

(defn mjsvgtypeset [x]
  (js/MathJax.Hub.Queue
   #js ["setRenderer" js/MathJax.Hub "SVG"]
   #js ["Reprocess" js/MathJax.Hub x]
   #js ["Typeset" js/MathJax.Hub x]
   #js ["setRenderer" js/MathJax.Hub "HTML-CSS"]))

#_(mjsvgtypeset "mathtest")

(defn mathtest []
  [:div {:ref (fn [x]
                (print "mj typeset" x)
                (mjsvgtypeset x))}
   "math test hello"
   "$\\alpha\\gamma\\int\\leadsto$"])

(defn init []
  (some->> "mathtest"
           (.getElementById js/document)
           (r/render [mathtest])))

