(ns talk.inference
  (:require [cuerdas.core :as str]
            [garden.core :as garden]
            [garden.stylesheet :as gs]
            [reagent.core :as r]
            [mathdoc.cljs.svg :as svg]
            [garden.color :as gc]))

(def color
  {:yellow  "#b58900"
   :orange  "#cb4b16"
   :red     "#dc322f"
   :magenta "#d33682"
   :violet  "#6c71c4"
   :blue    "#268bd2"
   :cyan    "#2aa198"
   :green   "#859900"
   :base03  "#002b36"
   :base02  "#073642"
   :base01  "#586e75"
   :base00  "#657b83"
   :base0   "#839496"
   :base1   "#93a1a1"
   :base2   "#eee8d5"
   :base3   "#fdf6e3"})

(def frags
  {:polynomial 7
   :exponential 6})

(def cogs-path
  "M181.861 361.026l20.649-28.908-22.627-22.628-28.909 20.648c-5.361-2.997-11.102-5.387-17.133-7.096l-5.841-35.042h-32l-5.84 35.043c-6.031 1.709-11.772 4.099-17.133 7.096l-28.909-20.649-22.628 22.628 20.649 28.908c-2.997 5.36-5.387 11.103-7.096 17.133l-35.043 5.841v32l35.043 5.841c1.709 6.030 4.099 11.772 7.096 17.133l-20.649 28.908 22.627 22.628 28.909-20.648c5.361 2.997 11.102 5.387 17.133 7.096l5.841 35.042h32l5.84-35.043c6.031-1.709 11.772-4.099 17.133-7.096l28.909 20.648 22.627-22.628-20.649-28.908c2.997-5.36 5.387-11.103 7.096-17.133l35.044-5.84v-32l-35.043-5.841c-1.709-6.030-4.099-11.772-7.096-17.133zM112 432c-17.674 0-32-14.327-32-32s14.326-32 32-32 32 14.327 32 32-14.326 32-32 32zM512 192v-32l-33.691-6.125c-0.621-4.023-1.416-7.989-2.362-11.895l28.779-18.55-12.246-29.564-33.472 7.234c-2.107-3.455-4.363-6.81-6.746-10.065l19.503-28.171-22.628-22.627-28.171 19.503c-3.256-2.383-6.61-4.638-10.065-6.747l7.234-33.472-29.564-12.247-18.55 28.779c-3.906-0.946-7.872-1.741-11.895-2.362l-6.126-33.691h-32l-6.126 33.691c-4.023 0.621-7.988 1.416-11.895 2.362l-18.549-28.779-29.564 12.246 7.234 33.472c-3.455 2.108-6.81 4.364-10.065 6.747l-28.171-19.503-22.627 22.627 19.503 28.171c-2.383 3.255-4.639 6.61-6.747 10.065l-33.472-7.234-12.246 29.564 28.779 18.55c-0.946 3.906-1.741 7.871-2.362 11.895l-33.692 6.126v32l33.691 6.125c0.621 4.023 1.416 7.989 2.362 11.895l-28.779 18.55 12.246 29.564 33.472-7.234c2.108 3.455 4.364 6.809 6.747 10.065l-19.503 28.171 22.627 22.628 28.171-19.503c3.255 2.383 6.61 4.638 10.065 6.746l-7.234 33.472 29.564 12.246 18.551-28.779c3.905 0.946 7.871 1.741 11.894 2.362l6.126 33.692h32l6.126-33.691c4.022-0.621 7.988-1.416 11.895-2.362l18.55 28.779 29.564-12.246-7.234-33.472c3.455-2.108 6.81-4.363 10.065-6.746l28.171 19.503 22.628-22.628-19.503-28.171c2.383-3.256 4.638-6.61 6.746-10.065l33.472 7.234 12.246-29.565-28.779-18.55c0.946-3.906 1.741-7.871 2.362-11.895l33.691-6.125zM336 245.6c-38.439 0-69.6-31.161-69.6-69.6s31.16-69.6 69.6-69.6 69.6 31.161 69.6 69.6c0 38.439-31.16 69.6-69.6 69.6z")

(def flow-arrow
  [:path
   {:d     "M19.414 27.414l10-10c0.781-0.781 0.781-2.047 0-2.828l-10-10c-0.781-0.781-2.047-0.781-2.828 0s-0.781 2.047 0 2.828l6.586 6.586h-19.172c-1.105 0-2 0.895-2 2s0.895 2 2 2h19.172l-6.586 6.586c-0.39 0.39-0.586 0.902-0.586 1.414s0.195 1.024 0.586 1.414c0.781 0.781 2.047 0.781 2.828 0z"
    :style {:fill (:yellow color)}}])

(def side-arrow
  [:path {:d "M16 31l15-15h-9v-16h-12v16h-9z"
          :style {:fill (:red color)}}])

(defn inference []
  [:div.fragment.addblockquote
   {:data-fragment-index (:polynomial frags)}
   [:div.fragment {:data-fragment-index (:exponential frags)}
    [:div.fragment
     {:data-fragment-index (:polynomial frags)
      :style {:margin-top "20px"}}
     [:strong.big "our results"]
     [:div.smaller
      "[Barak-Kelner-"
      [:strong "S."]
      " "
      [:em "STOC'15"]
      ","
      [:br]
      " Ma-Shi-"
      [:strong "S."]
      " "
      [:em "FOCS'16"] "]"]]
    [:svg
     {:viewBox "10 -8 300 105"
      :style {:margin-top "-135px"}}
     [:g {:transform "translate(0,54)"}
      [:g {:style {:transform "translate(215px,0px)"}}
       flow-arrow
       [:text
        {:font-size   "13px"
         :textAnchor  "start"
         :transform   "translate(33,19)"
         :fill        (:yellow color)
         :font-weight "bold"}
        "structure"]]
      [:g {:style {:transform "translate(70px,0px)"}}
       flow-arrow
       [:text
        {:font-size   "13px"
         :textAnchor  "end"
         :transform   "translate(0,19)"
         :fill        (:yellow color)
         :font-weight "bold"}
        "data"]]]
     [:g {:transform "translate(145,23)"}
      [:text
       {:font-size   "13px"
        :textAnchor  "middle"
        :transform   "translate(15,-20)"
        :fill        (:red color)
        :font-weight "bold"}
       "proof of identifiability"]
      [:text.fragment
       {:font-size   "12px"
        :data-fragment-index (:polynomial frags)
        :textAnchor  "middle"
        :font-style  "italic"
        :transform   "translate(15,-5)"
        :fill        (gc/as-hex (gc/lighten (:red color) 20))
        :font-weight "bold"}
       "poly-size in SOS system"]
      [:g {:transform "scale(1.0,0.8)"}
       side-arrow]]
     [:g {:style {:transform "translate(100px,50px)"}}
      [:rect {:x    0 :y 0 :width 120 :height 40
              :fill (:base2 color)}]
      [:g {:transform "translate(10,33)"}
       [:g.fragment.removescalex
        {:style {:transition "all 0.5s ease"}
         :data-fragment-index (:polynomial frags)}
        [:text {:style {:fill        (:base02 color)
                        :transform   "translate(0,-9px)"
                        :font-size   "15px"
                        :font-style  "italic"
                        :font-weight "bold"}} "exponential"]]
       [:g.fragment
        {:style {:transition "all 0.5s ease 0.7s"}
         :data-fragment-index (:polynomial frags)}
        [:text {:style {:fill        (:red color)
                        :transform   "translate(0,-9px)"
                        :font-size   "15px"
                        :font-style  "italic"
                        :font-weight "bold"}} "efficient"]]
       [:text {:style {:fill        (:base02 color)
                       :font-size   "15px"
                       :font-weight "bold"}} "algorithm"]]
      [:g {:style {:transform "translate(85px,10px)"}}
       [:path {:d         cogs-path
               :transform "scale(0.05)"
               :style     {:fill (:base01 color)}}]]]]]])

(def scfrags
  {:data 0
   :structure 1})


(defn sparsecoding []
  [:svg
   {:viewBox "10 25 300 90"
    :style   {:margin-top     "-40px"
              :margin-bottom  "-60px"
              #_#_:background "rgba(255,255,255,0.1)"}}
   [:g {:transform "translate(0,54)"}
    [:g.fragment {:data-fragment-index (scfrags :structure)
         :style {:transform "translate(185px,0px)"}}
     flow-arrow
     [:image {:href   "/figure/black white dictionary.png"
              :x      40
              :y      -20
              :width  70
              :height 70}]]
    [:g.fragment
     {:data-fragment-index (scfrags :data)
      :style {:transform "translate(70px,0px)"}}
     flow-arrow
     [:text
      {:font-size   "13px"
       :textAnchor  "middle"
       :transform   "translate(-25,19)"
       :fill        (:yellow color)
       :font-weight "bold"}
      [:tspan {:x "0" :dy "-0.6em"} "image"]
      [:tspan {:x "0" :dy "1.2em"} "patches"]]]]
   [:g {:style {:transform "translate(100px,50px)"}}
    [:rect {:x     0  :y      0
            :width 90 :height 40
            :fill  (:base2 color)}]
    [:g {:transform "translate(10,33)"}
     [:text {:style {:fill        (:base02 color)
                     :transform   "translate(0,-9px)"
                     :font-size   "15px"
                     :font-weight "bold"}} "sparse"]
     [:text {:style {:fill        (:base02 color)
                     :font-size   "15px"
                     :font-weight "bold"}} "coding"]]
    [:g {:style {:transform "translate(60px,10px)"}}
     [:path {:d         cogs-path
             :transform "scale(0.05)"
             :style     {:fill (:base01 color)}}]]]])



(defn init []
  (some->> "inference"
           (.getElementById js/document)
           (r/render [inference]))
  (some->> "sparsecoding"
           (.getElementById js/document)
           (r/render [sparsecoding])))
