(ns talk.core
  (:require [talk.complexity :as complexity]
            [talk.style :as style]
            [talk.pearson :as pearson]
            [talk.contentload :as contentload]
            [talk.background :as background]
            [talk.inference :as inference]
            [talk.superman :as superman]
            [talk.conclusion :as conclusion]
            [talk.highdim :as highdim]
            [talk.simplification :as simplification]
            [talk.datavstime :as datavstime]
            [talk.mathtest :as mathtest]
            [mathdoc.cljs.core :as mathdoc]))

(enable-console-print!)

(def no-slow-js true)

(defn init-slow []
  (highdim/init)
  (mathtest/init)
  (contentload/init))

(defn init []
  (print "talk init")
  (mathdoc/init)
  (style/init)
  (pearson/init)
  (datavstime/init)
  (background/init)
  (inference/init)
  (conclusion/init)
  (superman/init)
  (simplification/init)
  (complexity/init)
  (or no-slow-js (init-slow)))


(init)
