// Compiled by ClojureScript 1.9.494 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy.core.selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__66187__auto__ = elem.textContent;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var args85811 = [];
var len__67408__auto___85814 = arguments.length;
var i__67409__auto___85815 = (0);
while(true){
if((i__67409__auto___85815 < len__67408__auto___85814)){
args85811.push((arguments[i__67409__auto___85815]));

var G__85816 = (i__67409__auto___85815 + (1));
i__67409__auto___85815 = G__85816;
continue;
} else {
}
break;
}

var G__85813 = args85811.length;
switch (G__85813) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args85811.length)].join('')));

}
});

dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});

dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});

dommy.core.style.cljs$lang$maxFixedArity = 2;

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.call(null,elem,k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto__ = elem.classList;
if(cljs.core.truth_(temp__6751__auto__)){
var class_list = temp__6751__auto__;
return class_list.contains(c__$1);
} else {
var temp__6753__auto__ = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(temp__6753__auto__)){
var class_name = temp__6753__auto__;
var temp__6753__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);
if(cljs.core.truth_(temp__6753__auto____$1)){
var i = temp__6753__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var args85818 = [];
var len__67408__auto___85821 = arguments.length;
var i__67409__auto___85822 = (0);
while(true){
if((i__67409__auto___85822 < len__67408__auto___85821)){
args85818.push((arguments[i__67409__auto___85822]));

var G__85823 = (i__67409__auto___85822 + (1));
i__67409__auto___85822 = G__85823;
continue;
} else {
}
break;
}

var G__85820 = args85818.length;
switch (G__85820) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args85818.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var args85826 = [];
var len__67408__auto___85829 = arguments.length;
var i__67409__auto___85830 = (0);
while(true){
if((i__67409__auto___85830 < len__67408__auto___85829)){
args85826.push((arguments[i__67409__auto___85830]));

var G__85831 = (i__67409__auto___85830 + (1));
i__67409__auto___85830 = G__85831;
continue;
} else {
}
break;
}

var G__85828 = args85826.length;
switch (G__85828) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args85826.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__85825_SHARP_){
return !((p1__85825_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.call(null,document.body,elem,selector);
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if(!((void 0 === elem.textContent))){
elem.textContent = text;
} else {
elem.innerText = text;
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
elem.innerHTML = html;

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
elem.value = value;

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return elem.className = c;
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___85845 = arguments.length;
var i__67409__auto___85846 = (0);
while(true){
if((i__67409__auto___85846 < len__67408__auto___85845)){
args__67415__auto__.push((arguments[i__67409__auto___85846]));

var G__85847 = (i__67409__auto___85846 + (1));
i__67409__auto___85846 = G__85847;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__85835_85848 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__85836_85849 = null;
var count__85837_85850 = (0);
var i__85838_85851 = (0);
while(true){
if((i__85838_85851 < count__85837_85850)){
var vec__85839_85852 = cljs.core._nth.call(null,chunk__85836_85849,i__85838_85851);
var k_85853 = cljs.core.nth.call(null,vec__85839_85852,(0),null);
var v_85854 = cljs.core.nth.call(null,vec__85839_85852,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_85853),v_85854);

var G__85855 = seq__85835_85848;
var G__85856 = chunk__85836_85849;
var G__85857 = count__85837_85850;
var G__85858 = (i__85838_85851 + (1));
seq__85835_85848 = G__85855;
chunk__85836_85849 = G__85856;
count__85837_85850 = G__85857;
i__85838_85851 = G__85858;
continue;
} else {
var temp__6753__auto___85859 = cljs.core.seq.call(null,seq__85835_85848);
if(temp__6753__auto___85859){
var seq__85835_85860__$1 = temp__6753__auto___85859;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__85835_85860__$1)){
var c__67098__auto___85861 = cljs.core.chunk_first.call(null,seq__85835_85860__$1);
var G__85862 = cljs.core.chunk_rest.call(null,seq__85835_85860__$1);
var G__85863 = c__67098__auto___85861;
var G__85864 = cljs.core.count.call(null,c__67098__auto___85861);
var G__85865 = (0);
seq__85835_85848 = G__85862;
chunk__85836_85849 = G__85863;
count__85837_85850 = G__85864;
i__85838_85851 = G__85865;
continue;
} else {
var vec__85842_85866 = cljs.core.first.call(null,seq__85835_85860__$1);
var k_85867 = cljs.core.nth.call(null,vec__85842_85866,(0),null);
var v_85868 = cljs.core.nth.call(null,vec__85842_85866,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_85867),v_85868);

var G__85869 = cljs.core.next.call(null,seq__85835_85860__$1);
var G__85870 = null;
var G__85871 = (0);
var G__85872 = (0);
seq__85835_85848 = G__85869;
chunk__85836_85849 = G__85870;
count__85837_85850 = G__85871;
i__85838_85851 = G__85872;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq85833){
var G__85834 = cljs.core.first.call(null,seq85833);
var seq85833__$1 = cljs.core.next.call(null,seq85833);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__85834,seq85833__$1);
});

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___85879 = arguments.length;
var i__67409__auto___85880 = (0);
while(true){
if((i__67409__auto___85880 < len__67408__auto___85879)){
args__67415__auto__.push((arguments[i__67409__auto___85880]));

var G__85881 = (i__67409__auto___85880 + (1));
i__67409__auto___85880 = G__85881;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__85875_85882 = cljs.core.seq.call(null,keywords);
var chunk__85876_85883 = null;
var count__85877_85884 = (0);
var i__85878_85885 = (0);
while(true){
if((i__85878_85885 < count__85877_85884)){
var kw_85886 = cljs.core._nth.call(null,chunk__85876_85883,i__85878_85885);
style.removeProperty(dommy.utils.as_str.call(null,kw_85886));

var G__85887 = seq__85875_85882;
var G__85888 = chunk__85876_85883;
var G__85889 = count__85877_85884;
var G__85890 = (i__85878_85885 + (1));
seq__85875_85882 = G__85887;
chunk__85876_85883 = G__85888;
count__85877_85884 = G__85889;
i__85878_85885 = G__85890;
continue;
} else {
var temp__6753__auto___85891 = cljs.core.seq.call(null,seq__85875_85882);
if(temp__6753__auto___85891){
var seq__85875_85892__$1 = temp__6753__auto___85891;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__85875_85892__$1)){
var c__67098__auto___85893 = cljs.core.chunk_first.call(null,seq__85875_85892__$1);
var G__85894 = cljs.core.chunk_rest.call(null,seq__85875_85892__$1);
var G__85895 = c__67098__auto___85893;
var G__85896 = cljs.core.count.call(null,c__67098__auto___85893);
var G__85897 = (0);
seq__85875_85882 = G__85894;
chunk__85876_85883 = G__85895;
count__85877_85884 = G__85896;
i__85878_85885 = G__85897;
continue;
} else {
var kw_85898 = cljs.core.first.call(null,seq__85875_85892__$1);
style.removeProperty(dommy.utils.as_str.call(null,kw_85898));

var G__85899 = cljs.core.next.call(null,seq__85875_85892__$1);
var G__85900 = null;
var G__85901 = (0);
var G__85902 = (0);
seq__85875_85882 = G__85899;
chunk__85876_85883 = G__85900;
count__85877_85884 = G__85901;
i__85878_85885 = G__85902;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq85873){
var G__85874 = cljs.core.first.call(null,seq85873);
var seq85873__$1 = cljs.core.next.call(null,seq85873);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__85874,seq85873__$1);
});

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___85915 = arguments.length;
var i__67409__auto___85916 = (0);
while(true){
if((i__67409__auto___85916 < len__67408__auto___85915)){
args__67415__auto__.push((arguments[i__67409__auto___85916]));

var G__85917 = (i__67409__auto___85916 + (1));
i__67409__auto___85916 = G__85917;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__85905_85918 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__85906_85919 = null;
var count__85907_85920 = (0);
var i__85908_85921 = (0);
while(true){
if((i__85908_85921 < count__85907_85920)){
var vec__85909_85922 = cljs.core._nth.call(null,chunk__85906_85919,i__85908_85921);
var k_85923 = cljs.core.nth.call(null,vec__85909_85922,(0),null);
var v_85924 = cljs.core.nth.call(null,vec__85909_85922,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_85923,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_85924),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''));

var G__85925 = seq__85905_85918;
var G__85926 = chunk__85906_85919;
var G__85927 = count__85907_85920;
var G__85928 = (i__85908_85921 + (1));
seq__85905_85918 = G__85925;
chunk__85906_85919 = G__85926;
count__85907_85920 = G__85927;
i__85908_85921 = G__85928;
continue;
} else {
var temp__6753__auto___85929 = cljs.core.seq.call(null,seq__85905_85918);
if(temp__6753__auto___85929){
var seq__85905_85930__$1 = temp__6753__auto___85929;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__85905_85930__$1)){
var c__67098__auto___85931 = cljs.core.chunk_first.call(null,seq__85905_85930__$1);
var G__85932 = cljs.core.chunk_rest.call(null,seq__85905_85930__$1);
var G__85933 = c__67098__auto___85931;
var G__85934 = cljs.core.count.call(null,c__67098__auto___85931);
var G__85935 = (0);
seq__85905_85918 = G__85932;
chunk__85906_85919 = G__85933;
count__85907_85920 = G__85934;
i__85908_85921 = G__85935;
continue;
} else {
var vec__85912_85936 = cljs.core.first.call(null,seq__85905_85930__$1);
var k_85937 = cljs.core.nth.call(null,vec__85912_85936,(0),null);
var v_85938 = cljs.core.nth.call(null,vec__85912_85936,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_85937,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_85938),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''));

var G__85939 = cljs.core.next.call(null,seq__85905_85930__$1);
var G__85940 = null;
var G__85941 = (0);
var G__85942 = (0);
seq__85905_85918 = G__85939;
chunk__85906_85919 = G__85940;
count__85907_85920 = G__85941;
i__85908_85921 = G__85942;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq85903){
var G__85904 = cljs.core.first.call(null,seq85903);
var seq85903__$1 = cljs.core.next.call(null,seq85903);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__85904,seq85903__$1);
});

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var args85943 = [];
var len__67408__auto___85962 = arguments.length;
var i__67409__auto___85963 = (0);
while(true){
if((i__67409__auto___85963 < len__67408__auto___85962)){
args85943.push((arguments[i__67409__auto___85963]));

var G__85964 = (i__67409__auto___85963 + (1));
i__67409__auto___85963 = G__85964;
continue;
} else {
}
break;
}

var G__85949 = args85943.length;
switch (G__85949) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args85943.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__67431__auto__);

}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.call(null,elem,k,dommy.utils.as_str.call(null,k));
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__85950 = elem;
(G__85950[k__$1] = v);

return G__85950;
} else {
var G__85951 = elem;
G__85951.setAttribute(k__$1,v);

return G__85951;
}
} else {
return null;
}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__85952_85966 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__85953_85967 = null;
var count__85954_85968 = (0);
var i__85955_85969 = (0);
while(true){
if((i__85955_85969 < count__85954_85968)){
var vec__85956_85970 = cljs.core._nth.call(null,chunk__85953_85967,i__85955_85969);
var k_85971__$1 = cljs.core.nth.call(null,vec__85956_85970,(0),null);
var v_85972__$1 = cljs.core.nth.call(null,vec__85956_85970,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_85971__$1,v_85972__$1);

var G__85973 = seq__85952_85966;
var G__85974 = chunk__85953_85967;
var G__85975 = count__85954_85968;
var G__85976 = (i__85955_85969 + (1));
seq__85952_85966 = G__85973;
chunk__85953_85967 = G__85974;
count__85954_85968 = G__85975;
i__85955_85969 = G__85976;
continue;
} else {
var temp__6753__auto___85977 = cljs.core.seq.call(null,seq__85952_85966);
if(temp__6753__auto___85977){
var seq__85952_85978__$1 = temp__6753__auto___85977;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__85952_85978__$1)){
var c__67098__auto___85979 = cljs.core.chunk_first.call(null,seq__85952_85978__$1);
var G__85980 = cljs.core.chunk_rest.call(null,seq__85952_85978__$1);
var G__85981 = c__67098__auto___85979;
var G__85982 = cljs.core.count.call(null,c__67098__auto___85979);
var G__85983 = (0);
seq__85952_85966 = G__85980;
chunk__85953_85967 = G__85981;
count__85954_85968 = G__85982;
i__85955_85969 = G__85983;
continue;
} else {
var vec__85959_85984 = cljs.core.first.call(null,seq__85952_85978__$1);
var k_85985__$1 = cljs.core.nth.call(null,vec__85959_85984,(0),null);
var v_85986__$1 = cljs.core.nth.call(null,vec__85959_85984,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_85985__$1,v_85986__$1);

var G__85987 = cljs.core.next.call(null,seq__85952_85978__$1);
var G__85988 = null;
var G__85989 = (0);
var G__85990 = (0);
seq__85952_85966 = G__85987;
chunk__85953_85967 = G__85988;
count__85954_85968 = G__85989;
i__85955_85969 = G__85990;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq85944){
var G__85945 = cljs.core.first.call(null,seq85944);
var seq85944__$1 = cljs.core.next.call(null,seq85944);
var G__85946 = cljs.core.first.call(null,seq85944__$1);
var seq85944__$2 = cljs.core.next.call(null,seq85944__$1);
var G__85947 = cljs.core.first.call(null,seq85944__$2);
var seq85944__$3 = cljs.core.next.call(null,seq85944__$2);
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__85945,G__85946,G__85947,seq85944__$3);
});

dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var args85991 = [];
var len__67408__auto___86001 = arguments.length;
var i__67409__auto___86002 = (0);
while(true){
if((i__67409__auto___86002 < len__67408__auto___86001)){
args85991.push((arguments[i__67409__auto___86002]));

var G__86003 = (i__67409__auto___86002 + (1));
i__67409__auto___86002 = G__86003;
continue;
} else {
}
break;
}

var G__85996 = args85991.length;
switch (G__85996) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args85991.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_86005__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_86005__$1))){
dommy.core.set_class_BANG_.call(null,elem,"");
} else {
elem.removeAttribute(k_86005__$1);
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__85997_86006 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__85998_86007 = null;
var count__85999_86008 = (0);
var i__86000_86009 = (0);
while(true){
if((i__86000_86009 < count__85999_86008)){
var k_86010__$1 = cljs.core._nth.call(null,chunk__85998_86007,i__86000_86009);
dommy.core.remove_attr_BANG_.call(null,elem,k_86010__$1);

var G__86011 = seq__85997_86006;
var G__86012 = chunk__85998_86007;
var G__86013 = count__85999_86008;
var G__86014 = (i__86000_86009 + (1));
seq__85997_86006 = G__86011;
chunk__85998_86007 = G__86012;
count__85999_86008 = G__86013;
i__86000_86009 = G__86014;
continue;
} else {
var temp__6753__auto___86015 = cljs.core.seq.call(null,seq__85997_86006);
if(temp__6753__auto___86015){
var seq__85997_86016__$1 = temp__6753__auto___86015;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__85997_86016__$1)){
var c__67098__auto___86017 = cljs.core.chunk_first.call(null,seq__85997_86016__$1);
var G__86018 = cljs.core.chunk_rest.call(null,seq__85997_86016__$1);
var G__86019 = c__67098__auto___86017;
var G__86020 = cljs.core.count.call(null,c__67098__auto___86017);
var G__86021 = (0);
seq__85997_86006 = G__86018;
chunk__85998_86007 = G__86019;
count__85999_86008 = G__86020;
i__86000_86009 = G__86021;
continue;
} else {
var k_86022__$1 = cljs.core.first.call(null,seq__85997_86016__$1);
dommy.core.remove_attr_BANG_.call(null,elem,k_86022__$1);

var G__86023 = cljs.core.next.call(null,seq__85997_86016__$1);
var G__86024 = null;
var G__86025 = (0);
var G__86026 = (0);
seq__85997_86006 = G__86023;
chunk__85998_86007 = G__86024;
count__85999_86008 = G__86025;
i__86000_86009 = G__86026;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq85992){
var G__85993 = cljs.core.first.call(null,seq85992);
var seq85992__$1 = cljs.core.next.call(null,seq85992);
var G__85994 = cljs.core.first.call(null,seq85992__$1);
var seq85992__$2 = cljs.core.next.call(null,seq85992__$1);
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__85993,G__85994,seq85992__$2);
});

dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var args86027 = [];
var len__67408__auto___86030 = arguments.length;
var i__67409__auto___86031 = (0);
while(true){
if((i__67409__auto___86031 < len__67408__auto___86030)){
args86027.push((arguments[i__67409__auto___86031]));

var G__86032 = (i__67409__auto___86031 + (1));
i__67409__auto___86031 = G__86032;
continue;
} else {
}
break;
}

var G__86029 = args86027.length;
switch (G__86029) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args86027.length)].join('')));

}
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.call(null,elem,k);
} else {
return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});

dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var args86034 = [];
var len__67408__auto___86052 = arguments.length;
var i__67409__auto___86053 = (0);
while(true){
if((i__67409__auto___86053 < len__67408__auto___86052)){
args86034.push((arguments[i__67409__auto___86053]));

var G__86054 = (i__67409__auto___86053 + (1));
i__67409__auto___86053 = G__86054;
continue;
} else {
}
break;
}

var G__86039 = args86034.length;
switch (G__86039) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args86034.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);
if(cljs.core.seq.call(null,classes__$1)){
var temp__6751__auto___86056 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___86056)){
var class_list_86057 = temp__6751__auto___86056;
var seq__86040_86058 = cljs.core.seq.call(null,classes__$1);
var chunk__86041_86059 = null;
var count__86042_86060 = (0);
var i__86043_86061 = (0);
while(true){
if((i__86043_86061 < count__86042_86060)){
var c_86062 = cljs.core._nth.call(null,chunk__86041_86059,i__86043_86061);
class_list_86057.add(c_86062);

var G__86063 = seq__86040_86058;
var G__86064 = chunk__86041_86059;
var G__86065 = count__86042_86060;
var G__86066 = (i__86043_86061 + (1));
seq__86040_86058 = G__86063;
chunk__86041_86059 = G__86064;
count__86042_86060 = G__86065;
i__86043_86061 = G__86066;
continue;
} else {
var temp__6753__auto___86067 = cljs.core.seq.call(null,seq__86040_86058);
if(temp__6753__auto___86067){
var seq__86040_86068__$1 = temp__6753__auto___86067;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86040_86068__$1)){
var c__67098__auto___86069 = cljs.core.chunk_first.call(null,seq__86040_86068__$1);
var G__86070 = cljs.core.chunk_rest.call(null,seq__86040_86068__$1);
var G__86071 = c__67098__auto___86069;
var G__86072 = cljs.core.count.call(null,c__67098__auto___86069);
var G__86073 = (0);
seq__86040_86058 = G__86070;
chunk__86041_86059 = G__86071;
count__86042_86060 = G__86072;
i__86043_86061 = G__86073;
continue;
} else {
var c_86074 = cljs.core.first.call(null,seq__86040_86068__$1);
class_list_86057.add(c_86074);

var G__86075 = cljs.core.next.call(null,seq__86040_86068__$1);
var G__86076 = null;
var G__86077 = (0);
var G__86078 = (0);
seq__86040_86058 = G__86075;
chunk__86041_86059 = G__86076;
count__86042_86060 = G__86077;
i__86043_86061 = G__86078;
continue;
}
} else {
}
}
break;
}
} else {
var seq__86044_86079 = cljs.core.seq.call(null,classes__$1);
var chunk__86045_86080 = null;
var count__86046_86081 = (0);
var i__86047_86082 = (0);
while(true){
if((i__86047_86082 < count__86046_86081)){
var c_86083 = cljs.core._nth.call(null,chunk__86045_86080,i__86047_86082);
var class_name_86084 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_86084,c_86083))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_86084 === ""))?c_86083:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_86084),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_86083)].join('')));
}

var G__86085 = seq__86044_86079;
var G__86086 = chunk__86045_86080;
var G__86087 = count__86046_86081;
var G__86088 = (i__86047_86082 + (1));
seq__86044_86079 = G__86085;
chunk__86045_86080 = G__86086;
count__86046_86081 = G__86087;
i__86047_86082 = G__86088;
continue;
} else {
var temp__6753__auto___86089 = cljs.core.seq.call(null,seq__86044_86079);
if(temp__6753__auto___86089){
var seq__86044_86090__$1 = temp__6753__auto___86089;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86044_86090__$1)){
var c__67098__auto___86091 = cljs.core.chunk_first.call(null,seq__86044_86090__$1);
var G__86092 = cljs.core.chunk_rest.call(null,seq__86044_86090__$1);
var G__86093 = c__67098__auto___86091;
var G__86094 = cljs.core.count.call(null,c__67098__auto___86091);
var G__86095 = (0);
seq__86044_86079 = G__86092;
chunk__86045_86080 = G__86093;
count__86046_86081 = G__86094;
i__86047_86082 = G__86095;
continue;
} else {
var c_86096 = cljs.core.first.call(null,seq__86044_86090__$1);
var class_name_86097 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_86097,c_86096))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_86097 === ""))?c_86096:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_86097),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_86096)].join('')));
}

var G__86098 = cljs.core.next.call(null,seq__86044_86090__$1);
var G__86099 = null;
var G__86100 = (0);
var G__86101 = (0);
seq__86044_86079 = G__86098;
chunk__86045_86080 = G__86099;
count__86046_86081 = G__86100;
i__86047_86082 = G__86101;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__86048_86102 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__86049_86103 = null;
var count__86050_86104 = (0);
var i__86051_86105 = (0);
while(true){
if((i__86051_86105 < count__86050_86104)){
var c_86106 = cljs.core._nth.call(null,chunk__86049_86103,i__86051_86105);
dommy.core.add_class_BANG_.call(null,elem,c_86106);

var G__86107 = seq__86048_86102;
var G__86108 = chunk__86049_86103;
var G__86109 = count__86050_86104;
var G__86110 = (i__86051_86105 + (1));
seq__86048_86102 = G__86107;
chunk__86049_86103 = G__86108;
count__86050_86104 = G__86109;
i__86051_86105 = G__86110;
continue;
} else {
var temp__6753__auto___86111 = cljs.core.seq.call(null,seq__86048_86102);
if(temp__6753__auto___86111){
var seq__86048_86112__$1 = temp__6753__auto___86111;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86048_86112__$1)){
var c__67098__auto___86113 = cljs.core.chunk_first.call(null,seq__86048_86112__$1);
var G__86114 = cljs.core.chunk_rest.call(null,seq__86048_86112__$1);
var G__86115 = c__67098__auto___86113;
var G__86116 = cljs.core.count.call(null,c__67098__auto___86113);
var G__86117 = (0);
seq__86048_86102 = G__86114;
chunk__86049_86103 = G__86115;
count__86050_86104 = G__86116;
i__86051_86105 = G__86117;
continue;
} else {
var c_86118 = cljs.core.first.call(null,seq__86048_86112__$1);
dommy.core.add_class_BANG_.call(null,elem,c_86118);

var G__86119 = cljs.core.next.call(null,seq__86048_86112__$1);
var G__86120 = null;
var G__86121 = (0);
var G__86122 = (0);
seq__86048_86102 = G__86119;
chunk__86049_86103 = G__86120;
count__86050_86104 = G__86121;
i__86051_86105 = G__86122;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq86035){
var G__86036 = cljs.core.first.call(null,seq86035);
var seq86035__$1 = cljs.core.next.call(null,seq86035);
var G__86037 = cljs.core.first.call(null,seq86035__$1);
var seq86035__$2 = cljs.core.next.call(null,seq86035__$1);
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86036,G__86037,seq86035__$2);
});

dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var args86123 = [];
var len__67408__auto___86133 = arguments.length;
var i__67409__auto___86134 = (0);
while(true){
if((i__67409__auto___86134 < len__67408__auto___86133)){
args86123.push((arguments[i__67409__auto___86134]));

var G__86135 = (i__67409__auto___86134 + (1));
i__67409__auto___86134 = G__86135;
continue;
} else {
}
break;
}

var G__86128 = args86123.length;
switch (G__86128) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args86123.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto___86137 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___86137)){
var class_list_86138 = temp__6751__auto___86137;
class_list_86138.remove(c__$1);
} else {
var class_name_86139 = dommy.core.class$.call(null,elem);
var new_class_name_86140 = dommy.utils.remove_class_str.call(null,class_name_86139,c__$1);
if((class_name_86139 === new_class_name_86140)){
} else {
dommy.core.set_class_BANG_.call(null,elem,new_class_name_86140);
}
}

return elem;
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__86129 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__86130 = null;
var count__86131 = (0);
var i__86132 = (0);
while(true){
if((i__86132 < count__86131)){
var c = cljs.core._nth.call(null,chunk__86130,i__86132);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__86141 = seq__86129;
var G__86142 = chunk__86130;
var G__86143 = count__86131;
var G__86144 = (i__86132 + (1));
seq__86129 = G__86141;
chunk__86130 = G__86142;
count__86131 = G__86143;
i__86132 = G__86144;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__86129);
if(temp__6753__auto__){
var seq__86129__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86129__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__86129__$1);
var G__86145 = cljs.core.chunk_rest.call(null,seq__86129__$1);
var G__86146 = c__67098__auto__;
var G__86147 = cljs.core.count.call(null,c__67098__auto__);
var G__86148 = (0);
seq__86129 = G__86145;
chunk__86130 = G__86146;
count__86131 = G__86147;
i__86132 = G__86148;
continue;
} else {
var c = cljs.core.first.call(null,seq__86129__$1);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__86149 = cljs.core.next.call(null,seq__86129__$1);
var G__86150 = null;
var G__86151 = (0);
var G__86152 = (0);
seq__86129 = G__86149;
chunk__86130 = G__86150;
count__86131 = G__86151;
i__86132 = G__86152;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq86124){
var G__86125 = cljs.core.first.call(null,seq86124);
var seq86124__$1 = cljs.core.next.call(null,seq86124);
var G__86126 = cljs.core.first.call(null,seq86124__$1);
var seq86124__$2 = cljs.core.next.call(null,seq86124__$1);
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86125,G__86126,seq86124__$2);
});

dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var args86153 = [];
var len__67408__auto___86156 = arguments.length;
var i__67409__auto___86157 = (0);
while(true){
if((i__67409__auto___86157 < len__67408__auto___86156)){
args86153.push((arguments[i__67409__auto___86157]));

var G__86158 = (i__67409__auto___86157 + (1));
i__67409__auto___86157 = G__86158;
continue;
} else {
}
break;
}

var G__86155 = args86153.length;
switch (G__86155) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args86153.length)].join('')));

}
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto___86160 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___86160)){
var class_list_86161 = temp__6751__auto___86160;
class_list_86161.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.call(null,elem,class$);
} else {
dommy.core.remove_class_BANG_.call(null,elem,class$);
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var args86162 = [];
var len__67408__auto___86165 = arguments.length;
var i__67409__auto___86166 = (0);
while(true){
if((i__67409__auto___86166 < len__67408__auto___86165)){
args86162.push((arguments[i__67409__auto___86166]));

var G__86167 = (i__67409__auto___86166 + (1));
i__67409__auto___86166 = G__86167;
continue;
} else {
}
break;
}

var G__86164 = args86162.length;
switch (G__86164) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args86162.length)].join('')));

}
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});

dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var args86169 = [];
var len__67408__auto___86172 = arguments.length;
var i__67409__auto___86173 = (0);
while(true){
if((i__67409__auto___86173 < len__67408__auto___86172)){
args86169.push((arguments[i__67409__auto___86173]));

var G__86174 = (i__67409__auto___86173 + (1));
i__67409__auto___86173 = G__86174;
continue;
} else {
}
break;
}

var G__86171 = args86169.length;
switch (G__86171) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args86169.length)].join('')));

}
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$lang$maxFixedArity = 2;

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var args86176 = [];
var len__67408__auto___86187 = arguments.length;
var i__67409__auto___86188 = (0);
while(true){
if((i__67409__auto___86188 < len__67408__auto___86187)){
args86176.push((arguments[i__67409__auto___86188]));

var G__86189 = (i__67409__auto___86188 + (1));
i__67409__auto___86188 = G__86189;
continue;
} else {
}
break;
}

var G__86181 = args86176.length;
switch (G__86181) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args86176.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__86182 = parent;
G__86182.appendChild(child);

return G__86182;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__86183_86191 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__86184_86192 = null;
var count__86185_86193 = (0);
var i__86186_86194 = (0);
while(true){
if((i__86186_86194 < count__86185_86193)){
var c_86195 = cljs.core._nth.call(null,chunk__86184_86192,i__86186_86194);
dommy.core.append_BANG_.call(null,parent,c_86195);

var G__86196 = seq__86183_86191;
var G__86197 = chunk__86184_86192;
var G__86198 = count__86185_86193;
var G__86199 = (i__86186_86194 + (1));
seq__86183_86191 = G__86196;
chunk__86184_86192 = G__86197;
count__86185_86193 = G__86198;
i__86186_86194 = G__86199;
continue;
} else {
var temp__6753__auto___86200 = cljs.core.seq.call(null,seq__86183_86191);
if(temp__6753__auto___86200){
var seq__86183_86201__$1 = temp__6753__auto___86200;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86183_86201__$1)){
var c__67098__auto___86202 = cljs.core.chunk_first.call(null,seq__86183_86201__$1);
var G__86203 = cljs.core.chunk_rest.call(null,seq__86183_86201__$1);
var G__86204 = c__67098__auto___86202;
var G__86205 = cljs.core.count.call(null,c__67098__auto___86202);
var G__86206 = (0);
seq__86183_86191 = G__86203;
chunk__86184_86192 = G__86204;
count__86185_86193 = G__86205;
i__86186_86194 = G__86206;
continue;
} else {
var c_86207 = cljs.core.first.call(null,seq__86183_86201__$1);
dommy.core.append_BANG_.call(null,parent,c_86207);

var G__86208 = cljs.core.next.call(null,seq__86183_86201__$1);
var G__86209 = null;
var G__86210 = (0);
var G__86211 = (0);
seq__86183_86191 = G__86208;
chunk__86184_86192 = G__86209;
count__86185_86193 = G__86210;
i__86186_86194 = G__86211;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq86177){
var G__86178 = cljs.core.first.call(null,seq86177);
var seq86177__$1 = cljs.core.next.call(null,seq86177);
var G__86179 = cljs.core.first.call(null,seq86177__$1);
var seq86177__$2 = cljs.core.next.call(null,seq86177__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86178,G__86179,seq86177__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var args86212 = [];
var len__67408__auto___86223 = arguments.length;
var i__67409__auto___86224 = (0);
while(true){
if((i__67409__auto___86224 < len__67408__auto___86223)){
args86212.push((arguments[i__67409__auto___86224]));

var G__86225 = (i__67409__auto___86224 + (1));
i__67409__auto___86224 = G__86225;
continue;
} else {
}
break;
}

var G__86217 = args86212.length;
switch (G__86217) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args86212.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__86218 = parent;
G__86218.insertBefore(child,parent.firstChild);

return G__86218;
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__86219_86227 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__86220_86228 = null;
var count__86221_86229 = (0);
var i__86222_86230 = (0);
while(true){
if((i__86222_86230 < count__86221_86229)){
var c_86231 = cljs.core._nth.call(null,chunk__86220_86228,i__86222_86230);
dommy.core.prepend_BANG_.call(null,parent,c_86231);

var G__86232 = seq__86219_86227;
var G__86233 = chunk__86220_86228;
var G__86234 = count__86221_86229;
var G__86235 = (i__86222_86230 + (1));
seq__86219_86227 = G__86232;
chunk__86220_86228 = G__86233;
count__86221_86229 = G__86234;
i__86222_86230 = G__86235;
continue;
} else {
var temp__6753__auto___86236 = cljs.core.seq.call(null,seq__86219_86227);
if(temp__6753__auto___86236){
var seq__86219_86237__$1 = temp__6753__auto___86236;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86219_86237__$1)){
var c__67098__auto___86238 = cljs.core.chunk_first.call(null,seq__86219_86237__$1);
var G__86239 = cljs.core.chunk_rest.call(null,seq__86219_86237__$1);
var G__86240 = c__67098__auto___86238;
var G__86241 = cljs.core.count.call(null,c__67098__auto___86238);
var G__86242 = (0);
seq__86219_86227 = G__86239;
chunk__86220_86228 = G__86240;
count__86221_86229 = G__86241;
i__86222_86230 = G__86242;
continue;
} else {
var c_86243 = cljs.core.first.call(null,seq__86219_86237__$1);
dommy.core.prepend_BANG_.call(null,parent,c_86243);

var G__86244 = cljs.core.next.call(null,seq__86219_86237__$1);
var G__86245 = null;
var G__86246 = (0);
var G__86247 = (0);
seq__86219_86227 = G__86244;
chunk__86220_86228 = G__86245;
count__86221_86229 = G__86246;
i__86222_86230 = G__86247;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq86213){
var G__86214 = cljs.core.first.call(null,seq86213);
var seq86213__$1 = cljs.core.next.call(null,seq86213);
var G__86215 = cljs.core.first.call(null,seq86213__$1);
var seq86213__$2 = cljs.core.next.call(null,seq86213__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86214,G__86215,seq86213__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent.call(null,other);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__6751__auto___86248 = other.nextSibling;
if(cljs.core.truth_(temp__6751__auto___86248)){
var next_86249 = temp__6751__auto___86248;
dommy.core.insert_before_BANG_.call(null,elem,next_86249);
} else {
dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var args86250 = [];
var len__67408__auto___86254 = arguments.length;
var i__67409__auto___86255 = (0);
while(true){
if((i__67409__auto___86255 < len__67408__auto___86254)){
args86250.push((arguments[i__67409__auto___86255]));

var G__86256 = (i__67409__auto___86255 + (1));
i__67409__auto___86255 = G__86256;
continue;
} else {
}
break;
}

var G__86252 = args86250.length;
switch (G__86252) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args86250.length)].join('')));

}
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

return dommy.core.remove_BANG_.call(null,p,elem);
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__86253 = p;
G__86253.removeChild(elem);

return G__86253;
});

dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__86258){
var vec__86259 = p__86258;
var special_mouse_event = cljs.core.nth.call(null,vec__86259,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__86259,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,((function (vec__86259,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__86259,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__66187__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__66175__auto__ = related_target;
if(cljs.core.truth_(and__66175__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__66175__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__86259,special_mouse_event,real_mouse_event))
});})(vec__86259,special_mouse_event,real_mouse_event))
])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,elem,event.target,selector);
if(cljs.core.truth_((function (){var and__66175__auto__ = selected_target;
if(cljs.core.truth_(and__66175__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__66175__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__66187__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___86265 = arguments.length;
var i__67409__auto___86266 = (0);
while(true){
if((i__67409__auto___86266 < len__67408__auto___86265)){
args__67415__auto__.push((arguments[i__67409__auto___86266]));

var G__86267 = (i__67409__auto___86266 + (1));
i__67409__auto___86266 = G__86267;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((2) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67416__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq86262){
var G__86263 = cljs.core.first.call(null,seq86262);
var seq86262__$1 = cljs.core.next.call(null,seq86262);
var G__86264 = cljs.core.first.call(null,seq86262__$1);
var seq86262__$2 = cljs.core.next.call(null,seq86262__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86263,G__86264,seq86262__$2);
});

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___86307 = arguments.length;
var i__67409__auto___86308 = (0);
while(true){
if((i__67409__auto___86308 < len__67408__auto___86307)){
args__67415__auto__.push((arguments[i__67409__auto___86308]));

var G__86309 = (i__67409__auto___86308 + (1));
i__67409__auto___86308 = G__86309;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__86270_86310 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_86311 = cljs.core.nth.call(null,vec__86270_86310,(0),null);
var selector_86312 = cljs.core.nth.call(null,vec__86270_86310,(1),null);
var seq__86273_86313 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__86280_86314 = null;
var count__86281_86315 = (0);
var i__86282_86316 = (0);
while(true){
if((i__86282_86316 < count__86281_86315)){
var vec__86289_86317 = cljs.core._nth.call(null,chunk__86280_86314,i__86282_86316);
var orig_type_86318 = cljs.core.nth.call(null,vec__86289_86317,(0),null);
var f_86319 = cljs.core.nth.call(null,vec__86289_86317,(1),null);
var seq__86283_86320 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_86318,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_86318,cljs.core.identity])));
var chunk__86285_86321 = null;
var count__86286_86322 = (0);
var i__86287_86323 = (0);
while(true){
if((i__86287_86323 < count__86286_86322)){
var vec__86292_86324 = cljs.core._nth.call(null,chunk__86285_86321,i__86287_86323);
var actual_type_86325 = cljs.core.nth.call(null,vec__86292_86324,(0),null);
var factory_86326 = cljs.core.nth.call(null,vec__86292_86324,(1),null);
var canonical_f_86327 = (cljs.core.truth_(selector_86312)?cljs.core.partial.call(null,dommy.core.live_listener,elem_86311,selector_86312):cljs.core.identity).call(null,factory_86326.call(null,f_86319));
dommy.core.update_event_listeners_BANG_.call(null,elem_86311,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86312,actual_type_86325,f_86319], null),canonical_f_86327);

if(cljs.core.truth_(elem_86311.addEventListener)){
elem_86311.addEventListener(cljs.core.name.call(null,actual_type_86325),canonical_f_86327);
} else {
elem_86311.attachEvent(cljs.core.name.call(null,actual_type_86325),canonical_f_86327);
}

var G__86328 = seq__86283_86320;
var G__86329 = chunk__86285_86321;
var G__86330 = count__86286_86322;
var G__86331 = (i__86287_86323 + (1));
seq__86283_86320 = G__86328;
chunk__86285_86321 = G__86329;
count__86286_86322 = G__86330;
i__86287_86323 = G__86331;
continue;
} else {
var temp__6753__auto___86332 = cljs.core.seq.call(null,seq__86283_86320);
if(temp__6753__auto___86332){
var seq__86283_86333__$1 = temp__6753__auto___86332;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86283_86333__$1)){
var c__67098__auto___86334 = cljs.core.chunk_first.call(null,seq__86283_86333__$1);
var G__86335 = cljs.core.chunk_rest.call(null,seq__86283_86333__$1);
var G__86336 = c__67098__auto___86334;
var G__86337 = cljs.core.count.call(null,c__67098__auto___86334);
var G__86338 = (0);
seq__86283_86320 = G__86335;
chunk__86285_86321 = G__86336;
count__86286_86322 = G__86337;
i__86287_86323 = G__86338;
continue;
} else {
var vec__86295_86339 = cljs.core.first.call(null,seq__86283_86333__$1);
var actual_type_86340 = cljs.core.nth.call(null,vec__86295_86339,(0),null);
var factory_86341 = cljs.core.nth.call(null,vec__86295_86339,(1),null);
var canonical_f_86342 = (cljs.core.truth_(selector_86312)?cljs.core.partial.call(null,dommy.core.live_listener,elem_86311,selector_86312):cljs.core.identity).call(null,factory_86341.call(null,f_86319));
dommy.core.update_event_listeners_BANG_.call(null,elem_86311,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86312,actual_type_86340,f_86319], null),canonical_f_86342);

if(cljs.core.truth_(elem_86311.addEventListener)){
elem_86311.addEventListener(cljs.core.name.call(null,actual_type_86340),canonical_f_86342);
} else {
elem_86311.attachEvent(cljs.core.name.call(null,actual_type_86340),canonical_f_86342);
}

var G__86343 = cljs.core.next.call(null,seq__86283_86333__$1);
var G__86344 = null;
var G__86345 = (0);
var G__86346 = (0);
seq__86283_86320 = G__86343;
chunk__86285_86321 = G__86344;
count__86286_86322 = G__86345;
i__86287_86323 = G__86346;
continue;
}
} else {
}
}
break;
}

var G__86347 = seq__86273_86313;
var G__86348 = chunk__86280_86314;
var G__86349 = count__86281_86315;
var G__86350 = (i__86282_86316 + (1));
seq__86273_86313 = G__86347;
chunk__86280_86314 = G__86348;
count__86281_86315 = G__86349;
i__86282_86316 = G__86350;
continue;
} else {
var temp__6753__auto___86351 = cljs.core.seq.call(null,seq__86273_86313);
if(temp__6753__auto___86351){
var seq__86273_86352__$1 = temp__6753__auto___86351;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86273_86352__$1)){
var c__67098__auto___86353 = cljs.core.chunk_first.call(null,seq__86273_86352__$1);
var G__86354 = cljs.core.chunk_rest.call(null,seq__86273_86352__$1);
var G__86355 = c__67098__auto___86353;
var G__86356 = cljs.core.count.call(null,c__67098__auto___86353);
var G__86357 = (0);
seq__86273_86313 = G__86354;
chunk__86280_86314 = G__86355;
count__86281_86315 = G__86356;
i__86282_86316 = G__86357;
continue;
} else {
var vec__86298_86358 = cljs.core.first.call(null,seq__86273_86352__$1);
var orig_type_86359 = cljs.core.nth.call(null,vec__86298_86358,(0),null);
var f_86360 = cljs.core.nth.call(null,vec__86298_86358,(1),null);
var seq__86274_86361 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_86359,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_86359,cljs.core.identity])));
var chunk__86276_86362 = null;
var count__86277_86363 = (0);
var i__86278_86364 = (0);
while(true){
if((i__86278_86364 < count__86277_86363)){
var vec__86301_86365 = cljs.core._nth.call(null,chunk__86276_86362,i__86278_86364);
var actual_type_86366 = cljs.core.nth.call(null,vec__86301_86365,(0),null);
var factory_86367 = cljs.core.nth.call(null,vec__86301_86365,(1),null);
var canonical_f_86368 = (cljs.core.truth_(selector_86312)?cljs.core.partial.call(null,dommy.core.live_listener,elem_86311,selector_86312):cljs.core.identity).call(null,factory_86367.call(null,f_86360));
dommy.core.update_event_listeners_BANG_.call(null,elem_86311,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86312,actual_type_86366,f_86360], null),canonical_f_86368);

if(cljs.core.truth_(elem_86311.addEventListener)){
elem_86311.addEventListener(cljs.core.name.call(null,actual_type_86366),canonical_f_86368);
} else {
elem_86311.attachEvent(cljs.core.name.call(null,actual_type_86366),canonical_f_86368);
}

var G__86369 = seq__86274_86361;
var G__86370 = chunk__86276_86362;
var G__86371 = count__86277_86363;
var G__86372 = (i__86278_86364 + (1));
seq__86274_86361 = G__86369;
chunk__86276_86362 = G__86370;
count__86277_86363 = G__86371;
i__86278_86364 = G__86372;
continue;
} else {
var temp__6753__auto___86373__$1 = cljs.core.seq.call(null,seq__86274_86361);
if(temp__6753__auto___86373__$1){
var seq__86274_86374__$1 = temp__6753__auto___86373__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86274_86374__$1)){
var c__67098__auto___86375 = cljs.core.chunk_first.call(null,seq__86274_86374__$1);
var G__86376 = cljs.core.chunk_rest.call(null,seq__86274_86374__$1);
var G__86377 = c__67098__auto___86375;
var G__86378 = cljs.core.count.call(null,c__67098__auto___86375);
var G__86379 = (0);
seq__86274_86361 = G__86376;
chunk__86276_86362 = G__86377;
count__86277_86363 = G__86378;
i__86278_86364 = G__86379;
continue;
} else {
var vec__86304_86380 = cljs.core.first.call(null,seq__86274_86374__$1);
var actual_type_86381 = cljs.core.nth.call(null,vec__86304_86380,(0),null);
var factory_86382 = cljs.core.nth.call(null,vec__86304_86380,(1),null);
var canonical_f_86383 = (cljs.core.truth_(selector_86312)?cljs.core.partial.call(null,dommy.core.live_listener,elem_86311,selector_86312):cljs.core.identity).call(null,factory_86382.call(null,f_86360));
dommy.core.update_event_listeners_BANG_.call(null,elem_86311,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86312,actual_type_86381,f_86360], null),canonical_f_86383);

if(cljs.core.truth_(elem_86311.addEventListener)){
elem_86311.addEventListener(cljs.core.name.call(null,actual_type_86381),canonical_f_86383);
} else {
elem_86311.attachEvent(cljs.core.name.call(null,actual_type_86381),canonical_f_86383);
}

var G__86384 = cljs.core.next.call(null,seq__86274_86374__$1);
var G__86385 = null;
var G__86386 = (0);
var G__86387 = (0);
seq__86274_86361 = G__86384;
chunk__86276_86362 = G__86385;
count__86277_86363 = G__86386;
i__86278_86364 = G__86387;
continue;
}
} else {
}
}
break;
}

var G__86388 = cljs.core.next.call(null,seq__86273_86352__$1);
var G__86389 = null;
var G__86390 = (0);
var G__86391 = (0);
seq__86273_86313 = G__86388;
chunk__86280_86314 = G__86389;
count__86281_86315 = G__86390;
i__86282_86316 = G__86391;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq86268){
var G__86269 = cljs.core.first.call(null,seq86268);
var seq86268__$1 = cljs.core.next.call(null,seq86268);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86269,seq86268__$1);
});

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___86431 = arguments.length;
var i__67409__auto___86432 = (0);
while(true){
if((i__67409__auto___86432 < len__67408__auto___86431)){
args__67415__auto__.push((arguments[i__67409__auto___86432]));

var G__86433 = (i__67409__auto___86432 + (1));
i__67409__auto___86432 = G__86433;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__86394_86434 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_86435 = cljs.core.nth.call(null,vec__86394_86434,(0),null);
var selector_86436 = cljs.core.nth.call(null,vec__86394_86434,(1),null);
var seq__86397_86437 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__86404_86438 = null;
var count__86405_86439 = (0);
var i__86406_86440 = (0);
while(true){
if((i__86406_86440 < count__86405_86439)){
var vec__86413_86441 = cljs.core._nth.call(null,chunk__86404_86438,i__86406_86440);
var orig_type_86442 = cljs.core.nth.call(null,vec__86413_86441,(0),null);
var f_86443 = cljs.core.nth.call(null,vec__86413_86441,(1),null);
var seq__86407_86444 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_86442,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_86442,cljs.core.identity])));
var chunk__86409_86445 = null;
var count__86410_86446 = (0);
var i__86411_86447 = (0);
while(true){
if((i__86411_86447 < count__86410_86446)){
var vec__86416_86448 = cljs.core._nth.call(null,chunk__86409_86445,i__86411_86447);
var actual_type_86449 = cljs.core.nth.call(null,vec__86416_86448,(0),null);
var __86450 = cljs.core.nth.call(null,vec__86416_86448,(1),null);
var keys_86451 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86436,actual_type_86449,f_86443], null);
var canonical_f_86452 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_86435),keys_86451);
dommy.core.update_event_listeners_BANG_.call(null,elem_86435,dommy.utils.dissoc_in,keys_86451);

if(cljs.core.truth_(elem_86435.removeEventListener)){
elem_86435.removeEventListener(cljs.core.name.call(null,actual_type_86449),canonical_f_86452);
} else {
elem_86435.detachEvent(cljs.core.name.call(null,actual_type_86449),canonical_f_86452);
}

var G__86453 = seq__86407_86444;
var G__86454 = chunk__86409_86445;
var G__86455 = count__86410_86446;
var G__86456 = (i__86411_86447 + (1));
seq__86407_86444 = G__86453;
chunk__86409_86445 = G__86454;
count__86410_86446 = G__86455;
i__86411_86447 = G__86456;
continue;
} else {
var temp__6753__auto___86457 = cljs.core.seq.call(null,seq__86407_86444);
if(temp__6753__auto___86457){
var seq__86407_86458__$1 = temp__6753__auto___86457;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86407_86458__$1)){
var c__67098__auto___86459 = cljs.core.chunk_first.call(null,seq__86407_86458__$1);
var G__86460 = cljs.core.chunk_rest.call(null,seq__86407_86458__$1);
var G__86461 = c__67098__auto___86459;
var G__86462 = cljs.core.count.call(null,c__67098__auto___86459);
var G__86463 = (0);
seq__86407_86444 = G__86460;
chunk__86409_86445 = G__86461;
count__86410_86446 = G__86462;
i__86411_86447 = G__86463;
continue;
} else {
var vec__86419_86464 = cljs.core.first.call(null,seq__86407_86458__$1);
var actual_type_86465 = cljs.core.nth.call(null,vec__86419_86464,(0),null);
var __86466 = cljs.core.nth.call(null,vec__86419_86464,(1),null);
var keys_86467 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86436,actual_type_86465,f_86443], null);
var canonical_f_86468 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_86435),keys_86467);
dommy.core.update_event_listeners_BANG_.call(null,elem_86435,dommy.utils.dissoc_in,keys_86467);

if(cljs.core.truth_(elem_86435.removeEventListener)){
elem_86435.removeEventListener(cljs.core.name.call(null,actual_type_86465),canonical_f_86468);
} else {
elem_86435.detachEvent(cljs.core.name.call(null,actual_type_86465),canonical_f_86468);
}

var G__86469 = cljs.core.next.call(null,seq__86407_86458__$1);
var G__86470 = null;
var G__86471 = (0);
var G__86472 = (0);
seq__86407_86444 = G__86469;
chunk__86409_86445 = G__86470;
count__86410_86446 = G__86471;
i__86411_86447 = G__86472;
continue;
}
} else {
}
}
break;
}

var G__86473 = seq__86397_86437;
var G__86474 = chunk__86404_86438;
var G__86475 = count__86405_86439;
var G__86476 = (i__86406_86440 + (1));
seq__86397_86437 = G__86473;
chunk__86404_86438 = G__86474;
count__86405_86439 = G__86475;
i__86406_86440 = G__86476;
continue;
} else {
var temp__6753__auto___86477 = cljs.core.seq.call(null,seq__86397_86437);
if(temp__6753__auto___86477){
var seq__86397_86478__$1 = temp__6753__auto___86477;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86397_86478__$1)){
var c__67098__auto___86479 = cljs.core.chunk_first.call(null,seq__86397_86478__$1);
var G__86480 = cljs.core.chunk_rest.call(null,seq__86397_86478__$1);
var G__86481 = c__67098__auto___86479;
var G__86482 = cljs.core.count.call(null,c__67098__auto___86479);
var G__86483 = (0);
seq__86397_86437 = G__86480;
chunk__86404_86438 = G__86481;
count__86405_86439 = G__86482;
i__86406_86440 = G__86483;
continue;
} else {
var vec__86422_86484 = cljs.core.first.call(null,seq__86397_86478__$1);
var orig_type_86485 = cljs.core.nth.call(null,vec__86422_86484,(0),null);
var f_86486 = cljs.core.nth.call(null,vec__86422_86484,(1),null);
var seq__86398_86487 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_86485,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_86485,cljs.core.identity])));
var chunk__86400_86488 = null;
var count__86401_86489 = (0);
var i__86402_86490 = (0);
while(true){
if((i__86402_86490 < count__86401_86489)){
var vec__86425_86491 = cljs.core._nth.call(null,chunk__86400_86488,i__86402_86490);
var actual_type_86492 = cljs.core.nth.call(null,vec__86425_86491,(0),null);
var __86493 = cljs.core.nth.call(null,vec__86425_86491,(1),null);
var keys_86494 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86436,actual_type_86492,f_86486], null);
var canonical_f_86495 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_86435),keys_86494);
dommy.core.update_event_listeners_BANG_.call(null,elem_86435,dommy.utils.dissoc_in,keys_86494);

if(cljs.core.truth_(elem_86435.removeEventListener)){
elem_86435.removeEventListener(cljs.core.name.call(null,actual_type_86492),canonical_f_86495);
} else {
elem_86435.detachEvent(cljs.core.name.call(null,actual_type_86492),canonical_f_86495);
}

var G__86496 = seq__86398_86487;
var G__86497 = chunk__86400_86488;
var G__86498 = count__86401_86489;
var G__86499 = (i__86402_86490 + (1));
seq__86398_86487 = G__86496;
chunk__86400_86488 = G__86497;
count__86401_86489 = G__86498;
i__86402_86490 = G__86499;
continue;
} else {
var temp__6753__auto___86500__$1 = cljs.core.seq.call(null,seq__86398_86487);
if(temp__6753__auto___86500__$1){
var seq__86398_86501__$1 = temp__6753__auto___86500__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86398_86501__$1)){
var c__67098__auto___86502 = cljs.core.chunk_first.call(null,seq__86398_86501__$1);
var G__86503 = cljs.core.chunk_rest.call(null,seq__86398_86501__$1);
var G__86504 = c__67098__auto___86502;
var G__86505 = cljs.core.count.call(null,c__67098__auto___86502);
var G__86506 = (0);
seq__86398_86487 = G__86503;
chunk__86400_86488 = G__86504;
count__86401_86489 = G__86505;
i__86402_86490 = G__86506;
continue;
} else {
var vec__86428_86507 = cljs.core.first.call(null,seq__86398_86501__$1);
var actual_type_86508 = cljs.core.nth.call(null,vec__86428_86507,(0),null);
var __86509 = cljs.core.nth.call(null,vec__86428_86507,(1),null);
var keys_86510 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_86436,actual_type_86508,f_86486], null);
var canonical_f_86511 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_86435),keys_86510);
dommy.core.update_event_listeners_BANG_.call(null,elem_86435,dommy.utils.dissoc_in,keys_86510);

if(cljs.core.truth_(elem_86435.removeEventListener)){
elem_86435.removeEventListener(cljs.core.name.call(null,actual_type_86508),canonical_f_86511);
} else {
elem_86435.detachEvent(cljs.core.name.call(null,actual_type_86508),canonical_f_86511);
}

var G__86512 = cljs.core.next.call(null,seq__86398_86501__$1);
var G__86513 = null;
var G__86514 = (0);
var G__86515 = (0);
seq__86398_86487 = G__86512;
chunk__86400_86488 = G__86513;
count__86401_86489 = G__86514;
i__86402_86490 = G__86515;
continue;
}
} else {
}
}
break;
}

var G__86516 = cljs.core.next.call(null,seq__86397_86478__$1);
var G__86517 = null;
var G__86518 = (0);
var G__86519 = (0);
seq__86397_86437 = G__86516;
chunk__86404_86438 = G__86517;
count__86405_86439 = G__86518;
i__86406_86440 = G__86519;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq86392){
var G__86393 = cljs.core.first.call(null,seq86392);
var seq86392__$1 = cljs.core.next.call(null,seq86392);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86393,seq86392__$1);
});

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___86535 = arguments.length;
var i__67409__auto___86536 = (0);
while(true){
if((i__67409__auto___86536 < len__67408__auto___86535)){
args__67415__auto__.push((arguments[i__67409__auto___86536]));

var G__86537 = (i__67409__auto___86536 + (1));
i__67409__auto___86536 = G__86537;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__86522_86538 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_86539 = cljs.core.nth.call(null,vec__86522_86538,(0),null);
var selector_86540 = cljs.core.nth.call(null,vec__86522_86538,(1),null);
var seq__86525_86541 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__86526_86542 = null;
var count__86527_86543 = (0);
var i__86528_86544 = (0);
while(true){
if((i__86528_86544 < count__86527_86543)){
var vec__86529_86545 = cljs.core._nth.call(null,chunk__86526_86542,i__86528_86544);
var type_86546 = cljs.core.nth.call(null,vec__86529_86545,(0),null);
var f_86547 = cljs.core.nth.call(null,vec__86529_86545,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_86546,((function (seq__86525_86541,chunk__86526_86542,count__86527_86543,i__86528_86544,vec__86529_86545,type_86546,f_86547,vec__86522_86538,elem_86539,selector_86540){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_86546,dommy$core$this_fn);

return f_86547.call(null,e);
});})(seq__86525_86541,chunk__86526_86542,count__86527_86543,i__86528_86544,vec__86529_86545,type_86546,f_86547,vec__86522_86538,elem_86539,selector_86540))
);

var G__86548 = seq__86525_86541;
var G__86549 = chunk__86526_86542;
var G__86550 = count__86527_86543;
var G__86551 = (i__86528_86544 + (1));
seq__86525_86541 = G__86548;
chunk__86526_86542 = G__86549;
count__86527_86543 = G__86550;
i__86528_86544 = G__86551;
continue;
} else {
var temp__6753__auto___86552 = cljs.core.seq.call(null,seq__86525_86541);
if(temp__6753__auto___86552){
var seq__86525_86553__$1 = temp__6753__auto___86552;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86525_86553__$1)){
var c__67098__auto___86554 = cljs.core.chunk_first.call(null,seq__86525_86553__$1);
var G__86555 = cljs.core.chunk_rest.call(null,seq__86525_86553__$1);
var G__86556 = c__67098__auto___86554;
var G__86557 = cljs.core.count.call(null,c__67098__auto___86554);
var G__86558 = (0);
seq__86525_86541 = G__86555;
chunk__86526_86542 = G__86556;
count__86527_86543 = G__86557;
i__86528_86544 = G__86558;
continue;
} else {
var vec__86532_86559 = cljs.core.first.call(null,seq__86525_86553__$1);
var type_86560 = cljs.core.nth.call(null,vec__86532_86559,(0),null);
var f_86561 = cljs.core.nth.call(null,vec__86532_86559,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_86560,((function (seq__86525_86541,chunk__86526_86542,count__86527_86543,i__86528_86544,vec__86532_86559,type_86560,f_86561,seq__86525_86553__$1,temp__6753__auto___86552,vec__86522_86538,elem_86539,selector_86540){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_86560,dommy$core$this_fn);

return f_86561.call(null,e);
});})(seq__86525_86541,chunk__86526_86542,count__86527_86543,i__86528_86544,vec__86532_86559,type_86560,f_86561,seq__86525_86553__$1,temp__6753__auto___86552,vec__86522_86538,elem_86539,selector_86540))
);

var G__86562 = cljs.core.next.call(null,seq__86525_86553__$1);
var G__86563 = null;
var G__86564 = (0);
var G__86565 = (0);
seq__86525_86541 = G__86562;
chunk__86526_86542 = G__86563;
count__86527_86543 = G__86564;
i__86528_86544 = G__86565;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq86520){
var G__86521 = cljs.core.first.call(null,seq86520);
var seq86520__$1 = cljs.core.next.call(null,seq86520);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__86521,seq86520__$1);
});


//# sourceMappingURL=core.js.map?rel=1489355967031