// Compiled by ClojureScript 1.9.494 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args79148 = [];
var len__67408__auto___79154 = arguments.length;
var i__67409__auto___79155 = (0);
while(true){
if((i__67409__auto___79155 < len__67408__auto___79154)){
args79148.push((arguments[i__67409__auto___79155]));

var G__79156 = (i__67409__auto___79155 + (1));
i__67409__auto___79155 = G__79156;
continue;
} else {
}
break;
}

var G__79150 = args79148.length;
switch (G__79150) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79148.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async79151 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async79151 = (function (f,blockable,meta79152){
this.f = f;
this.blockable = blockable;
this.meta79152 = meta79152;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async79151.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_79153,meta79152__$1){
var self__ = this;
var _79153__$1 = this;
return (new cljs.core.async.t_cljs$core$async79151(self__.f,self__.blockable,meta79152__$1));
});

cljs.core.async.t_cljs$core$async79151.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_79153){
var self__ = this;
var _79153__$1 = this;
return self__.meta79152;
});

cljs.core.async.t_cljs$core$async79151.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async79151.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async79151.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async79151.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async79151.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta79152","meta79152",-1699573147,null)], null);
});

cljs.core.async.t_cljs$core$async79151.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async79151.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async79151";

cljs.core.async.t_cljs$core$async79151.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async79151");
});

cljs.core.async.__GT_t_cljs$core$async79151 = (function cljs$core$async$__GT_t_cljs$core$async79151(f__$1,blockable__$1,meta79152){
return (new cljs.core.async.t_cljs$core$async79151(f__$1,blockable__$1,meta79152));
});

}

return (new cljs.core.async.t_cljs$core$async79151(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args79160 = [];
var len__67408__auto___79163 = arguments.length;
var i__67409__auto___79164 = (0);
while(true){
if((i__67409__auto___79164 < len__67408__auto___79163)){
args79160.push((arguments[i__67409__auto___79164]));

var G__79165 = (i__67409__auto___79164 + (1));
i__67409__auto___79164 = G__79165;
continue;
} else {
}
break;
}

var G__79162 = args79160.length;
switch (G__79162) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79160.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args79167 = [];
var len__67408__auto___79170 = arguments.length;
var i__67409__auto___79171 = (0);
while(true){
if((i__67409__auto___79171 < len__67408__auto___79170)){
args79167.push((arguments[i__67409__auto___79171]));

var G__79172 = (i__67409__auto___79171 + (1));
i__67409__auto___79171 = G__79172;
continue;
} else {
}
break;
}

var G__79169 = args79167.length;
switch (G__79169) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79167.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args79174 = [];
var len__67408__auto___79177 = arguments.length;
var i__67409__auto___79178 = (0);
while(true){
if((i__67409__auto___79178 < len__67408__auto___79177)){
args79174.push((arguments[i__67409__auto___79178]));

var G__79179 = (i__67409__auto___79178 + (1));
i__67409__auto___79178 = G__79179;
continue;
} else {
}
break;
}

var G__79176 = args79174.length;
switch (G__79176) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79174.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_79181 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_79181);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_79181,ret){
return (function (){
return fn1.call(null,val_79181);
});})(val_79181,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args79182 = [];
var len__67408__auto___79185 = arguments.length;
var i__67409__auto___79186 = (0);
while(true){
if((i__67409__auto___79186 < len__67408__auto___79185)){
args79182.push((arguments[i__67409__auto___79186]));

var G__79187 = (i__67409__auto___79186 + (1));
i__67409__auto___79186 = G__79187;
continue;
} else {
}
break;
}

var G__79184 = args79182.length;
switch (G__79184) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79182.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__67208__auto___79189 = n;
var x_79190 = (0);
while(true){
if((x_79190 < n__67208__auto___79189)){
(a[x_79190] = (0));

var G__79191 = (x_79190 + (1));
x_79190 = G__79191;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__79192 = (i + (1));
i = G__79192;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async79196 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async79196 = (function (flag,meta79197){
this.flag = flag;
this.meta79197 = meta79197;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async79196.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_79198,meta79197__$1){
var self__ = this;
var _79198__$1 = this;
return (new cljs.core.async.t_cljs$core$async79196(self__.flag,meta79197__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async79196.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_79198){
var self__ = this;
var _79198__$1 = this;
return self__.meta79197;
});})(flag))
;

cljs.core.async.t_cljs$core$async79196.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async79196.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async79196.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async79196.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async79196.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta79197","meta79197",994828805,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async79196.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async79196.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async79196";

cljs.core.async.t_cljs$core$async79196.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async79196");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async79196 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async79196(flag__$1,meta79197){
return (new cljs.core.async.t_cljs$core$async79196(flag__$1,meta79197));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async79196(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async79202 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async79202 = (function (flag,cb,meta79203){
this.flag = flag;
this.cb = cb;
this.meta79203 = meta79203;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async79202.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_79204,meta79203__$1){
var self__ = this;
var _79204__$1 = this;
return (new cljs.core.async.t_cljs$core$async79202(self__.flag,self__.cb,meta79203__$1));
});

cljs.core.async.t_cljs$core$async79202.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_79204){
var self__ = this;
var _79204__$1 = this;
return self__.meta79203;
});

cljs.core.async.t_cljs$core$async79202.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async79202.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async79202.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async79202.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async79202.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta79203","meta79203",395484684,null)], null);
});

cljs.core.async.t_cljs$core$async79202.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async79202.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async79202";

cljs.core.async.t_cljs$core$async79202.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async79202");
});

cljs.core.async.__GT_t_cljs$core$async79202 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async79202(flag__$1,cb__$1,meta79203){
return (new cljs.core.async.t_cljs$core$async79202(flag__$1,cb__$1,meta79203));
});

}

return (new cljs.core.async.t_cljs$core$async79202(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__79205_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__79205_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__79206_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__79206_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__66187__auto__ = wport;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return port;
}
})()], null));
} else {
var G__79207 = (i + (1));
i = G__79207;
continue;
}
} else {
return null;
}
break;
}
})();
var or__66187__auto__ = ret;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__66175__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__66175__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__66175__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___79213 = arguments.length;
var i__67409__auto___79214 = (0);
while(true){
if((i__67409__auto___79214 < len__67408__auto___79213)){
args__67415__auto__.push((arguments[i__67409__auto___79214]));

var G__79215 = (i__67409__auto___79214 + (1));
i__67409__auto___79214 = G__79215;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__79210){
var map__79211 = p__79210;
var map__79211__$1 = ((((!((map__79211 == null)))?((((map__79211.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__79211.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__79211):map__79211);
var opts = map__79211__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq79208){
var G__79209 = cljs.core.first.call(null,seq79208);
var seq79208__$1 = cljs.core.next.call(null,seq79208);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__79209,seq79208__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args79216 = [];
var len__67408__auto___79266 = arguments.length;
var i__67409__auto___79267 = (0);
while(true){
if((i__67409__auto___79267 < len__67408__auto___79266)){
args79216.push((arguments[i__67409__auto___79267]));

var G__79268 = (i__67409__auto___79267 + (1));
i__67409__auto___79267 = G__79268;
continue;
} else {
}
break;
}

var G__79218 = args79216.length;
switch (G__79218) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79216.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__70934__auto___79270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___79270){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___79270){
return (function (state_79242){
var state_val_79243 = (state_79242[(1)]);
if((state_val_79243 === (7))){
var inst_79238 = (state_79242[(2)]);
var state_79242__$1 = state_79242;
var statearr_79244_79271 = state_79242__$1;
(statearr_79244_79271[(2)] = inst_79238);

(statearr_79244_79271[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (1))){
var state_79242__$1 = state_79242;
var statearr_79245_79272 = state_79242__$1;
(statearr_79245_79272[(2)] = null);

(statearr_79245_79272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (4))){
var inst_79221 = (state_79242[(7)]);
var inst_79221__$1 = (state_79242[(2)]);
var inst_79222 = (inst_79221__$1 == null);
var state_79242__$1 = (function (){var statearr_79246 = state_79242;
(statearr_79246[(7)] = inst_79221__$1);

return statearr_79246;
})();
if(cljs.core.truth_(inst_79222)){
var statearr_79247_79273 = state_79242__$1;
(statearr_79247_79273[(1)] = (5));

} else {
var statearr_79248_79274 = state_79242__$1;
(statearr_79248_79274[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (13))){
var state_79242__$1 = state_79242;
var statearr_79249_79275 = state_79242__$1;
(statearr_79249_79275[(2)] = null);

(statearr_79249_79275[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (6))){
var inst_79221 = (state_79242[(7)]);
var state_79242__$1 = state_79242;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79242__$1,(11),to,inst_79221);
} else {
if((state_val_79243 === (3))){
var inst_79240 = (state_79242[(2)]);
var state_79242__$1 = state_79242;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79242__$1,inst_79240);
} else {
if((state_val_79243 === (12))){
var state_79242__$1 = state_79242;
var statearr_79250_79276 = state_79242__$1;
(statearr_79250_79276[(2)] = null);

(statearr_79250_79276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (2))){
var state_79242__$1 = state_79242;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79242__$1,(4),from);
} else {
if((state_val_79243 === (11))){
var inst_79231 = (state_79242[(2)]);
var state_79242__$1 = state_79242;
if(cljs.core.truth_(inst_79231)){
var statearr_79251_79277 = state_79242__$1;
(statearr_79251_79277[(1)] = (12));

} else {
var statearr_79252_79278 = state_79242__$1;
(statearr_79252_79278[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (9))){
var state_79242__$1 = state_79242;
var statearr_79253_79279 = state_79242__$1;
(statearr_79253_79279[(2)] = null);

(statearr_79253_79279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (5))){
var state_79242__$1 = state_79242;
if(cljs.core.truth_(close_QMARK_)){
var statearr_79254_79280 = state_79242__$1;
(statearr_79254_79280[(1)] = (8));

} else {
var statearr_79255_79281 = state_79242__$1;
(statearr_79255_79281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (14))){
var inst_79236 = (state_79242[(2)]);
var state_79242__$1 = state_79242;
var statearr_79256_79282 = state_79242__$1;
(statearr_79256_79282[(2)] = inst_79236);

(statearr_79256_79282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (10))){
var inst_79228 = (state_79242[(2)]);
var state_79242__$1 = state_79242;
var statearr_79257_79283 = state_79242__$1;
(statearr_79257_79283[(2)] = inst_79228);

(statearr_79257_79283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79243 === (8))){
var inst_79225 = cljs.core.async.close_BANG_.call(null,to);
var state_79242__$1 = state_79242;
var statearr_79258_79284 = state_79242__$1;
(statearr_79258_79284[(2)] = inst_79225);

(statearr_79258_79284[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___79270))
;
return ((function (switch__70820__auto__,c__70934__auto___79270){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_79262 = [null,null,null,null,null,null,null,null];
(statearr_79262[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_79262[(1)] = (1));

return statearr_79262;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_79242){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79242);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79263){if((e79263 instanceof Object)){
var ex__70824__auto__ = e79263;
var statearr_79264_79285 = state_79242;
(statearr_79264_79285[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79242);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79286 = state_79242;
state_79242 = G__79286;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_79242){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_79242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___79270))
})();
var state__70936__auto__ = (function (){var statearr_79265 = f__70935__auto__.call(null);
(statearr_79265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___79270);

return statearr_79265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___79270))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__79474){
var vec__79475 = p__79474;
var v = cljs.core.nth.call(null,vec__79475,(0),null);
var p = cljs.core.nth.call(null,vec__79475,(1),null);
var job = vec__79475;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__70934__auto___79661 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___79661,res,vec__79475,v,p,job,jobs,results){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___79661,res,vec__79475,v,p,job,jobs,results){
return (function (state_79482){
var state_val_79483 = (state_79482[(1)]);
if((state_val_79483 === (1))){
var state_79482__$1 = state_79482;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79482__$1,(2),res,v);
} else {
if((state_val_79483 === (2))){
var inst_79479 = (state_79482[(2)]);
var inst_79480 = cljs.core.async.close_BANG_.call(null,res);
var state_79482__$1 = (function (){var statearr_79484 = state_79482;
(statearr_79484[(7)] = inst_79479);

return statearr_79484;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79482__$1,inst_79480);
} else {
return null;
}
}
});})(c__70934__auto___79661,res,vec__79475,v,p,job,jobs,results))
;
return ((function (switch__70820__auto__,c__70934__auto___79661,res,vec__79475,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_79488 = [null,null,null,null,null,null,null,null];
(statearr_79488[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_79488[(1)] = (1));

return statearr_79488;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_79482){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79489){if((e79489 instanceof Object)){
var ex__70824__auto__ = e79489;
var statearr_79490_79662 = state_79482;
(statearr_79490_79662[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79482);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79489;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79663 = state_79482;
state_79482 = G__79663;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_79482){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_79482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___79661,res,vec__79475,v,p,job,jobs,results))
})();
var state__70936__auto__ = (function (){var statearr_79491 = f__70935__auto__.call(null);
(statearr_79491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___79661);

return statearr_79491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___79661,res,vec__79475,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__79492){
var vec__79493 = p__79492;
var v = cljs.core.nth.call(null,vec__79493,(0),null);
var p = cljs.core.nth.call(null,vec__79493,(1),null);
var job = vec__79493;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__67208__auto___79664 = n;
var __79665 = (0);
while(true){
if((__79665 < n__67208__auto___79664)){
var G__79496_79666 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__79496_79666) {
case "compute":
var c__70934__auto___79668 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__79665,c__70934__auto___79668,G__79496_79666,n__67208__auto___79664,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (__79665,c__70934__auto___79668,G__79496_79666,n__67208__auto___79664,jobs,results,process,async){
return (function (state_79509){
var state_val_79510 = (state_79509[(1)]);
if((state_val_79510 === (1))){
var state_79509__$1 = state_79509;
var statearr_79511_79669 = state_79509__$1;
(statearr_79511_79669[(2)] = null);

(statearr_79511_79669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79510 === (2))){
var state_79509__$1 = state_79509;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79509__$1,(4),jobs);
} else {
if((state_val_79510 === (3))){
var inst_79507 = (state_79509[(2)]);
var state_79509__$1 = state_79509;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79509__$1,inst_79507);
} else {
if((state_val_79510 === (4))){
var inst_79499 = (state_79509[(2)]);
var inst_79500 = process.call(null,inst_79499);
var state_79509__$1 = state_79509;
if(cljs.core.truth_(inst_79500)){
var statearr_79512_79670 = state_79509__$1;
(statearr_79512_79670[(1)] = (5));

} else {
var statearr_79513_79671 = state_79509__$1;
(statearr_79513_79671[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79510 === (5))){
var state_79509__$1 = state_79509;
var statearr_79514_79672 = state_79509__$1;
(statearr_79514_79672[(2)] = null);

(statearr_79514_79672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79510 === (6))){
var state_79509__$1 = state_79509;
var statearr_79515_79673 = state_79509__$1;
(statearr_79515_79673[(2)] = null);

(statearr_79515_79673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79510 === (7))){
var inst_79505 = (state_79509[(2)]);
var state_79509__$1 = state_79509;
var statearr_79516_79674 = state_79509__$1;
(statearr_79516_79674[(2)] = inst_79505);

(statearr_79516_79674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__79665,c__70934__auto___79668,G__79496_79666,n__67208__auto___79664,jobs,results,process,async))
;
return ((function (__79665,switch__70820__auto__,c__70934__auto___79668,G__79496_79666,n__67208__auto___79664,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_79520 = [null,null,null,null,null,null,null];
(statearr_79520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_79520[(1)] = (1));

return statearr_79520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_79509){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79509);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79521){if((e79521 instanceof Object)){
var ex__70824__auto__ = e79521;
var statearr_79522_79675 = state_79509;
(statearr_79522_79675[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79509);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79521;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79676 = state_79509;
state_79509 = G__79676;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_79509){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_79509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(__79665,switch__70820__auto__,c__70934__auto___79668,G__79496_79666,n__67208__auto___79664,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_79523 = f__70935__auto__.call(null);
(statearr_79523[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___79668);

return statearr_79523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(__79665,c__70934__auto___79668,G__79496_79666,n__67208__auto___79664,jobs,results,process,async))
);


break;
case "async":
var c__70934__auto___79677 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__79665,c__70934__auto___79677,G__79496_79666,n__67208__auto___79664,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (__79665,c__70934__auto___79677,G__79496_79666,n__67208__auto___79664,jobs,results,process,async){
return (function (state_79536){
var state_val_79537 = (state_79536[(1)]);
if((state_val_79537 === (1))){
var state_79536__$1 = state_79536;
var statearr_79538_79678 = state_79536__$1;
(statearr_79538_79678[(2)] = null);

(statearr_79538_79678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79537 === (2))){
var state_79536__$1 = state_79536;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79536__$1,(4),jobs);
} else {
if((state_val_79537 === (3))){
var inst_79534 = (state_79536[(2)]);
var state_79536__$1 = state_79536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79536__$1,inst_79534);
} else {
if((state_val_79537 === (4))){
var inst_79526 = (state_79536[(2)]);
var inst_79527 = async.call(null,inst_79526);
var state_79536__$1 = state_79536;
if(cljs.core.truth_(inst_79527)){
var statearr_79539_79679 = state_79536__$1;
(statearr_79539_79679[(1)] = (5));

} else {
var statearr_79540_79680 = state_79536__$1;
(statearr_79540_79680[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79537 === (5))){
var state_79536__$1 = state_79536;
var statearr_79541_79681 = state_79536__$1;
(statearr_79541_79681[(2)] = null);

(statearr_79541_79681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79537 === (6))){
var state_79536__$1 = state_79536;
var statearr_79542_79682 = state_79536__$1;
(statearr_79542_79682[(2)] = null);

(statearr_79542_79682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79537 === (7))){
var inst_79532 = (state_79536[(2)]);
var state_79536__$1 = state_79536;
var statearr_79543_79683 = state_79536__$1;
(statearr_79543_79683[(2)] = inst_79532);

(statearr_79543_79683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__79665,c__70934__auto___79677,G__79496_79666,n__67208__auto___79664,jobs,results,process,async))
;
return ((function (__79665,switch__70820__auto__,c__70934__auto___79677,G__79496_79666,n__67208__auto___79664,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_79547 = [null,null,null,null,null,null,null];
(statearr_79547[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_79547[(1)] = (1));

return statearr_79547;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_79536){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79548){if((e79548 instanceof Object)){
var ex__70824__auto__ = e79548;
var statearr_79549_79684 = state_79536;
(statearr_79549_79684[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79536);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79548;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79685 = state_79536;
state_79536 = G__79685;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_79536){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_79536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(__79665,switch__70820__auto__,c__70934__auto___79677,G__79496_79666,n__67208__auto___79664,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_79550 = f__70935__auto__.call(null);
(statearr_79550[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___79677);

return statearr_79550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(__79665,c__70934__auto___79677,G__79496_79666,n__67208__auto___79664,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__79686 = (__79665 + (1));
__79665 = G__79686;
continue;
} else {
}
break;
}

var c__70934__auto___79687 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___79687,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___79687,jobs,results,process,async){
return (function (state_79572){
var state_val_79573 = (state_79572[(1)]);
if((state_val_79573 === (1))){
var state_79572__$1 = state_79572;
var statearr_79574_79688 = state_79572__$1;
(statearr_79574_79688[(2)] = null);

(statearr_79574_79688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79573 === (2))){
var state_79572__$1 = state_79572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79572__$1,(4),from);
} else {
if((state_val_79573 === (3))){
var inst_79570 = (state_79572[(2)]);
var state_79572__$1 = state_79572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79572__$1,inst_79570);
} else {
if((state_val_79573 === (4))){
var inst_79553 = (state_79572[(7)]);
var inst_79553__$1 = (state_79572[(2)]);
var inst_79554 = (inst_79553__$1 == null);
var state_79572__$1 = (function (){var statearr_79575 = state_79572;
(statearr_79575[(7)] = inst_79553__$1);

return statearr_79575;
})();
if(cljs.core.truth_(inst_79554)){
var statearr_79576_79689 = state_79572__$1;
(statearr_79576_79689[(1)] = (5));

} else {
var statearr_79577_79690 = state_79572__$1;
(statearr_79577_79690[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79573 === (5))){
var inst_79556 = cljs.core.async.close_BANG_.call(null,jobs);
var state_79572__$1 = state_79572;
var statearr_79578_79691 = state_79572__$1;
(statearr_79578_79691[(2)] = inst_79556);

(statearr_79578_79691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79573 === (6))){
var inst_79553 = (state_79572[(7)]);
var inst_79558 = (state_79572[(8)]);
var inst_79558__$1 = cljs.core.async.chan.call(null,(1));
var inst_79559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79560 = [inst_79553,inst_79558__$1];
var inst_79561 = (new cljs.core.PersistentVector(null,2,(5),inst_79559,inst_79560,null));
var state_79572__$1 = (function (){var statearr_79579 = state_79572;
(statearr_79579[(8)] = inst_79558__$1);

return statearr_79579;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79572__$1,(8),jobs,inst_79561);
} else {
if((state_val_79573 === (7))){
var inst_79568 = (state_79572[(2)]);
var state_79572__$1 = state_79572;
var statearr_79580_79692 = state_79572__$1;
(statearr_79580_79692[(2)] = inst_79568);

(statearr_79580_79692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79573 === (8))){
var inst_79558 = (state_79572[(8)]);
var inst_79563 = (state_79572[(2)]);
var state_79572__$1 = (function (){var statearr_79581 = state_79572;
(statearr_79581[(9)] = inst_79563);

return statearr_79581;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79572__$1,(9),results,inst_79558);
} else {
if((state_val_79573 === (9))){
var inst_79565 = (state_79572[(2)]);
var state_79572__$1 = (function (){var statearr_79582 = state_79572;
(statearr_79582[(10)] = inst_79565);

return statearr_79582;
})();
var statearr_79583_79693 = state_79572__$1;
(statearr_79583_79693[(2)] = null);

(statearr_79583_79693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___79687,jobs,results,process,async))
;
return ((function (switch__70820__auto__,c__70934__auto___79687,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_79587 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_79587[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_79587[(1)] = (1));

return statearr_79587;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_79572){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79588){if((e79588 instanceof Object)){
var ex__70824__auto__ = e79588;
var statearr_79589_79694 = state_79572;
(statearr_79589_79694[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79695 = state_79572;
state_79572 = G__79695;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_79572){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_79572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___79687,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_79590 = f__70935__auto__.call(null);
(statearr_79590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___79687);

return statearr_79590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___79687,jobs,results,process,async))
);


var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,jobs,results,process,async){
return (function (state_79628){
var state_val_79629 = (state_79628[(1)]);
if((state_val_79629 === (7))){
var inst_79624 = (state_79628[(2)]);
var state_79628__$1 = state_79628;
var statearr_79630_79696 = state_79628__$1;
(statearr_79630_79696[(2)] = inst_79624);

(statearr_79630_79696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (20))){
var state_79628__$1 = state_79628;
var statearr_79631_79697 = state_79628__$1;
(statearr_79631_79697[(2)] = null);

(statearr_79631_79697[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (1))){
var state_79628__$1 = state_79628;
var statearr_79632_79698 = state_79628__$1;
(statearr_79632_79698[(2)] = null);

(statearr_79632_79698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (4))){
var inst_79593 = (state_79628[(7)]);
var inst_79593__$1 = (state_79628[(2)]);
var inst_79594 = (inst_79593__$1 == null);
var state_79628__$1 = (function (){var statearr_79633 = state_79628;
(statearr_79633[(7)] = inst_79593__$1);

return statearr_79633;
})();
if(cljs.core.truth_(inst_79594)){
var statearr_79634_79699 = state_79628__$1;
(statearr_79634_79699[(1)] = (5));

} else {
var statearr_79635_79700 = state_79628__$1;
(statearr_79635_79700[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (15))){
var inst_79606 = (state_79628[(8)]);
var state_79628__$1 = state_79628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79628__$1,(18),to,inst_79606);
} else {
if((state_val_79629 === (21))){
var inst_79619 = (state_79628[(2)]);
var state_79628__$1 = state_79628;
var statearr_79636_79701 = state_79628__$1;
(statearr_79636_79701[(2)] = inst_79619);

(statearr_79636_79701[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (13))){
var inst_79621 = (state_79628[(2)]);
var state_79628__$1 = (function (){var statearr_79637 = state_79628;
(statearr_79637[(9)] = inst_79621);

return statearr_79637;
})();
var statearr_79638_79702 = state_79628__$1;
(statearr_79638_79702[(2)] = null);

(statearr_79638_79702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (6))){
var inst_79593 = (state_79628[(7)]);
var state_79628__$1 = state_79628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79628__$1,(11),inst_79593);
} else {
if((state_val_79629 === (17))){
var inst_79614 = (state_79628[(2)]);
var state_79628__$1 = state_79628;
if(cljs.core.truth_(inst_79614)){
var statearr_79639_79703 = state_79628__$1;
(statearr_79639_79703[(1)] = (19));

} else {
var statearr_79640_79704 = state_79628__$1;
(statearr_79640_79704[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (3))){
var inst_79626 = (state_79628[(2)]);
var state_79628__$1 = state_79628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79628__$1,inst_79626);
} else {
if((state_val_79629 === (12))){
var inst_79603 = (state_79628[(10)]);
var state_79628__$1 = state_79628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79628__$1,(14),inst_79603);
} else {
if((state_val_79629 === (2))){
var state_79628__$1 = state_79628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79628__$1,(4),results);
} else {
if((state_val_79629 === (19))){
var state_79628__$1 = state_79628;
var statearr_79641_79705 = state_79628__$1;
(statearr_79641_79705[(2)] = null);

(statearr_79641_79705[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (11))){
var inst_79603 = (state_79628[(2)]);
var state_79628__$1 = (function (){var statearr_79642 = state_79628;
(statearr_79642[(10)] = inst_79603);

return statearr_79642;
})();
var statearr_79643_79706 = state_79628__$1;
(statearr_79643_79706[(2)] = null);

(statearr_79643_79706[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (9))){
var state_79628__$1 = state_79628;
var statearr_79644_79707 = state_79628__$1;
(statearr_79644_79707[(2)] = null);

(statearr_79644_79707[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (5))){
var state_79628__$1 = state_79628;
if(cljs.core.truth_(close_QMARK_)){
var statearr_79645_79708 = state_79628__$1;
(statearr_79645_79708[(1)] = (8));

} else {
var statearr_79646_79709 = state_79628__$1;
(statearr_79646_79709[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (14))){
var inst_79608 = (state_79628[(11)]);
var inst_79606 = (state_79628[(8)]);
var inst_79606__$1 = (state_79628[(2)]);
var inst_79607 = (inst_79606__$1 == null);
var inst_79608__$1 = cljs.core.not.call(null,inst_79607);
var state_79628__$1 = (function (){var statearr_79647 = state_79628;
(statearr_79647[(11)] = inst_79608__$1);

(statearr_79647[(8)] = inst_79606__$1);

return statearr_79647;
})();
if(inst_79608__$1){
var statearr_79648_79710 = state_79628__$1;
(statearr_79648_79710[(1)] = (15));

} else {
var statearr_79649_79711 = state_79628__$1;
(statearr_79649_79711[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (16))){
var inst_79608 = (state_79628[(11)]);
var state_79628__$1 = state_79628;
var statearr_79650_79712 = state_79628__$1;
(statearr_79650_79712[(2)] = inst_79608);

(statearr_79650_79712[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (10))){
var inst_79600 = (state_79628[(2)]);
var state_79628__$1 = state_79628;
var statearr_79651_79713 = state_79628__$1;
(statearr_79651_79713[(2)] = inst_79600);

(statearr_79651_79713[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (18))){
var inst_79611 = (state_79628[(2)]);
var state_79628__$1 = state_79628;
var statearr_79652_79714 = state_79628__$1;
(statearr_79652_79714[(2)] = inst_79611);

(statearr_79652_79714[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79629 === (8))){
var inst_79597 = cljs.core.async.close_BANG_.call(null,to);
var state_79628__$1 = state_79628;
var statearr_79653_79715 = state_79628__$1;
(statearr_79653_79715[(2)] = inst_79597);

(statearr_79653_79715[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__,jobs,results,process,async))
;
return ((function (switch__70820__auto__,c__70934__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_79657 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79657[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_79657[(1)] = (1));

return statearr_79657;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_79628){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79658){if((e79658 instanceof Object)){
var ex__70824__auto__ = e79658;
var statearr_79659_79716 = state_79628;
(statearr_79659_79716[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79717 = state_79628;
state_79628 = G__79717;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_79628){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_79628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_79660 = f__70935__auto__.call(null);
(statearr_79660[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_79660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,jobs,results,process,async))
);

return c__70934__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args79718 = [];
var len__67408__auto___79721 = arguments.length;
var i__67409__auto___79722 = (0);
while(true){
if((i__67409__auto___79722 < len__67408__auto___79721)){
args79718.push((arguments[i__67409__auto___79722]));

var G__79723 = (i__67409__auto___79722 + (1));
i__67409__auto___79722 = G__79723;
continue;
} else {
}
break;
}

var G__79720 = args79718.length;
switch (G__79720) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79718.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args79725 = [];
var len__67408__auto___79728 = arguments.length;
var i__67409__auto___79729 = (0);
while(true){
if((i__67409__auto___79729 < len__67408__auto___79728)){
args79725.push((arguments[i__67409__auto___79729]));

var G__79730 = (i__67409__auto___79729 + (1));
i__67409__auto___79729 = G__79730;
continue;
} else {
}
break;
}

var G__79727 = args79725.length;
switch (G__79727) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79725.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args79732 = [];
var len__67408__auto___79785 = arguments.length;
var i__67409__auto___79786 = (0);
while(true){
if((i__67409__auto___79786 < len__67408__auto___79785)){
args79732.push((arguments[i__67409__auto___79786]));

var G__79787 = (i__67409__auto___79786 + (1));
i__67409__auto___79786 = G__79787;
continue;
} else {
}
break;
}

var G__79734 = args79732.length;
switch (G__79734) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79732.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__70934__auto___79789 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___79789,tc,fc){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___79789,tc,fc){
return (function (state_79760){
var state_val_79761 = (state_79760[(1)]);
if((state_val_79761 === (7))){
var inst_79756 = (state_79760[(2)]);
var state_79760__$1 = state_79760;
var statearr_79762_79790 = state_79760__$1;
(statearr_79762_79790[(2)] = inst_79756);

(statearr_79762_79790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (1))){
var state_79760__$1 = state_79760;
var statearr_79763_79791 = state_79760__$1;
(statearr_79763_79791[(2)] = null);

(statearr_79763_79791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (4))){
var inst_79737 = (state_79760[(7)]);
var inst_79737__$1 = (state_79760[(2)]);
var inst_79738 = (inst_79737__$1 == null);
var state_79760__$1 = (function (){var statearr_79764 = state_79760;
(statearr_79764[(7)] = inst_79737__$1);

return statearr_79764;
})();
if(cljs.core.truth_(inst_79738)){
var statearr_79765_79792 = state_79760__$1;
(statearr_79765_79792[(1)] = (5));

} else {
var statearr_79766_79793 = state_79760__$1;
(statearr_79766_79793[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (13))){
var state_79760__$1 = state_79760;
var statearr_79767_79794 = state_79760__$1;
(statearr_79767_79794[(2)] = null);

(statearr_79767_79794[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (6))){
var inst_79737 = (state_79760[(7)]);
var inst_79743 = p.call(null,inst_79737);
var state_79760__$1 = state_79760;
if(cljs.core.truth_(inst_79743)){
var statearr_79768_79795 = state_79760__$1;
(statearr_79768_79795[(1)] = (9));

} else {
var statearr_79769_79796 = state_79760__$1;
(statearr_79769_79796[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (3))){
var inst_79758 = (state_79760[(2)]);
var state_79760__$1 = state_79760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79760__$1,inst_79758);
} else {
if((state_val_79761 === (12))){
var state_79760__$1 = state_79760;
var statearr_79770_79797 = state_79760__$1;
(statearr_79770_79797[(2)] = null);

(statearr_79770_79797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (2))){
var state_79760__$1 = state_79760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79760__$1,(4),ch);
} else {
if((state_val_79761 === (11))){
var inst_79737 = (state_79760[(7)]);
var inst_79747 = (state_79760[(2)]);
var state_79760__$1 = state_79760;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79760__$1,(8),inst_79747,inst_79737);
} else {
if((state_val_79761 === (9))){
var state_79760__$1 = state_79760;
var statearr_79771_79798 = state_79760__$1;
(statearr_79771_79798[(2)] = tc);

(statearr_79771_79798[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (5))){
var inst_79740 = cljs.core.async.close_BANG_.call(null,tc);
var inst_79741 = cljs.core.async.close_BANG_.call(null,fc);
var state_79760__$1 = (function (){var statearr_79772 = state_79760;
(statearr_79772[(8)] = inst_79740);

return statearr_79772;
})();
var statearr_79773_79799 = state_79760__$1;
(statearr_79773_79799[(2)] = inst_79741);

(statearr_79773_79799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (14))){
var inst_79754 = (state_79760[(2)]);
var state_79760__$1 = state_79760;
var statearr_79774_79800 = state_79760__$1;
(statearr_79774_79800[(2)] = inst_79754);

(statearr_79774_79800[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (10))){
var state_79760__$1 = state_79760;
var statearr_79775_79801 = state_79760__$1;
(statearr_79775_79801[(2)] = fc);

(statearr_79775_79801[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79761 === (8))){
var inst_79749 = (state_79760[(2)]);
var state_79760__$1 = state_79760;
if(cljs.core.truth_(inst_79749)){
var statearr_79776_79802 = state_79760__$1;
(statearr_79776_79802[(1)] = (12));

} else {
var statearr_79777_79803 = state_79760__$1;
(statearr_79777_79803[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___79789,tc,fc))
;
return ((function (switch__70820__auto__,c__70934__auto___79789,tc,fc){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_79781 = [null,null,null,null,null,null,null,null,null];
(statearr_79781[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_79781[(1)] = (1));

return statearr_79781;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_79760){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79782){if((e79782 instanceof Object)){
var ex__70824__auto__ = e79782;
var statearr_79783_79804 = state_79760;
(statearr_79783_79804[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79782;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79805 = state_79760;
state_79760 = G__79805;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_79760){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_79760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___79789,tc,fc))
})();
var state__70936__auto__ = (function (){var statearr_79784 = f__70935__auto__.call(null);
(statearr_79784[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___79789);

return statearr_79784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___79789,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_79869){
var state_val_79870 = (state_79869[(1)]);
if((state_val_79870 === (7))){
var inst_79865 = (state_79869[(2)]);
var state_79869__$1 = state_79869;
var statearr_79871_79892 = state_79869__$1;
(statearr_79871_79892[(2)] = inst_79865);

(statearr_79871_79892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (1))){
var inst_79849 = init;
var state_79869__$1 = (function (){var statearr_79872 = state_79869;
(statearr_79872[(7)] = inst_79849);

return statearr_79872;
})();
var statearr_79873_79893 = state_79869__$1;
(statearr_79873_79893[(2)] = null);

(statearr_79873_79893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (4))){
var inst_79852 = (state_79869[(8)]);
var inst_79852__$1 = (state_79869[(2)]);
var inst_79853 = (inst_79852__$1 == null);
var state_79869__$1 = (function (){var statearr_79874 = state_79869;
(statearr_79874[(8)] = inst_79852__$1);

return statearr_79874;
})();
if(cljs.core.truth_(inst_79853)){
var statearr_79875_79894 = state_79869__$1;
(statearr_79875_79894[(1)] = (5));

} else {
var statearr_79876_79895 = state_79869__$1;
(statearr_79876_79895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (6))){
var inst_79852 = (state_79869[(8)]);
var inst_79856 = (state_79869[(9)]);
var inst_79849 = (state_79869[(7)]);
var inst_79856__$1 = f.call(null,inst_79849,inst_79852);
var inst_79857 = cljs.core.reduced_QMARK_.call(null,inst_79856__$1);
var state_79869__$1 = (function (){var statearr_79877 = state_79869;
(statearr_79877[(9)] = inst_79856__$1);

return statearr_79877;
})();
if(inst_79857){
var statearr_79878_79896 = state_79869__$1;
(statearr_79878_79896[(1)] = (8));

} else {
var statearr_79879_79897 = state_79869__$1;
(statearr_79879_79897[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (3))){
var inst_79867 = (state_79869[(2)]);
var state_79869__$1 = state_79869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79869__$1,inst_79867);
} else {
if((state_val_79870 === (2))){
var state_79869__$1 = state_79869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79869__$1,(4),ch);
} else {
if((state_val_79870 === (9))){
var inst_79856 = (state_79869[(9)]);
var inst_79849 = inst_79856;
var state_79869__$1 = (function (){var statearr_79880 = state_79869;
(statearr_79880[(7)] = inst_79849);

return statearr_79880;
})();
var statearr_79881_79898 = state_79869__$1;
(statearr_79881_79898[(2)] = null);

(statearr_79881_79898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (5))){
var inst_79849 = (state_79869[(7)]);
var state_79869__$1 = state_79869;
var statearr_79882_79899 = state_79869__$1;
(statearr_79882_79899[(2)] = inst_79849);

(statearr_79882_79899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (10))){
var inst_79863 = (state_79869[(2)]);
var state_79869__$1 = state_79869;
var statearr_79883_79900 = state_79869__$1;
(statearr_79883_79900[(2)] = inst_79863);

(statearr_79883_79900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79870 === (8))){
var inst_79856 = (state_79869[(9)]);
var inst_79859 = cljs.core.deref.call(null,inst_79856);
var state_79869__$1 = state_79869;
var statearr_79884_79901 = state_79869__$1;
(statearr_79884_79901[(2)] = inst_79859);

(statearr_79884_79901[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__70821__auto__ = null;
var cljs$core$async$reduce_$_state_machine__70821__auto____0 = (function (){
var statearr_79888 = [null,null,null,null,null,null,null,null,null,null];
(statearr_79888[(0)] = cljs$core$async$reduce_$_state_machine__70821__auto__);

(statearr_79888[(1)] = (1));

return statearr_79888;
});
var cljs$core$async$reduce_$_state_machine__70821__auto____1 = (function (state_79869){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79889){if((e79889 instanceof Object)){
var ex__70824__auto__ = e79889;
var statearr_79890_79902 = state_79869;
(statearr_79890_79902[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79869);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79889;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79903 = state_79869;
state_79869 = G__79903;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__70821__auto__ = function(state_79869){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__70821__auto____1.call(this,state_79869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__70821__auto____0;
cljs$core$async$reduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__70821__auto____1;
return cljs$core$async$reduce_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_79891 = f__70935__auto__.call(null);
(statearr_79891[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_79891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,f__$1){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,f__$1){
return (function (state_79923){
var state_val_79924 = (state_79923[(1)]);
if((state_val_79924 === (1))){
var inst_79918 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_79923__$1 = state_79923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79923__$1,(2),inst_79918);
} else {
if((state_val_79924 === (2))){
var inst_79920 = (state_79923[(2)]);
var inst_79921 = f__$1.call(null,inst_79920);
var state_79923__$1 = state_79923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79923__$1,inst_79921);
} else {
return null;
}
}
});})(c__70934__auto__,f__$1))
;
return ((function (switch__70820__auto__,c__70934__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__70821__auto__ = null;
var cljs$core$async$transduce_$_state_machine__70821__auto____0 = (function (){
var statearr_79928 = [null,null,null,null,null,null,null];
(statearr_79928[(0)] = cljs$core$async$transduce_$_state_machine__70821__auto__);

(statearr_79928[(1)] = (1));

return statearr_79928;
});
var cljs$core$async$transduce_$_state_machine__70821__auto____1 = (function (state_79923){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79929){if((e79929 instanceof Object)){
var ex__70824__auto__ = e79929;
var statearr_79930_79932 = state_79923;
(statearr_79930_79932[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79929;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79933 = state_79923;
state_79923 = G__79933;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__70821__auto__ = function(state_79923){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__70821__auto____1.call(this,state_79923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__70821__auto____0;
cljs$core$async$transduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__70821__auto____1;
return cljs$core$async$transduce_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,f__$1))
})();
var state__70936__auto__ = (function (){var statearr_79931 = f__70935__auto__.call(null);
(statearr_79931[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_79931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,f__$1))
);

return c__70934__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args79934 = [];
var len__67408__auto___79986 = arguments.length;
var i__67409__auto___79987 = (0);
while(true){
if((i__67409__auto___79987 < len__67408__auto___79986)){
args79934.push((arguments[i__67409__auto___79987]));

var G__79988 = (i__67409__auto___79987 + (1));
i__67409__auto___79987 = G__79988;
continue;
} else {
}
break;
}

var G__79936 = args79934.length;
switch (G__79936) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args79934.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_79961){
var state_val_79962 = (state_79961[(1)]);
if((state_val_79962 === (7))){
var inst_79943 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
var statearr_79963_79990 = state_79961__$1;
(statearr_79963_79990[(2)] = inst_79943);

(statearr_79963_79990[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (1))){
var inst_79937 = cljs.core.seq.call(null,coll);
var inst_79938 = inst_79937;
var state_79961__$1 = (function (){var statearr_79964 = state_79961;
(statearr_79964[(7)] = inst_79938);

return statearr_79964;
})();
var statearr_79965_79991 = state_79961__$1;
(statearr_79965_79991[(2)] = null);

(statearr_79965_79991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (4))){
var inst_79938 = (state_79961[(7)]);
var inst_79941 = cljs.core.first.call(null,inst_79938);
var state_79961__$1 = state_79961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79961__$1,(7),ch,inst_79941);
} else {
if((state_val_79962 === (13))){
var inst_79955 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
var statearr_79966_79992 = state_79961__$1;
(statearr_79966_79992[(2)] = inst_79955);

(statearr_79966_79992[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (6))){
var inst_79946 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
if(cljs.core.truth_(inst_79946)){
var statearr_79967_79993 = state_79961__$1;
(statearr_79967_79993[(1)] = (8));

} else {
var statearr_79968_79994 = state_79961__$1;
(statearr_79968_79994[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (3))){
var inst_79959 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79961__$1,inst_79959);
} else {
if((state_val_79962 === (12))){
var state_79961__$1 = state_79961;
var statearr_79969_79995 = state_79961__$1;
(statearr_79969_79995[(2)] = null);

(statearr_79969_79995[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (2))){
var inst_79938 = (state_79961[(7)]);
var state_79961__$1 = state_79961;
if(cljs.core.truth_(inst_79938)){
var statearr_79970_79996 = state_79961__$1;
(statearr_79970_79996[(1)] = (4));

} else {
var statearr_79971_79997 = state_79961__$1;
(statearr_79971_79997[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (11))){
var inst_79952 = cljs.core.async.close_BANG_.call(null,ch);
var state_79961__$1 = state_79961;
var statearr_79972_79998 = state_79961__$1;
(statearr_79972_79998[(2)] = inst_79952);

(statearr_79972_79998[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (9))){
var state_79961__$1 = state_79961;
if(cljs.core.truth_(close_QMARK_)){
var statearr_79973_79999 = state_79961__$1;
(statearr_79973_79999[(1)] = (11));

} else {
var statearr_79974_80000 = state_79961__$1;
(statearr_79974_80000[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (5))){
var inst_79938 = (state_79961[(7)]);
var state_79961__$1 = state_79961;
var statearr_79975_80001 = state_79961__$1;
(statearr_79975_80001[(2)] = inst_79938);

(statearr_79975_80001[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (10))){
var inst_79957 = (state_79961[(2)]);
var state_79961__$1 = state_79961;
var statearr_79976_80002 = state_79961__$1;
(statearr_79976_80002[(2)] = inst_79957);

(statearr_79976_80002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79962 === (8))){
var inst_79938 = (state_79961[(7)]);
var inst_79948 = cljs.core.next.call(null,inst_79938);
var inst_79938__$1 = inst_79948;
var state_79961__$1 = (function (){var statearr_79977 = state_79961;
(statearr_79977[(7)] = inst_79938__$1);

return statearr_79977;
})();
var statearr_79978_80003 = state_79961__$1;
(statearr_79978_80003[(2)] = null);

(statearr_79978_80003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_79982 = [null,null,null,null,null,null,null,null];
(statearr_79982[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_79982[(1)] = (1));

return statearr_79982;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_79961){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_79961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e79983){if((e79983 instanceof Object)){
var ex__70824__auto__ = e79983;
var statearr_79984_80004 = state_79961;
(statearr_79984_80004[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80005 = state_79961;
state_79961 = G__80005;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_79961){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_79961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_79985 = f__70935__auto__.call(null);
(statearr_79985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_79985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__66905__auto__ = (((_ == null))?null:_);
var m__66906__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,_);
} else {
var m__66906__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__66906__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m);
} else {
var m__66906__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async80231 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async80231 = (function (ch,cs,meta80232){
this.ch = ch;
this.cs = cs;
this.meta80232 = meta80232;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_80233,meta80232__$1){
var self__ = this;
var _80233__$1 = this;
return (new cljs.core.async.t_cljs$core$async80231(self__.ch,self__.cs,meta80232__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_80233){
var self__ = this;
var _80233__$1 = this;
return self__.meta80232;
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta80232","meta80232",-646813278,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async80231.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async80231.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async80231";

cljs.core.async.t_cljs$core$async80231.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async80231");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async80231 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async80231(ch__$1,cs__$1,meta80232){
return (new cljs.core.async.t_cljs$core$async80231(ch__$1,cs__$1,meta80232));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async80231(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__70934__auto___80456 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___80456,cs,m,dchan,dctr,done){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___80456,cs,m,dchan,dctr,done){
return (function (state_80368){
var state_val_80369 = (state_80368[(1)]);
if((state_val_80369 === (7))){
var inst_80364 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80370_80457 = state_80368__$1;
(statearr_80370_80457[(2)] = inst_80364);

(statearr_80370_80457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (20))){
var inst_80267 = (state_80368[(7)]);
var inst_80279 = cljs.core.first.call(null,inst_80267);
var inst_80280 = cljs.core.nth.call(null,inst_80279,(0),null);
var inst_80281 = cljs.core.nth.call(null,inst_80279,(1),null);
var state_80368__$1 = (function (){var statearr_80371 = state_80368;
(statearr_80371[(8)] = inst_80280);

return statearr_80371;
})();
if(cljs.core.truth_(inst_80281)){
var statearr_80372_80458 = state_80368__$1;
(statearr_80372_80458[(1)] = (22));

} else {
var statearr_80373_80459 = state_80368__$1;
(statearr_80373_80459[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (27))){
var inst_80309 = (state_80368[(9)]);
var inst_80316 = (state_80368[(10)]);
var inst_80236 = (state_80368[(11)]);
var inst_80311 = (state_80368[(12)]);
var inst_80316__$1 = cljs.core._nth.call(null,inst_80309,inst_80311);
var inst_80317 = cljs.core.async.put_BANG_.call(null,inst_80316__$1,inst_80236,done);
var state_80368__$1 = (function (){var statearr_80374 = state_80368;
(statearr_80374[(10)] = inst_80316__$1);

return statearr_80374;
})();
if(cljs.core.truth_(inst_80317)){
var statearr_80375_80460 = state_80368__$1;
(statearr_80375_80460[(1)] = (30));

} else {
var statearr_80376_80461 = state_80368__$1;
(statearr_80376_80461[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (1))){
var state_80368__$1 = state_80368;
var statearr_80377_80462 = state_80368__$1;
(statearr_80377_80462[(2)] = null);

(statearr_80377_80462[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (24))){
var inst_80267 = (state_80368[(7)]);
var inst_80286 = (state_80368[(2)]);
var inst_80287 = cljs.core.next.call(null,inst_80267);
var inst_80245 = inst_80287;
var inst_80246 = null;
var inst_80247 = (0);
var inst_80248 = (0);
var state_80368__$1 = (function (){var statearr_80378 = state_80368;
(statearr_80378[(13)] = inst_80246);

(statearr_80378[(14)] = inst_80286);

(statearr_80378[(15)] = inst_80247);

(statearr_80378[(16)] = inst_80245);

(statearr_80378[(17)] = inst_80248);

return statearr_80378;
})();
var statearr_80379_80463 = state_80368__$1;
(statearr_80379_80463[(2)] = null);

(statearr_80379_80463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (39))){
var state_80368__$1 = state_80368;
var statearr_80383_80464 = state_80368__$1;
(statearr_80383_80464[(2)] = null);

(statearr_80383_80464[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (4))){
var inst_80236 = (state_80368[(11)]);
var inst_80236__$1 = (state_80368[(2)]);
var inst_80237 = (inst_80236__$1 == null);
var state_80368__$1 = (function (){var statearr_80384 = state_80368;
(statearr_80384[(11)] = inst_80236__$1);

return statearr_80384;
})();
if(cljs.core.truth_(inst_80237)){
var statearr_80385_80465 = state_80368__$1;
(statearr_80385_80465[(1)] = (5));

} else {
var statearr_80386_80466 = state_80368__$1;
(statearr_80386_80466[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (15))){
var inst_80246 = (state_80368[(13)]);
var inst_80247 = (state_80368[(15)]);
var inst_80245 = (state_80368[(16)]);
var inst_80248 = (state_80368[(17)]);
var inst_80263 = (state_80368[(2)]);
var inst_80264 = (inst_80248 + (1));
var tmp80380 = inst_80246;
var tmp80381 = inst_80247;
var tmp80382 = inst_80245;
var inst_80245__$1 = tmp80382;
var inst_80246__$1 = tmp80380;
var inst_80247__$1 = tmp80381;
var inst_80248__$1 = inst_80264;
var state_80368__$1 = (function (){var statearr_80387 = state_80368;
(statearr_80387[(13)] = inst_80246__$1);

(statearr_80387[(15)] = inst_80247__$1);

(statearr_80387[(18)] = inst_80263);

(statearr_80387[(16)] = inst_80245__$1);

(statearr_80387[(17)] = inst_80248__$1);

return statearr_80387;
})();
var statearr_80388_80467 = state_80368__$1;
(statearr_80388_80467[(2)] = null);

(statearr_80388_80467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (21))){
var inst_80290 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80392_80468 = state_80368__$1;
(statearr_80392_80468[(2)] = inst_80290);

(statearr_80392_80468[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (31))){
var inst_80316 = (state_80368[(10)]);
var inst_80320 = done.call(null,null);
var inst_80321 = cljs.core.async.untap_STAR_.call(null,m,inst_80316);
var state_80368__$1 = (function (){var statearr_80393 = state_80368;
(statearr_80393[(19)] = inst_80320);

return statearr_80393;
})();
var statearr_80394_80469 = state_80368__$1;
(statearr_80394_80469[(2)] = inst_80321);

(statearr_80394_80469[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (32))){
var inst_80309 = (state_80368[(9)]);
var inst_80310 = (state_80368[(20)]);
var inst_80311 = (state_80368[(12)]);
var inst_80308 = (state_80368[(21)]);
var inst_80323 = (state_80368[(2)]);
var inst_80324 = (inst_80311 + (1));
var tmp80389 = inst_80309;
var tmp80390 = inst_80310;
var tmp80391 = inst_80308;
var inst_80308__$1 = tmp80391;
var inst_80309__$1 = tmp80389;
var inst_80310__$1 = tmp80390;
var inst_80311__$1 = inst_80324;
var state_80368__$1 = (function (){var statearr_80395 = state_80368;
(statearr_80395[(9)] = inst_80309__$1);

(statearr_80395[(20)] = inst_80310__$1);

(statearr_80395[(22)] = inst_80323);

(statearr_80395[(12)] = inst_80311__$1);

(statearr_80395[(21)] = inst_80308__$1);

return statearr_80395;
})();
var statearr_80396_80470 = state_80368__$1;
(statearr_80396_80470[(2)] = null);

(statearr_80396_80470[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (40))){
var inst_80336 = (state_80368[(23)]);
var inst_80340 = done.call(null,null);
var inst_80341 = cljs.core.async.untap_STAR_.call(null,m,inst_80336);
var state_80368__$1 = (function (){var statearr_80397 = state_80368;
(statearr_80397[(24)] = inst_80340);

return statearr_80397;
})();
var statearr_80398_80471 = state_80368__$1;
(statearr_80398_80471[(2)] = inst_80341);

(statearr_80398_80471[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (33))){
var inst_80327 = (state_80368[(25)]);
var inst_80329 = cljs.core.chunked_seq_QMARK_.call(null,inst_80327);
var state_80368__$1 = state_80368;
if(inst_80329){
var statearr_80399_80472 = state_80368__$1;
(statearr_80399_80472[(1)] = (36));

} else {
var statearr_80400_80473 = state_80368__$1;
(statearr_80400_80473[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (13))){
var inst_80257 = (state_80368[(26)]);
var inst_80260 = cljs.core.async.close_BANG_.call(null,inst_80257);
var state_80368__$1 = state_80368;
var statearr_80401_80474 = state_80368__$1;
(statearr_80401_80474[(2)] = inst_80260);

(statearr_80401_80474[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (22))){
var inst_80280 = (state_80368[(8)]);
var inst_80283 = cljs.core.async.close_BANG_.call(null,inst_80280);
var state_80368__$1 = state_80368;
var statearr_80402_80475 = state_80368__$1;
(statearr_80402_80475[(2)] = inst_80283);

(statearr_80402_80475[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (36))){
var inst_80327 = (state_80368[(25)]);
var inst_80331 = cljs.core.chunk_first.call(null,inst_80327);
var inst_80332 = cljs.core.chunk_rest.call(null,inst_80327);
var inst_80333 = cljs.core.count.call(null,inst_80331);
var inst_80308 = inst_80332;
var inst_80309 = inst_80331;
var inst_80310 = inst_80333;
var inst_80311 = (0);
var state_80368__$1 = (function (){var statearr_80403 = state_80368;
(statearr_80403[(9)] = inst_80309);

(statearr_80403[(20)] = inst_80310);

(statearr_80403[(12)] = inst_80311);

(statearr_80403[(21)] = inst_80308);

return statearr_80403;
})();
var statearr_80404_80476 = state_80368__$1;
(statearr_80404_80476[(2)] = null);

(statearr_80404_80476[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (41))){
var inst_80327 = (state_80368[(25)]);
var inst_80343 = (state_80368[(2)]);
var inst_80344 = cljs.core.next.call(null,inst_80327);
var inst_80308 = inst_80344;
var inst_80309 = null;
var inst_80310 = (0);
var inst_80311 = (0);
var state_80368__$1 = (function (){var statearr_80405 = state_80368;
(statearr_80405[(9)] = inst_80309);

(statearr_80405[(20)] = inst_80310);

(statearr_80405[(27)] = inst_80343);

(statearr_80405[(12)] = inst_80311);

(statearr_80405[(21)] = inst_80308);

return statearr_80405;
})();
var statearr_80406_80477 = state_80368__$1;
(statearr_80406_80477[(2)] = null);

(statearr_80406_80477[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (43))){
var state_80368__$1 = state_80368;
var statearr_80407_80478 = state_80368__$1;
(statearr_80407_80478[(2)] = null);

(statearr_80407_80478[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (29))){
var inst_80352 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80408_80479 = state_80368__$1;
(statearr_80408_80479[(2)] = inst_80352);

(statearr_80408_80479[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (44))){
var inst_80361 = (state_80368[(2)]);
var state_80368__$1 = (function (){var statearr_80409 = state_80368;
(statearr_80409[(28)] = inst_80361);

return statearr_80409;
})();
var statearr_80410_80480 = state_80368__$1;
(statearr_80410_80480[(2)] = null);

(statearr_80410_80480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (6))){
var inst_80300 = (state_80368[(29)]);
var inst_80299 = cljs.core.deref.call(null,cs);
var inst_80300__$1 = cljs.core.keys.call(null,inst_80299);
var inst_80301 = cljs.core.count.call(null,inst_80300__$1);
var inst_80302 = cljs.core.reset_BANG_.call(null,dctr,inst_80301);
var inst_80307 = cljs.core.seq.call(null,inst_80300__$1);
var inst_80308 = inst_80307;
var inst_80309 = null;
var inst_80310 = (0);
var inst_80311 = (0);
var state_80368__$1 = (function (){var statearr_80411 = state_80368;
(statearr_80411[(9)] = inst_80309);

(statearr_80411[(20)] = inst_80310);

(statearr_80411[(29)] = inst_80300__$1);

(statearr_80411[(12)] = inst_80311);

(statearr_80411[(21)] = inst_80308);

(statearr_80411[(30)] = inst_80302);

return statearr_80411;
})();
var statearr_80412_80481 = state_80368__$1;
(statearr_80412_80481[(2)] = null);

(statearr_80412_80481[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (28))){
var inst_80308 = (state_80368[(21)]);
var inst_80327 = (state_80368[(25)]);
var inst_80327__$1 = cljs.core.seq.call(null,inst_80308);
var state_80368__$1 = (function (){var statearr_80413 = state_80368;
(statearr_80413[(25)] = inst_80327__$1);

return statearr_80413;
})();
if(inst_80327__$1){
var statearr_80414_80482 = state_80368__$1;
(statearr_80414_80482[(1)] = (33));

} else {
var statearr_80415_80483 = state_80368__$1;
(statearr_80415_80483[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (25))){
var inst_80310 = (state_80368[(20)]);
var inst_80311 = (state_80368[(12)]);
var inst_80313 = (inst_80311 < inst_80310);
var inst_80314 = inst_80313;
var state_80368__$1 = state_80368;
if(cljs.core.truth_(inst_80314)){
var statearr_80416_80484 = state_80368__$1;
(statearr_80416_80484[(1)] = (27));

} else {
var statearr_80417_80485 = state_80368__$1;
(statearr_80417_80485[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (34))){
var state_80368__$1 = state_80368;
var statearr_80418_80486 = state_80368__$1;
(statearr_80418_80486[(2)] = null);

(statearr_80418_80486[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (17))){
var state_80368__$1 = state_80368;
var statearr_80419_80487 = state_80368__$1;
(statearr_80419_80487[(2)] = null);

(statearr_80419_80487[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (3))){
var inst_80366 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80368__$1,inst_80366);
} else {
if((state_val_80369 === (12))){
var inst_80295 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80420_80488 = state_80368__$1;
(statearr_80420_80488[(2)] = inst_80295);

(statearr_80420_80488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (2))){
var state_80368__$1 = state_80368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80368__$1,(4),ch);
} else {
if((state_val_80369 === (23))){
var state_80368__$1 = state_80368;
var statearr_80421_80489 = state_80368__$1;
(statearr_80421_80489[(2)] = null);

(statearr_80421_80489[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (35))){
var inst_80350 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80422_80490 = state_80368__$1;
(statearr_80422_80490[(2)] = inst_80350);

(statearr_80422_80490[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (19))){
var inst_80267 = (state_80368[(7)]);
var inst_80271 = cljs.core.chunk_first.call(null,inst_80267);
var inst_80272 = cljs.core.chunk_rest.call(null,inst_80267);
var inst_80273 = cljs.core.count.call(null,inst_80271);
var inst_80245 = inst_80272;
var inst_80246 = inst_80271;
var inst_80247 = inst_80273;
var inst_80248 = (0);
var state_80368__$1 = (function (){var statearr_80423 = state_80368;
(statearr_80423[(13)] = inst_80246);

(statearr_80423[(15)] = inst_80247);

(statearr_80423[(16)] = inst_80245);

(statearr_80423[(17)] = inst_80248);

return statearr_80423;
})();
var statearr_80424_80491 = state_80368__$1;
(statearr_80424_80491[(2)] = null);

(statearr_80424_80491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (11))){
var inst_80245 = (state_80368[(16)]);
var inst_80267 = (state_80368[(7)]);
var inst_80267__$1 = cljs.core.seq.call(null,inst_80245);
var state_80368__$1 = (function (){var statearr_80425 = state_80368;
(statearr_80425[(7)] = inst_80267__$1);

return statearr_80425;
})();
if(inst_80267__$1){
var statearr_80426_80492 = state_80368__$1;
(statearr_80426_80492[(1)] = (16));

} else {
var statearr_80427_80493 = state_80368__$1;
(statearr_80427_80493[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (9))){
var inst_80297 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80428_80494 = state_80368__$1;
(statearr_80428_80494[(2)] = inst_80297);

(statearr_80428_80494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (5))){
var inst_80243 = cljs.core.deref.call(null,cs);
var inst_80244 = cljs.core.seq.call(null,inst_80243);
var inst_80245 = inst_80244;
var inst_80246 = null;
var inst_80247 = (0);
var inst_80248 = (0);
var state_80368__$1 = (function (){var statearr_80429 = state_80368;
(statearr_80429[(13)] = inst_80246);

(statearr_80429[(15)] = inst_80247);

(statearr_80429[(16)] = inst_80245);

(statearr_80429[(17)] = inst_80248);

return statearr_80429;
})();
var statearr_80430_80495 = state_80368__$1;
(statearr_80430_80495[(2)] = null);

(statearr_80430_80495[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (14))){
var state_80368__$1 = state_80368;
var statearr_80431_80496 = state_80368__$1;
(statearr_80431_80496[(2)] = null);

(statearr_80431_80496[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (45))){
var inst_80358 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80432_80497 = state_80368__$1;
(statearr_80432_80497[(2)] = inst_80358);

(statearr_80432_80497[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (26))){
var inst_80300 = (state_80368[(29)]);
var inst_80354 = (state_80368[(2)]);
var inst_80355 = cljs.core.seq.call(null,inst_80300);
var state_80368__$1 = (function (){var statearr_80433 = state_80368;
(statearr_80433[(31)] = inst_80354);

return statearr_80433;
})();
if(inst_80355){
var statearr_80434_80498 = state_80368__$1;
(statearr_80434_80498[(1)] = (42));

} else {
var statearr_80435_80499 = state_80368__$1;
(statearr_80435_80499[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (16))){
var inst_80267 = (state_80368[(7)]);
var inst_80269 = cljs.core.chunked_seq_QMARK_.call(null,inst_80267);
var state_80368__$1 = state_80368;
if(inst_80269){
var statearr_80436_80500 = state_80368__$1;
(statearr_80436_80500[(1)] = (19));

} else {
var statearr_80437_80501 = state_80368__$1;
(statearr_80437_80501[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (38))){
var inst_80347 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80438_80502 = state_80368__$1;
(statearr_80438_80502[(2)] = inst_80347);

(statearr_80438_80502[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (30))){
var state_80368__$1 = state_80368;
var statearr_80439_80503 = state_80368__$1;
(statearr_80439_80503[(2)] = null);

(statearr_80439_80503[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (10))){
var inst_80246 = (state_80368[(13)]);
var inst_80248 = (state_80368[(17)]);
var inst_80256 = cljs.core._nth.call(null,inst_80246,inst_80248);
var inst_80257 = cljs.core.nth.call(null,inst_80256,(0),null);
var inst_80258 = cljs.core.nth.call(null,inst_80256,(1),null);
var state_80368__$1 = (function (){var statearr_80440 = state_80368;
(statearr_80440[(26)] = inst_80257);

return statearr_80440;
})();
if(cljs.core.truth_(inst_80258)){
var statearr_80441_80504 = state_80368__$1;
(statearr_80441_80504[(1)] = (13));

} else {
var statearr_80442_80505 = state_80368__$1;
(statearr_80442_80505[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (18))){
var inst_80293 = (state_80368[(2)]);
var state_80368__$1 = state_80368;
var statearr_80443_80506 = state_80368__$1;
(statearr_80443_80506[(2)] = inst_80293);

(statearr_80443_80506[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (42))){
var state_80368__$1 = state_80368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_80368__$1,(45),dchan);
} else {
if((state_val_80369 === (37))){
var inst_80236 = (state_80368[(11)]);
var inst_80336 = (state_80368[(23)]);
var inst_80327 = (state_80368[(25)]);
var inst_80336__$1 = cljs.core.first.call(null,inst_80327);
var inst_80337 = cljs.core.async.put_BANG_.call(null,inst_80336__$1,inst_80236,done);
var state_80368__$1 = (function (){var statearr_80444 = state_80368;
(statearr_80444[(23)] = inst_80336__$1);

return statearr_80444;
})();
if(cljs.core.truth_(inst_80337)){
var statearr_80445_80507 = state_80368__$1;
(statearr_80445_80507[(1)] = (39));

} else {
var statearr_80446_80508 = state_80368__$1;
(statearr_80446_80508[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80369 === (8))){
var inst_80247 = (state_80368[(15)]);
var inst_80248 = (state_80368[(17)]);
var inst_80250 = (inst_80248 < inst_80247);
var inst_80251 = inst_80250;
var state_80368__$1 = state_80368;
if(cljs.core.truth_(inst_80251)){
var statearr_80447_80509 = state_80368__$1;
(statearr_80447_80509[(1)] = (10));

} else {
var statearr_80448_80510 = state_80368__$1;
(statearr_80448_80510[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___80456,cs,m,dchan,dctr,done))
;
return ((function (switch__70820__auto__,c__70934__auto___80456,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__70821__auto__ = null;
var cljs$core$async$mult_$_state_machine__70821__auto____0 = (function (){
var statearr_80452 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80452[(0)] = cljs$core$async$mult_$_state_machine__70821__auto__);

(statearr_80452[(1)] = (1));

return statearr_80452;
});
var cljs$core$async$mult_$_state_machine__70821__auto____1 = (function (state_80368){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_80368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e80453){if((e80453 instanceof Object)){
var ex__70824__auto__ = e80453;
var statearr_80454_80511 = state_80368;
(statearr_80454_80511[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80368);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80512 = state_80368;
state_80368 = G__80512;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__70821__auto__ = function(state_80368){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__70821__auto____1.call(this,state_80368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__70821__auto____0;
cljs$core$async$mult_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__70821__auto____1;
return cljs$core$async$mult_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___80456,cs,m,dchan,dctr,done))
})();
var state__70936__auto__ = (function (){var statearr_80455 = f__70935__auto__.call(null);
(statearr_80455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___80456);

return statearr_80455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___80456,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args80513 = [];
var len__67408__auto___80516 = arguments.length;
var i__67409__auto___80517 = (0);
while(true){
if((i__67409__auto___80517 < len__67408__auto___80516)){
args80513.push((arguments[i__67409__auto___80517]));

var G__80518 = (i__67409__auto___80517 + (1));
i__67409__auto___80517 = G__80518;
continue;
} else {
}
break;
}

var G__80515 = args80513.length;
switch (G__80515) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80513.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m);
} else {
var m__66906__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,state_map);
} else {
var m__66906__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,mode);
} else {
var m__66906__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___80530 = arguments.length;
var i__67409__auto___80531 = (0);
while(true){
if((i__67409__auto___80531 < len__67408__auto___80530)){
args__67415__auto__.push((arguments[i__67409__auto___80531]));

var G__80532 = (i__67409__auto___80531 + (1));
i__67409__auto___80531 = G__80532;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((3) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__67416__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__80524){
var map__80525 = p__80524;
var map__80525__$1 = ((((!((map__80525 == null)))?((((map__80525.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80525.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__80525):map__80525);
var opts = map__80525__$1;
var statearr_80527_80533 = state;
(statearr_80527_80533[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__80525,map__80525__$1,opts){
return (function (val){
var statearr_80528_80534 = state;
(statearr_80528_80534[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__80525,map__80525__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_80529_80535 = state;
(statearr_80529_80535[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq80520){
var G__80521 = cljs.core.first.call(null,seq80520);
var seq80520__$1 = cljs.core.next.call(null,seq80520);
var G__80522 = cljs.core.first.call(null,seq80520__$1);
var seq80520__$2 = cljs.core.next.call(null,seq80520__$1);
var G__80523 = cljs.core.first.call(null,seq80520__$2);
var seq80520__$3 = cljs.core.next.call(null,seq80520__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__80521,G__80522,G__80523,seq80520__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async80703 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async80703 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta80704){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta80704 = meta80704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_80705,meta80704__$1){
var self__ = this;
var _80705__$1 = this;
return (new cljs.core.async.t_cljs$core$async80703(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta80704__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_80705){
var self__ = this;
var _80705__$1 = this;
return self__.meta80704;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta80704","meta80704",-89717306,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async80703.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async80703.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async80703";

cljs.core.async.t_cljs$core$async80703.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async80703");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async80703 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async80703(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta80704){
return (new cljs.core.async.t_cljs$core$async80703(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta80704));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async80703(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70934__auto___80870 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___80870,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___80870,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_80807){
var state_val_80808 = (state_80807[(1)]);
if((state_val_80808 === (7))){
var inst_80722 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
var statearr_80809_80871 = state_80807__$1;
(statearr_80809_80871[(2)] = inst_80722);

(statearr_80809_80871[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (20))){
var inst_80734 = (state_80807[(7)]);
var state_80807__$1 = state_80807;
var statearr_80810_80872 = state_80807__$1;
(statearr_80810_80872[(2)] = inst_80734);

(statearr_80810_80872[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (27))){
var state_80807__$1 = state_80807;
var statearr_80811_80873 = state_80807__$1;
(statearr_80811_80873[(2)] = null);

(statearr_80811_80873[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (1))){
var inst_80709 = (state_80807[(8)]);
var inst_80709__$1 = calc_state.call(null);
var inst_80711 = (inst_80709__$1 == null);
var inst_80712 = cljs.core.not.call(null,inst_80711);
var state_80807__$1 = (function (){var statearr_80812 = state_80807;
(statearr_80812[(8)] = inst_80709__$1);

return statearr_80812;
})();
if(inst_80712){
var statearr_80813_80874 = state_80807__$1;
(statearr_80813_80874[(1)] = (2));

} else {
var statearr_80814_80875 = state_80807__$1;
(statearr_80814_80875[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (24))){
var inst_80767 = (state_80807[(9)]);
var inst_80781 = (state_80807[(10)]);
var inst_80758 = (state_80807[(11)]);
var inst_80781__$1 = inst_80758.call(null,inst_80767);
var state_80807__$1 = (function (){var statearr_80815 = state_80807;
(statearr_80815[(10)] = inst_80781__$1);

return statearr_80815;
})();
if(cljs.core.truth_(inst_80781__$1)){
var statearr_80816_80876 = state_80807__$1;
(statearr_80816_80876[(1)] = (29));

} else {
var statearr_80817_80877 = state_80807__$1;
(statearr_80817_80877[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (4))){
var inst_80725 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80725)){
var statearr_80818_80878 = state_80807__$1;
(statearr_80818_80878[(1)] = (8));

} else {
var statearr_80819_80879 = state_80807__$1;
(statearr_80819_80879[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (15))){
var inst_80752 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80752)){
var statearr_80820_80880 = state_80807__$1;
(statearr_80820_80880[(1)] = (19));

} else {
var statearr_80821_80881 = state_80807__$1;
(statearr_80821_80881[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (21))){
var inst_80757 = (state_80807[(12)]);
var inst_80757__$1 = (state_80807[(2)]);
var inst_80758 = cljs.core.get.call(null,inst_80757__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_80759 = cljs.core.get.call(null,inst_80757__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_80760 = cljs.core.get.call(null,inst_80757__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_80807__$1 = (function (){var statearr_80822 = state_80807;
(statearr_80822[(13)] = inst_80759);

(statearr_80822[(12)] = inst_80757__$1);

(statearr_80822[(11)] = inst_80758);

return statearr_80822;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_80807__$1,(22),inst_80760);
} else {
if((state_val_80808 === (31))){
var inst_80789 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80789)){
var statearr_80823_80882 = state_80807__$1;
(statearr_80823_80882[(1)] = (32));

} else {
var statearr_80824_80883 = state_80807__$1;
(statearr_80824_80883[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (32))){
var inst_80766 = (state_80807[(14)]);
var state_80807__$1 = state_80807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_80807__$1,(35),out,inst_80766);
} else {
if((state_val_80808 === (33))){
var inst_80757 = (state_80807[(12)]);
var inst_80734 = inst_80757;
var state_80807__$1 = (function (){var statearr_80825 = state_80807;
(statearr_80825[(7)] = inst_80734);

return statearr_80825;
})();
var statearr_80826_80884 = state_80807__$1;
(statearr_80826_80884[(2)] = null);

(statearr_80826_80884[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (13))){
var inst_80734 = (state_80807[(7)]);
var inst_80741 = inst_80734.cljs$lang$protocol_mask$partition0$;
var inst_80742 = (inst_80741 & (64));
var inst_80743 = inst_80734.cljs$core$ISeq$;
var inst_80744 = (cljs.core.PROTOCOL_SENTINEL === inst_80743);
var inst_80745 = (inst_80742) || (inst_80744);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80745)){
var statearr_80827_80885 = state_80807__$1;
(statearr_80827_80885[(1)] = (16));

} else {
var statearr_80828_80886 = state_80807__$1;
(statearr_80828_80886[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (22))){
var inst_80767 = (state_80807[(9)]);
var inst_80766 = (state_80807[(14)]);
var inst_80765 = (state_80807[(2)]);
var inst_80766__$1 = cljs.core.nth.call(null,inst_80765,(0),null);
var inst_80767__$1 = cljs.core.nth.call(null,inst_80765,(1),null);
var inst_80768 = (inst_80766__$1 == null);
var inst_80769 = cljs.core._EQ_.call(null,inst_80767__$1,change);
var inst_80770 = (inst_80768) || (inst_80769);
var state_80807__$1 = (function (){var statearr_80829 = state_80807;
(statearr_80829[(9)] = inst_80767__$1);

(statearr_80829[(14)] = inst_80766__$1);

return statearr_80829;
})();
if(cljs.core.truth_(inst_80770)){
var statearr_80830_80887 = state_80807__$1;
(statearr_80830_80887[(1)] = (23));

} else {
var statearr_80831_80888 = state_80807__$1;
(statearr_80831_80888[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (36))){
var inst_80757 = (state_80807[(12)]);
var inst_80734 = inst_80757;
var state_80807__$1 = (function (){var statearr_80832 = state_80807;
(statearr_80832[(7)] = inst_80734);

return statearr_80832;
})();
var statearr_80833_80889 = state_80807__$1;
(statearr_80833_80889[(2)] = null);

(statearr_80833_80889[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (29))){
var inst_80781 = (state_80807[(10)]);
var state_80807__$1 = state_80807;
var statearr_80834_80890 = state_80807__$1;
(statearr_80834_80890[(2)] = inst_80781);

(statearr_80834_80890[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (6))){
var state_80807__$1 = state_80807;
var statearr_80835_80891 = state_80807__$1;
(statearr_80835_80891[(2)] = false);

(statearr_80835_80891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (28))){
var inst_80777 = (state_80807[(2)]);
var inst_80778 = calc_state.call(null);
var inst_80734 = inst_80778;
var state_80807__$1 = (function (){var statearr_80836 = state_80807;
(statearr_80836[(7)] = inst_80734);

(statearr_80836[(15)] = inst_80777);

return statearr_80836;
})();
var statearr_80837_80892 = state_80807__$1;
(statearr_80837_80892[(2)] = null);

(statearr_80837_80892[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (25))){
var inst_80803 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
var statearr_80838_80893 = state_80807__$1;
(statearr_80838_80893[(2)] = inst_80803);

(statearr_80838_80893[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (34))){
var inst_80801 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
var statearr_80839_80894 = state_80807__$1;
(statearr_80839_80894[(2)] = inst_80801);

(statearr_80839_80894[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (17))){
var state_80807__$1 = state_80807;
var statearr_80840_80895 = state_80807__$1;
(statearr_80840_80895[(2)] = false);

(statearr_80840_80895[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (3))){
var state_80807__$1 = state_80807;
var statearr_80841_80896 = state_80807__$1;
(statearr_80841_80896[(2)] = false);

(statearr_80841_80896[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (12))){
var inst_80805 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_80807__$1,inst_80805);
} else {
if((state_val_80808 === (2))){
var inst_80709 = (state_80807[(8)]);
var inst_80714 = inst_80709.cljs$lang$protocol_mask$partition0$;
var inst_80715 = (inst_80714 & (64));
var inst_80716 = inst_80709.cljs$core$ISeq$;
var inst_80717 = (cljs.core.PROTOCOL_SENTINEL === inst_80716);
var inst_80718 = (inst_80715) || (inst_80717);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80718)){
var statearr_80842_80897 = state_80807__$1;
(statearr_80842_80897[(1)] = (5));

} else {
var statearr_80843_80898 = state_80807__$1;
(statearr_80843_80898[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (23))){
var inst_80766 = (state_80807[(14)]);
var inst_80772 = (inst_80766 == null);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80772)){
var statearr_80844_80899 = state_80807__$1;
(statearr_80844_80899[(1)] = (26));

} else {
var statearr_80845_80900 = state_80807__$1;
(statearr_80845_80900[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (35))){
var inst_80792 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
if(cljs.core.truth_(inst_80792)){
var statearr_80846_80901 = state_80807__$1;
(statearr_80846_80901[(1)] = (36));

} else {
var statearr_80847_80902 = state_80807__$1;
(statearr_80847_80902[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (19))){
var inst_80734 = (state_80807[(7)]);
var inst_80754 = cljs.core.apply.call(null,cljs.core.hash_map,inst_80734);
var state_80807__$1 = state_80807;
var statearr_80848_80903 = state_80807__$1;
(statearr_80848_80903[(2)] = inst_80754);

(statearr_80848_80903[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (11))){
var inst_80734 = (state_80807[(7)]);
var inst_80738 = (inst_80734 == null);
var inst_80739 = cljs.core.not.call(null,inst_80738);
var state_80807__$1 = state_80807;
if(inst_80739){
var statearr_80849_80904 = state_80807__$1;
(statearr_80849_80904[(1)] = (13));

} else {
var statearr_80850_80905 = state_80807__$1;
(statearr_80850_80905[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (9))){
var inst_80709 = (state_80807[(8)]);
var state_80807__$1 = state_80807;
var statearr_80851_80906 = state_80807__$1;
(statearr_80851_80906[(2)] = inst_80709);

(statearr_80851_80906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (5))){
var state_80807__$1 = state_80807;
var statearr_80852_80907 = state_80807__$1;
(statearr_80852_80907[(2)] = true);

(statearr_80852_80907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (14))){
var state_80807__$1 = state_80807;
var statearr_80853_80908 = state_80807__$1;
(statearr_80853_80908[(2)] = false);

(statearr_80853_80908[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (26))){
var inst_80767 = (state_80807[(9)]);
var inst_80774 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_80767);
var state_80807__$1 = state_80807;
var statearr_80854_80909 = state_80807__$1;
(statearr_80854_80909[(2)] = inst_80774);

(statearr_80854_80909[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (16))){
var state_80807__$1 = state_80807;
var statearr_80855_80910 = state_80807__$1;
(statearr_80855_80910[(2)] = true);

(statearr_80855_80910[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (38))){
var inst_80797 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
var statearr_80856_80911 = state_80807__$1;
(statearr_80856_80911[(2)] = inst_80797);

(statearr_80856_80911[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (30))){
var inst_80759 = (state_80807[(13)]);
var inst_80767 = (state_80807[(9)]);
var inst_80758 = (state_80807[(11)]);
var inst_80784 = cljs.core.empty_QMARK_.call(null,inst_80758);
var inst_80785 = inst_80759.call(null,inst_80767);
var inst_80786 = cljs.core.not.call(null,inst_80785);
var inst_80787 = (inst_80784) && (inst_80786);
var state_80807__$1 = state_80807;
var statearr_80857_80912 = state_80807__$1;
(statearr_80857_80912[(2)] = inst_80787);

(statearr_80857_80912[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (10))){
var inst_80709 = (state_80807[(8)]);
var inst_80730 = (state_80807[(2)]);
var inst_80731 = cljs.core.get.call(null,inst_80730,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_80732 = cljs.core.get.call(null,inst_80730,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_80733 = cljs.core.get.call(null,inst_80730,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_80734 = inst_80709;
var state_80807__$1 = (function (){var statearr_80858 = state_80807;
(statearr_80858[(16)] = inst_80731);

(statearr_80858[(17)] = inst_80732);

(statearr_80858[(18)] = inst_80733);

(statearr_80858[(7)] = inst_80734);

return statearr_80858;
})();
var statearr_80859_80913 = state_80807__$1;
(statearr_80859_80913[(2)] = null);

(statearr_80859_80913[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (18))){
var inst_80749 = (state_80807[(2)]);
var state_80807__$1 = state_80807;
var statearr_80860_80914 = state_80807__$1;
(statearr_80860_80914[(2)] = inst_80749);

(statearr_80860_80914[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (37))){
var state_80807__$1 = state_80807;
var statearr_80861_80915 = state_80807__$1;
(statearr_80861_80915[(2)] = null);

(statearr_80861_80915[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_80808 === (8))){
var inst_80709 = (state_80807[(8)]);
var inst_80727 = cljs.core.apply.call(null,cljs.core.hash_map,inst_80709);
var state_80807__$1 = state_80807;
var statearr_80862_80916 = state_80807__$1;
(statearr_80862_80916[(2)] = inst_80727);

(statearr_80862_80916[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___80870,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__70820__auto__,c__70934__auto___80870,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__70821__auto__ = null;
var cljs$core$async$mix_$_state_machine__70821__auto____0 = (function (){
var statearr_80866 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_80866[(0)] = cljs$core$async$mix_$_state_machine__70821__auto__);

(statearr_80866[(1)] = (1));

return statearr_80866;
});
var cljs$core$async$mix_$_state_machine__70821__auto____1 = (function (state_80807){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_80807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e80867){if((e80867 instanceof Object)){
var ex__70824__auto__ = e80867;
var statearr_80868_80917 = state_80807;
(statearr_80868_80917[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_80807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e80867;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__80918 = state_80807;
state_80807 = G__80918;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__70821__auto__ = function(state_80807){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__70821__auto____1.call(this,state_80807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__70821__auto____0;
cljs$core$async$mix_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__70821__auto____1;
return cljs$core$async$mix_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___80870,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__70936__auto__ = (function (){var statearr_80869 = f__70935__auto__.call(null);
(statearr_80869[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___80870);

return statearr_80869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___80870,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__66906__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p,v,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args80919 = [];
var len__67408__auto___80922 = arguments.length;
var i__67409__auto___80923 = (0);
while(true){
if((i__67409__auto___80923 < len__67408__auto___80922)){
args80919.push((arguments[i__67409__auto___80923]));

var G__80924 = (i__67409__auto___80923 + (1));
i__67409__auto___80923 = G__80924;
continue;
} else {
}
break;
}

var G__80921 = args80919.length;
switch (G__80921) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80919.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p);
} else {
var m__66906__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p,v);
} else {
var m__66906__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args80927 = [];
var len__67408__auto___81052 = arguments.length;
var i__67409__auto___81053 = (0);
while(true){
if((i__67409__auto___81053 < len__67408__auto___81052)){
args80927.push((arguments[i__67409__auto___81053]));

var G__81054 = (i__67409__auto___81053 + (1));
i__67409__auto___81053 = G__81054;
continue;
} else {
}
break;
}

var G__80929 = args80927.length;
switch (G__80929) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args80927.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__66187__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__66187__auto__,mults){
return (function (p1__80926_SHARP_){
if(cljs.core.truth_(p1__80926_SHARP_.call(null,topic))){
return p1__80926_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__80926_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__66187__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async80930 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async80930 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta80931){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta80931 = meta80931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_80932,meta80931__$1){
var self__ = this;
var _80932__$1 = this;
return (new cljs.core.async.t_cljs$core$async80930(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta80931__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_80932){
var self__ = this;
var _80932__$1 = this;
return self__.meta80931;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta80931","meta80931",-1692331711,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async80930.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async80930.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async80930";

cljs.core.async.t_cljs$core$async80930.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async80930");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async80930 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async80930(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta80931){
return (new cljs.core.async.t_cljs$core$async80930(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta80931));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async80930(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70934__auto___81056 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81056,mults,ensure_mult,p){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81056,mults,ensure_mult,p){
return (function (state_81004){
var state_val_81005 = (state_81004[(1)]);
if((state_val_81005 === (7))){
var inst_81000 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
var statearr_81006_81057 = state_81004__$1;
(statearr_81006_81057[(2)] = inst_81000);

(statearr_81006_81057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (20))){
var state_81004__$1 = state_81004;
var statearr_81007_81058 = state_81004__$1;
(statearr_81007_81058[(2)] = null);

(statearr_81007_81058[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (1))){
var state_81004__$1 = state_81004;
var statearr_81008_81059 = state_81004__$1;
(statearr_81008_81059[(2)] = null);

(statearr_81008_81059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (24))){
var inst_80983 = (state_81004[(7)]);
var inst_80992 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_80983);
var state_81004__$1 = state_81004;
var statearr_81009_81060 = state_81004__$1;
(statearr_81009_81060[(2)] = inst_80992);

(statearr_81009_81060[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (4))){
var inst_80935 = (state_81004[(8)]);
var inst_80935__$1 = (state_81004[(2)]);
var inst_80936 = (inst_80935__$1 == null);
var state_81004__$1 = (function (){var statearr_81010 = state_81004;
(statearr_81010[(8)] = inst_80935__$1);

return statearr_81010;
})();
if(cljs.core.truth_(inst_80936)){
var statearr_81011_81061 = state_81004__$1;
(statearr_81011_81061[(1)] = (5));

} else {
var statearr_81012_81062 = state_81004__$1;
(statearr_81012_81062[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (15))){
var inst_80977 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
var statearr_81013_81063 = state_81004__$1;
(statearr_81013_81063[(2)] = inst_80977);

(statearr_81013_81063[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (21))){
var inst_80997 = (state_81004[(2)]);
var state_81004__$1 = (function (){var statearr_81014 = state_81004;
(statearr_81014[(9)] = inst_80997);

return statearr_81014;
})();
var statearr_81015_81064 = state_81004__$1;
(statearr_81015_81064[(2)] = null);

(statearr_81015_81064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (13))){
var inst_80959 = (state_81004[(10)]);
var inst_80961 = cljs.core.chunked_seq_QMARK_.call(null,inst_80959);
var state_81004__$1 = state_81004;
if(inst_80961){
var statearr_81016_81065 = state_81004__$1;
(statearr_81016_81065[(1)] = (16));

} else {
var statearr_81017_81066 = state_81004__$1;
(statearr_81017_81066[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (22))){
var inst_80989 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
if(cljs.core.truth_(inst_80989)){
var statearr_81018_81067 = state_81004__$1;
(statearr_81018_81067[(1)] = (23));

} else {
var statearr_81019_81068 = state_81004__$1;
(statearr_81019_81068[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (6))){
var inst_80983 = (state_81004[(7)]);
var inst_80935 = (state_81004[(8)]);
var inst_80985 = (state_81004[(11)]);
var inst_80983__$1 = topic_fn.call(null,inst_80935);
var inst_80984 = cljs.core.deref.call(null,mults);
var inst_80985__$1 = cljs.core.get.call(null,inst_80984,inst_80983__$1);
var state_81004__$1 = (function (){var statearr_81020 = state_81004;
(statearr_81020[(7)] = inst_80983__$1);

(statearr_81020[(11)] = inst_80985__$1);

return statearr_81020;
})();
if(cljs.core.truth_(inst_80985__$1)){
var statearr_81021_81069 = state_81004__$1;
(statearr_81021_81069[(1)] = (19));

} else {
var statearr_81022_81070 = state_81004__$1;
(statearr_81022_81070[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (25))){
var inst_80994 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
var statearr_81023_81071 = state_81004__$1;
(statearr_81023_81071[(2)] = inst_80994);

(statearr_81023_81071[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (17))){
var inst_80959 = (state_81004[(10)]);
var inst_80968 = cljs.core.first.call(null,inst_80959);
var inst_80969 = cljs.core.async.muxch_STAR_.call(null,inst_80968);
var inst_80970 = cljs.core.async.close_BANG_.call(null,inst_80969);
var inst_80971 = cljs.core.next.call(null,inst_80959);
var inst_80945 = inst_80971;
var inst_80946 = null;
var inst_80947 = (0);
var inst_80948 = (0);
var state_81004__$1 = (function (){var statearr_81024 = state_81004;
(statearr_81024[(12)] = inst_80948);

(statearr_81024[(13)] = inst_80970);

(statearr_81024[(14)] = inst_80945);

(statearr_81024[(15)] = inst_80947);

(statearr_81024[(16)] = inst_80946);

return statearr_81024;
})();
var statearr_81025_81072 = state_81004__$1;
(statearr_81025_81072[(2)] = null);

(statearr_81025_81072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (3))){
var inst_81002 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81004__$1,inst_81002);
} else {
if((state_val_81005 === (12))){
var inst_80979 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
var statearr_81026_81073 = state_81004__$1;
(statearr_81026_81073[(2)] = inst_80979);

(statearr_81026_81073[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (2))){
var state_81004__$1 = state_81004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81004__$1,(4),ch);
} else {
if((state_val_81005 === (23))){
var state_81004__$1 = state_81004;
var statearr_81027_81074 = state_81004__$1;
(statearr_81027_81074[(2)] = null);

(statearr_81027_81074[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (19))){
var inst_80935 = (state_81004[(8)]);
var inst_80985 = (state_81004[(11)]);
var inst_80987 = cljs.core.async.muxch_STAR_.call(null,inst_80985);
var state_81004__$1 = state_81004;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81004__$1,(22),inst_80987,inst_80935);
} else {
if((state_val_81005 === (11))){
var inst_80959 = (state_81004[(10)]);
var inst_80945 = (state_81004[(14)]);
var inst_80959__$1 = cljs.core.seq.call(null,inst_80945);
var state_81004__$1 = (function (){var statearr_81028 = state_81004;
(statearr_81028[(10)] = inst_80959__$1);

return statearr_81028;
})();
if(inst_80959__$1){
var statearr_81029_81075 = state_81004__$1;
(statearr_81029_81075[(1)] = (13));

} else {
var statearr_81030_81076 = state_81004__$1;
(statearr_81030_81076[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (9))){
var inst_80981 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
var statearr_81031_81077 = state_81004__$1;
(statearr_81031_81077[(2)] = inst_80981);

(statearr_81031_81077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (5))){
var inst_80942 = cljs.core.deref.call(null,mults);
var inst_80943 = cljs.core.vals.call(null,inst_80942);
var inst_80944 = cljs.core.seq.call(null,inst_80943);
var inst_80945 = inst_80944;
var inst_80946 = null;
var inst_80947 = (0);
var inst_80948 = (0);
var state_81004__$1 = (function (){var statearr_81032 = state_81004;
(statearr_81032[(12)] = inst_80948);

(statearr_81032[(14)] = inst_80945);

(statearr_81032[(15)] = inst_80947);

(statearr_81032[(16)] = inst_80946);

return statearr_81032;
})();
var statearr_81033_81078 = state_81004__$1;
(statearr_81033_81078[(2)] = null);

(statearr_81033_81078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (14))){
var state_81004__$1 = state_81004;
var statearr_81037_81079 = state_81004__$1;
(statearr_81037_81079[(2)] = null);

(statearr_81037_81079[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (16))){
var inst_80959 = (state_81004[(10)]);
var inst_80963 = cljs.core.chunk_first.call(null,inst_80959);
var inst_80964 = cljs.core.chunk_rest.call(null,inst_80959);
var inst_80965 = cljs.core.count.call(null,inst_80963);
var inst_80945 = inst_80964;
var inst_80946 = inst_80963;
var inst_80947 = inst_80965;
var inst_80948 = (0);
var state_81004__$1 = (function (){var statearr_81038 = state_81004;
(statearr_81038[(12)] = inst_80948);

(statearr_81038[(14)] = inst_80945);

(statearr_81038[(15)] = inst_80947);

(statearr_81038[(16)] = inst_80946);

return statearr_81038;
})();
var statearr_81039_81080 = state_81004__$1;
(statearr_81039_81080[(2)] = null);

(statearr_81039_81080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (10))){
var inst_80948 = (state_81004[(12)]);
var inst_80945 = (state_81004[(14)]);
var inst_80947 = (state_81004[(15)]);
var inst_80946 = (state_81004[(16)]);
var inst_80953 = cljs.core._nth.call(null,inst_80946,inst_80948);
var inst_80954 = cljs.core.async.muxch_STAR_.call(null,inst_80953);
var inst_80955 = cljs.core.async.close_BANG_.call(null,inst_80954);
var inst_80956 = (inst_80948 + (1));
var tmp81034 = inst_80945;
var tmp81035 = inst_80947;
var tmp81036 = inst_80946;
var inst_80945__$1 = tmp81034;
var inst_80946__$1 = tmp81036;
var inst_80947__$1 = tmp81035;
var inst_80948__$1 = inst_80956;
var state_81004__$1 = (function (){var statearr_81040 = state_81004;
(statearr_81040[(12)] = inst_80948__$1);

(statearr_81040[(14)] = inst_80945__$1);

(statearr_81040[(15)] = inst_80947__$1);

(statearr_81040[(17)] = inst_80955);

(statearr_81040[(16)] = inst_80946__$1);

return statearr_81040;
})();
var statearr_81041_81081 = state_81004__$1;
(statearr_81041_81081[(2)] = null);

(statearr_81041_81081[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (18))){
var inst_80974 = (state_81004[(2)]);
var state_81004__$1 = state_81004;
var statearr_81042_81082 = state_81004__$1;
(statearr_81042_81082[(2)] = inst_80974);

(statearr_81042_81082[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81005 === (8))){
var inst_80948 = (state_81004[(12)]);
var inst_80947 = (state_81004[(15)]);
var inst_80950 = (inst_80948 < inst_80947);
var inst_80951 = inst_80950;
var state_81004__$1 = state_81004;
if(cljs.core.truth_(inst_80951)){
var statearr_81043_81083 = state_81004__$1;
(statearr_81043_81083[(1)] = (10));

} else {
var statearr_81044_81084 = state_81004__$1;
(statearr_81044_81084[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81056,mults,ensure_mult,p))
;
return ((function (switch__70820__auto__,c__70934__auto___81056,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81048[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81048[(1)] = (1));

return statearr_81048;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81004){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81049){if((e81049 instanceof Object)){
var ex__70824__auto__ = e81049;
var statearr_81050_81085 = state_81004;
(statearr_81050_81085[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81004);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81049;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81086 = state_81004;
state_81004 = G__81086;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81004){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81056,mults,ensure_mult,p))
})();
var state__70936__auto__ = (function (){var statearr_81051 = f__70935__auto__.call(null);
(statearr_81051[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81056);

return statearr_81051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81056,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args81087 = [];
var len__67408__auto___81090 = arguments.length;
var i__67409__auto___81091 = (0);
while(true){
if((i__67409__auto___81091 < len__67408__auto___81090)){
args81087.push((arguments[i__67409__auto___81091]));

var G__81092 = (i__67409__auto___81091 + (1));
i__67409__auto___81091 = G__81092;
continue;
} else {
}
break;
}

var G__81089 = args81087.length;
switch (G__81089) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81087.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args81094 = [];
var len__67408__auto___81097 = arguments.length;
var i__67409__auto___81098 = (0);
while(true){
if((i__67409__auto___81098 < len__67408__auto___81097)){
args81094.push((arguments[i__67409__auto___81098]));

var G__81099 = (i__67409__auto___81098 + (1));
i__67409__auto___81098 = G__81099;
continue;
} else {
}
break;
}

var G__81096 = args81094.length;
switch (G__81096) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81094.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args81101 = [];
var len__67408__auto___81172 = arguments.length;
var i__67409__auto___81173 = (0);
while(true){
if((i__67409__auto___81173 < len__67408__auto___81172)){
args81101.push((arguments[i__67409__auto___81173]));

var G__81174 = (i__67409__auto___81173 + (1));
i__67409__auto___81173 = G__81174;
continue;
} else {
}
break;
}

var G__81103 = args81101.length;
switch (G__81103) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81101.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__70934__auto___81176 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81176,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81176,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_81142){
var state_val_81143 = (state_81142[(1)]);
if((state_val_81143 === (7))){
var state_81142__$1 = state_81142;
var statearr_81144_81177 = state_81142__$1;
(statearr_81144_81177[(2)] = null);

(statearr_81144_81177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (1))){
var state_81142__$1 = state_81142;
var statearr_81145_81178 = state_81142__$1;
(statearr_81145_81178[(2)] = null);

(statearr_81145_81178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (4))){
var inst_81106 = (state_81142[(7)]);
var inst_81108 = (inst_81106 < cnt);
var state_81142__$1 = state_81142;
if(cljs.core.truth_(inst_81108)){
var statearr_81146_81179 = state_81142__$1;
(statearr_81146_81179[(1)] = (6));

} else {
var statearr_81147_81180 = state_81142__$1;
(statearr_81147_81180[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (15))){
var inst_81138 = (state_81142[(2)]);
var state_81142__$1 = state_81142;
var statearr_81148_81181 = state_81142__$1;
(statearr_81148_81181[(2)] = inst_81138);

(statearr_81148_81181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (13))){
var inst_81131 = cljs.core.async.close_BANG_.call(null,out);
var state_81142__$1 = state_81142;
var statearr_81149_81182 = state_81142__$1;
(statearr_81149_81182[(2)] = inst_81131);

(statearr_81149_81182[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (6))){
var state_81142__$1 = state_81142;
var statearr_81150_81183 = state_81142__$1;
(statearr_81150_81183[(2)] = null);

(statearr_81150_81183[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (3))){
var inst_81140 = (state_81142[(2)]);
var state_81142__$1 = state_81142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81142__$1,inst_81140);
} else {
if((state_val_81143 === (12))){
var inst_81128 = (state_81142[(8)]);
var inst_81128__$1 = (state_81142[(2)]);
var inst_81129 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_81128__$1);
var state_81142__$1 = (function (){var statearr_81151 = state_81142;
(statearr_81151[(8)] = inst_81128__$1);

return statearr_81151;
})();
if(cljs.core.truth_(inst_81129)){
var statearr_81152_81184 = state_81142__$1;
(statearr_81152_81184[(1)] = (13));

} else {
var statearr_81153_81185 = state_81142__$1;
(statearr_81153_81185[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (2))){
var inst_81105 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_81106 = (0);
var state_81142__$1 = (function (){var statearr_81154 = state_81142;
(statearr_81154[(7)] = inst_81106);

(statearr_81154[(9)] = inst_81105);

return statearr_81154;
})();
var statearr_81155_81186 = state_81142__$1;
(statearr_81155_81186[(2)] = null);

(statearr_81155_81186[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (11))){
var inst_81106 = (state_81142[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_81142,(10),Object,null,(9));
var inst_81115 = chs__$1.call(null,inst_81106);
var inst_81116 = done.call(null,inst_81106);
var inst_81117 = cljs.core.async.take_BANG_.call(null,inst_81115,inst_81116);
var state_81142__$1 = state_81142;
var statearr_81156_81187 = state_81142__$1;
(statearr_81156_81187[(2)] = inst_81117);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81142__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (9))){
var inst_81106 = (state_81142[(7)]);
var inst_81119 = (state_81142[(2)]);
var inst_81120 = (inst_81106 + (1));
var inst_81106__$1 = inst_81120;
var state_81142__$1 = (function (){var statearr_81157 = state_81142;
(statearr_81157[(7)] = inst_81106__$1);

(statearr_81157[(10)] = inst_81119);

return statearr_81157;
})();
var statearr_81158_81188 = state_81142__$1;
(statearr_81158_81188[(2)] = null);

(statearr_81158_81188[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (5))){
var inst_81126 = (state_81142[(2)]);
var state_81142__$1 = (function (){var statearr_81159 = state_81142;
(statearr_81159[(11)] = inst_81126);

return statearr_81159;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81142__$1,(12),dchan);
} else {
if((state_val_81143 === (14))){
var inst_81128 = (state_81142[(8)]);
var inst_81133 = cljs.core.apply.call(null,f,inst_81128);
var state_81142__$1 = state_81142;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81142__$1,(16),out,inst_81133);
} else {
if((state_val_81143 === (16))){
var inst_81135 = (state_81142[(2)]);
var state_81142__$1 = (function (){var statearr_81160 = state_81142;
(statearr_81160[(12)] = inst_81135);

return statearr_81160;
})();
var statearr_81161_81189 = state_81142__$1;
(statearr_81161_81189[(2)] = null);

(statearr_81161_81189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (10))){
var inst_81110 = (state_81142[(2)]);
var inst_81111 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_81142__$1 = (function (){var statearr_81162 = state_81142;
(statearr_81162[(13)] = inst_81110);

return statearr_81162;
})();
var statearr_81163_81190 = state_81142__$1;
(statearr_81163_81190[(2)] = inst_81111);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81142__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81143 === (8))){
var inst_81124 = (state_81142[(2)]);
var state_81142__$1 = state_81142;
var statearr_81164_81191 = state_81142__$1;
(statearr_81164_81191[(2)] = inst_81124);

(statearr_81164_81191[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81176,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__70820__auto__,c__70934__auto___81176,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81168[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81168[(1)] = (1));

return statearr_81168;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81142){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81169){if((e81169 instanceof Object)){
var ex__70824__auto__ = e81169;
var statearr_81170_81192 = state_81142;
(statearr_81170_81192[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81142);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81169;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81193 = state_81142;
state_81142 = G__81193;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81142){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81176,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__70936__auto__ = (function (){var statearr_81171 = f__70935__auto__.call(null);
(statearr_81171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81176);

return statearr_81171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81176,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args81195 = [];
var len__67408__auto___81253 = arguments.length;
var i__67409__auto___81254 = (0);
while(true){
if((i__67409__auto___81254 < len__67408__auto___81253)){
args81195.push((arguments[i__67409__auto___81254]));

var G__81255 = (i__67409__auto___81254 + (1));
i__67409__auto___81254 = G__81255;
continue;
} else {
}
break;
}

var G__81197 = args81195.length;
switch (G__81197) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81195.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___81257 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81257,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81257,out){
return (function (state_81229){
var state_val_81230 = (state_81229[(1)]);
if((state_val_81230 === (7))){
var inst_81209 = (state_81229[(7)]);
var inst_81208 = (state_81229[(8)]);
var inst_81208__$1 = (state_81229[(2)]);
var inst_81209__$1 = cljs.core.nth.call(null,inst_81208__$1,(0),null);
var inst_81210 = cljs.core.nth.call(null,inst_81208__$1,(1),null);
var inst_81211 = (inst_81209__$1 == null);
var state_81229__$1 = (function (){var statearr_81231 = state_81229;
(statearr_81231[(7)] = inst_81209__$1);

(statearr_81231[(9)] = inst_81210);

(statearr_81231[(8)] = inst_81208__$1);

return statearr_81231;
})();
if(cljs.core.truth_(inst_81211)){
var statearr_81232_81258 = state_81229__$1;
(statearr_81232_81258[(1)] = (8));

} else {
var statearr_81233_81259 = state_81229__$1;
(statearr_81233_81259[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (1))){
var inst_81198 = cljs.core.vec.call(null,chs);
var inst_81199 = inst_81198;
var state_81229__$1 = (function (){var statearr_81234 = state_81229;
(statearr_81234[(10)] = inst_81199);

return statearr_81234;
})();
var statearr_81235_81260 = state_81229__$1;
(statearr_81235_81260[(2)] = null);

(statearr_81235_81260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (4))){
var inst_81199 = (state_81229[(10)]);
var state_81229__$1 = state_81229;
return cljs.core.async.ioc_alts_BANG_.call(null,state_81229__$1,(7),inst_81199);
} else {
if((state_val_81230 === (6))){
var inst_81225 = (state_81229[(2)]);
var state_81229__$1 = state_81229;
var statearr_81236_81261 = state_81229__$1;
(statearr_81236_81261[(2)] = inst_81225);

(statearr_81236_81261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (3))){
var inst_81227 = (state_81229[(2)]);
var state_81229__$1 = state_81229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81229__$1,inst_81227);
} else {
if((state_val_81230 === (2))){
var inst_81199 = (state_81229[(10)]);
var inst_81201 = cljs.core.count.call(null,inst_81199);
var inst_81202 = (inst_81201 > (0));
var state_81229__$1 = state_81229;
if(cljs.core.truth_(inst_81202)){
var statearr_81238_81262 = state_81229__$1;
(statearr_81238_81262[(1)] = (4));

} else {
var statearr_81239_81263 = state_81229__$1;
(statearr_81239_81263[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (11))){
var inst_81199 = (state_81229[(10)]);
var inst_81218 = (state_81229[(2)]);
var tmp81237 = inst_81199;
var inst_81199__$1 = tmp81237;
var state_81229__$1 = (function (){var statearr_81240 = state_81229;
(statearr_81240[(10)] = inst_81199__$1);

(statearr_81240[(11)] = inst_81218);

return statearr_81240;
})();
var statearr_81241_81264 = state_81229__$1;
(statearr_81241_81264[(2)] = null);

(statearr_81241_81264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (9))){
var inst_81209 = (state_81229[(7)]);
var state_81229__$1 = state_81229;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81229__$1,(11),out,inst_81209);
} else {
if((state_val_81230 === (5))){
var inst_81223 = cljs.core.async.close_BANG_.call(null,out);
var state_81229__$1 = state_81229;
var statearr_81242_81265 = state_81229__$1;
(statearr_81242_81265[(2)] = inst_81223);

(statearr_81242_81265[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (10))){
var inst_81221 = (state_81229[(2)]);
var state_81229__$1 = state_81229;
var statearr_81243_81266 = state_81229__$1;
(statearr_81243_81266[(2)] = inst_81221);

(statearr_81243_81266[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81230 === (8))){
var inst_81199 = (state_81229[(10)]);
var inst_81209 = (state_81229[(7)]);
var inst_81210 = (state_81229[(9)]);
var inst_81208 = (state_81229[(8)]);
var inst_81213 = (function (){var cs = inst_81199;
var vec__81204 = inst_81208;
var v = inst_81209;
var c = inst_81210;
return ((function (cs,vec__81204,v,c,inst_81199,inst_81209,inst_81210,inst_81208,state_val_81230,c__70934__auto___81257,out){
return (function (p1__81194_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__81194_SHARP_);
});
;})(cs,vec__81204,v,c,inst_81199,inst_81209,inst_81210,inst_81208,state_val_81230,c__70934__auto___81257,out))
})();
var inst_81214 = cljs.core.filterv.call(null,inst_81213,inst_81199);
var inst_81199__$1 = inst_81214;
var state_81229__$1 = (function (){var statearr_81244 = state_81229;
(statearr_81244[(10)] = inst_81199__$1);

return statearr_81244;
})();
var statearr_81245_81267 = state_81229__$1;
(statearr_81245_81267[(2)] = null);

(statearr_81245_81267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81257,out))
;
return ((function (switch__70820__auto__,c__70934__auto___81257,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81249 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81249[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81249[(1)] = (1));

return statearr_81249;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81229){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81250){if((e81250 instanceof Object)){
var ex__70824__auto__ = e81250;
var statearr_81251_81268 = state_81229;
(statearr_81251_81268[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81250;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81269 = state_81229;
state_81229 = G__81269;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81257,out))
})();
var state__70936__auto__ = (function (){var statearr_81252 = f__70935__auto__.call(null);
(statearr_81252[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81257);

return statearr_81252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81257,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args81270 = [];
var len__67408__auto___81319 = arguments.length;
var i__67409__auto___81320 = (0);
while(true){
if((i__67409__auto___81320 < len__67408__auto___81319)){
args81270.push((arguments[i__67409__auto___81320]));

var G__81321 = (i__67409__auto___81320 + (1));
i__67409__auto___81320 = G__81321;
continue;
} else {
}
break;
}

var G__81272 = args81270.length;
switch (G__81272) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81270.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___81323 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81323,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81323,out){
return (function (state_81296){
var state_val_81297 = (state_81296[(1)]);
if((state_val_81297 === (7))){
var inst_81278 = (state_81296[(7)]);
var inst_81278__$1 = (state_81296[(2)]);
var inst_81279 = (inst_81278__$1 == null);
var inst_81280 = cljs.core.not.call(null,inst_81279);
var state_81296__$1 = (function (){var statearr_81298 = state_81296;
(statearr_81298[(7)] = inst_81278__$1);

return statearr_81298;
})();
if(inst_81280){
var statearr_81299_81324 = state_81296__$1;
(statearr_81299_81324[(1)] = (8));

} else {
var statearr_81300_81325 = state_81296__$1;
(statearr_81300_81325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (1))){
var inst_81273 = (0);
var state_81296__$1 = (function (){var statearr_81301 = state_81296;
(statearr_81301[(8)] = inst_81273);

return statearr_81301;
})();
var statearr_81302_81326 = state_81296__$1;
(statearr_81302_81326[(2)] = null);

(statearr_81302_81326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (4))){
var state_81296__$1 = state_81296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81296__$1,(7),ch);
} else {
if((state_val_81297 === (6))){
var inst_81291 = (state_81296[(2)]);
var state_81296__$1 = state_81296;
var statearr_81303_81327 = state_81296__$1;
(statearr_81303_81327[(2)] = inst_81291);

(statearr_81303_81327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (3))){
var inst_81293 = (state_81296[(2)]);
var inst_81294 = cljs.core.async.close_BANG_.call(null,out);
var state_81296__$1 = (function (){var statearr_81304 = state_81296;
(statearr_81304[(9)] = inst_81293);

return statearr_81304;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81296__$1,inst_81294);
} else {
if((state_val_81297 === (2))){
var inst_81273 = (state_81296[(8)]);
var inst_81275 = (inst_81273 < n);
var state_81296__$1 = state_81296;
if(cljs.core.truth_(inst_81275)){
var statearr_81305_81328 = state_81296__$1;
(statearr_81305_81328[(1)] = (4));

} else {
var statearr_81306_81329 = state_81296__$1;
(statearr_81306_81329[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (11))){
var inst_81273 = (state_81296[(8)]);
var inst_81283 = (state_81296[(2)]);
var inst_81284 = (inst_81273 + (1));
var inst_81273__$1 = inst_81284;
var state_81296__$1 = (function (){var statearr_81307 = state_81296;
(statearr_81307[(10)] = inst_81283);

(statearr_81307[(8)] = inst_81273__$1);

return statearr_81307;
})();
var statearr_81308_81330 = state_81296__$1;
(statearr_81308_81330[(2)] = null);

(statearr_81308_81330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (9))){
var state_81296__$1 = state_81296;
var statearr_81309_81331 = state_81296__$1;
(statearr_81309_81331[(2)] = null);

(statearr_81309_81331[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (5))){
var state_81296__$1 = state_81296;
var statearr_81310_81332 = state_81296__$1;
(statearr_81310_81332[(2)] = null);

(statearr_81310_81332[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (10))){
var inst_81288 = (state_81296[(2)]);
var state_81296__$1 = state_81296;
var statearr_81311_81333 = state_81296__$1;
(statearr_81311_81333[(2)] = inst_81288);

(statearr_81311_81333[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81297 === (8))){
var inst_81278 = (state_81296[(7)]);
var state_81296__$1 = state_81296;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81296__$1,(11),out,inst_81278);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81323,out))
;
return ((function (switch__70820__auto__,c__70934__auto___81323,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81315 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81315[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81315[(1)] = (1));

return statearr_81315;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81296){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81316){if((e81316 instanceof Object)){
var ex__70824__auto__ = e81316;
var statearr_81317_81334 = state_81296;
(statearr_81317_81334[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81316;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81335 = state_81296;
state_81296 = G__81335;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81323,out))
})();
var state__70936__auto__ = (function (){var statearr_81318 = f__70935__auto__.call(null);
(statearr_81318[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81323);

return statearr_81318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81323,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async81343 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81343 = (function (f,ch,meta81344){
this.f = f;
this.ch = ch;
this.meta81344 = meta81344;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81345,meta81344__$1){
var self__ = this;
var _81345__$1 = this;
return (new cljs.core.async.t_cljs$core$async81343(self__.f,self__.ch,meta81344__$1));
});

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81345){
var self__ = this;
var _81345__$1 = this;
return self__.meta81344;
});

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async81346 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81346 = (function (f,ch,meta81344,_,fn1,meta81347){
this.f = f;
this.ch = ch;
this.meta81344 = meta81344;
this._ = _;
this.fn1 = fn1;
this.meta81347 = meta81347;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async81346.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_81348,meta81347__$1){
var self__ = this;
var _81348__$1 = this;
return (new cljs.core.async.t_cljs$core$async81346(self__.f,self__.ch,self__.meta81344,self__._,self__.fn1,meta81347__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async81346.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_81348){
var self__ = this;
var _81348__$1 = this;
return self__.meta81347;
});})(___$1))
;

cljs.core.async.t_cljs$core$async81346.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81346.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async81346.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async81346.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__81336_SHARP_){
return f1.call(null,(((p1__81336_SHARP_ == null))?null:self__.f.call(null,p1__81336_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async81346.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81344","meta81344",1529759339,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async81343","cljs.core.async/t_cljs$core$async81343",2117382183,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta81347","meta81347",499090603,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async81346.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81346.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81346";

cljs.core.async.t_cljs$core$async81346.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async81346");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async81346 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async81346(f__$1,ch__$1,meta81344__$1,___$2,fn1__$1,meta81347){
return (new cljs.core.async.t_cljs$core$async81346(f__$1,ch__$1,meta81344__$1,___$2,fn1__$1,meta81347));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async81346(self__.f,self__.ch,self__.meta81344,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__66175__auto__ = ret;
if(cljs.core.truth_(and__66175__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__66175__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81343.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async81343.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81344","meta81344",1529759339,null)], null);
});

cljs.core.async.t_cljs$core$async81343.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81343.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81343";

cljs.core.async.t_cljs$core$async81343.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async81343");
});

cljs.core.async.__GT_t_cljs$core$async81343 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async81343(f__$1,ch__$1,meta81344){
return (new cljs.core.async.t_cljs$core$async81343(f__$1,ch__$1,meta81344));
});

}

return (new cljs.core.async.t_cljs$core$async81343(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async81352 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81352 = (function (f,ch,meta81353){
this.f = f;
this.ch = ch;
this.meta81353 = meta81353;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81354,meta81353__$1){
var self__ = this;
var _81354__$1 = this;
return (new cljs.core.async.t_cljs$core$async81352(self__.f,self__.ch,meta81353__$1));
});

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81354){
var self__ = this;
var _81354__$1 = this;
return self__.meta81353;
});

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81352.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async81352.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81353","meta81353",-591395045,null)], null);
});

cljs.core.async.t_cljs$core$async81352.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81352.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81352";

cljs.core.async.t_cljs$core$async81352.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async81352");
});

cljs.core.async.__GT_t_cljs$core$async81352 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async81352(f__$1,ch__$1,meta81353){
return (new cljs.core.async.t_cljs$core$async81352(f__$1,ch__$1,meta81353));
});

}

return (new cljs.core.async.t_cljs$core$async81352(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async81358 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async81358 = (function (p,ch,meta81359){
this.p = p;
this.ch = ch;
this.meta81359 = meta81359;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_81360,meta81359__$1){
var self__ = this;
var _81360__$1 = this;
return (new cljs.core.async.t_cljs$core$async81358(self__.p,self__.ch,meta81359__$1));
});

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_81360){
var self__ = this;
var _81360__$1 = this;
return self__.meta81359;
});

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async81358.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async81358.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta81359","meta81359",692133784,null)], null);
});

cljs.core.async.t_cljs$core$async81358.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async81358.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async81358";

cljs.core.async.t_cljs$core$async81358.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async81358");
});

cljs.core.async.__GT_t_cljs$core$async81358 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async81358(p__$1,ch__$1,meta81359){
return (new cljs.core.async.t_cljs$core$async81358(p__$1,ch__$1,meta81359));
});

}

return (new cljs.core.async.t_cljs$core$async81358(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args81361 = [];
var len__67408__auto___81405 = arguments.length;
var i__67409__auto___81406 = (0);
while(true){
if((i__67409__auto___81406 < len__67408__auto___81405)){
args81361.push((arguments[i__67409__auto___81406]));

var G__81407 = (i__67409__auto___81406 + (1));
i__67409__auto___81406 = G__81407;
continue;
} else {
}
break;
}

var G__81363 = args81361.length;
switch (G__81363) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81361.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___81409 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81409,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81409,out){
return (function (state_81384){
var state_val_81385 = (state_81384[(1)]);
if((state_val_81385 === (7))){
var inst_81380 = (state_81384[(2)]);
var state_81384__$1 = state_81384;
var statearr_81386_81410 = state_81384__$1;
(statearr_81386_81410[(2)] = inst_81380);

(statearr_81386_81410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (1))){
var state_81384__$1 = state_81384;
var statearr_81387_81411 = state_81384__$1;
(statearr_81387_81411[(2)] = null);

(statearr_81387_81411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (4))){
var inst_81366 = (state_81384[(7)]);
var inst_81366__$1 = (state_81384[(2)]);
var inst_81367 = (inst_81366__$1 == null);
var state_81384__$1 = (function (){var statearr_81388 = state_81384;
(statearr_81388[(7)] = inst_81366__$1);

return statearr_81388;
})();
if(cljs.core.truth_(inst_81367)){
var statearr_81389_81412 = state_81384__$1;
(statearr_81389_81412[(1)] = (5));

} else {
var statearr_81390_81413 = state_81384__$1;
(statearr_81390_81413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (6))){
var inst_81366 = (state_81384[(7)]);
var inst_81371 = p.call(null,inst_81366);
var state_81384__$1 = state_81384;
if(cljs.core.truth_(inst_81371)){
var statearr_81391_81414 = state_81384__$1;
(statearr_81391_81414[(1)] = (8));

} else {
var statearr_81392_81415 = state_81384__$1;
(statearr_81392_81415[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (3))){
var inst_81382 = (state_81384[(2)]);
var state_81384__$1 = state_81384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81384__$1,inst_81382);
} else {
if((state_val_81385 === (2))){
var state_81384__$1 = state_81384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81384__$1,(4),ch);
} else {
if((state_val_81385 === (11))){
var inst_81374 = (state_81384[(2)]);
var state_81384__$1 = state_81384;
var statearr_81393_81416 = state_81384__$1;
(statearr_81393_81416[(2)] = inst_81374);

(statearr_81393_81416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (9))){
var state_81384__$1 = state_81384;
var statearr_81394_81417 = state_81384__$1;
(statearr_81394_81417[(2)] = null);

(statearr_81394_81417[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (5))){
var inst_81369 = cljs.core.async.close_BANG_.call(null,out);
var state_81384__$1 = state_81384;
var statearr_81395_81418 = state_81384__$1;
(statearr_81395_81418[(2)] = inst_81369);

(statearr_81395_81418[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (10))){
var inst_81377 = (state_81384[(2)]);
var state_81384__$1 = (function (){var statearr_81396 = state_81384;
(statearr_81396[(8)] = inst_81377);

return statearr_81396;
})();
var statearr_81397_81419 = state_81384__$1;
(statearr_81397_81419[(2)] = null);

(statearr_81397_81419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81385 === (8))){
var inst_81366 = (state_81384[(7)]);
var state_81384__$1 = state_81384;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81384__$1,(11),out,inst_81366);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81409,out))
;
return ((function (switch__70820__auto__,c__70934__auto___81409,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81401 = [null,null,null,null,null,null,null,null,null];
(statearr_81401[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81401[(1)] = (1));

return statearr_81401;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81384){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81402){if((e81402 instanceof Object)){
var ex__70824__auto__ = e81402;
var statearr_81403_81420 = state_81384;
(statearr_81403_81420[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81384);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81421 = state_81384;
state_81384 = G__81421;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81384){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81409,out))
})();
var state__70936__auto__ = (function (){var statearr_81404 = f__70935__auto__.call(null);
(statearr_81404[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81409);

return statearr_81404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81409,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args81422 = [];
var len__67408__auto___81425 = arguments.length;
var i__67409__auto___81426 = (0);
while(true){
if((i__67409__auto___81426 < len__67408__auto___81425)){
args81422.push((arguments[i__67409__auto___81426]));

var G__81427 = (i__67409__auto___81426 + (1));
i__67409__auto___81426 = G__81427;
continue;
} else {
}
break;
}

var G__81424 = args81422.length;
switch (G__81424) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81422.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_81594){
var state_val_81595 = (state_81594[(1)]);
if((state_val_81595 === (7))){
var inst_81590 = (state_81594[(2)]);
var state_81594__$1 = state_81594;
var statearr_81596_81637 = state_81594__$1;
(statearr_81596_81637[(2)] = inst_81590);

(statearr_81596_81637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (20))){
var inst_81560 = (state_81594[(7)]);
var inst_81571 = (state_81594[(2)]);
var inst_81572 = cljs.core.next.call(null,inst_81560);
var inst_81546 = inst_81572;
var inst_81547 = null;
var inst_81548 = (0);
var inst_81549 = (0);
var state_81594__$1 = (function (){var statearr_81597 = state_81594;
(statearr_81597[(8)] = inst_81546);

(statearr_81597[(9)] = inst_81549);

(statearr_81597[(10)] = inst_81571);

(statearr_81597[(11)] = inst_81547);

(statearr_81597[(12)] = inst_81548);

return statearr_81597;
})();
var statearr_81598_81638 = state_81594__$1;
(statearr_81598_81638[(2)] = null);

(statearr_81598_81638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (1))){
var state_81594__$1 = state_81594;
var statearr_81599_81639 = state_81594__$1;
(statearr_81599_81639[(2)] = null);

(statearr_81599_81639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (4))){
var inst_81535 = (state_81594[(13)]);
var inst_81535__$1 = (state_81594[(2)]);
var inst_81536 = (inst_81535__$1 == null);
var state_81594__$1 = (function (){var statearr_81600 = state_81594;
(statearr_81600[(13)] = inst_81535__$1);

return statearr_81600;
})();
if(cljs.core.truth_(inst_81536)){
var statearr_81601_81640 = state_81594__$1;
(statearr_81601_81640[(1)] = (5));

} else {
var statearr_81602_81641 = state_81594__$1;
(statearr_81602_81641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (15))){
var state_81594__$1 = state_81594;
var statearr_81606_81642 = state_81594__$1;
(statearr_81606_81642[(2)] = null);

(statearr_81606_81642[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (21))){
var state_81594__$1 = state_81594;
var statearr_81607_81643 = state_81594__$1;
(statearr_81607_81643[(2)] = null);

(statearr_81607_81643[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (13))){
var inst_81546 = (state_81594[(8)]);
var inst_81549 = (state_81594[(9)]);
var inst_81547 = (state_81594[(11)]);
var inst_81548 = (state_81594[(12)]);
var inst_81556 = (state_81594[(2)]);
var inst_81557 = (inst_81549 + (1));
var tmp81603 = inst_81546;
var tmp81604 = inst_81547;
var tmp81605 = inst_81548;
var inst_81546__$1 = tmp81603;
var inst_81547__$1 = tmp81604;
var inst_81548__$1 = tmp81605;
var inst_81549__$1 = inst_81557;
var state_81594__$1 = (function (){var statearr_81608 = state_81594;
(statearr_81608[(14)] = inst_81556);

(statearr_81608[(8)] = inst_81546__$1);

(statearr_81608[(9)] = inst_81549__$1);

(statearr_81608[(11)] = inst_81547__$1);

(statearr_81608[(12)] = inst_81548__$1);

return statearr_81608;
})();
var statearr_81609_81644 = state_81594__$1;
(statearr_81609_81644[(2)] = null);

(statearr_81609_81644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (22))){
var state_81594__$1 = state_81594;
var statearr_81610_81645 = state_81594__$1;
(statearr_81610_81645[(2)] = null);

(statearr_81610_81645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (6))){
var inst_81535 = (state_81594[(13)]);
var inst_81544 = f.call(null,inst_81535);
var inst_81545 = cljs.core.seq.call(null,inst_81544);
var inst_81546 = inst_81545;
var inst_81547 = null;
var inst_81548 = (0);
var inst_81549 = (0);
var state_81594__$1 = (function (){var statearr_81611 = state_81594;
(statearr_81611[(8)] = inst_81546);

(statearr_81611[(9)] = inst_81549);

(statearr_81611[(11)] = inst_81547);

(statearr_81611[(12)] = inst_81548);

return statearr_81611;
})();
var statearr_81612_81646 = state_81594__$1;
(statearr_81612_81646[(2)] = null);

(statearr_81612_81646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (17))){
var inst_81560 = (state_81594[(7)]);
var inst_81564 = cljs.core.chunk_first.call(null,inst_81560);
var inst_81565 = cljs.core.chunk_rest.call(null,inst_81560);
var inst_81566 = cljs.core.count.call(null,inst_81564);
var inst_81546 = inst_81565;
var inst_81547 = inst_81564;
var inst_81548 = inst_81566;
var inst_81549 = (0);
var state_81594__$1 = (function (){var statearr_81613 = state_81594;
(statearr_81613[(8)] = inst_81546);

(statearr_81613[(9)] = inst_81549);

(statearr_81613[(11)] = inst_81547);

(statearr_81613[(12)] = inst_81548);

return statearr_81613;
})();
var statearr_81614_81647 = state_81594__$1;
(statearr_81614_81647[(2)] = null);

(statearr_81614_81647[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (3))){
var inst_81592 = (state_81594[(2)]);
var state_81594__$1 = state_81594;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81594__$1,inst_81592);
} else {
if((state_val_81595 === (12))){
var inst_81580 = (state_81594[(2)]);
var state_81594__$1 = state_81594;
var statearr_81615_81648 = state_81594__$1;
(statearr_81615_81648[(2)] = inst_81580);

(statearr_81615_81648[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (2))){
var state_81594__$1 = state_81594;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81594__$1,(4),in$);
} else {
if((state_val_81595 === (23))){
var inst_81588 = (state_81594[(2)]);
var state_81594__$1 = state_81594;
var statearr_81616_81649 = state_81594__$1;
(statearr_81616_81649[(2)] = inst_81588);

(statearr_81616_81649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (19))){
var inst_81575 = (state_81594[(2)]);
var state_81594__$1 = state_81594;
var statearr_81617_81650 = state_81594__$1;
(statearr_81617_81650[(2)] = inst_81575);

(statearr_81617_81650[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (11))){
var inst_81546 = (state_81594[(8)]);
var inst_81560 = (state_81594[(7)]);
var inst_81560__$1 = cljs.core.seq.call(null,inst_81546);
var state_81594__$1 = (function (){var statearr_81618 = state_81594;
(statearr_81618[(7)] = inst_81560__$1);

return statearr_81618;
})();
if(inst_81560__$1){
var statearr_81619_81651 = state_81594__$1;
(statearr_81619_81651[(1)] = (14));

} else {
var statearr_81620_81652 = state_81594__$1;
(statearr_81620_81652[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (9))){
var inst_81582 = (state_81594[(2)]);
var inst_81583 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_81594__$1 = (function (){var statearr_81621 = state_81594;
(statearr_81621[(15)] = inst_81582);

return statearr_81621;
})();
if(cljs.core.truth_(inst_81583)){
var statearr_81622_81653 = state_81594__$1;
(statearr_81622_81653[(1)] = (21));

} else {
var statearr_81623_81654 = state_81594__$1;
(statearr_81623_81654[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (5))){
var inst_81538 = cljs.core.async.close_BANG_.call(null,out);
var state_81594__$1 = state_81594;
var statearr_81624_81655 = state_81594__$1;
(statearr_81624_81655[(2)] = inst_81538);

(statearr_81624_81655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (14))){
var inst_81560 = (state_81594[(7)]);
var inst_81562 = cljs.core.chunked_seq_QMARK_.call(null,inst_81560);
var state_81594__$1 = state_81594;
if(inst_81562){
var statearr_81625_81656 = state_81594__$1;
(statearr_81625_81656[(1)] = (17));

} else {
var statearr_81626_81657 = state_81594__$1;
(statearr_81626_81657[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (16))){
var inst_81578 = (state_81594[(2)]);
var state_81594__$1 = state_81594;
var statearr_81627_81658 = state_81594__$1;
(statearr_81627_81658[(2)] = inst_81578);

(statearr_81627_81658[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81595 === (10))){
var inst_81549 = (state_81594[(9)]);
var inst_81547 = (state_81594[(11)]);
var inst_81554 = cljs.core._nth.call(null,inst_81547,inst_81549);
var state_81594__$1 = state_81594;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81594__$1,(13),out,inst_81554);
} else {
if((state_val_81595 === (18))){
var inst_81560 = (state_81594[(7)]);
var inst_81569 = cljs.core.first.call(null,inst_81560);
var state_81594__$1 = state_81594;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81594__$1,(20),out,inst_81569);
} else {
if((state_val_81595 === (8))){
var inst_81549 = (state_81594[(9)]);
var inst_81548 = (state_81594[(12)]);
var inst_81551 = (inst_81549 < inst_81548);
var inst_81552 = inst_81551;
var state_81594__$1 = state_81594;
if(cljs.core.truth_(inst_81552)){
var statearr_81628_81659 = state_81594__$1;
(statearr_81628_81659[(1)] = (10));

} else {
var statearr_81629_81660 = state_81594__$1;
(statearr_81629_81660[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_81633 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81633[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__);

(statearr_81633[(1)] = (1));

return statearr_81633;
});
var cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____1 = (function (state_81594){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81594);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81634){if((e81634 instanceof Object)){
var ex__70824__auto__ = e81634;
var statearr_81635_81661 = state_81594;
(statearr_81635_81661[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81594);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81662 = state_81594;
state_81594 = G__81662;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__ = function(state_81594){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____1.call(this,state_81594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_81636 = f__70935__auto__.call(null);
(statearr_81636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_81636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args81663 = [];
var len__67408__auto___81666 = arguments.length;
var i__67409__auto___81667 = (0);
while(true){
if((i__67409__auto___81667 < len__67408__auto___81666)){
args81663.push((arguments[i__67409__auto___81667]));

var G__81668 = (i__67409__auto___81667 + (1));
i__67409__auto___81667 = G__81668;
continue;
} else {
}
break;
}

var G__81665 = args81663.length;
switch (G__81665) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81663.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args81670 = [];
var len__67408__auto___81673 = arguments.length;
var i__67409__auto___81674 = (0);
while(true){
if((i__67409__auto___81674 < len__67408__auto___81673)){
args81670.push((arguments[i__67409__auto___81674]));

var G__81675 = (i__67409__auto___81674 + (1));
i__67409__auto___81674 = G__81675;
continue;
} else {
}
break;
}

var G__81672 = args81670.length;
switch (G__81672) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81670.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args81677 = [];
var len__67408__auto___81728 = arguments.length;
var i__67409__auto___81729 = (0);
while(true){
if((i__67409__auto___81729 < len__67408__auto___81728)){
args81677.push((arguments[i__67409__auto___81729]));

var G__81730 = (i__67409__auto___81729 + (1));
i__67409__auto___81729 = G__81730;
continue;
} else {
}
break;
}

var G__81679 = args81677.length;
switch (G__81679) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81677.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___81732 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81732,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81732,out){
return (function (state_81703){
var state_val_81704 = (state_81703[(1)]);
if((state_val_81704 === (7))){
var inst_81698 = (state_81703[(2)]);
var state_81703__$1 = state_81703;
var statearr_81705_81733 = state_81703__$1;
(statearr_81705_81733[(2)] = inst_81698);

(statearr_81705_81733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (1))){
var inst_81680 = null;
var state_81703__$1 = (function (){var statearr_81706 = state_81703;
(statearr_81706[(7)] = inst_81680);

return statearr_81706;
})();
var statearr_81707_81734 = state_81703__$1;
(statearr_81707_81734[(2)] = null);

(statearr_81707_81734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (4))){
var inst_81683 = (state_81703[(8)]);
var inst_81683__$1 = (state_81703[(2)]);
var inst_81684 = (inst_81683__$1 == null);
var inst_81685 = cljs.core.not.call(null,inst_81684);
var state_81703__$1 = (function (){var statearr_81708 = state_81703;
(statearr_81708[(8)] = inst_81683__$1);

return statearr_81708;
})();
if(inst_81685){
var statearr_81709_81735 = state_81703__$1;
(statearr_81709_81735[(1)] = (5));

} else {
var statearr_81710_81736 = state_81703__$1;
(statearr_81710_81736[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (6))){
var state_81703__$1 = state_81703;
var statearr_81711_81737 = state_81703__$1;
(statearr_81711_81737[(2)] = null);

(statearr_81711_81737[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (3))){
var inst_81700 = (state_81703[(2)]);
var inst_81701 = cljs.core.async.close_BANG_.call(null,out);
var state_81703__$1 = (function (){var statearr_81712 = state_81703;
(statearr_81712[(9)] = inst_81700);

return statearr_81712;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81703__$1,inst_81701);
} else {
if((state_val_81704 === (2))){
var state_81703__$1 = state_81703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81703__$1,(4),ch);
} else {
if((state_val_81704 === (11))){
var inst_81683 = (state_81703[(8)]);
var inst_81692 = (state_81703[(2)]);
var inst_81680 = inst_81683;
var state_81703__$1 = (function (){var statearr_81713 = state_81703;
(statearr_81713[(7)] = inst_81680);

(statearr_81713[(10)] = inst_81692);

return statearr_81713;
})();
var statearr_81714_81738 = state_81703__$1;
(statearr_81714_81738[(2)] = null);

(statearr_81714_81738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (9))){
var inst_81683 = (state_81703[(8)]);
var state_81703__$1 = state_81703;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81703__$1,(11),out,inst_81683);
} else {
if((state_val_81704 === (5))){
var inst_81680 = (state_81703[(7)]);
var inst_81683 = (state_81703[(8)]);
var inst_81687 = cljs.core._EQ_.call(null,inst_81683,inst_81680);
var state_81703__$1 = state_81703;
if(inst_81687){
var statearr_81716_81739 = state_81703__$1;
(statearr_81716_81739[(1)] = (8));

} else {
var statearr_81717_81740 = state_81703__$1;
(statearr_81717_81740[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (10))){
var inst_81695 = (state_81703[(2)]);
var state_81703__$1 = state_81703;
var statearr_81718_81741 = state_81703__$1;
(statearr_81718_81741[(2)] = inst_81695);

(statearr_81718_81741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81704 === (8))){
var inst_81680 = (state_81703[(7)]);
var tmp81715 = inst_81680;
var inst_81680__$1 = tmp81715;
var state_81703__$1 = (function (){var statearr_81719 = state_81703;
(statearr_81719[(7)] = inst_81680__$1);

return statearr_81719;
})();
var statearr_81720_81742 = state_81703__$1;
(statearr_81720_81742[(2)] = null);

(statearr_81720_81742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81732,out))
;
return ((function (switch__70820__auto__,c__70934__auto___81732,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81724 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_81724[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81724[(1)] = (1));

return statearr_81724;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81703){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81725){if((e81725 instanceof Object)){
var ex__70824__auto__ = e81725;
var statearr_81726_81743 = state_81703;
(statearr_81726_81743[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81703);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81725;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81744 = state_81703;
state_81703 = G__81744;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81703){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81732,out))
})();
var state__70936__auto__ = (function (){var statearr_81727 = f__70935__auto__.call(null);
(statearr_81727[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81732);

return statearr_81727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81732,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args81745 = [];
var len__67408__auto___81815 = arguments.length;
var i__67409__auto___81816 = (0);
while(true){
if((i__67409__auto___81816 < len__67408__auto___81815)){
args81745.push((arguments[i__67409__auto___81816]));

var G__81817 = (i__67409__auto___81816 + (1));
i__67409__auto___81816 = G__81817;
continue;
} else {
}
break;
}

var G__81747 = args81745.length;
switch (G__81747) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81745.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___81819 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81819,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81819,out){
return (function (state_81785){
var state_val_81786 = (state_81785[(1)]);
if((state_val_81786 === (7))){
var inst_81781 = (state_81785[(2)]);
var state_81785__$1 = state_81785;
var statearr_81787_81820 = state_81785__$1;
(statearr_81787_81820[(2)] = inst_81781);

(statearr_81787_81820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (1))){
var inst_81748 = (new Array(n));
var inst_81749 = inst_81748;
var inst_81750 = (0);
var state_81785__$1 = (function (){var statearr_81788 = state_81785;
(statearr_81788[(7)] = inst_81750);

(statearr_81788[(8)] = inst_81749);

return statearr_81788;
})();
var statearr_81789_81821 = state_81785__$1;
(statearr_81789_81821[(2)] = null);

(statearr_81789_81821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (4))){
var inst_81753 = (state_81785[(9)]);
var inst_81753__$1 = (state_81785[(2)]);
var inst_81754 = (inst_81753__$1 == null);
var inst_81755 = cljs.core.not.call(null,inst_81754);
var state_81785__$1 = (function (){var statearr_81790 = state_81785;
(statearr_81790[(9)] = inst_81753__$1);

return statearr_81790;
})();
if(inst_81755){
var statearr_81791_81822 = state_81785__$1;
(statearr_81791_81822[(1)] = (5));

} else {
var statearr_81792_81823 = state_81785__$1;
(statearr_81792_81823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (15))){
var inst_81775 = (state_81785[(2)]);
var state_81785__$1 = state_81785;
var statearr_81793_81824 = state_81785__$1;
(statearr_81793_81824[(2)] = inst_81775);

(statearr_81793_81824[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (13))){
var state_81785__$1 = state_81785;
var statearr_81794_81825 = state_81785__$1;
(statearr_81794_81825[(2)] = null);

(statearr_81794_81825[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (6))){
var inst_81750 = (state_81785[(7)]);
var inst_81771 = (inst_81750 > (0));
var state_81785__$1 = state_81785;
if(cljs.core.truth_(inst_81771)){
var statearr_81795_81826 = state_81785__$1;
(statearr_81795_81826[(1)] = (12));

} else {
var statearr_81796_81827 = state_81785__$1;
(statearr_81796_81827[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (3))){
var inst_81783 = (state_81785[(2)]);
var state_81785__$1 = state_81785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81785__$1,inst_81783);
} else {
if((state_val_81786 === (12))){
var inst_81749 = (state_81785[(8)]);
var inst_81773 = cljs.core.vec.call(null,inst_81749);
var state_81785__$1 = state_81785;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81785__$1,(15),out,inst_81773);
} else {
if((state_val_81786 === (2))){
var state_81785__$1 = state_81785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81785__$1,(4),ch);
} else {
if((state_val_81786 === (11))){
var inst_81765 = (state_81785[(2)]);
var inst_81766 = (new Array(n));
var inst_81749 = inst_81766;
var inst_81750 = (0);
var state_81785__$1 = (function (){var statearr_81797 = state_81785;
(statearr_81797[(7)] = inst_81750);

(statearr_81797[(10)] = inst_81765);

(statearr_81797[(8)] = inst_81749);

return statearr_81797;
})();
var statearr_81798_81828 = state_81785__$1;
(statearr_81798_81828[(2)] = null);

(statearr_81798_81828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (9))){
var inst_81749 = (state_81785[(8)]);
var inst_81763 = cljs.core.vec.call(null,inst_81749);
var state_81785__$1 = state_81785;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81785__$1,(11),out,inst_81763);
} else {
if((state_val_81786 === (5))){
var inst_81758 = (state_81785[(11)]);
var inst_81750 = (state_81785[(7)]);
var inst_81753 = (state_81785[(9)]);
var inst_81749 = (state_81785[(8)]);
var inst_81757 = (inst_81749[inst_81750] = inst_81753);
var inst_81758__$1 = (inst_81750 + (1));
var inst_81759 = (inst_81758__$1 < n);
var state_81785__$1 = (function (){var statearr_81799 = state_81785;
(statearr_81799[(12)] = inst_81757);

(statearr_81799[(11)] = inst_81758__$1);

return statearr_81799;
})();
if(cljs.core.truth_(inst_81759)){
var statearr_81800_81829 = state_81785__$1;
(statearr_81800_81829[(1)] = (8));

} else {
var statearr_81801_81830 = state_81785__$1;
(statearr_81801_81830[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (14))){
var inst_81778 = (state_81785[(2)]);
var inst_81779 = cljs.core.async.close_BANG_.call(null,out);
var state_81785__$1 = (function (){var statearr_81803 = state_81785;
(statearr_81803[(13)] = inst_81778);

return statearr_81803;
})();
var statearr_81804_81831 = state_81785__$1;
(statearr_81804_81831[(2)] = inst_81779);

(statearr_81804_81831[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (10))){
var inst_81769 = (state_81785[(2)]);
var state_81785__$1 = state_81785;
var statearr_81805_81832 = state_81785__$1;
(statearr_81805_81832[(2)] = inst_81769);

(statearr_81805_81832[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81786 === (8))){
var inst_81758 = (state_81785[(11)]);
var inst_81749 = (state_81785[(8)]);
var tmp81802 = inst_81749;
var inst_81749__$1 = tmp81802;
var inst_81750 = inst_81758;
var state_81785__$1 = (function (){var statearr_81806 = state_81785;
(statearr_81806[(7)] = inst_81750);

(statearr_81806[(8)] = inst_81749__$1);

return statearr_81806;
})();
var statearr_81807_81833 = state_81785__$1;
(statearr_81807_81833[(2)] = null);

(statearr_81807_81833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81819,out))
;
return ((function (switch__70820__auto__,c__70934__auto___81819,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81811[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81811[(1)] = (1));

return statearr_81811;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81785){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81812){if((e81812 instanceof Object)){
var ex__70824__auto__ = e81812;
var statearr_81813_81834 = state_81785;
(statearr_81813_81834[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81812;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81835 = state_81785;
state_81785 = G__81835;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81819,out))
})();
var state__70936__auto__ = (function (){var statearr_81814 = f__70935__auto__.call(null);
(statearr_81814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81819);

return statearr_81814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81819,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args81836 = [];
var len__67408__auto___81910 = arguments.length;
var i__67409__auto___81911 = (0);
while(true){
if((i__67409__auto___81911 < len__67408__auto___81910)){
args81836.push((arguments[i__67409__auto___81911]));

var G__81912 = (i__67409__auto___81911 + (1));
i__67409__auto___81911 = G__81912;
continue;
} else {
}
break;
}

var G__81838 = args81836.length;
switch (G__81838) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args81836.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___81914 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___81914,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___81914,out){
return (function (state_81880){
var state_val_81881 = (state_81880[(1)]);
if((state_val_81881 === (7))){
var inst_81876 = (state_81880[(2)]);
var state_81880__$1 = state_81880;
var statearr_81882_81915 = state_81880__$1;
(statearr_81882_81915[(2)] = inst_81876);

(statearr_81882_81915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (1))){
var inst_81839 = [];
var inst_81840 = inst_81839;
var inst_81841 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_81880__$1 = (function (){var statearr_81883 = state_81880;
(statearr_81883[(7)] = inst_81840);

(statearr_81883[(8)] = inst_81841);

return statearr_81883;
})();
var statearr_81884_81916 = state_81880__$1;
(statearr_81884_81916[(2)] = null);

(statearr_81884_81916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (4))){
var inst_81844 = (state_81880[(9)]);
var inst_81844__$1 = (state_81880[(2)]);
var inst_81845 = (inst_81844__$1 == null);
var inst_81846 = cljs.core.not.call(null,inst_81845);
var state_81880__$1 = (function (){var statearr_81885 = state_81880;
(statearr_81885[(9)] = inst_81844__$1);

return statearr_81885;
})();
if(inst_81846){
var statearr_81886_81917 = state_81880__$1;
(statearr_81886_81917[(1)] = (5));

} else {
var statearr_81887_81918 = state_81880__$1;
(statearr_81887_81918[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (15))){
var inst_81870 = (state_81880[(2)]);
var state_81880__$1 = state_81880;
var statearr_81888_81919 = state_81880__$1;
(statearr_81888_81919[(2)] = inst_81870);

(statearr_81888_81919[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (13))){
var state_81880__$1 = state_81880;
var statearr_81889_81920 = state_81880__$1;
(statearr_81889_81920[(2)] = null);

(statearr_81889_81920[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (6))){
var inst_81840 = (state_81880[(7)]);
var inst_81865 = inst_81840.length;
var inst_81866 = (inst_81865 > (0));
var state_81880__$1 = state_81880;
if(cljs.core.truth_(inst_81866)){
var statearr_81890_81921 = state_81880__$1;
(statearr_81890_81921[(1)] = (12));

} else {
var statearr_81891_81922 = state_81880__$1;
(statearr_81891_81922[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (3))){
var inst_81878 = (state_81880[(2)]);
var state_81880__$1 = state_81880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_81880__$1,inst_81878);
} else {
if((state_val_81881 === (12))){
var inst_81840 = (state_81880[(7)]);
var inst_81868 = cljs.core.vec.call(null,inst_81840);
var state_81880__$1 = state_81880;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81880__$1,(15),out,inst_81868);
} else {
if((state_val_81881 === (2))){
var state_81880__$1 = state_81880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_81880__$1,(4),ch);
} else {
if((state_val_81881 === (11))){
var inst_81844 = (state_81880[(9)]);
var inst_81848 = (state_81880[(10)]);
var inst_81858 = (state_81880[(2)]);
var inst_81859 = [];
var inst_81860 = inst_81859.push(inst_81844);
var inst_81840 = inst_81859;
var inst_81841 = inst_81848;
var state_81880__$1 = (function (){var statearr_81892 = state_81880;
(statearr_81892[(7)] = inst_81840);

(statearr_81892[(11)] = inst_81860);

(statearr_81892[(8)] = inst_81841);

(statearr_81892[(12)] = inst_81858);

return statearr_81892;
})();
var statearr_81893_81923 = state_81880__$1;
(statearr_81893_81923[(2)] = null);

(statearr_81893_81923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (9))){
var inst_81840 = (state_81880[(7)]);
var inst_81856 = cljs.core.vec.call(null,inst_81840);
var state_81880__$1 = state_81880;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_81880__$1,(11),out,inst_81856);
} else {
if((state_val_81881 === (5))){
var inst_81844 = (state_81880[(9)]);
var inst_81841 = (state_81880[(8)]);
var inst_81848 = (state_81880[(10)]);
var inst_81848__$1 = f.call(null,inst_81844);
var inst_81849 = cljs.core._EQ_.call(null,inst_81848__$1,inst_81841);
var inst_81850 = cljs.core.keyword_identical_QMARK_.call(null,inst_81841,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_81851 = (inst_81849) || (inst_81850);
var state_81880__$1 = (function (){var statearr_81894 = state_81880;
(statearr_81894[(10)] = inst_81848__$1);

return statearr_81894;
})();
if(cljs.core.truth_(inst_81851)){
var statearr_81895_81924 = state_81880__$1;
(statearr_81895_81924[(1)] = (8));

} else {
var statearr_81896_81925 = state_81880__$1;
(statearr_81896_81925[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (14))){
var inst_81873 = (state_81880[(2)]);
var inst_81874 = cljs.core.async.close_BANG_.call(null,out);
var state_81880__$1 = (function (){var statearr_81898 = state_81880;
(statearr_81898[(13)] = inst_81873);

return statearr_81898;
})();
var statearr_81899_81926 = state_81880__$1;
(statearr_81899_81926[(2)] = inst_81874);

(statearr_81899_81926[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (10))){
var inst_81863 = (state_81880[(2)]);
var state_81880__$1 = state_81880;
var statearr_81900_81927 = state_81880__$1;
(statearr_81900_81927[(2)] = inst_81863);

(statearr_81900_81927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_81881 === (8))){
var inst_81840 = (state_81880[(7)]);
var inst_81844 = (state_81880[(9)]);
var inst_81848 = (state_81880[(10)]);
var inst_81853 = inst_81840.push(inst_81844);
var tmp81897 = inst_81840;
var inst_81840__$1 = tmp81897;
var inst_81841 = inst_81848;
var state_81880__$1 = (function (){var statearr_81901 = state_81880;
(statearr_81901[(7)] = inst_81840__$1);

(statearr_81901[(14)] = inst_81853);

(statearr_81901[(8)] = inst_81841);

return statearr_81901;
})();
var statearr_81902_81928 = state_81880__$1;
(statearr_81902_81928[(2)] = null);

(statearr_81902_81928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___81914,out))
;
return ((function (switch__70820__auto__,c__70934__auto___81914,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_81906 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81906[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_81906[(1)] = (1));

return statearr_81906;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_81880){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_81880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e81907){if((e81907 instanceof Object)){
var ex__70824__auto__ = e81907;
var statearr_81908_81929 = state_81880;
(statearr_81908_81929[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_81880);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e81907;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__81930 = state_81880;
state_81880 = G__81930;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_81880){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_81880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___81914,out))
})();
var state__70936__auto__ = (function (){var statearr_81909 = f__70935__auto__.call(null);
(statearr_81909[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___81914);

return statearr_81909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___81914,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1489355960814