(ns talk.superman
  (:require [cuerdas.core :as str]
            [garden.core :as garden]
            [dommy.core :as dommy :refer-macros [sel sel1]]
            [garden.stylesheet :as gs]
            [mathdoc.cljs.svg :as svg]
            [reagent.core :as r]
            [garden.color :as gc]
            [clojure.walk :as walk]
            [cuerdas.core :as str]
            [mathdoc.cljs.svg :as svg]))

;;; context

(def context
  (let [color {:color/yellow  "#b58900"
               :color/orange  "#cb4b16"
               :color/red     "#dc322f"
               :color/magenta "#d33682"
               :color/violet  "#6c71c4"
               :color/blue    "#268bd2"
               :color/cyan    "#2aa198"
               :color/green   "#859900"
               :color/base03  "#002b36"
               :color/base02  "#073642"
               :color/base01  "#586e75"
               :color/base00  "#657b83"
               :color/base0   "#839496"
               :color/base1   "#93a1a1"
               :color/base2   "#eee8d5"
               :color/base3   "#fdf6e3"}]
    (merge
     color
     {:cycle/radius   "25"
      :font/size      "10px"
      :font/color     (:color/base1 color)
      :font/bigsize   "15px"
      :font/largesize "14px"

      :frag/shieldsos    0
      :frag/tractability    1
      :frag/optimality    2
      :frag/intractability    3
      :frag/practicality    4
      :frag/bigpicture   5
      :frag/applications 6
      :frag/machinelearning 7
      :frag/unconditional 8
      :frag/nplowerbound 9

      :color/lightyellow (gc/as-hex (gc/lighten (:color/yellow color) 8))}
     #_(zipmap
        [:frag/general-alg
         :frag/simplify
         :frag/simple-alg
         :frag/lp
         :frag/physical
         :frag/entropy
         :frag/equations
         :frag/maxentropy
         :frag/exponentialfamily
         :frag/sosapprox
         :frag/quantumsdp
         :frag/quantumrepresent] (repeat 0)))))

;;; refs

(defrecord Ref [key])

(defn ref [k]
  (->Ref k))

(defn ref? [x]
  (instance? Ref x))

(defn expand
  [form]
  (walk/postwalk
   (fn [x]
     (if (ref? x)
       (context (:key x))
       x))
   form))

;;; actual code

(defn process
  []
  (some->
   (dommy/sel1 "#sos-candidate")
   (dommy/set-style!
    :position "absolute"
    :top "450px"
    :left "0px"))
  (some->
   (dommy/sel1 "#sos-candidate")
   (dommy/set-attr!
    :data-fragment-index (:frag/shieldsos context))
   (dommy/add-class!
    "fragment"
    "removevisible"))

  (some->
   (dommy/sel1 "#sos-tractable")
   (dommy/set-style!
    :width "50%"
    :position "absolute"
    :top "-40px"
    :left "-80px")
   (dommy/add-class!
    "blockquote"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/tractability context))
   (dommy/add-class!
    "fragment"))
  (some->
   (dommy/sel1 "#sos-intractable")
   (dommy/set-style!
    :width "50%"
    :position "absolute"
    :top "-40px"
    :left "600px")
   (dommy/add-class!
    "blockquote"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/intractability context))
   (dommy/add-class!
    "fragment"))
  (some->
   (dommy/sel1 "#sos-practical")
   (dommy/set-style!
    :width "50%"
    :position "absolute"
    :top "465px"
    :left "-80px")
   (dommy/add-class!
    "blockquote"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/practicality context))
   (dommy/add-class!
    "fragment"))
  (some->
   (dommy/sel1 "#sos-optimality")
   (dommy/set-style!
    :width "50%"
    :position "absolute"
    :top "465px"
    :left "600px")
   (dommy/add-class!
    "blockquote"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/optimality context))
   (dommy/add-class!
    "fragment"))

  (some->
   (dommy/sel1 "#sos-bigpicture")
   (dommy/set-style!
    :position "absolute"
    :width "1000px"
    :top "200px"
    :z-index "100"
    :left "30px")
   (dommy/add-class!
    "blockquote"
    "border-box"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/bigpicture context))
   (dommy/add-class!
    "fragment"))
  (some->
   (dommy/sel1 "#sos-removebigpicture")
   (dommy/set-attr!
    :data-fragment-index (:frag/machinelearning context))
   (dommy/add-class!
    "fragment"
    "removevisible"))
  (some->
   (dommy/sel1 "#sos-removepractical")
   (dommy/set-attr!
    :data-fragment-index (:frag/machinelearning context))
   (dommy/add-class!
    "fragment"
    "removevisible"))
  (some->
   (dommy/sel1 "#sos-removeintractable")
   (dommy/set-attr!
    :data-fragment-index (:frag/machinelearning context))
   (dommy/add-class!
    "fragment"
    "removevisible"))

  (some->
   (dommy/sel1 "#sos-machinelearning")
   (dommy/set-style!
    :width "600px"
    :position "absolute"
    :background (:color/base2 context)
    :z-index 11
    :top "-20px"
    :left "520px")
   (dommy/add-class!
    "blockquote"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/machinelearning context))
   (dommy/add-class!
    "fragment"
    "transition-delay"))
  (some->
   (dommy/sel1 "#sos-unconditional")
   (dommy/set-style!
    :width "600px"
    :background (:color/base2 context)
    :z-index 11
    :position "absolute"
    :top "510px"
    :left "-80px")
   (dommy/add-class!
    "blockquote"
    "background-more-shaded")
   (dommy/set-attr!
    :data-fragment-index (:frag/unconditional context))
   (dommy/add-class!
    "fragment")))

(def right-arrow
  [:g
   {:transform "scale(2)"}
   [:g
    {:transform "translate(20,0)"}
    [:g
     {:transform "translate(0,-16.2)"}
     [:path {:d "M31 16l-15-15v9h-16v12h16v9z"
             :transform "scale(2.5,1.0)"
             :fill (ref :color/lightyellow)}]]]])

(def left-arrow
  [:g
   {:transform "scale(-1.0,1.0)"}
   right-arrow])

(defn mjsvgtypeset [x]
  (try
    (js/MathJax.Hub.Queue
     #js ["Reprocess" js/MathJax.Hub x]
     #js ["Typeset" js/MathJax.Hub x])
    (catch js/Error e
      (js/console.log e))))

(def soslogo
  [:g
   {:transform "scale(2)"}
   [:g
    {:transform "translate(-40,-15)"}
    [:path {:d (svg/path-d :M 0 0 :l 40 40 :l 40 -40 :l -10 -10 :l -60 0 :z)
            :fill (ref :color/lightyellow)
            :stroke (ref :color/red)
            :stroke-width 3}]]
   [:text
    {:font-size "34px"
     :fill (ref :color/red)
     :dy -1
     :text-anchor "middle"
     :alignment-baseline "baseline"
     :font-weight "bold"}
    "SOS"]])

(defn sosresearch []
  (expand
   [:div
    [:div.fragment.removevisible
     {:data-fragment-index (ref :frag/machinelearning)
      :style
      {:transition-duration "1s"}}
     [:div#sosshading.fragment
      {:data-fragment-index (ref :frag/bigpicture)
       :style
       {:position            "absolute"
        :transition-duration "1s"
        :top                 "-1000px"
        :z-index             10
        :left                "-1000px"
        :width               "4000px"
        :height              "4000px"
        :background          "rgba(0,0,0,0.7)"}}]]
    [:div.fragment.transition-delay
     {:data-fragment-index (ref :frag/shieldsos)}
     [:svg
      {:viewBox "-380 -250 760 500"
       :style   {#_#_:background       "rgba(255,255,255,0.1)"
                 :z-index          9
                 :transform        "scale(1.3)"
                 :margin-top       "-25px"
                 :transform-origin "top center"
                 :position         "absolute"
                 :top              "0px"
                 :left             "0px"}}
      right-arrow
      left-arrow
      soslogo
      [:text
       {:font-size          "34px"
        :fill               (ref :color/red)
        :dx                 -280
        :text-anchor        "middle"
        :alignment-baseline "middle"
        :font-weight        "bold"}
       "strengths"]
      [:text
       {:font-size          "34px"
        :fill               (ref :color/red)
        :dx                 280
        :text-anchor        "middle"
        :alignment-baseline "middle"
        :font-weight        "bold"}
       "limitations"]
      [:g.fragment.transition-delay
       {:transform "translate(-58,-200)"
        :data-fragment-index (ref :frag/machinelearning)}
       [:path
        {:d    (svg/path-d :m 0 0 :l 100 30 :l 0 -40 :z)
         :fill (ref :color/base2)}]]
      [:g.fragment
       {:transform "translate(50,80)"
        :data-fragment-index (ref :frag/unconditional)}
       [:g
        {:transform "scale(-1,1)"}
        [:path
         {:d    (svg/path-d :m 0 0 :l 100 30 :l 0 -40 :z)
          :fill (ref :color/base2)}]]]]]]))

(defn init []
  (process)
  (some->> "sosresearch"
           (.getElementById js/document)
           (r/render [sosresearch])))
