(ns talk.style
  (:require garden.color
            [garden.core :as garden]
            [reagent.core :as r]
            [garden.stylesheet :as gs]))

(def color
  {:yellow  "#b58900"
   :orange  "#cb4b16"
   :red     "#dc322f"
   :magenta "#d33682"
   :violet  "#6c71c4"
   :blue    "#268bd2"
   :cyan    "#2aa198"
   :green   "#859900"
   :base03  "#002b36"
   :base02  "#073642"
   :base01  "#586e75"
   :base00  "#657b83"
   :base0   "#839496"
   :base1   "#93a1a1"
   :base2   "#eee8d5"
   :base3   "#fdf6e3"})

(defn helper-style []
  (list
   [:.base02
    {:color (:base02 color)}]
   [:.base01
    {:color (:base01 color)}]
   [:.base03
    {:color (:base03 color)}]
   [:.clearboth
    {:clear "both"}]
   [:.clearfix::after
    {:content "\"\""
     :display "block"
     :clear "both"}]
   [:.block
    {:display "block"}]
   [:.inlineblock
    {:display "inline-block"}]
   [:.bigmathhighlight
    {:display "inline-block"
     :filter "brightness(1.5)"
     :transform "scale(1.3)"
     :font-weight "bold"
     :color "white"}]
   [:.absolute
    {:position "absolute"}]
   [:.relative
    {:position "relative"}]
   [:.yellow
    {:color (:yellow color)}]
   [:.slide-background-faded.slide-background
    {:filter "opacity(50%)"}]
   [:.slide-background-more-faded.slide-background
    {:filter "opacity(25%)"}]
   [:.pull-up
    {:margin-top "-15px"}]
   [:.pull-bottom-up
    {:margin-bottom "-15px"}]
   [:.magenta
    {:color (:magenta color)}]
   [:.blue
    {:color (:blue color)}]
   [:.red
    {:color (:red color)}]
   [:.orange
    {:color (:orange color)}]
   [:.green
    {:color (:green color)}]
   [:.cyan
    {:color (:cyan color)}]
   [:.fullwidth
    {:width "100%"}]
   [:.padding-bottom
    {:padding-bottom "15px"}]
   [:.small :.smaller :.SMALL
    {:color     "#93a1a1"}]
   [:.small
    {:font-size "80%"}]
   [:.smaller
    {:font-size "70%"}]
   [:.SMALL
    {:font-size "60%"}]
   [:.header
    {:text-transform "uppercase"}]
   [:.transform-origin-center-top
    {:transform-origin "center top"}]
   [:.transform-origin-left-top
    {:transform-origin "left top"}]
   [:.nomarginbottom
    {:margin-bottom "0px"}]
   [:.background-color
    {:background (:base03 color)}]
   [:.fake-background
    {:background (:base03 color)
     :width "100%"
     :margin "0px -20px"
     :padding "0px 20px"}]
   [:.background-shaded
    {:background (-> (:base03 color)
                     (garden.color/as-rgb)
                     (garden.color/darken 1)
                     (assoc :alpha 0.5))}]
   [:.background-more-shaded
    {:background (-> (:base03 color)
                     (garden.color/as-rgb)
                     (assoc :alpha 0.8))}]
   [:.border-box
    {:border-width "6px"
     :border-color (:yellow color)}]
   [:.url
    {:font-family "Source Code Pro, Courier"
     :color       (:magenta color)}]))

(def blockquote
  {:font-style "normal"
   :border-radius "10px 10px"
   :background "rgba(255, 255, 255, 0.10)"
   :border-color "rgba(255, 255, 255, 0.30)"
   :border-width "3px"
   :border-style "solid"
   :width "100%"
   :margin "20px -15px"
   :padding "0px 15px"})

(defn fragment-style []
  (list
   [:&.appearfont
    {:font-size "0px"}
    [:&.visible
     {:font-size "100%"}]]
   [:&.removevisible
    {:visibility "visible"
     :opacity    1}
    [:&.visible
     {:opacity    0}]]
   [:&.removefont
    {:visibility "visible"
     :opacity    1}
    [:&.visible
     {:opacity   0
      :font-size "0px"}]]
   [:&.removedisplay
    {:visibility "visible"
     :opacity    1}
    [:&.visible
     {:display   "none"}]]
   [:&.removescalex
    {:visibility "visible"
     :opacity    1}
    [:&.visible
     {:opacity   0
      :transform "scale(0,1)"}]]
   
   [:&.marginremove
    {:opacity    1
     :transition "all 1s ease"
     :margin-top "-15px"
     :visibility "visible"}
    [:&.visible
     {:margin-top "-100%"
      :opacity    0}]]
   [:&.marginappear
    {:opacity    1
     :transition "all 1s ease"
     :margin-top "-100%"
     :visibility "visible"}
    [:&.visible
     {:margin-top "0px"
      :opacity    0}]]
   [:&.slightly-fade-out
    {:opacity    1
     :visibility "visible"}
    [:&.visible
     {:opacity 0.7}]]
   [:&.appeargrow
    {:opacity    1
     :transform  "scale(0.0)"
     :visibility "visible"}
    [:&.visible
     {:transform "scale(1.0)"}]]
   [:&.appearscalex
    {:opacity    1
     :transform  "scale(0.0,1.0)"
     :visibility "visible"}
    [:&.visible
     {:transform "scale(1.0,1.0)"}]]
   [:&.addblockquote
    {:opacity    1
     :visibility "visible"}
    [:&.visible
     blockquote]]
   [:&.transition-delay
    {:transition-delay "0.7s"}]
   [:&.fast-transition
    {:transition-duration "0.2s"}]
   [:&.slow-transition
    {:transition-duration "1s"}]))



(defn theme []
  (list
   [:&
    {:background (:base03 color)
     :font-size "38px"}]
   [".slides > section" ".slides > section > section"
    {:padding 0}]
   [:strong :h1
    {:color (:yellow color)}]
   [:em
    {:color (:magenta color)}]
   [:.math
    {:color (:blue color)}]
   [:h2 :h3
    {:color (:cyan color)}]
   [:h2 :h3
    {:font-size "1.3em"}]))

(defn style []
  [:style
   (garden/css
    (gs/at-keyframes
     "dash"
     [:to
      {:stroke-dashoffset 0}])
    [:.reveal
     (theme)
     (helper-style)
     [:.wrapmargin
      {:overflow      "hidden"
       :padding-left  "30px"
       :margin-left   "-30px"
       :margin-right  "-30px"
       :padding-right "30px"}]
     [:.slides
      [:section
       [:.fragment
        (fragment-style)]]]
     [:table
      {:width "100%"}
      [:th
       {:color         (color :magenta)
        :border-bottom "2px solid rgba(255,255,255,0.5)"}]]
     [:tr.noborder :.tbodynoborder
      [:td
       {:border "none"}]]])])

(defn init []
  (print "style init")
  (some->>
   "stylecljs"
   (.getElementById js/document)
   (r/render [style])))

#_(init)
