// Compiled by ClojureScript 1.9.494 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy.core.selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__66187__auto__ = elem.textContent;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var args73998 = [];
var len__67408__auto___74001 = arguments.length;
var i__67409__auto___74002 = (0);
while(true){
if((i__67409__auto___74002 < len__67408__auto___74001)){
args73998.push((arguments[i__67409__auto___74002]));

var G__74003 = (i__67409__auto___74002 + (1));
i__67409__auto___74002 = G__74003;
continue;
} else {
}
break;
}

var G__74000 = args73998.length;
switch (G__74000) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73998.length)].join('')));

}
});

dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});

dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});

dommy.core.style.cljs$lang$maxFixedArity = 2;

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.call(null,elem,k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto__ = elem.classList;
if(cljs.core.truth_(temp__6751__auto__)){
var class_list = temp__6751__auto__;
return class_list.contains(c__$1);
} else {
var temp__6753__auto__ = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(temp__6753__auto__)){
var class_name = temp__6753__auto__;
var temp__6753__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);
if(cljs.core.truth_(temp__6753__auto____$1)){
var i = temp__6753__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var args74005 = [];
var len__67408__auto___74008 = arguments.length;
var i__67409__auto___74009 = (0);
while(true){
if((i__67409__auto___74009 < len__67408__auto___74008)){
args74005.push((arguments[i__67409__auto___74009]));

var G__74010 = (i__67409__auto___74009 + (1));
i__67409__auto___74009 = G__74010;
continue;
} else {
}
break;
}

var G__74007 = args74005.length;
switch (G__74007) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74005.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var args74013 = [];
var len__67408__auto___74016 = arguments.length;
var i__67409__auto___74017 = (0);
while(true){
if((i__67409__auto___74017 < len__67408__auto___74016)){
args74013.push((arguments[i__67409__auto___74017]));

var G__74018 = (i__67409__auto___74017 + (1));
i__67409__auto___74017 = G__74018;
continue;
} else {
}
break;
}

var G__74015 = args74013.length;
switch (G__74015) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74013.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__74012_SHARP_){
return !((p1__74012_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.call(null,document.body,elem,selector);
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if(!((void 0 === elem.textContent))){
elem.textContent = text;
} else {
elem.innerText = text;
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
elem.innerHTML = html;

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
elem.value = value;

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return elem.className = c;
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74032 = arguments.length;
var i__67409__auto___74033 = (0);
while(true){
if((i__67409__auto___74033 < len__67408__auto___74032)){
args__67415__auto__.push((arguments[i__67409__auto___74033]));

var G__74034 = (i__67409__auto___74033 + (1));
i__67409__auto___74033 = G__74034;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__74022_74035 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__74023_74036 = null;
var count__74024_74037 = (0);
var i__74025_74038 = (0);
while(true){
if((i__74025_74038 < count__74024_74037)){
var vec__74026_74039 = cljs.core._nth.call(null,chunk__74023_74036,i__74025_74038);
var k_74040 = cljs.core.nth.call(null,vec__74026_74039,(0),null);
var v_74041 = cljs.core.nth.call(null,vec__74026_74039,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_74040),v_74041);

var G__74042 = seq__74022_74035;
var G__74043 = chunk__74023_74036;
var G__74044 = count__74024_74037;
var G__74045 = (i__74025_74038 + (1));
seq__74022_74035 = G__74042;
chunk__74023_74036 = G__74043;
count__74024_74037 = G__74044;
i__74025_74038 = G__74045;
continue;
} else {
var temp__6753__auto___74046 = cljs.core.seq.call(null,seq__74022_74035);
if(temp__6753__auto___74046){
var seq__74022_74047__$1 = temp__6753__auto___74046;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74022_74047__$1)){
var c__67098__auto___74048 = cljs.core.chunk_first.call(null,seq__74022_74047__$1);
var G__74049 = cljs.core.chunk_rest.call(null,seq__74022_74047__$1);
var G__74050 = c__67098__auto___74048;
var G__74051 = cljs.core.count.call(null,c__67098__auto___74048);
var G__74052 = (0);
seq__74022_74035 = G__74049;
chunk__74023_74036 = G__74050;
count__74024_74037 = G__74051;
i__74025_74038 = G__74052;
continue;
} else {
var vec__74029_74053 = cljs.core.first.call(null,seq__74022_74047__$1);
var k_74054 = cljs.core.nth.call(null,vec__74029_74053,(0),null);
var v_74055 = cljs.core.nth.call(null,vec__74029_74053,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_74054),v_74055);

var G__74056 = cljs.core.next.call(null,seq__74022_74047__$1);
var G__74057 = null;
var G__74058 = (0);
var G__74059 = (0);
seq__74022_74035 = G__74056;
chunk__74023_74036 = G__74057;
count__74024_74037 = G__74058;
i__74025_74038 = G__74059;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq74020){
var G__74021 = cljs.core.first.call(null,seq74020);
var seq74020__$1 = cljs.core.next.call(null,seq74020);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74021,seq74020__$1);
});

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74066 = arguments.length;
var i__67409__auto___74067 = (0);
while(true){
if((i__67409__auto___74067 < len__67408__auto___74066)){
args__67415__auto__.push((arguments[i__67409__auto___74067]));

var G__74068 = (i__67409__auto___74067 + (1));
i__67409__auto___74067 = G__74068;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__74062_74069 = cljs.core.seq.call(null,keywords);
var chunk__74063_74070 = null;
var count__74064_74071 = (0);
var i__74065_74072 = (0);
while(true){
if((i__74065_74072 < count__74064_74071)){
var kw_74073 = cljs.core._nth.call(null,chunk__74063_74070,i__74065_74072);
style.removeProperty(dommy.utils.as_str.call(null,kw_74073));

var G__74074 = seq__74062_74069;
var G__74075 = chunk__74063_74070;
var G__74076 = count__74064_74071;
var G__74077 = (i__74065_74072 + (1));
seq__74062_74069 = G__74074;
chunk__74063_74070 = G__74075;
count__74064_74071 = G__74076;
i__74065_74072 = G__74077;
continue;
} else {
var temp__6753__auto___74078 = cljs.core.seq.call(null,seq__74062_74069);
if(temp__6753__auto___74078){
var seq__74062_74079__$1 = temp__6753__auto___74078;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74062_74079__$1)){
var c__67098__auto___74080 = cljs.core.chunk_first.call(null,seq__74062_74079__$1);
var G__74081 = cljs.core.chunk_rest.call(null,seq__74062_74079__$1);
var G__74082 = c__67098__auto___74080;
var G__74083 = cljs.core.count.call(null,c__67098__auto___74080);
var G__74084 = (0);
seq__74062_74069 = G__74081;
chunk__74063_74070 = G__74082;
count__74064_74071 = G__74083;
i__74065_74072 = G__74084;
continue;
} else {
var kw_74085 = cljs.core.first.call(null,seq__74062_74079__$1);
style.removeProperty(dommy.utils.as_str.call(null,kw_74085));

var G__74086 = cljs.core.next.call(null,seq__74062_74079__$1);
var G__74087 = null;
var G__74088 = (0);
var G__74089 = (0);
seq__74062_74069 = G__74086;
chunk__74063_74070 = G__74087;
count__74064_74071 = G__74088;
i__74065_74072 = G__74089;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq74060){
var G__74061 = cljs.core.first.call(null,seq74060);
var seq74060__$1 = cljs.core.next.call(null,seq74060);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74061,seq74060__$1);
});

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74102 = arguments.length;
var i__67409__auto___74103 = (0);
while(true){
if((i__67409__auto___74103 < len__67408__auto___74102)){
args__67415__auto__.push((arguments[i__67409__auto___74103]));

var G__74104 = (i__67409__auto___74103 + (1));
i__67409__auto___74103 = G__74104;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__74092_74105 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__74093_74106 = null;
var count__74094_74107 = (0);
var i__74095_74108 = (0);
while(true){
if((i__74095_74108 < count__74094_74107)){
var vec__74096_74109 = cljs.core._nth.call(null,chunk__74093_74106,i__74095_74108);
var k_74110 = cljs.core.nth.call(null,vec__74096_74109,(0),null);
var v_74111 = cljs.core.nth.call(null,vec__74096_74109,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_74110,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_74111),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''));

var G__74112 = seq__74092_74105;
var G__74113 = chunk__74093_74106;
var G__74114 = count__74094_74107;
var G__74115 = (i__74095_74108 + (1));
seq__74092_74105 = G__74112;
chunk__74093_74106 = G__74113;
count__74094_74107 = G__74114;
i__74095_74108 = G__74115;
continue;
} else {
var temp__6753__auto___74116 = cljs.core.seq.call(null,seq__74092_74105);
if(temp__6753__auto___74116){
var seq__74092_74117__$1 = temp__6753__auto___74116;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74092_74117__$1)){
var c__67098__auto___74118 = cljs.core.chunk_first.call(null,seq__74092_74117__$1);
var G__74119 = cljs.core.chunk_rest.call(null,seq__74092_74117__$1);
var G__74120 = c__67098__auto___74118;
var G__74121 = cljs.core.count.call(null,c__67098__auto___74118);
var G__74122 = (0);
seq__74092_74105 = G__74119;
chunk__74093_74106 = G__74120;
count__74094_74107 = G__74121;
i__74095_74108 = G__74122;
continue;
} else {
var vec__74099_74123 = cljs.core.first.call(null,seq__74092_74117__$1);
var k_74124 = cljs.core.nth.call(null,vec__74099_74123,(0),null);
var v_74125 = cljs.core.nth.call(null,vec__74099_74123,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_74124,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_74125),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''));

var G__74126 = cljs.core.next.call(null,seq__74092_74117__$1);
var G__74127 = null;
var G__74128 = (0);
var G__74129 = (0);
seq__74092_74105 = G__74126;
chunk__74093_74106 = G__74127;
count__74094_74107 = G__74128;
i__74095_74108 = G__74129;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq74090){
var G__74091 = cljs.core.first.call(null,seq74090);
var seq74090__$1 = cljs.core.next.call(null,seq74090);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74091,seq74090__$1);
});

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var args74130 = [];
var len__67408__auto___74149 = arguments.length;
var i__67409__auto___74150 = (0);
while(true){
if((i__67409__auto___74150 < len__67408__auto___74149)){
args74130.push((arguments[i__67409__auto___74150]));

var G__74151 = (i__67409__auto___74150 + (1));
i__67409__auto___74150 = G__74151;
continue;
} else {
}
break;
}

var G__74136 = args74130.length;
switch (G__74136) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args74130.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__67431__auto__);

}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.call(null,elem,k,dommy.utils.as_str.call(null,k));
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__74137 = elem;
(G__74137[k__$1] = v);

return G__74137;
} else {
var G__74138 = elem;
G__74138.setAttribute(k__$1,v);

return G__74138;
}
} else {
return null;
}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__74139_74153 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__74140_74154 = null;
var count__74141_74155 = (0);
var i__74142_74156 = (0);
while(true){
if((i__74142_74156 < count__74141_74155)){
var vec__74143_74157 = cljs.core._nth.call(null,chunk__74140_74154,i__74142_74156);
var k_74158__$1 = cljs.core.nth.call(null,vec__74143_74157,(0),null);
var v_74159__$1 = cljs.core.nth.call(null,vec__74143_74157,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_74158__$1,v_74159__$1);

var G__74160 = seq__74139_74153;
var G__74161 = chunk__74140_74154;
var G__74162 = count__74141_74155;
var G__74163 = (i__74142_74156 + (1));
seq__74139_74153 = G__74160;
chunk__74140_74154 = G__74161;
count__74141_74155 = G__74162;
i__74142_74156 = G__74163;
continue;
} else {
var temp__6753__auto___74164 = cljs.core.seq.call(null,seq__74139_74153);
if(temp__6753__auto___74164){
var seq__74139_74165__$1 = temp__6753__auto___74164;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74139_74165__$1)){
var c__67098__auto___74166 = cljs.core.chunk_first.call(null,seq__74139_74165__$1);
var G__74167 = cljs.core.chunk_rest.call(null,seq__74139_74165__$1);
var G__74168 = c__67098__auto___74166;
var G__74169 = cljs.core.count.call(null,c__67098__auto___74166);
var G__74170 = (0);
seq__74139_74153 = G__74167;
chunk__74140_74154 = G__74168;
count__74141_74155 = G__74169;
i__74142_74156 = G__74170;
continue;
} else {
var vec__74146_74171 = cljs.core.first.call(null,seq__74139_74165__$1);
var k_74172__$1 = cljs.core.nth.call(null,vec__74146_74171,(0),null);
var v_74173__$1 = cljs.core.nth.call(null,vec__74146_74171,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_74172__$1,v_74173__$1);

var G__74174 = cljs.core.next.call(null,seq__74139_74165__$1);
var G__74175 = null;
var G__74176 = (0);
var G__74177 = (0);
seq__74139_74153 = G__74174;
chunk__74140_74154 = G__74175;
count__74141_74155 = G__74176;
i__74142_74156 = G__74177;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq74131){
var G__74132 = cljs.core.first.call(null,seq74131);
var seq74131__$1 = cljs.core.next.call(null,seq74131);
var G__74133 = cljs.core.first.call(null,seq74131__$1);
var seq74131__$2 = cljs.core.next.call(null,seq74131__$1);
var G__74134 = cljs.core.first.call(null,seq74131__$2);
var seq74131__$3 = cljs.core.next.call(null,seq74131__$2);
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74132,G__74133,G__74134,seq74131__$3);
});

dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var args74178 = [];
var len__67408__auto___74188 = arguments.length;
var i__67409__auto___74189 = (0);
while(true){
if((i__67409__auto___74189 < len__67408__auto___74188)){
args74178.push((arguments[i__67409__auto___74189]));

var G__74190 = (i__67409__auto___74189 + (1));
i__67409__auto___74189 = G__74190;
continue;
} else {
}
break;
}

var G__74183 = args74178.length;
switch (G__74183) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args74178.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_74192__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_74192__$1))){
dommy.core.set_class_BANG_.call(null,elem,"");
} else {
elem.removeAttribute(k_74192__$1);
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__74184_74193 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__74185_74194 = null;
var count__74186_74195 = (0);
var i__74187_74196 = (0);
while(true){
if((i__74187_74196 < count__74186_74195)){
var k_74197__$1 = cljs.core._nth.call(null,chunk__74185_74194,i__74187_74196);
dommy.core.remove_attr_BANG_.call(null,elem,k_74197__$1);

var G__74198 = seq__74184_74193;
var G__74199 = chunk__74185_74194;
var G__74200 = count__74186_74195;
var G__74201 = (i__74187_74196 + (1));
seq__74184_74193 = G__74198;
chunk__74185_74194 = G__74199;
count__74186_74195 = G__74200;
i__74187_74196 = G__74201;
continue;
} else {
var temp__6753__auto___74202 = cljs.core.seq.call(null,seq__74184_74193);
if(temp__6753__auto___74202){
var seq__74184_74203__$1 = temp__6753__auto___74202;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74184_74203__$1)){
var c__67098__auto___74204 = cljs.core.chunk_first.call(null,seq__74184_74203__$1);
var G__74205 = cljs.core.chunk_rest.call(null,seq__74184_74203__$1);
var G__74206 = c__67098__auto___74204;
var G__74207 = cljs.core.count.call(null,c__67098__auto___74204);
var G__74208 = (0);
seq__74184_74193 = G__74205;
chunk__74185_74194 = G__74206;
count__74186_74195 = G__74207;
i__74187_74196 = G__74208;
continue;
} else {
var k_74209__$1 = cljs.core.first.call(null,seq__74184_74203__$1);
dommy.core.remove_attr_BANG_.call(null,elem,k_74209__$1);

var G__74210 = cljs.core.next.call(null,seq__74184_74203__$1);
var G__74211 = null;
var G__74212 = (0);
var G__74213 = (0);
seq__74184_74193 = G__74210;
chunk__74185_74194 = G__74211;
count__74186_74195 = G__74212;
i__74187_74196 = G__74213;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq74179){
var G__74180 = cljs.core.first.call(null,seq74179);
var seq74179__$1 = cljs.core.next.call(null,seq74179);
var G__74181 = cljs.core.first.call(null,seq74179__$1);
var seq74179__$2 = cljs.core.next.call(null,seq74179__$1);
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74180,G__74181,seq74179__$2);
});

dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var args74214 = [];
var len__67408__auto___74217 = arguments.length;
var i__67409__auto___74218 = (0);
while(true){
if((i__67409__auto___74218 < len__67408__auto___74217)){
args74214.push((arguments[i__67409__auto___74218]));

var G__74219 = (i__67409__auto___74218 + (1));
i__67409__auto___74218 = G__74219;
continue;
} else {
}
break;
}

var G__74216 = args74214.length;
switch (G__74216) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74214.length)].join('')));

}
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.call(null,elem,k);
} else {
return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});

dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var args74221 = [];
var len__67408__auto___74239 = arguments.length;
var i__67409__auto___74240 = (0);
while(true){
if((i__67409__auto___74240 < len__67408__auto___74239)){
args74221.push((arguments[i__67409__auto___74240]));

var G__74241 = (i__67409__auto___74240 + (1));
i__67409__auto___74240 = G__74241;
continue;
} else {
}
break;
}

var G__74226 = args74221.length;
switch (G__74226) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args74221.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);
if(cljs.core.seq.call(null,classes__$1)){
var temp__6751__auto___74243 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___74243)){
var class_list_74244 = temp__6751__auto___74243;
var seq__74227_74245 = cljs.core.seq.call(null,classes__$1);
var chunk__74228_74246 = null;
var count__74229_74247 = (0);
var i__74230_74248 = (0);
while(true){
if((i__74230_74248 < count__74229_74247)){
var c_74249 = cljs.core._nth.call(null,chunk__74228_74246,i__74230_74248);
class_list_74244.add(c_74249);

var G__74250 = seq__74227_74245;
var G__74251 = chunk__74228_74246;
var G__74252 = count__74229_74247;
var G__74253 = (i__74230_74248 + (1));
seq__74227_74245 = G__74250;
chunk__74228_74246 = G__74251;
count__74229_74247 = G__74252;
i__74230_74248 = G__74253;
continue;
} else {
var temp__6753__auto___74254 = cljs.core.seq.call(null,seq__74227_74245);
if(temp__6753__auto___74254){
var seq__74227_74255__$1 = temp__6753__auto___74254;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74227_74255__$1)){
var c__67098__auto___74256 = cljs.core.chunk_first.call(null,seq__74227_74255__$1);
var G__74257 = cljs.core.chunk_rest.call(null,seq__74227_74255__$1);
var G__74258 = c__67098__auto___74256;
var G__74259 = cljs.core.count.call(null,c__67098__auto___74256);
var G__74260 = (0);
seq__74227_74245 = G__74257;
chunk__74228_74246 = G__74258;
count__74229_74247 = G__74259;
i__74230_74248 = G__74260;
continue;
} else {
var c_74261 = cljs.core.first.call(null,seq__74227_74255__$1);
class_list_74244.add(c_74261);

var G__74262 = cljs.core.next.call(null,seq__74227_74255__$1);
var G__74263 = null;
var G__74264 = (0);
var G__74265 = (0);
seq__74227_74245 = G__74262;
chunk__74228_74246 = G__74263;
count__74229_74247 = G__74264;
i__74230_74248 = G__74265;
continue;
}
} else {
}
}
break;
}
} else {
var seq__74231_74266 = cljs.core.seq.call(null,classes__$1);
var chunk__74232_74267 = null;
var count__74233_74268 = (0);
var i__74234_74269 = (0);
while(true){
if((i__74234_74269 < count__74233_74268)){
var c_74270 = cljs.core._nth.call(null,chunk__74232_74267,i__74234_74269);
var class_name_74271 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_74271,c_74270))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_74271 === ""))?c_74270:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_74271),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_74270)].join('')));
}

var G__74272 = seq__74231_74266;
var G__74273 = chunk__74232_74267;
var G__74274 = count__74233_74268;
var G__74275 = (i__74234_74269 + (1));
seq__74231_74266 = G__74272;
chunk__74232_74267 = G__74273;
count__74233_74268 = G__74274;
i__74234_74269 = G__74275;
continue;
} else {
var temp__6753__auto___74276 = cljs.core.seq.call(null,seq__74231_74266);
if(temp__6753__auto___74276){
var seq__74231_74277__$1 = temp__6753__auto___74276;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74231_74277__$1)){
var c__67098__auto___74278 = cljs.core.chunk_first.call(null,seq__74231_74277__$1);
var G__74279 = cljs.core.chunk_rest.call(null,seq__74231_74277__$1);
var G__74280 = c__67098__auto___74278;
var G__74281 = cljs.core.count.call(null,c__67098__auto___74278);
var G__74282 = (0);
seq__74231_74266 = G__74279;
chunk__74232_74267 = G__74280;
count__74233_74268 = G__74281;
i__74234_74269 = G__74282;
continue;
} else {
var c_74283 = cljs.core.first.call(null,seq__74231_74277__$1);
var class_name_74284 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_74284,c_74283))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_74284 === ""))?c_74283:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_74284),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_74283)].join('')));
}

var G__74285 = cljs.core.next.call(null,seq__74231_74277__$1);
var G__74286 = null;
var G__74287 = (0);
var G__74288 = (0);
seq__74231_74266 = G__74285;
chunk__74232_74267 = G__74286;
count__74233_74268 = G__74287;
i__74234_74269 = G__74288;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__74235_74289 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__74236_74290 = null;
var count__74237_74291 = (0);
var i__74238_74292 = (0);
while(true){
if((i__74238_74292 < count__74237_74291)){
var c_74293 = cljs.core._nth.call(null,chunk__74236_74290,i__74238_74292);
dommy.core.add_class_BANG_.call(null,elem,c_74293);

var G__74294 = seq__74235_74289;
var G__74295 = chunk__74236_74290;
var G__74296 = count__74237_74291;
var G__74297 = (i__74238_74292 + (1));
seq__74235_74289 = G__74294;
chunk__74236_74290 = G__74295;
count__74237_74291 = G__74296;
i__74238_74292 = G__74297;
continue;
} else {
var temp__6753__auto___74298 = cljs.core.seq.call(null,seq__74235_74289);
if(temp__6753__auto___74298){
var seq__74235_74299__$1 = temp__6753__auto___74298;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74235_74299__$1)){
var c__67098__auto___74300 = cljs.core.chunk_first.call(null,seq__74235_74299__$1);
var G__74301 = cljs.core.chunk_rest.call(null,seq__74235_74299__$1);
var G__74302 = c__67098__auto___74300;
var G__74303 = cljs.core.count.call(null,c__67098__auto___74300);
var G__74304 = (0);
seq__74235_74289 = G__74301;
chunk__74236_74290 = G__74302;
count__74237_74291 = G__74303;
i__74238_74292 = G__74304;
continue;
} else {
var c_74305 = cljs.core.first.call(null,seq__74235_74299__$1);
dommy.core.add_class_BANG_.call(null,elem,c_74305);

var G__74306 = cljs.core.next.call(null,seq__74235_74299__$1);
var G__74307 = null;
var G__74308 = (0);
var G__74309 = (0);
seq__74235_74289 = G__74306;
chunk__74236_74290 = G__74307;
count__74237_74291 = G__74308;
i__74238_74292 = G__74309;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq74222){
var G__74223 = cljs.core.first.call(null,seq74222);
var seq74222__$1 = cljs.core.next.call(null,seq74222);
var G__74224 = cljs.core.first.call(null,seq74222__$1);
var seq74222__$2 = cljs.core.next.call(null,seq74222__$1);
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74223,G__74224,seq74222__$2);
});

dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var args74310 = [];
var len__67408__auto___74320 = arguments.length;
var i__67409__auto___74321 = (0);
while(true){
if((i__67409__auto___74321 < len__67408__auto___74320)){
args74310.push((arguments[i__67409__auto___74321]));

var G__74322 = (i__67409__auto___74321 + (1));
i__67409__auto___74321 = G__74322;
continue;
} else {
}
break;
}

var G__74315 = args74310.length;
switch (G__74315) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args74310.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto___74324 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___74324)){
var class_list_74325 = temp__6751__auto___74324;
class_list_74325.remove(c__$1);
} else {
var class_name_74326 = dommy.core.class$.call(null,elem);
var new_class_name_74327 = dommy.utils.remove_class_str.call(null,class_name_74326,c__$1);
if((class_name_74326 === new_class_name_74327)){
} else {
dommy.core.set_class_BANG_.call(null,elem,new_class_name_74327);
}
}

return elem;
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__74316 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__74317 = null;
var count__74318 = (0);
var i__74319 = (0);
while(true){
if((i__74319 < count__74318)){
var c = cljs.core._nth.call(null,chunk__74317,i__74319);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__74328 = seq__74316;
var G__74329 = chunk__74317;
var G__74330 = count__74318;
var G__74331 = (i__74319 + (1));
seq__74316 = G__74328;
chunk__74317 = G__74329;
count__74318 = G__74330;
i__74319 = G__74331;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__74316);
if(temp__6753__auto__){
var seq__74316__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74316__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__74316__$1);
var G__74332 = cljs.core.chunk_rest.call(null,seq__74316__$1);
var G__74333 = c__67098__auto__;
var G__74334 = cljs.core.count.call(null,c__67098__auto__);
var G__74335 = (0);
seq__74316 = G__74332;
chunk__74317 = G__74333;
count__74318 = G__74334;
i__74319 = G__74335;
continue;
} else {
var c = cljs.core.first.call(null,seq__74316__$1);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__74336 = cljs.core.next.call(null,seq__74316__$1);
var G__74337 = null;
var G__74338 = (0);
var G__74339 = (0);
seq__74316 = G__74336;
chunk__74317 = G__74337;
count__74318 = G__74338;
i__74319 = G__74339;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq74311){
var G__74312 = cljs.core.first.call(null,seq74311);
var seq74311__$1 = cljs.core.next.call(null,seq74311);
var G__74313 = cljs.core.first.call(null,seq74311__$1);
var seq74311__$2 = cljs.core.next.call(null,seq74311__$1);
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74312,G__74313,seq74311__$2);
});

dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var args74340 = [];
var len__67408__auto___74343 = arguments.length;
var i__67409__auto___74344 = (0);
while(true){
if((i__67409__auto___74344 < len__67408__auto___74343)){
args74340.push((arguments[i__67409__auto___74344]));

var G__74345 = (i__67409__auto___74344 + (1));
i__67409__auto___74344 = G__74345;
continue;
} else {
}
break;
}

var G__74342 = args74340.length;
switch (G__74342) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74340.length)].join('')));

}
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto___74347 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___74347)){
var class_list_74348 = temp__6751__auto___74347;
class_list_74348.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.call(null,elem,class$);
} else {
dommy.core.remove_class_BANG_.call(null,elem,class$);
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var args74349 = [];
var len__67408__auto___74352 = arguments.length;
var i__67409__auto___74353 = (0);
while(true){
if((i__67409__auto___74353 < len__67408__auto___74352)){
args74349.push((arguments[i__67409__auto___74353]));

var G__74354 = (i__67409__auto___74353 + (1));
i__67409__auto___74353 = G__74354;
continue;
} else {
}
break;
}

var G__74351 = args74349.length;
switch (G__74351) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74349.length)].join('')));

}
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});

dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var args74356 = [];
var len__67408__auto___74359 = arguments.length;
var i__67409__auto___74360 = (0);
while(true){
if((i__67409__auto___74360 < len__67408__auto___74359)){
args74356.push((arguments[i__67409__auto___74360]));

var G__74361 = (i__67409__auto___74360 + (1));
i__67409__auto___74360 = G__74361;
continue;
} else {
}
break;
}

var G__74358 = args74356.length;
switch (G__74358) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74356.length)].join('')));

}
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$lang$maxFixedArity = 2;

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var args74363 = [];
var len__67408__auto___74374 = arguments.length;
var i__67409__auto___74375 = (0);
while(true){
if((i__67409__auto___74375 < len__67408__auto___74374)){
args74363.push((arguments[i__67409__auto___74375]));

var G__74376 = (i__67409__auto___74375 + (1));
i__67409__auto___74375 = G__74376;
continue;
} else {
}
break;
}

var G__74368 = args74363.length;
switch (G__74368) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args74363.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__74369 = parent;
G__74369.appendChild(child);

return G__74369;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__74370_74378 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__74371_74379 = null;
var count__74372_74380 = (0);
var i__74373_74381 = (0);
while(true){
if((i__74373_74381 < count__74372_74380)){
var c_74382 = cljs.core._nth.call(null,chunk__74371_74379,i__74373_74381);
dommy.core.append_BANG_.call(null,parent,c_74382);

var G__74383 = seq__74370_74378;
var G__74384 = chunk__74371_74379;
var G__74385 = count__74372_74380;
var G__74386 = (i__74373_74381 + (1));
seq__74370_74378 = G__74383;
chunk__74371_74379 = G__74384;
count__74372_74380 = G__74385;
i__74373_74381 = G__74386;
continue;
} else {
var temp__6753__auto___74387 = cljs.core.seq.call(null,seq__74370_74378);
if(temp__6753__auto___74387){
var seq__74370_74388__$1 = temp__6753__auto___74387;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74370_74388__$1)){
var c__67098__auto___74389 = cljs.core.chunk_first.call(null,seq__74370_74388__$1);
var G__74390 = cljs.core.chunk_rest.call(null,seq__74370_74388__$1);
var G__74391 = c__67098__auto___74389;
var G__74392 = cljs.core.count.call(null,c__67098__auto___74389);
var G__74393 = (0);
seq__74370_74378 = G__74390;
chunk__74371_74379 = G__74391;
count__74372_74380 = G__74392;
i__74373_74381 = G__74393;
continue;
} else {
var c_74394 = cljs.core.first.call(null,seq__74370_74388__$1);
dommy.core.append_BANG_.call(null,parent,c_74394);

var G__74395 = cljs.core.next.call(null,seq__74370_74388__$1);
var G__74396 = null;
var G__74397 = (0);
var G__74398 = (0);
seq__74370_74378 = G__74395;
chunk__74371_74379 = G__74396;
count__74372_74380 = G__74397;
i__74373_74381 = G__74398;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq74364){
var G__74365 = cljs.core.first.call(null,seq74364);
var seq74364__$1 = cljs.core.next.call(null,seq74364);
var G__74366 = cljs.core.first.call(null,seq74364__$1);
var seq74364__$2 = cljs.core.next.call(null,seq74364__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74365,G__74366,seq74364__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var args74399 = [];
var len__67408__auto___74410 = arguments.length;
var i__67409__auto___74411 = (0);
while(true){
if((i__67409__auto___74411 < len__67408__auto___74410)){
args74399.push((arguments[i__67409__auto___74411]));

var G__74412 = (i__67409__auto___74411 + (1));
i__67409__auto___74411 = G__74412;
continue;
} else {
}
break;
}

var G__74404 = args74399.length;
switch (G__74404) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args74399.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67431__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__74405 = parent;
G__74405.insertBefore(child,parent.firstChild);

return G__74405;
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__74406_74414 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__74407_74415 = null;
var count__74408_74416 = (0);
var i__74409_74417 = (0);
while(true){
if((i__74409_74417 < count__74408_74416)){
var c_74418 = cljs.core._nth.call(null,chunk__74407_74415,i__74409_74417);
dommy.core.prepend_BANG_.call(null,parent,c_74418);

var G__74419 = seq__74406_74414;
var G__74420 = chunk__74407_74415;
var G__74421 = count__74408_74416;
var G__74422 = (i__74409_74417 + (1));
seq__74406_74414 = G__74419;
chunk__74407_74415 = G__74420;
count__74408_74416 = G__74421;
i__74409_74417 = G__74422;
continue;
} else {
var temp__6753__auto___74423 = cljs.core.seq.call(null,seq__74406_74414);
if(temp__6753__auto___74423){
var seq__74406_74424__$1 = temp__6753__auto___74423;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74406_74424__$1)){
var c__67098__auto___74425 = cljs.core.chunk_first.call(null,seq__74406_74424__$1);
var G__74426 = cljs.core.chunk_rest.call(null,seq__74406_74424__$1);
var G__74427 = c__67098__auto___74425;
var G__74428 = cljs.core.count.call(null,c__67098__auto___74425);
var G__74429 = (0);
seq__74406_74414 = G__74426;
chunk__74407_74415 = G__74427;
count__74408_74416 = G__74428;
i__74409_74417 = G__74429;
continue;
} else {
var c_74430 = cljs.core.first.call(null,seq__74406_74424__$1);
dommy.core.prepend_BANG_.call(null,parent,c_74430);

var G__74431 = cljs.core.next.call(null,seq__74406_74424__$1);
var G__74432 = null;
var G__74433 = (0);
var G__74434 = (0);
seq__74406_74414 = G__74431;
chunk__74407_74415 = G__74432;
count__74408_74416 = G__74433;
i__74409_74417 = G__74434;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq74400){
var G__74401 = cljs.core.first.call(null,seq74400);
var seq74400__$1 = cljs.core.next.call(null,seq74400);
var G__74402 = cljs.core.first.call(null,seq74400__$1);
var seq74400__$2 = cljs.core.next.call(null,seq74400__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74401,G__74402,seq74400__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent.call(null,other);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__6751__auto___74435 = other.nextSibling;
if(cljs.core.truth_(temp__6751__auto___74435)){
var next_74436 = temp__6751__auto___74435;
dommy.core.insert_before_BANG_.call(null,elem,next_74436);
} else {
dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var args74437 = [];
var len__67408__auto___74441 = arguments.length;
var i__67409__auto___74442 = (0);
while(true){
if((i__67409__auto___74442 < len__67408__auto___74441)){
args74437.push((arguments[i__67409__auto___74442]));

var G__74443 = (i__67409__auto___74442 + (1));
i__67409__auto___74442 = G__74443;
continue;
} else {
}
break;
}

var G__74439 = args74437.length;
switch (G__74439) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74437.length)].join('')));

}
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

return dommy.core.remove_BANG_.call(null,p,elem);
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__74440 = p;
G__74440.removeChild(elem);

return G__74440;
});

dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__74445){
var vec__74446 = p__74445;
var special_mouse_event = cljs.core.nth.call(null,vec__74446,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__74446,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,((function (vec__74446,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__74446,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__66187__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__66175__auto__ = related_target;
if(cljs.core.truth_(and__66175__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__66175__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__74446,special_mouse_event,real_mouse_event))
});})(vec__74446,special_mouse_event,real_mouse_event))
])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,elem,event.target,selector);
if(cljs.core.truth_((function (){var and__66175__auto__ = selected_target;
if(cljs.core.truth_(and__66175__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__66175__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__66187__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74452 = arguments.length;
var i__67409__auto___74453 = (0);
while(true){
if((i__67409__auto___74453 < len__67408__auto___74452)){
args__67415__auto__.push((arguments[i__67409__auto___74453]));

var G__74454 = (i__67409__auto___74453 + (1));
i__67409__auto___74453 = G__74454;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((2) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67416__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq74449){
var G__74450 = cljs.core.first.call(null,seq74449);
var seq74449__$1 = cljs.core.next.call(null,seq74449);
var G__74451 = cljs.core.first.call(null,seq74449__$1);
var seq74449__$2 = cljs.core.next.call(null,seq74449__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74450,G__74451,seq74449__$2);
});

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74494 = arguments.length;
var i__67409__auto___74495 = (0);
while(true){
if((i__67409__auto___74495 < len__67408__auto___74494)){
args__67415__auto__.push((arguments[i__67409__auto___74495]));

var G__74496 = (i__67409__auto___74495 + (1));
i__67409__auto___74495 = G__74496;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__74457_74497 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_74498 = cljs.core.nth.call(null,vec__74457_74497,(0),null);
var selector_74499 = cljs.core.nth.call(null,vec__74457_74497,(1),null);
var seq__74460_74500 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__74467_74501 = null;
var count__74468_74502 = (0);
var i__74469_74503 = (0);
while(true){
if((i__74469_74503 < count__74468_74502)){
var vec__74476_74504 = cljs.core._nth.call(null,chunk__74467_74501,i__74469_74503);
var orig_type_74505 = cljs.core.nth.call(null,vec__74476_74504,(0),null);
var f_74506 = cljs.core.nth.call(null,vec__74476_74504,(1),null);
var seq__74470_74507 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_74505,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_74505,cljs.core.identity])));
var chunk__74472_74508 = null;
var count__74473_74509 = (0);
var i__74474_74510 = (0);
while(true){
if((i__74474_74510 < count__74473_74509)){
var vec__74479_74511 = cljs.core._nth.call(null,chunk__74472_74508,i__74474_74510);
var actual_type_74512 = cljs.core.nth.call(null,vec__74479_74511,(0),null);
var factory_74513 = cljs.core.nth.call(null,vec__74479_74511,(1),null);
var canonical_f_74514 = (cljs.core.truth_(selector_74499)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74498,selector_74499):cljs.core.identity).call(null,factory_74513.call(null,f_74506));
dommy.core.update_event_listeners_BANG_.call(null,elem_74498,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74499,actual_type_74512,f_74506], null),canonical_f_74514);

if(cljs.core.truth_(elem_74498.addEventListener)){
elem_74498.addEventListener(cljs.core.name.call(null,actual_type_74512),canonical_f_74514);
} else {
elem_74498.attachEvent(cljs.core.name.call(null,actual_type_74512),canonical_f_74514);
}

var G__74515 = seq__74470_74507;
var G__74516 = chunk__74472_74508;
var G__74517 = count__74473_74509;
var G__74518 = (i__74474_74510 + (1));
seq__74470_74507 = G__74515;
chunk__74472_74508 = G__74516;
count__74473_74509 = G__74517;
i__74474_74510 = G__74518;
continue;
} else {
var temp__6753__auto___74519 = cljs.core.seq.call(null,seq__74470_74507);
if(temp__6753__auto___74519){
var seq__74470_74520__$1 = temp__6753__auto___74519;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74470_74520__$1)){
var c__67098__auto___74521 = cljs.core.chunk_first.call(null,seq__74470_74520__$1);
var G__74522 = cljs.core.chunk_rest.call(null,seq__74470_74520__$1);
var G__74523 = c__67098__auto___74521;
var G__74524 = cljs.core.count.call(null,c__67098__auto___74521);
var G__74525 = (0);
seq__74470_74507 = G__74522;
chunk__74472_74508 = G__74523;
count__74473_74509 = G__74524;
i__74474_74510 = G__74525;
continue;
} else {
var vec__74482_74526 = cljs.core.first.call(null,seq__74470_74520__$1);
var actual_type_74527 = cljs.core.nth.call(null,vec__74482_74526,(0),null);
var factory_74528 = cljs.core.nth.call(null,vec__74482_74526,(1),null);
var canonical_f_74529 = (cljs.core.truth_(selector_74499)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74498,selector_74499):cljs.core.identity).call(null,factory_74528.call(null,f_74506));
dommy.core.update_event_listeners_BANG_.call(null,elem_74498,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74499,actual_type_74527,f_74506], null),canonical_f_74529);

if(cljs.core.truth_(elem_74498.addEventListener)){
elem_74498.addEventListener(cljs.core.name.call(null,actual_type_74527),canonical_f_74529);
} else {
elem_74498.attachEvent(cljs.core.name.call(null,actual_type_74527),canonical_f_74529);
}

var G__74530 = cljs.core.next.call(null,seq__74470_74520__$1);
var G__74531 = null;
var G__74532 = (0);
var G__74533 = (0);
seq__74470_74507 = G__74530;
chunk__74472_74508 = G__74531;
count__74473_74509 = G__74532;
i__74474_74510 = G__74533;
continue;
}
} else {
}
}
break;
}

var G__74534 = seq__74460_74500;
var G__74535 = chunk__74467_74501;
var G__74536 = count__74468_74502;
var G__74537 = (i__74469_74503 + (1));
seq__74460_74500 = G__74534;
chunk__74467_74501 = G__74535;
count__74468_74502 = G__74536;
i__74469_74503 = G__74537;
continue;
} else {
var temp__6753__auto___74538 = cljs.core.seq.call(null,seq__74460_74500);
if(temp__6753__auto___74538){
var seq__74460_74539__$1 = temp__6753__auto___74538;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74460_74539__$1)){
var c__67098__auto___74540 = cljs.core.chunk_first.call(null,seq__74460_74539__$1);
var G__74541 = cljs.core.chunk_rest.call(null,seq__74460_74539__$1);
var G__74542 = c__67098__auto___74540;
var G__74543 = cljs.core.count.call(null,c__67098__auto___74540);
var G__74544 = (0);
seq__74460_74500 = G__74541;
chunk__74467_74501 = G__74542;
count__74468_74502 = G__74543;
i__74469_74503 = G__74544;
continue;
} else {
var vec__74485_74545 = cljs.core.first.call(null,seq__74460_74539__$1);
var orig_type_74546 = cljs.core.nth.call(null,vec__74485_74545,(0),null);
var f_74547 = cljs.core.nth.call(null,vec__74485_74545,(1),null);
var seq__74461_74548 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_74546,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_74546,cljs.core.identity])));
var chunk__74463_74549 = null;
var count__74464_74550 = (0);
var i__74465_74551 = (0);
while(true){
if((i__74465_74551 < count__74464_74550)){
var vec__74488_74552 = cljs.core._nth.call(null,chunk__74463_74549,i__74465_74551);
var actual_type_74553 = cljs.core.nth.call(null,vec__74488_74552,(0),null);
var factory_74554 = cljs.core.nth.call(null,vec__74488_74552,(1),null);
var canonical_f_74555 = (cljs.core.truth_(selector_74499)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74498,selector_74499):cljs.core.identity).call(null,factory_74554.call(null,f_74547));
dommy.core.update_event_listeners_BANG_.call(null,elem_74498,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74499,actual_type_74553,f_74547], null),canonical_f_74555);

if(cljs.core.truth_(elem_74498.addEventListener)){
elem_74498.addEventListener(cljs.core.name.call(null,actual_type_74553),canonical_f_74555);
} else {
elem_74498.attachEvent(cljs.core.name.call(null,actual_type_74553),canonical_f_74555);
}

var G__74556 = seq__74461_74548;
var G__74557 = chunk__74463_74549;
var G__74558 = count__74464_74550;
var G__74559 = (i__74465_74551 + (1));
seq__74461_74548 = G__74556;
chunk__74463_74549 = G__74557;
count__74464_74550 = G__74558;
i__74465_74551 = G__74559;
continue;
} else {
var temp__6753__auto___74560__$1 = cljs.core.seq.call(null,seq__74461_74548);
if(temp__6753__auto___74560__$1){
var seq__74461_74561__$1 = temp__6753__auto___74560__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74461_74561__$1)){
var c__67098__auto___74562 = cljs.core.chunk_first.call(null,seq__74461_74561__$1);
var G__74563 = cljs.core.chunk_rest.call(null,seq__74461_74561__$1);
var G__74564 = c__67098__auto___74562;
var G__74565 = cljs.core.count.call(null,c__67098__auto___74562);
var G__74566 = (0);
seq__74461_74548 = G__74563;
chunk__74463_74549 = G__74564;
count__74464_74550 = G__74565;
i__74465_74551 = G__74566;
continue;
} else {
var vec__74491_74567 = cljs.core.first.call(null,seq__74461_74561__$1);
var actual_type_74568 = cljs.core.nth.call(null,vec__74491_74567,(0),null);
var factory_74569 = cljs.core.nth.call(null,vec__74491_74567,(1),null);
var canonical_f_74570 = (cljs.core.truth_(selector_74499)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74498,selector_74499):cljs.core.identity).call(null,factory_74569.call(null,f_74547));
dommy.core.update_event_listeners_BANG_.call(null,elem_74498,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74499,actual_type_74568,f_74547], null),canonical_f_74570);

if(cljs.core.truth_(elem_74498.addEventListener)){
elem_74498.addEventListener(cljs.core.name.call(null,actual_type_74568),canonical_f_74570);
} else {
elem_74498.attachEvent(cljs.core.name.call(null,actual_type_74568),canonical_f_74570);
}

var G__74571 = cljs.core.next.call(null,seq__74461_74561__$1);
var G__74572 = null;
var G__74573 = (0);
var G__74574 = (0);
seq__74461_74548 = G__74571;
chunk__74463_74549 = G__74572;
count__74464_74550 = G__74573;
i__74465_74551 = G__74574;
continue;
}
} else {
}
}
break;
}

var G__74575 = cljs.core.next.call(null,seq__74460_74539__$1);
var G__74576 = null;
var G__74577 = (0);
var G__74578 = (0);
seq__74460_74500 = G__74575;
chunk__74467_74501 = G__74576;
count__74468_74502 = G__74577;
i__74469_74503 = G__74578;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq74455){
var G__74456 = cljs.core.first.call(null,seq74455);
var seq74455__$1 = cljs.core.next.call(null,seq74455);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74456,seq74455__$1);
});

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74618 = arguments.length;
var i__67409__auto___74619 = (0);
while(true){
if((i__67409__auto___74619 < len__67408__auto___74618)){
args__67415__auto__.push((arguments[i__67409__auto___74619]));

var G__74620 = (i__67409__auto___74619 + (1));
i__67409__auto___74619 = G__74620;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__74581_74621 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_74622 = cljs.core.nth.call(null,vec__74581_74621,(0),null);
var selector_74623 = cljs.core.nth.call(null,vec__74581_74621,(1),null);
var seq__74584_74624 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__74591_74625 = null;
var count__74592_74626 = (0);
var i__74593_74627 = (0);
while(true){
if((i__74593_74627 < count__74592_74626)){
var vec__74600_74628 = cljs.core._nth.call(null,chunk__74591_74625,i__74593_74627);
var orig_type_74629 = cljs.core.nth.call(null,vec__74600_74628,(0),null);
var f_74630 = cljs.core.nth.call(null,vec__74600_74628,(1),null);
var seq__74594_74631 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_74629,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_74629,cljs.core.identity])));
var chunk__74596_74632 = null;
var count__74597_74633 = (0);
var i__74598_74634 = (0);
while(true){
if((i__74598_74634 < count__74597_74633)){
var vec__74603_74635 = cljs.core._nth.call(null,chunk__74596_74632,i__74598_74634);
var actual_type_74636 = cljs.core.nth.call(null,vec__74603_74635,(0),null);
var __74637 = cljs.core.nth.call(null,vec__74603_74635,(1),null);
var keys_74638 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74623,actual_type_74636,f_74630], null);
var canonical_f_74639 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_74622),keys_74638);
dommy.core.update_event_listeners_BANG_.call(null,elem_74622,dommy.utils.dissoc_in,keys_74638);

if(cljs.core.truth_(elem_74622.removeEventListener)){
elem_74622.removeEventListener(cljs.core.name.call(null,actual_type_74636),canonical_f_74639);
} else {
elem_74622.detachEvent(cljs.core.name.call(null,actual_type_74636),canonical_f_74639);
}

var G__74640 = seq__74594_74631;
var G__74641 = chunk__74596_74632;
var G__74642 = count__74597_74633;
var G__74643 = (i__74598_74634 + (1));
seq__74594_74631 = G__74640;
chunk__74596_74632 = G__74641;
count__74597_74633 = G__74642;
i__74598_74634 = G__74643;
continue;
} else {
var temp__6753__auto___74644 = cljs.core.seq.call(null,seq__74594_74631);
if(temp__6753__auto___74644){
var seq__74594_74645__$1 = temp__6753__auto___74644;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74594_74645__$1)){
var c__67098__auto___74646 = cljs.core.chunk_first.call(null,seq__74594_74645__$1);
var G__74647 = cljs.core.chunk_rest.call(null,seq__74594_74645__$1);
var G__74648 = c__67098__auto___74646;
var G__74649 = cljs.core.count.call(null,c__67098__auto___74646);
var G__74650 = (0);
seq__74594_74631 = G__74647;
chunk__74596_74632 = G__74648;
count__74597_74633 = G__74649;
i__74598_74634 = G__74650;
continue;
} else {
var vec__74606_74651 = cljs.core.first.call(null,seq__74594_74645__$1);
var actual_type_74652 = cljs.core.nth.call(null,vec__74606_74651,(0),null);
var __74653 = cljs.core.nth.call(null,vec__74606_74651,(1),null);
var keys_74654 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74623,actual_type_74652,f_74630], null);
var canonical_f_74655 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_74622),keys_74654);
dommy.core.update_event_listeners_BANG_.call(null,elem_74622,dommy.utils.dissoc_in,keys_74654);

if(cljs.core.truth_(elem_74622.removeEventListener)){
elem_74622.removeEventListener(cljs.core.name.call(null,actual_type_74652),canonical_f_74655);
} else {
elem_74622.detachEvent(cljs.core.name.call(null,actual_type_74652),canonical_f_74655);
}

var G__74656 = cljs.core.next.call(null,seq__74594_74645__$1);
var G__74657 = null;
var G__74658 = (0);
var G__74659 = (0);
seq__74594_74631 = G__74656;
chunk__74596_74632 = G__74657;
count__74597_74633 = G__74658;
i__74598_74634 = G__74659;
continue;
}
} else {
}
}
break;
}

var G__74660 = seq__74584_74624;
var G__74661 = chunk__74591_74625;
var G__74662 = count__74592_74626;
var G__74663 = (i__74593_74627 + (1));
seq__74584_74624 = G__74660;
chunk__74591_74625 = G__74661;
count__74592_74626 = G__74662;
i__74593_74627 = G__74663;
continue;
} else {
var temp__6753__auto___74664 = cljs.core.seq.call(null,seq__74584_74624);
if(temp__6753__auto___74664){
var seq__74584_74665__$1 = temp__6753__auto___74664;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74584_74665__$1)){
var c__67098__auto___74666 = cljs.core.chunk_first.call(null,seq__74584_74665__$1);
var G__74667 = cljs.core.chunk_rest.call(null,seq__74584_74665__$1);
var G__74668 = c__67098__auto___74666;
var G__74669 = cljs.core.count.call(null,c__67098__auto___74666);
var G__74670 = (0);
seq__74584_74624 = G__74667;
chunk__74591_74625 = G__74668;
count__74592_74626 = G__74669;
i__74593_74627 = G__74670;
continue;
} else {
var vec__74609_74671 = cljs.core.first.call(null,seq__74584_74665__$1);
var orig_type_74672 = cljs.core.nth.call(null,vec__74609_74671,(0),null);
var f_74673 = cljs.core.nth.call(null,vec__74609_74671,(1),null);
var seq__74585_74674 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_74672,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_74672,cljs.core.identity])));
var chunk__74587_74675 = null;
var count__74588_74676 = (0);
var i__74589_74677 = (0);
while(true){
if((i__74589_74677 < count__74588_74676)){
var vec__74612_74678 = cljs.core._nth.call(null,chunk__74587_74675,i__74589_74677);
var actual_type_74679 = cljs.core.nth.call(null,vec__74612_74678,(0),null);
var __74680 = cljs.core.nth.call(null,vec__74612_74678,(1),null);
var keys_74681 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74623,actual_type_74679,f_74673], null);
var canonical_f_74682 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_74622),keys_74681);
dommy.core.update_event_listeners_BANG_.call(null,elem_74622,dommy.utils.dissoc_in,keys_74681);

if(cljs.core.truth_(elem_74622.removeEventListener)){
elem_74622.removeEventListener(cljs.core.name.call(null,actual_type_74679),canonical_f_74682);
} else {
elem_74622.detachEvent(cljs.core.name.call(null,actual_type_74679),canonical_f_74682);
}

var G__74683 = seq__74585_74674;
var G__74684 = chunk__74587_74675;
var G__74685 = count__74588_74676;
var G__74686 = (i__74589_74677 + (1));
seq__74585_74674 = G__74683;
chunk__74587_74675 = G__74684;
count__74588_74676 = G__74685;
i__74589_74677 = G__74686;
continue;
} else {
var temp__6753__auto___74687__$1 = cljs.core.seq.call(null,seq__74585_74674);
if(temp__6753__auto___74687__$1){
var seq__74585_74688__$1 = temp__6753__auto___74687__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74585_74688__$1)){
var c__67098__auto___74689 = cljs.core.chunk_first.call(null,seq__74585_74688__$1);
var G__74690 = cljs.core.chunk_rest.call(null,seq__74585_74688__$1);
var G__74691 = c__67098__auto___74689;
var G__74692 = cljs.core.count.call(null,c__67098__auto___74689);
var G__74693 = (0);
seq__74585_74674 = G__74690;
chunk__74587_74675 = G__74691;
count__74588_74676 = G__74692;
i__74589_74677 = G__74693;
continue;
} else {
var vec__74615_74694 = cljs.core.first.call(null,seq__74585_74688__$1);
var actual_type_74695 = cljs.core.nth.call(null,vec__74615_74694,(0),null);
var __74696 = cljs.core.nth.call(null,vec__74615_74694,(1),null);
var keys_74697 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74623,actual_type_74695,f_74673], null);
var canonical_f_74698 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_74622),keys_74697);
dommy.core.update_event_listeners_BANG_.call(null,elem_74622,dommy.utils.dissoc_in,keys_74697);

if(cljs.core.truth_(elem_74622.removeEventListener)){
elem_74622.removeEventListener(cljs.core.name.call(null,actual_type_74695),canonical_f_74698);
} else {
elem_74622.detachEvent(cljs.core.name.call(null,actual_type_74695),canonical_f_74698);
}

var G__74699 = cljs.core.next.call(null,seq__74585_74688__$1);
var G__74700 = null;
var G__74701 = (0);
var G__74702 = (0);
seq__74585_74674 = G__74699;
chunk__74587_74675 = G__74700;
count__74588_74676 = G__74701;
i__74589_74677 = G__74702;
continue;
}
} else {
}
}
break;
}

var G__74703 = cljs.core.next.call(null,seq__74584_74665__$1);
var G__74704 = null;
var G__74705 = (0);
var G__74706 = (0);
seq__74584_74624 = G__74703;
chunk__74591_74625 = G__74704;
count__74592_74626 = G__74705;
i__74593_74627 = G__74706;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq74579){
var G__74580 = cljs.core.first.call(null,seq74579);
var seq74579__$1 = cljs.core.next.call(null,seq74579);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74580,seq74579__$1);
});

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___74722 = arguments.length;
var i__67409__auto___74723 = (0);
while(true){
if((i__67409__auto___74723 < len__67408__auto___74722)){
args__67415__auto__.push((arguments[i__67409__auto___74723]));

var G__74724 = (i__67409__auto___74723 + (1));
i__67409__auto___74723 = G__74724;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__74709_74725 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_74726 = cljs.core.nth.call(null,vec__74709_74725,(0),null);
var selector_74727 = cljs.core.nth.call(null,vec__74709_74725,(1),null);
var seq__74712_74728 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__74713_74729 = null;
var count__74714_74730 = (0);
var i__74715_74731 = (0);
while(true){
if((i__74715_74731 < count__74714_74730)){
var vec__74716_74732 = cljs.core._nth.call(null,chunk__74713_74729,i__74715_74731);
var type_74733 = cljs.core.nth.call(null,vec__74716_74732,(0),null);
var f_74734 = cljs.core.nth.call(null,vec__74716_74732,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_74733,((function (seq__74712_74728,chunk__74713_74729,count__74714_74730,i__74715_74731,vec__74716_74732,type_74733,f_74734,vec__74709_74725,elem_74726,selector_74727){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_74733,dommy$core$this_fn);

return f_74734.call(null,e);
});})(seq__74712_74728,chunk__74713_74729,count__74714_74730,i__74715_74731,vec__74716_74732,type_74733,f_74734,vec__74709_74725,elem_74726,selector_74727))
);

var G__74735 = seq__74712_74728;
var G__74736 = chunk__74713_74729;
var G__74737 = count__74714_74730;
var G__74738 = (i__74715_74731 + (1));
seq__74712_74728 = G__74735;
chunk__74713_74729 = G__74736;
count__74714_74730 = G__74737;
i__74715_74731 = G__74738;
continue;
} else {
var temp__6753__auto___74739 = cljs.core.seq.call(null,seq__74712_74728);
if(temp__6753__auto___74739){
var seq__74712_74740__$1 = temp__6753__auto___74739;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74712_74740__$1)){
var c__67098__auto___74741 = cljs.core.chunk_first.call(null,seq__74712_74740__$1);
var G__74742 = cljs.core.chunk_rest.call(null,seq__74712_74740__$1);
var G__74743 = c__67098__auto___74741;
var G__74744 = cljs.core.count.call(null,c__67098__auto___74741);
var G__74745 = (0);
seq__74712_74728 = G__74742;
chunk__74713_74729 = G__74743;
count__74714_74730 = G__74744;
i__74715_74731 = G__74745;
continue;
} else {
var vec__74719_74746 = cljs.core.first.call(null,seq__74712_74740__$1);
var type_74747 = cljs.core.nth.call(null,vec__74719_74746,(0),null);
var f_74748 = cljs.core.nth.call(null,vec__74719_74746,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_74747,((function (seq__74712_74728,chunk__74713_74729,count__74714_74730,i__74715_74731,vec__74719_74746,type_74747,f_74748,seq__74712_74740__$1,temp__6753__auto___74739,vec__74709_74725,elem_74726,selector_74727){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_74747,dommy$core$this_fn);

return f_74748.call(null,e);
});})(seq__74712_74728,chunk__74713_74729,count__74714_74730,i__74715_74731,vec__74719_74746,type_74747,f_74748,seq__74712_74740__$1,temp__6753__auto___74739,vec__74709_74725,elem_74726,selector_74727))
);

var G__74749 = cljs.core.next.call(null,seq__74712_74740__$1);
var G__74750 = null;
var G__74751 = (0);
var G__74752 = (0);
seq__74712_74728 = G__74749;
chunk__74713_74729 = G__74750;
count__74714_74730 = G__74751;
i__74715_74731 = G__74752;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq74707){
var G__74708 = cljs.core.first.call(null,seq74707);
var seq74707__$1 = cljs.core.next.call(null,seq74707);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74708,seq74707__$1);
});


//# sourceMappingURL=core.js.map