// Compiled by ClojureScript 1.9.494 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__66187__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__66187__auto__){
return or__66187__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__66187__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__86730_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__86730_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__86735 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__86736 = null;
var count__86737 = (0);
var i__86738 = (0);
while(true){
if((i__86738 < count__86737)){
var n = cljs.core._nth.call(null,chunk__86736,i__86738);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__86739 = seq__86735;
var G__86740 = chunk__86736;
var G__86741 = count__86737;
var G__86742 = (i__86738 + (1));
seq__86735 = G__86739;
chunk__86736 = G__86740;
count__86737 = G__86741;
i__86738 = G__86742;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__86735);
if(temp__6753__auto__){
var seq__86735__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86735__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__86735__$1);
var G__86743 = cljs.core.chunk_rest.call(null,seq__86735__$1);
var G__86744 = c__67098__auto__;
var G__86745 = cljs.core.count.call(null,c__67098__auto__);
var G__86746 = (0);
seq__86735 = G__86743;
chunk__86736 = G__86744;
count__86737 = G__86745;
i__86738 = G__86746;
continue;
} else {
var n = cljs.core.first.call(null,seq__86735__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__86747 = cljs.core.next.call(null,seq__86735__$1);
var G__86748 = null;
var G__86749 = (0);
var G__86750 = (0);
seq__86735 = G__86747;
chunk__86736 = G__86748;
count__86737 = G__86749;
i__86738 = G__86750;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__86801_86812 = cljs.core.seq.call(null,deps);
var chunk__86802_86813 = null;
var count__86803_86814 = (0);
var i__86804_86815 = (0);
while(true){
if((i__86804_86815 < count__86803_86814)){
var dep_86816 = cljs.core._nth.call(null,chunk__86802_86813,i__86804_86815);
topo_sort_helper_STAR_.call(null,dep_86816,(depth + (1)),state);

var G__86817 = seq__86801_86812;
var G__86818 = chunk__86802_86813;
var G__86819 = count__86803_86814;
var G__86820 = (i__86804_86815 + (1));
seq__86801_86812 = G__86817;
chunk__86802_86813 = G__86818;
count__86803_86814 = G__86819;
i__86804_86815 = G__86820;
continue;
} else {
var temp__6753__auto___86821 = cljs.core.seq.call(null,seq__86801_86812);
if(temp__6753__auto___86821){
var seq__86801_86822__$1 = temp__6753__auto___86821;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86801_86822__$1)){
var c__67098__auto___86823 = cljs.core.chunk_first.call(null,seq__86801_86822__$1);
var G__86824 = cljs.core.chunk_rest.call(null,seq__86801_86822__$1);
var G__86825 = c__67098__auto___86823;
var G__86826 = cljs.core.count.call(null,c__67098__auto___86823);
var G__86827 = (0);
seq__86801_86812 = G__86824;
chunk__86802_86813 = G__86825;
count__86803_86814 = G__86826;
i__86804_86815 = G__86827;
continue;
} else {
var dep_86828 = cljs.core.first.call(null,seq__86801_86822__$1);
topo_sort_helper_STAR_.call(null,dep_86828,(depth + (1)),state);

var G__86829 = cljs.core.next.call(null,seq__86801_86822__$1);
var G__86830 = null;
var G__86831 = (0);
var G__86832 = (0);
seq__86801_86812 = G__86829;
chunk__86802_86813 = G__86830;
count__86803_86814 = G__86831;
i__86804_86815 = G__86832;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__86805){
var vec__86809 = p__86805;
var seq__86810 = cljs.core.seq.call(null,vec__86809);
var first__86811 = cljs.core.first.call(null,seq__86810);
var seq__86810__$1 = cljs.core.next.call(null,seq__86810);
var x = first__86811;
var xs = seq__86810__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__86809,seq__86810,first__86811,seq__86810__$1,x,xs,get_deps__$1){
return (function (p1__86751_SHARP_){
return clojure.set.difference.call(null,p1__86751_SHARP_,x);
});})(vec__86809,seq__86810,first__86811,seq__86810__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__86845 = cljs.core.seq.call(null,provides);
var chunk__86846 = null;
var count__86847 = (0);
var i__86848 = (0);
while(true){
if((i__86848 < count__86847)){
var prov = cljs.core._nth.call(null,chunk__86846,i__86848);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__86849_86857 = cljs.core.seq.call(null,requires);
var chunk__86850_86858 = null;
var count__86851_86859 = (0);
var i__86852_86860 = (0);
while(true){
if((i__86852_86860 < count__86851_86859)){
var req_86861 = cljs.core._nth.call(null,chunk__86850_86858,i__86852_86860);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_86861,prov);

var G__86862 = seq__86849_86857;
var G__86863 = chunk__86850_86858;
var G__86864 = count__86851_86859;
var G__86865 = (i__86852_86860 + (1));
seq__86849_86857 = G__86862;
chunk__86850_86858 = G__86863;
count__86851_86859 = G__86864;
i__86852_86860 = G__86865;
continue;
} else {
var temp__6753__auto___86866 = cljs.core.seq.call(null,seq__86849_86857);
if(temp__6753__auto___86866){
var seq__86849_86867__$1 = temp__6753__auto___86866;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86849_86867__$1)){
var c__67098__auto___86868 = cljs.core.chunk_first.call(null,seq__86849_86867__$1);
var G__86869 = cljs.core.chunk_rest.call(null,seq__86849_86867__$1);
var G__86870 = c__67098__auto___86868;
var G__86871 = cljs.core.count.call(null,c__67098__auto___86868);
var G__86872 = (0);
seq__86849_86857 = G__86869;
chunk__86850_86858 = G__86870;
count__86851_86859 = G__86871;
i__86852_86860 = G__86872;
continue;
} else {
var req_86873 = cljs.core.first.call(null,seq__86849_86867__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_86873,prov);

var G__86874 = cljs.core.next.call(null,seq__86849_86867__$1);
var G__86875 = null;
var G__86876 = (0);
var G__86877 = (0);
seq__86849_86857 = G__86874;
chunk__86850_86858 = G__86875;
count__86851_86859 = G__86876;
i__86852_86860 = G__86877;
continue;
}
} else {
}
}
break;
}

var G__86878 = seq__86845;
var G__86879 = chunk__86846;
var G__86880 = count__86847;
var G__86881 = (i__86848 + (1));
seq__86845 = G__86878;
chunk__86846 = G__86879;
count__86847 = G__86880;
i__86848 = G__86881;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__86845);
if(temp__6753__auto__){
var seq__86845__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86845__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__86845__$1);
var G__86882 = cljs.core.chunk_rest.call(null,seq__86845__$1);
var G__86883 = c__67098__auto__;
var G__86884 = cljs.core.count.call(null,c__67098__auto__);
var G__86885 = (0);
seq__86845 = G__86882;
chunk__86846 = G__86883;
count__86847 = G__86884;
i__86848 = G__86885;
continue;
} else {
var prov = cljs.core.first.call(null,seq__86845__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__86853_86886 = cljs.core.seq.call(null,requires);
var chunk__86854_86887 = null;
var count__86855_86888 = (0);
var i__86856_86889 = (0);
while(true){
if((i__86856_86889 < count__86855_86888)){
var req_86890 = cljs.core._nth.call(null,chunk__86854_86887,i__86856_86889);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_86890,prov);

var G__86891 = seq__86853_86886;
var G__86892 = chunk__86854_86887;
var G__86893 = count__86855_86888;
var G__86894 = (i__86856_86889 + (1));
seq__86853_86886 = G__86891;
chunk__86854_86887 = G__86892;
count__86855_86888 = G__86893;
i__86856_86889 = G__86894;
continue;
} else {
var temp__6753__auto___86895__$1 = cljs.core.seq.call(null,seq__86853_86886);
if(temp__6753__auto___86895__$1){
var seq__86853_86896__$1 = temp__6753__auto___86895__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86853_86896__$1)){
var c__67098__auto___86897 = cljs.core.chunk_first.call(null,seq__86853_86896__$1);
var G__86898 = cljs.core.chunk_rest.call(null,seq__86853_86896__$1);
var G__86899 = c__67098__auto___86897;
var G__86900 = cljs.core.count.call(null,c__67098__auto___86897);
var G__86901 = (0);
seq__86853_86886 = G__86898;
chunk__86854_86887 = G__86899;
count__86855_86888 = G__86900;
i__86856_86889 = G__86901;
continue;
} else {
var req_86902 = cljs.core.first.call(null,seq__86853_86896__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_86902,prov);

var G__86903 = cljs.core.next.call(null,seq__86853_86896__$1);
var G__86904 = null;
var G__86905 = (0);
var G__86906 = (0);
seq__86853_86886 = G__86903;
chunk__86854_86887 = G__86904;
count__86855_86888 = G__86905;
i__86856_86889 = G__86906;
continue;
}
} else {
}
}
break;
}

var G__86907 = cljs.core.next.call(null,seq__86845__$1);
var G__86908 = null;
var G__86909 = (0);
var G__86910 = (0);
seq__86845 = G__86907;
chunk__86846 = G__86908;
count__86847 = G__86909;
i__86848 = G__86910;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__86915_86919 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__86916_86920 = null;
var count__86917_86921 = (0);
var i__86918_86922 = (0);
while(true){
if((i__86918_86922 < count__86917_86921)){
var ns_86923 = cljs.core._nth.call(null,chunk__86916_86920,i__86918_86922);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_86923);

var G__86924 = seq__86915_86919;
var G__86925 = chunk__86916_86920;
var G__86926 = count__86917_86921;
var G__86927 = (i__86918_86922 + (1));
seq__86915_86919 = G__86924;
chunk__86916_86920 = G__86925;
count__86917_86921 = G__86926;
i__86918_86922 = G__86927;
continue;
} else {
var temp__6753__auto___86928 = cljs.core.seq.call(null,seq__86915_86919);
if(temp__6753__auto___86928){
var seq__86915_86929__$1 = temp__6753__auto___86928;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__86915_86929__$1)){
var c__67098__auto___86930 = cljs.core.chunk_first.call(null,seq__86915_86929__$1);
var G__86931 = cljs.core.chunk_rest.call(null,seq__86915_86929__$1);
var G__86932 = c__67098__auto___86930;
var G__86933 = cljs.core.count.call(null,c__67098__auto___86930);
var G__86934 = (0);
seq__86915_86919 = G__86931;
chunk__86916_86920 = G__86932;
count__86917_86921 = G__86933;
i__86918_86922 = G__86934;
continue;
} else {
var ns_86935 = cljs.core.first.call(null,seq__86915_86929__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_86935);

var G__86936 = cljs.core.next.call(null,seq__86915_86929__$1);
var G__86937 = null;
var G__86938 = (0);
var G__86939 = (0);
seq__86915_86919 = G__86936;
chunk__86916_86920 = G__86937;
count__86917_86921 = G__86938;
i__86918_86922 = G__86939;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__66187__auto__ = goog.require__;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__86940__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__86940 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__86941__i = 0, G__86941__a = new Array(arguments.length -  0);
while (G__86941__i < G__86941__a.length) {G__86941__a[G__86941__i] = arguments[G__86941__i + 0]; ++G__86941__i;}
  args = new cljs.core.IndexedSeq(G__86941__a,0);
} 
return G__86940__delegate.call(this,args);};
G__86940.cljs$lang$maxFixedArity = 0;
G__86940.cljs$lang$applyTo = (function (arglist__86942){
var args = cljs.core.seq(arglist__86942);
return G__86940__delegate(args);
});
G__86940.cljs$core$IFn$_invoke$arity$variadic = G__86940__delegate;
return G__86940;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__86943 = cljs.core._EQ_;
var expr__86944 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__86943.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__86944))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__86943,expr__86944){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__86943,expr__86944))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__86943,expr__86944){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e86946){if((e86946 instanceof Error)){
var e = e86946;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e86946;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__86943,expr__86944))
} else {
if(cljs.core.truth_(pred__86943.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__86944))){
return ((function (pred__86943,expr__86944){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__86943,expr__86944){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__86943,expr__86944))
);

return deferred.addErrback(((function (deferred,pred__86943,expr__86944){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__86943,expr__86944))
);
});
;})(pred__86943,expr__86944))
} else {
if(cljs.core.truth_(pred__86943.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__86944))){
return ((function (pred__86943,expr__86944){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e86947){if((e86947 instanceof Error)){
var e = e86947;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e86947;

}
}})());
});
;})(pred__86943,expr__86944))
} else {
return ((function (pred__86943,expr__86944){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__86943,expr__86944))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__86948,callback){
var map__86951 = p__86948;
var map__86951__$1 = ((((!((map__86951 == null)))?((((map__86951.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__86951.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__86951):map__86951);
var file_msg = map__86951__$1;
var request_url = cljs.core.get.call(null,map__86951__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__86951,map__86951__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__86951,map__86951__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_86975){
var state_val_86976 = (state_86975[(1)]);
if((state_val_86976 === (7))){
var inst_86971 = (state_86975[(2)]);
var state_86975__$1 = state_86975;
var statearr_86977_86997 = state_86975__$1;
(statearr_86977_86997[(2)] = inst_86971);

(statearr_86977_86997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (1))){
var state_86975__$1 = state_86975;
var statearr_86978_86998 = state_86975__$1;
(statearr_86978_86998[(2)] = null);

(statearr_86978_86998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (4))){
var inst_86955 = (state_86975[(7)]);
var inst_86955__$1 = (state_86975[(2)]);
var state_86975__$1 = (function (){var statearr_86979 = state_86975;
(statearr_86979[(7)] = inst_86955__$1);

return statearr_86979;
})();
if(cljs.core.truth_(inst_86955__$1)){
var statearr_86980_86999 = state_86975__$1;
(statearr_86980_86999[(1)] = (5));

} else {
var statearr_86981_87000 = state_86975__$1;
(statearr_86981_87000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (6))){
var state_86975__$1 = state_86975;
var statearr_86982_87001 = state_86975__$1;
(statearr_86982_87001[(2)] = null);

(statearr_86982_87001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (3))){
var inst_86973 = (state_86975[(2)]);
var state_86975__$1 = state_86975;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_86975__$1,inst_86973);
} else {
if((state_val_86976 === (2))){
var state_86975__$1 = state_86975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_86975__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_86976 === (11))){
var inst_86967 = (state_86975[(2)]);
var state_86975__$1 = (function (){var statearr_86983 = state_86975;
(statearr_86983[(8)] = inst_86967);

return statearr_86983;
})();
var statearr_86984_87002 = state_86975__$1;
(statearr_86984_87002[(2)] = null);

(statearr_86984_87002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (9))){
var inst_86961 = (state_86975[(9)]);
var inst_86959 = (state_86975[(10)]);
var inst_86963 = inst_86961.call(null,inst_86959);
var state_86975__$1 = state_86975;
var statearr_86985_87003 = state_86975__$1;
(statearr_86985_87003[(2)] = inst_86963);

(statearr_86985_87003[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (5))){
var inst_86955 = (state_86975[(7)]);
var inst_86957 = figwheel.client.file_reloading.blocking_load.call(null,inst_86955);
var state_86975__$1 = state_86975;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_86975__$1,(8),inst_86957);
} else {
if((state_val_86976 === (10))){
var inst_86959 = (state_86975[(10)]);
var inst_86965 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_86959);
var state_86975__$1 = state_86975;
var statearr_86986_87004 = state_86975__$1;
(statearr_86986_87004[(2)] = inst_86965);

(statearr_86986_87004[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86976 === (8))){
var inst_86955 = (state_86975[(7)]);
var inst_86961 = (state_86975[(9)]);
var inst_86959 = (state_86975[(2)]);
var inst_86960 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_86961__$1 = cljs.core.get.call(null,inst_86960,inst_86955);
var state_86975__$1 = (function (){var statearr_86987 = state_86975;
(statearr_86987[(9)] = inst_86961__$1);

(statearr_86987[(10)] = inst_86959);

return statearr_86987;
})();
if(cljs.core.truth_(inst_86961__$1)){
var statearr_86988_87005 = state_86975__$1;
(statearr_86988_87005[(1)] = (9));

} else {
var statearr_86989_87006 = state_86975__$1;
(statearr_86989_87006[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__70821__auto__ = null;
var figwheel$client$file_reloading$state_machine__70821__auto____0 = (function (){
var statearr_86993 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_86993[(0)] = figwheel$client$file_reloading$state_machine__70821__auto__);

(statearr_86993[(1)] = (1));

return statearr_86993;
});
var figwheel$client$file_reloading$state_machine__70821__auto____1 = (function (state_86975){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_86975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e86994){if((e86994 instanceof Object)){
var ex__70824__auto__ = e86994;
var statearr_86995_87007 = state_86975;
(statearr_86995_87007[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_86975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e86994;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87008 = state_86975;
state_86975 = G__87008;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__70821__auto__ = function(state_86975){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__70821__auto____1.call(this,state_86975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__70821__auto____0;
figwheel$client$file_reloading$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__70821__auto____1;
return figwheel$client$file_reloading$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_86996 = f__70935__auto__.call(null);
(statearr_86996[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_86996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__87009,callback){
var map__87012 = p__87009;
var map__87012__$1 = ((((!((map__87012 == null)))?((((map__87012.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87012.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87012):map__87012);
var file_msg = map__87012__$1;
var namespace = cljs.core.get.call(null,map__87012__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__87012,map__87012__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__87012,map__87012__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__87014){
var map__87017 = p__87014;
var map__87017__$1 = ((((!((map__87017 == null)))?((((map__87017.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87017.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87017):map__87017);
var file_msg = map__87017__$1;
var namespace = cljs.core.get.call(null,map__87017__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__87019){
var map__87022 = p__87019;
var map__87022__$1 = ((((!((map__87022 == null)))?((((map__87022.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87022.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87022):map__87022);
var file_msg = map__87022__$1;
var namespace = cljs.core.get.call(null,map__87022__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__66175__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__66175__auto__){
var or__66187__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
var or__66187__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__66187__auto____$1)){
return or__66187__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__66175__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__87024,callback){
var map__87027 = p__87024;
var map__87027__$1 = ((((!((map__87027 == null)))?((((map__87027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87027.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87027):map__87027);
var file_msg = map__87027__$1;
var request_url = cljs.core.get.call(null,map__87027__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__87027__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__70934__auto___87131 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___87131,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___87131,out){
return (function (state_87113){
var state_val_87114 = (state_87113[(1)]);
if((state_val_87114 === (1))){
var inst_87087 = cljs.core.seq.call(null,files);
var inst_87088 = cljs.core.first.call(null,inst_87087);
var inst_87089 = cljs.core.next.call(null,inst_87087);
var inst_87090 = files;
var state_87113__$1 = (function (){var statearr_87115 = state_87113;
(statearr_87115[(7)] = inst_87090);

(statearr_87115[(8)] = inst_87089);

(statearr_87115[(9)] = inst_87088);

return statearr_87115;
})();
var statearr_87116_87132 = state_87113__$1;
(statearr_87116_87132[(2)] = null);

(statearr_87116_87132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87114 === (2))){
var inst_87090 = (state_87113[(7)]);
var inst_87096 = (state_87113[(10)]);
var inst_87095 = cljs.core.seq.call(null,inst_87090);
var inst_87096__$1 = cljs.core.first.call(null,inst_87095);
var inst_87097 = cljs.core.next.call(null,inst_87095);
var inst_87098 = (inst_87096__$1 == null);
var inst_87099 = cljs.core.not.call(null,inst_87098);
var state_87113__$1 = (function (){var statearr_87117 = state_87113;
(statearr_87117[(11)] = inst_87097);

(statearr_87117[(10)] = inst_87096__$1);

return statearr_87117;
})();
if(inst_87099){
var statearr_87118_87133 = state_87113__$1;
(statearr_87118_87133[(1)] = (4));

} else {
var statearr_87119_87134 = state_87113__$1;
(statearr_87119_87134[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87114 === (3))){
var inst_87111 = (state_87113[(2)]);
var state_87113__$1 = state_87113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_87113__$1,inst_87111);
} else {
if((state_val_87114 === (4))){
var inst_87096 = (state_87113[(10)]);
var inst_87101 = figwheel.client.file_reloading.reload_js_file.call(null,inst_87096);
var state_87113__$1 = state_87113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_87113__$1,(7),inst_87101);
} else {
if((state_val_87114 === (5))){
var inst_87107 = cljs.core.async.close_BANG_.call(null,out);
var state_87113__$1 = state_87113;
var statearr_87120_87135 = state_87113__$1;
(statearr_87120_87135[(2)] = inst_87107);

(statearr_87120_87135[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87114 === (6))){
var inst_87109 = (state_87113[(2)]);
var state_87113__$1 = state_87113;
var statearr_87121_87136 = state_87113__$1;
(statearr_87121_87136[(2)] = inst_87109);

(statearr_87121_87136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87114 === (7))){
var inst_87097 = (state_87113[(11)]);
var inst_87103 = (state_87113[(2)]);
var inst_87104 = cljs.core.async.put_BANG_.call(null,out,inst_87103);
var inst_87090 = inst_87097;
var state_87113__$1 = (function (){var statearr_87122 = state_87113;
(statearr_87122[(7)] = inst_87090);

(statearr_87122[(12)] = inst_87104);

return statearr_87122;
})();
var statearr_87123_87137 = state_87113__$1;
(statearr_87123_87137[(2)] = null);

(statearr_87123_87137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__70934__auto___87131,out))
;
return ((function (switch__70820__auto__,c__70934__auto___87131,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto____0 = (function (){
var statearr_87127 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87127[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto__);

(statearr_87127[(1)] = (1));

return statearr_87127;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto____1 = (function (state_87113){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_87113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e87128){if((e87128 instanceof Object)){
var ex__70824__auto__ = e87128;
var statearr_87129_87138 = state_87113;
(statearr_87129_87138[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_87113);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e87128;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87139 = state_87113;
state_87113 = G__87139;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto__ = function(state_87113){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto____1.call(this,state_87113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___87131,out))
})();
var state__70936__auto__ = (function (){var statearr_87130 = f__70935__auto__.call(null);
(statearr_87130[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___87131);

return statearr_87130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___87131,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__87140,opts){
var map__87144 = p__87140;
var map__87144__$1 = ((((!((map__87144 == null)))?((((map__87144.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87144.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87144):map__87144);
var eval_body = cljs.core.get.call(null,map__87144__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__87144__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__66175__auto__ = eval_body;
if(cljs.core.truth_(and__66175__auto__)){
return typeof eval_body === 'string';
} else {
return and__66175__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e87146){var e = e87146;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__87147_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__87147_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__87156){
var vec__87157 = p__87156;
var k = cljs.core.nth.call(null,vec__87157,(0),null);
var v = cljs.core.nth.call(null,vec__87157,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__87160){
var vec__87161 = p__87160;
var k = cljs.core.nth.call(null,vec__87161,(0),null);
var v = cljs.core.nth.call(null,vec__87161,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__87167,p__87168){
var map__87416 = p__87167;
var map__87416__$1 = ((((!((map__87416 == null)))?((((map__87416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87416.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87416):map__87416);
var opts = map__87416__$1;
var before_jsload = cljs.core.get.call(null,map__87416__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__87416__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__87416__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__87417 = p__87168;
var map__87417__$1 = ((((!((map__87417 == null)))?((((map__87417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87417.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87417):map__87417);
var msg = map__87417__$1;
var files = cljs.core.get.call(null,map__87417__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__87417__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__87417__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_87571){
var state_val_87572 = (state_87571[(1)]);
if((state_val_87572 === (7))){
var inst_87432 = (state_87571[(7)]);
var inst_87434 = (state_87571[(8)]);
var inst_87433 = (state_87571[(9)]);
var inst_87431 = (state_87571[(10)]);
var inst_87439 = cljs.core._nth.call(null,inst_87432,inst_87434);
var inst_87440 = figwheel.client.file_reloading.eval_body.call(null,inst_87439,opts);
var inst_87441 = (inst_87434 + (1));
var tmp87573 = inst_87432;
var tmp87574 = inst_87433;
var tmp87575 = inst_87431;
var inst_87431__$1 = tmp87575;
var inst_87432__$1 = tmp87573;
var inst_87433__$1 = tmp87574;
var inst_87434__$1 = inst_87441;
var state_87571__$1 = (function (){var statearr_87576 = state_87571;
(statearr_87576[(7)] = inst_87432__$1);

(statearr_87576[(11)] = inst_87440);

(statearr_87576[(8)] = inst_87434__$1);

(statearr_87576[(9)] = inst_87433__$1);

(statearr_87576[(10)] = inst_87431__$1);

return statearr_87576;
})();
var statearr_87577_87663 = state_87571__$1;
(statearr_87577_87663[(2)] = null);

(statearr_87577_87663[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (20))){
var inst_87474 = (state_87571[(12)]);
var inst_87482 = figwheel.client.file_reloading.sort_files.call(null,inst_87474);
var state_87571__$1 = state_87571;
var statearr_87578_87664 = state_87571__$1;
(statearr_87578_87664[(2)] = inst_87482);

(statearr_87578_87664[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (27))){
var state_87571__$1 = state_87571;
var statearr_87579_87665 = state_87571__$1;
(statearr_87579_87665[(2)] = null);

(statearr_87579_87665[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (1))){
var inst_87423 = (state_87571[(13)]);
var inst_87420 = before_jsload.call(null,files);
var inst_87421 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_87422 = (function (){return ((function (inst_87423,inst_87420,inst_87421,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__87164_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__87164_SHARP_);
});
;})(inst_87423,inst_87420,inst_87421,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87423__$1 = cljs.core.filter.call(null,inst_87422,files);
var inst_87424 = cljs.core.not_empty.call(null,inst_87423__$1);
var state_87571__$1 = (function (){var statearr_87580 = state_87571;
(statearr_87580[(14)] = inst_87421);

(statearr_87580[(13)] = inst_87423__$1);

(statearr_87580[(15)] = inst_87420);

return statearr_87580;
})();
if(cljs.core.truth_(inst_87424)){
var statearr_87581_87666 = state_87571__$1;
(statearr_87581_87666[(1)] = (2));

} else {
var statearr_87582_87667 = state_87571__$1;
(statearr_87582_87667[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (24))){
var state_87571__$1 = state_87571;
var statearr_87583_87668 = state_87571__$1;
(statearr_87583_87668[(2)] = null);

(statearr_87583_87668[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (39))){
var inst_87524 = (state_87571[(16)]);
var state_87571__$1 = state_87571;
var statearr_87584_87669 = state_87571__$1;
(statearr_87584_87669[(2)] = inst_87524);

(statearr_87584_87669[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (46))){
var inst_87566 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
var statearr_87585_87670 = state_87571__$1;
(statearr_87585_87670[(2)] = inst_87566);

(statearr_87585_87670[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (4))){
var inst_87468 = (state_87571[(2)]);
var inst_87469 = cljs.core.List.EMPTY;
var inst_87470 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_87469);
var inst_87471 = (function (){return ((function (inst_87468,inst_87469,inst_87470,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__87165_SHARP_){
var and__66175__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__87165_SHARP_);
if(cljs.core.truth_(and__66175__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__87165_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__87165_SHARP_)));
} else {
return and__66175__auto__;
}
});
;})(inst_87468,inst_87469,inst_87470,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87472 = cljs.core.filter.call(null,inst_87471,files);
var inst_87473 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_87474 = cljs.core.concat.call(null,inst_87472,inst_87473);
var state_87571__$1 = (function (){var statearr_87586 = state_87571;
(statearr_87586[(17)] = inst_87468);

(statearr_87586[(12)] = inst_87474);

(statearr_87586[(18)] = inst_87470);

return statearr_87586;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_87587_87671 = state_87571__$1;
(statearr_87587_87671[(1)] = (16));

} else {
var statearr_87588_87672 = state_87571__$1;
(statearr_87588_87672[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (15))){
var inst_87458 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
var statearr_87589_87673 = state_87571__$1;
(statearr_87589_87673[(2)] = inst_87458);

(statearr_87589_87673[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (21))){
var inst_87484 = (state_87571[(19)]);
var inst_87484__$1 = (state_87571[(2)]);
var inst_87485 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_87484__$1);
var state_87571__$1 = (function (){var statearr_87590 = state_87571;
(statearr_87590[(19)] = inst_87484__$1);

return statearr_87590;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_87571__$1,(22),inst_87485);
} else {
if((state_val_87572 === (31))){
var inst_87569 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_87571__$1,inst_87569);
} else {
if((state_val_87572 === (32))){
var inst_87524 = (state_87571[(16)]);
var inst_87529 = inst_87524.cljs$lang$protocol_mask$partition0$;
var inst_87530 = (inst_87529 & (64));
var inst_87531 = inst_87524.cljs$core$ISeq$;
var inst_87532 = (cljs.core.PROTOCOL_SENTINEL === inst_87531);
var inst_87533 = (inst_87530) || (inst_87532);
var state_87571__$1 = state_87571;
if(cljs.core.truth_(inst_87533)){
var statearr_87591_87674 = state_87571__$1;
(statearr_87591_87674[(1)] = (35));

} else {
var statearr_87592_87675 = state_87571__$1;
(statearr_87592_87675[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (40))){
var inst_87546 = (state_87571[(20)]);
var inst_87545 = (state_87571[(2)]);
var inst_87546__$1 = cljs.core.get.call(null,inst_87545,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_87547 = cljs.core.get.call(null,inst_87545,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_87548 = cljs.core.not_empty.call(null,inst_87546__$1);
var state_87571__$1 = (function (){var statearr_87593 = state_87571;
(statearr_87593[(21)] = inst_87547);

(statearr_87593[(20)] = inst_87546__$1);

return statearr_87593;
})();
if(cljs.core.truth_(inst_87548)){
var statearr_87594_87676 = state_87571__$1;
(statearr_87594_87676[(1)] = (41));

} else {
var statearr_87595_87677 = state_87571__$1;
(statearr_87595_87677[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (33))){
var state_87571__$1 = state_87571;
var statearr_87596_87678 = state_87571__$1;
(statearr_87596_87678[(2)] = false);

(statearr_87596_87678[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (13))){
var inst_87444 = (state_87571[(22)]);
var inst_87448 = cljs.core.chunk_first.call(null,inst_87444);
var inst_87449 = cljs.core.chunk_rest.call(null,inst_87444);
var inst_87450 = cljs.core.count.call(null,inst_87448);
var inst_87431 = inst_87449;
var inst_87432 = inst_87448;
var inst_87433 = inst_87450;
var inst_87434 = (0);
var state_87571__$1 = (function (){var statearr_87597 = state_87571;
(statearr_87597[(7)] = inst_87432);

(statearr_87597[(8)] = inst_87434);

(statearr_87597[(9)] = inst_87433);

(statearr_87597[(10)] = inst_87431);

return statearr_87597;
})();
var statearr_87598_87679 = state_87571__$1;
(statearr_87598_87679[(2)] = null);

(statearr_87598_87679[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (22))){
var inst_87484 = (state_87571[(19)]);
var inst_87487 = (state_87571[(23)]);
var inst_87492 = (state_87571[(24)]);
var inst_87488 = (state_87571[(25)]);
var inst_87487__$1 = (state_87571[(2)]);
var inst_87488__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_87487__$1);
var inst_87489 = (function (){var all_files = inst_87484;
var res_SINGLEQUOTE_ = inst_87487__$1;
var res = inst_87488__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_87484,inst_87487,inst_87492,inst_87488,inst_87487__$1,inst_87488__$1,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__87166_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__87166_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_87484,inst_87487,inst_87492,inst_87488,inst_87487__$1,inst_87488__$1,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87490 = cljs.core.filter.call(null,inst_87489,inst_87487__$1);
var inst_87491 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_87492__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_87491);
var inst_87493 = cljs.core.not_empty.call(null,inst_87492__$1);
var state_87571__$1 = (function (){var statearr_87599 = state_87571;
(statearr_87599[(23)] = inst_87487__$1);

(statearr_87599[(24)] = inst_87492__$1);

(statearr_87599[(25)] = inst_87488__$1);

(statearr_87599[(26)] = inst_87490);

return statearr_87599;
})();
if(cljs.core.truth_(inst_87493)){
var statearr_87600_87680 = state_87571__$1;
(statearr_87600_87680[(1)] = (23));

} else {
var statearr_87601_87681 = state_87571__$1;
(statearr_87601_87681[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (36))){
var state_87571__$1 = state_87571;
var statearr_87602_87682 = state_87571__$1;
(statearr_87602_87682[(2)] = false);

(statearr_87602_87682[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (41))){
var inst_87546 = (state_87571[(20)]);
var inst_87550 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_87551 = cljs.core.map.call(null,inst_87550,inst_87546);
var inst_87552 = cljs.core.pr_str.call(null,inst_87551);
var inst_87553 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_87552)].join('');
var inst_87554 = figwheel.client.utils.log.call(null,inst_87553);
var state_87571__$1 = state_87571;
var statearr_87603_87683 = state_87571__$1;
(statearr_87603_87683[(2)] = inst_87554);

(statearr_87603_87683[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (43))){
var inst_87547 = (state_87571[(21)]);
var inst_87557 = (state_87571[(2)]);
var inst_87558 = cljs.core.not_empty.call(null,inst_87547);
var state_87571__$1 = (function (){var statearr_87604 = state_87571;
(statearr_87604[(27)] = inst_87557);

return statearr_87604;
})();
if(cljs.core.truth_(inst_87558)){
var statearr_87605_87684 = state_87571__$1;
(statearr_87605_87684[(1)] = (44));

} else {
var statearr_87606_87685 = state_87571__$1;
(statearr_87606_87685[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (29))){
var inst_87484 = (state_87571[(19)]);
var inst_87487 = (state_87571[(23)]);
var inst_87524 = (state_87571[(16)]);
var inst_87492 = (state_87571[(24)]);
var inst_87488 = (state_87571[(25)]);
var inst_87490 = (state_87571[(26)]);
var inst_87520 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_87523 = (function (){var all_files = inst_87484;
var res_SINGLEQUOTE_ = inst_87487;
var res = inst_87488;
var files_not_loaded = inst_87490;
var dependencies_that_loaded = inst_87492;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87524,inst_87492,inst_87488,inst_87490,inst_87520,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__87522){
var map__87607 = p__87522;
var map__87607__$1 = ((((!((map__87607 == null)))?((((map__87607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87607.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87607):map__87607);
var namespace = cljs.core.get.call(null,map__87607__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87524,inst_87492,inst_87488,inst_87490,inst_87520,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87524__$1 = cljs.core.group_by.call(null,inst_87523,inst_87490);
var inst_87526 = (inst_87524__$1 == null);
var inst_87527 = cljs.core.not.call(null,inst_87526);
var state_87571__$1 = (function (){var statearr_87609 = state_87571;
(statearr_87609[(16)] = inst_87524__$1);

(statearr_87609[(28)] = inst_87520);

return statearr_87609;
})();
if(inst_87527){
var statearr_87610_87686 = state_87571__$1;
(statearr_87610_87686[(1)] = (32));

} else {
var statearr_87611_87687 = state_87571__$1;
(statearr_87611_87687[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (44))){
var inst_87547 = (state_87571[(21)]);
var inst_87560 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_87547);
var inst_87561 = cljs.core.pr_str.call(null,inst_87560);
var inst_87562 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_87561)].join('');
var inst_87563 = figwheel.client.utils.log.call(null,inst_87562);
var state_87571__$1 = state_87571;
var statearr_87612_87688 = state_87571__$1;
(statearr_87612_87688[(2)] = inst_87563);

(statearr_87612_87688[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (6))){
var inst_87465 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
var statearr_87613_87689 = state_87571__$1;
(statearr_87613_87689[(2)] = inst_87465);

(statearr_87613_87689[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (28))){
var inst_87490 = (state_87571[(26)]);
var inst_87517 = (state_87571[(2)]);
var inst_87518 = cljs.core.not_empty.call(null,inst_87490);
var state_87571__$1 = (function (){var statearr_87614 = state_87571;
(statearr_87614[(29)] = inst_87517);

return statearr_87614;
})();
if(cljs.core.truth_(inst_87518)){
var statearr_87615_87690 = state_87571__$1;
(statearr_87615_87690[(1)] = (29));

} else {
var statearr_87616_87691 = state_87571__$1;
(statearr_87616_87691[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (25))){
var inst_87488 = (state_87571[(25)]);
var inst_87504 = (state_87571[(2)]);
var inst_87505 = cljs.core.not_empty.call(null,inst_87488);
var state_87571__$1 = (function (){var statearr_87617 = state_87571;
(statearr_87617[(30)] = inst_87504);

return statearr_87617;
})();
if(cljs.core.truth_(inst_87505)){
var statearr_87618_87692 = state_87571__$1;
(statearr_87618_87692[(1)] = (26));

} else {
var statearr_87619_87693 = state_87571__$1;
(statearr_87619_87693[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (34))){
var inst_87540 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
if(cljs.core.truth_(inst_87540)){
var statearr_87620_87694 = state_87571__$1;
(statearr_87620_87694[(1)] = (38));

} else {
var statearr_87621_87695 = state_87571__$1;
(statearr_87621_87695[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (17))){
var state_87571__$1 = state_87571;
var statearr_87622_87696 = state_87571__$1;
(statearr_87622_87696[(2)] = recompile_dependents);

(statearr_87622_87696[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (3))){
var state_87571__$1 = state_87571;
var statearr_87623_87697 = state_87571__$1;
(statearr_87623_87697[(2)] = null);

(statearr_87623_87697[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (12))){
var inst_87461 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
var statearr_87624_87698 = state_87571__$1;
(statearr_87624_87698[(2)] = inst_87461);

(statearr_87624_87698[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (2))){
var inst_87423 = (state_87571[(13)]);
var inst_87430 = cljs.core.seq.call(null,inst_87423);
var inst_87431 = inst_87430;
var inst_87432 = null;
var inst_87433 = (0);
var inst_87434 = (0);
var state_87571__$1 = (function (){var statearr_87625 = state_87571;
(statearr_87625[(7)] = inst_87432);

(statearr_87625[(8)] = inst_87434);

(statearr_87625[(9)] = inst_87433);

(statearr_87625[(10)] = inst_87431);

return statearr_87625;
})();
var statearr_87626_87699 = state_87571__$1;
(statearr_87626_87699[(2)] = null);

(statearr_87626_87699[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (23))){
var inst_87484 = (state_87571[(19)]);
var inst_87487 = (state_87571[(23)]);
var inst_87492 = (state_87571[(24)]);
var inst_87488 = (state_87571[(25)]);
var inst_87490 = (state_87571[(26)]);
var inst_87495 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_87497 = (function (){var all_files = inst_87484;
var res_SINGLEQUOTE_ = inst_87487;
var res = inst_87488;
var files_not_loaded = inst_87490;
var dependencies_that_loaded = inst_87492;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87492,inst_87488,inst_87490,inst_87495,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__87496){
var map__87627 = p__87496;
var map__87627__$1 = ((((!((map__87627 == null)))?((((map__87627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87627.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87627):map__87627);
var request_url = cljs.core.get.call(null,map__87627__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87492,inst_87488,inst_87490,inst_87495,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87498 = cljs.core.reverse.call(null,inst_87492);
var inst_87499 = cljs.core.map.call(null,inst_87497,inst_87498);
var inst_87500 = cljs.core.pr_str.call(null,inst_87499);
var inst_87501 = figwheel.client.utils.log.call(null,inst_87500);
var state_87571__$1 = (function (){var statearr_87629 = state_87571;
(statearr_87629[(31)] = inst_87495);

return statearr_87629;
})();
var statearr_87630_87700 = state_87571__$1;
(statearr_87630_87700[(2)] = inst_87501);

(statearr_87630_87700[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (35))){
var state_87571__$1 = state_87571;
var statearr_87631_87701 = state_87571__$1;
(statearr_87631_87701[(2)] = true);

(statearr_87631_87701[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (19))){
var inst_87474 = (state_87571[(12)]);
var inst_87480 = figwheel.client.file_reloading.expand_files.call(null,inst_87474);
var state_87571__$1 = state_87571;
var statearr_87632_87702 = state_87571__$1;
(statearr_87632_87702[(2)] = inst_87480);

(statearr_87632_87702[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (11))){
var state_87571__$1 = state_87571;
var statearr_87633_87703 = state_87571__$1;
(statearr_87633_87703[(2)] = null);

(statearr_87633_87703[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (9))){
var inst_87463 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
var statearr_87634_87704 = state_87571__$1;
(statearr_87634_87704[(2)] = inst_87463);

(statearr_87634_87704[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (5))){
var inst_87434 = (state_87571[(8)]);
var inst_87433 = (state_87571[(9)]);
var inst_87436 = (inst_87434 < inst_87433);
var inst_87437 = inst_87436;
var state_87571__$1 = state_87571;
if(cljs.core.truth_(inst_87437)){
var statearr_87635_87705 = state_87571__$1;
(statearr_87635_87705[(1)] = (7));

} else {
var statearr_87636_87706 = state_87571__$1;
(statearr_87636_87706[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (14))){
var inst_87444 = (state_87571[(22)]);
var inst_87453 = cljs.core.first.call(null,inst_87444);
var inst_87454 = figwheel.client.file_reloading.eval_body.call(null,inst_87453,opts);
var inst_87455 = cljs.core.next.call(null,inst_87444);
var inst_87431 = inst_87455;
var inst_87432 = null;
var inst_87433 = (0);
var inst_87434 = (0);
var state_87571__$1 = (function (){var statearr_87637 = state_87571;
(statearr_87637[(7)] = inst_87432);

(statearr_87637[(32)] = inst_87454);

(statearr_87637[(8)] = inst_87434);

(statearr_87637[(9)] = inst_87433);

(statearr_87637[(10)] = inst_87431);

return statearr_87637;
})();
var statearr_87638_87707 = state_87571__$1;
(statearr_87638_87707[(2)] = null);

(statearr_87638_87707[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (45))){
var state_87571__$1 = state_87571;
var statearr_87639_87708 = state_87571__$1;
(statearr_87639_87708[(2)] = null);

(statearr_87639_87708[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (26))){
var inst_87484 = (state_87571[(19)]);
var inst_87487 = (state_87571[(23)]);
var inst_87492 = (state_87571[(24)]);
var inst_87488 = (state_87571[(25)]);
var inst_87490 = (state_87571[(26)]);
var inst_87507 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_87509 = (function (){var all_files = inst_87484;
var res_SINGLEQUOTE_ = inst_87487;
var res = inst_87488;
var files_not_loaded = inst_87490;
var dependencies_that_loaded = inst_87492;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87492,inst_87488,inst_87490,inst_87507,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__87508){
var map__87640 = p__87508;
var map__87640__$1 = ((((!((map__87640 == null)))?((((map__87640.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87640.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87640):map__87640);
var namespace = cljs.core.get.call(null,map__87640__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__87640__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87492,inst_87488,inst_87490,inst_87507,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87510 = cljs.core.map.call(null,inst_87509,inst_87488);
var inst_87511 = cljs.core.pr_str.call(null,inst_87510);
var inst_87512 = figwheel.client.utils.log.call(null,inst_87511);
var inst_87513 = (function (){var all_files = inst_87484;
var res_SINGLEQUOTE_ = inst_87487;
var res = inst_87488;
var files_not_loaded = inst_87490;
var dependencies_that_loaded = inst_87492;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87492,inst_87488,inst_87490,inst_87507,inst_87509,inst_87510,inst_87511,inst_87512,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_87484,inst_87487,inst_87492,inst_87488,inst_87490,inst_87507,inst_87509,inst_87510,inst_87511,inst_87512,state_val_87572,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_87514 = setTimeout(inst_87513,(10));
var state_87571__$1 = (function (){var statearr_87642 = state_87571;
(statearr_87642[(33)] = inst_87512);

(statearr_87642[(34)] = inst_87507);

return statearr_87642;
})();
var statearr_87643_87709 = state_87571__$1;
(statearr_87643_87709[(2)] = inst_87514);

(statearr_87643_87709[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (16))){
var state_87571__$1 = state_87571;
var statearr_87644_87710 = state_87571__$1;
(statearr_87644_87710[(2)] = reload_dependents);

(statearr_87644_87710[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (38))){
var inst_87524 = (state_87571[(16)]);
var inst_87542 = cljs.core.apply.call(null,cljs.core.hash_map,inst_87524);
var state_87571__$1 = state_87571;
var statearr_87645_87711 = state_87571__$1;
(statearr_87645_87711[(2)] = inst_87542);

(statearr_87645_87711[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (30))){
var state_87571__$1 = state_87571;
var statearr_87646_87712 = state_87571__$1;
(statearr_87646_87712[(2)] = null);

(statearr_87646_87712[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (10))){
var inst_87444 = (state_87571[(22)]);
var inst_87446 = cljs.core.chunked_seq_QMARK_.call(null,inst_87444);
var state_87571__$1 = state_87571;
if(inst_87446){
var statearr_87647_87713 = state_87571__$1;
(statearr_87647_87713[(1)] = (13));

} else {
var statearr_87648_87714 = state_87571__$1;
(statearr_87648_87714[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (18))){
var inst_87478 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
if(cljs.core.truth_(inst_87478)){
var statearr_87649_87715 = state_87571__$1;
(statearr_87649_87715[(1)] = (19));

} else {
var statearr_87650_87716 = state_87571__$1;
(statearr_87650_87716[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (42))){
var state_87571__$1 = state_87571;
var statearr_87651_87717 = state_87571__$1;
(statearr_87651_87717[(2)] = null);

(statearr_87651_87717[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (37))){
var inst_87537 = (state_87571[(2)]);
var state_87571__$1 = state_87571;
var statearr_87652_87718 = state_87571__$1;
(statearr_87652_87718[(2)] = inst_87537);

(statearr_87652_87718[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87572 === (8))){
var inst_87444 = (state_87571[(22)]);
var inst_87431 = (state_87571[(10)]);
var inst_87444__$1 = cljs.core.seq.call(null,inst_87431);
var state_87571__$1 = (function (){var statearr_87653 = state_87571;
(statearr_87653[(22)] = inst_87444__$1);

return statearr_87653;
})();
if(inst_87444__$1){
var statearr_87654_87719 = state_87571__$1;
(statearr_87654_87719[(1)] = (10));

} else {
var statearr_87655_87720 = state_87571__$1;
(statearr_87655_87720[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__70820__auto__,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto____0 = (function (){
var statearr_87659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87659[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto__);

(statearr_87659[(1)] = (1));

return statearr_87659;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto____1 = (function (state_87571){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_87571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e87660){if((e87660 instanceof Object)){
var ex__70824__auto__ = e87660;
var statearr_87661_87721 = state_87571;
(statearr_87661_87721[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_87571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e87660;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87722 = state_87571;
state_87571 = G__87722;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto__ = function(state_87571){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto____1.call(this,state_87571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__70936__auto__ = (function (){var statearr_87662 = f__70935__auto__.call(null);
(statearr_87662[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_87662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,map__87416,map__87416__$1,opts,before_jsload,on_jsload,reload_dependents,map__87417,map__87417__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__70934__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__87725,link){
var map__87728 = p__87725;
var map__87728__$1 = ((((!((map__87728 == null)))?((((map__87728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87728.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87728):map__87728);
var file = cljs.core.get.call(null,map__87728__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__87728,map__87728__$1,file){
return (function (p1__87723_SHARP_,p2__87724_SHARP_){
if(cljs.core._EQ_.call(null,p1__87723_SHARP_,p2__87724_SHARP_)){
return p1__87723_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__87728,map__87728__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__87734){
var map__87735 = p__87734;
var map__87735__$1 = ((((!((map__87735 == null)))?((((map__87735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87735.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87735):map__87735);
var match_length = cljs.core.get.call(null,map__87735__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__87735__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__87730_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__87730_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__87737_SHARP_,p2__87738_SHARP_){
return cljs.core.assoc.call(null,p1__87737_SHARP_,cljs.core.get.call(null,p2__87738_SHARP_,key),p2__87738_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6751__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6751__auto__)){
var link = temp__6751__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6751__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6751__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_87739 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_87739);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_87739);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__87740,p__87741){
var map__87746 = p__87740;
var map__87746__$1 = ((((!((map__87746 == null)))?((((map__87746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87746.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87746):map__87746);
var on_cssload = cljs.core.get.call(null,map__87746__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__87747 = p__87741;
var map__87747__$1 = ((((!((map__87747 == null)))?((((map__87747.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87747.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__87747):map__87747);
var files_msg = map__87747__$1;
var files = cljs.core.get.call(null,map__87747__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6753__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6753__auto__)){
var f_datas = temp__6753__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1489355967820