// Compiled by ClojureScript 1.9.494 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy.core.selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__66199__auto__ = elem.textContent;
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var args74448 = [];
var len__67420__auto___74451 = arguments.length;
var i__67421__auto___74452 = (0);
while(true){
if((i__67421__auto___74452 < len__67420__auto___74451)){
args74448.push((arguments[i__67421__auto___74452]));

var G__74453 = (i__67421__auto___74452 + (1));
i__67421__auto___74452 = G__74453;
continue;
} else {
}
break;
}

var G__74450 = args74448.length;
switch (G__74450) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74448.length)].join('')));

}
});

dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});

dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});

dommy.core.style.cljs$lang$maxFixedArity = 2;

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.call(null,elem,k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto__ = elem.classList;
if(cljs.core.truth_(temp__6751__auto__)){
var class_list = temp__6751__auto__;
return class_list.contains(c__$1);
} else {
var temp__6753__auto__ = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(temp__6753__auto__)){
var class_name = temp__6753__auto__;
var temp__6753__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);
if(cljs.core.truth_(temp__6753__auto____$1)){
var i = temp__6753__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var args74455 = [];
var len__67420__auto___74458 = arguments.length;
var i__67421__auto___74459 = (0);
while(true){
if((i__67421__auto___74459 < len__67420__auto___74458)){
args74455.push((arguments[i__67421__auto___74459]));

var G__74460 = (i__67421__auto___74459 + (1));
i__67421__auto___74459 = G__74460;
continue;
} else {
}
break;
}

var G__74457 = args74455.length;
switch (G__74457) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74455.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var args74463 = [];
var len__67420__auto___74466 = arguments.length;
var i__67421__auto___74467 = (0);
while(true){
if((i__67421__auto___74467 < len__67420__auto___74466)){
args74463.push((arguments[i__67421__auto___74467]));

var G__74468 = (i__67421__auto___74467 + (1));
i__67421__auto___74467 = G__74468;
continue;
} else {
}
break;
}

var G__74465 = args74463.length;
switch (G__74465) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74463.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__74462_SHARP_){
return !((p1__74462_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.call(null,document.body,elem,selector);
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if(!((void 0 === elem.textContent))){
elem.textContent = text;
} else {
elem.innerText = text;
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
elem.innerHTML = html;

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
elem.value = value;

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return elem.className = c;
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___74482 = arguments.length;
var i__67421__auto___74483 = (0);
while(true){
if((i__67421__auto___74483 < len__67420__auto___74482)){
args__67427__auto__.push((arguments[i__67421__auto___74483]));

var G__74484 = (i__67421__auto___74483 + (1));
i__67421__auto___74483 = G__74484;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__74472_74485 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__74473_74486 = null;
var count__74474_74487 = (0);
var i__74475_74488 = (0);
while(true){
if((i__74475_74488 < count__74474_74487)){
var vec__74476_74489 = cljs.core._nth.call(null,chunk__74473_74486,i__74475_74488);
var k_74490 = cljs.core.nth.call(null,vec__74476_74489,(0),null);
var v_74491 = cljs.core.nth.call(null,vec__74476_74489,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_74490),v_74491);

var G__74492 = seq__74472_74485;
var G__74493 = chunk__74473_74486;
var G__74494 = count__74474_74487;
var G__74495 = (i__74475_74488 + (1));
seq__74472_74485 = G__74492;
chunk__74473_74486 = G__74493;
count__74474_74487 = G__74494;
i__74475_74488 = G__74495;
continue;
} else {
var temp__6753__auto___74496 = cljs.core.seq.call(null,seq__74472_74485);
if(temp__6753__auto___74496){
var seq__74472_74497__$1 = temp__6753__auto___74496;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74472_74497__$1)){
var c__67110__auto___74498 = cljs.core.chunk_first.call(null,seq__74472_74497__$1);
var G__74499 = cljs.core.chunk_rest.call(null,seq__74472_74497__$1);
var G__74500 = c__67110__auto___74498;
var G__74501 = cljs.core.count.call(null,c__67110__auto___74498);
var G__74502 = (0);
seq__74472_74485 = G__74499;
chunk__74473_74486 = G__74500;
count__74474_74487 = G__74501;
i__74475_74488 = G__74502;
continue;
} else {
var vec__74479_74503 = cljs.core.first.call(null,seq__74472_74497__$1);
var k_74504 = cljs.core.nth.call(null,vec__74479_74503,(0),null);
var v_74505 = cljs.core.nth.call(null,vec__74479_74503,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_74504),v_74505);

var G__74506 = cljs.core.next.call(null,seq__74472_74497__$1);
var G__74507 = null;
var G__74508 = (0);
var G__74509 = (0);
seq__74472_74485 = G__74506;
chunk__74473_74486 = G__74507;
count__74474_74487 = G__74508;
i__74475_74488 = G__74509;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq74470){
var G__74471 = cljs.core.first.call(null,seq74470);
var seq74470__$1 = cljs.core.next.call(null,seq74470);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74471,seq74470__$1);
});

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___74516 = arguments.length;
var i__67421__auto___74517 = (0);
while(true){
if((i__67421__auto___74517 < len__67420__auto___74516)){
args__67427__auto__.push((arguments[i__67421__auto___74517]));

var G__74518 = (i__67421__auto___74517 + (1));
i__67421__auto___74517 = G__74518;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__74512_74519 = cljs.core.seq.call(null,keywords);
var chunk__74513_74520 = null;
var count__74514_74521 = (0);
var i__74515_74522 = (0);
while(true){
if((i__74515_74522 < count__74514_74521)){
var kw_74523 = cljs.core._nth.call(null,chunk__74513_74520,i__74515_74522);
style.removeProperty(dommy.utils.as_str.call(null,kw_74523));

var G__74524 = seq__74512_74519;
var G__74525 = chunk__74513_74520;
var G__74526 = count__74514_74521;
var G__74527 = (i__74515_74522 + (1));
seq__74512_74519 = G__74524;
chunk__74513_74520 = G__74525;
count__74514_74521 = G__74526;
i__74515_74522 = G__74527;
continue;
} else {
var temp__6753__auto___74528 = cljs.core.seq.call(null,seq__74512_74519);
if(temp__6753__auto___74528){
var seq__74512_74529__$1 = temp__6753__auto___74528;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74512_74529__$1)){
var c__67110__auto___74530 = cljs.core.chunk_first.call(null,seq__74512_74529__$1);
var G__74531 = cljs.core.chunk_rest.call(null,seq__74512_74529__$1);
var G__74532 = c__67110__auto___74530;
var G__74533 = cljs.core.count.call(null,c__67110__auto___74530);
var G__74534 = (0);
seq__74512_74519 = G__74531;
chunk__74513_74520 = G__74532;
count__74514_74521 = G__74533;
i__74515_74522 = G__74534;
continue;
} else {
var kw_74535 = cljs.core.first.call(null,seq__74512_74529__$1);
style.removeProperty(dommy.utils.as_str.call(null,kw_74535));

var G__74536 = cljs.core.next.call(null,seq__74512_74529__$1);
var G__74537 = null;
var G__74538 = (0);
var G__74539 = (0);
seq__74512_74519 = G__74536;
chunk__74513_74520 = G__74537;
count__74514_74521 = G__74538;
i__74515_74522 = G__74539;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq74510){
var G__74511 = cljs.core.first.call(null,seq74510);
var seq74510__$1 = cljs.core.next.call(null,seq74510);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74511,seq74510__$1);
});

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___74552 = arguments.length;
var i__67421__auto___74553 = (0);
while(true){
if((i__67421__auto___74553 < len__67420__auto___74552)){
args__67427__auto__.push((arguments[i__67421__auto___74553]));

var G__74554 = (i__67421__auto___74553 + (1));
i__67421__auto___74553 = G__74554;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__74542_74555 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__74543_74556 = null;
var count__74544_74557 = (0);
var i__74545_74558 = (0);
while(true){
if((i__74545_74558 < count__74544_74557)){
var vec__74546_74559 = cljs.core._nth.call(null,chunk__74543_74556,i__74545_74558);
var k_74560 = cljs.core.nth.call(null,vec__74546_74559,(0),null);
var v_74561 = cljs.core.nth.call(null,vec__74546_74559,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_74560,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_74561),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''));

var G__74562 = seq__74542_74555;
var G__74563 = chunk__74543_74556;
var G__74564 = count__74544_74557;
var G__74565 = (i__74545_74558 + (1));
seq__74542_74555 = G__74562;
chunk__74543_74556 = G__74563;
count__74544_74557 = G__74564;
i__74545_74558 = G__74565;
continue;
} else {
var temp__6753__auto___74566 = cljs.core.seq.call(null,seq__74542_74555);
if(temp__6753__auto___74566){
var seq__74542_74567__$1 = temp__6753__auto___74566;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74542_74567__$1)){
var c__67110__auto___74568 = cljs.core.chunk_first.call(null,seq__74542_74567__$1);
var G__74569 = cljs.core.chunk_rest.call(null,seq__74542_74567__$1);
var G__74570 = c__67110__auto___74568;
var G__74571 = cljs.core.count.call(null,c__67110__auto___74568);
var G__74572 = (0);
seq__74542_74555 = G__74569;
chunk__74543_74556 = G__74570;
count__74544_74557 = G__74571;
i__74545_74558 = G__74572;
continue;
} else {
var vec__74549_74573 = cljs.core.first.call(null,seq__74542_74567__$1);
var k_74574 = cljs.core.nth.call(null,vec__74549_74573,(0),null);
var v_74575 = cljs.core.nth.call(null,vec__74549_74573,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_74574,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_74575),cljs.core.str.cljs$core$IFn$_invoke$arity$1("px")].join(''));

var G__74576 = cljs.core.next.call(null,seq__74542_74567__$1);
var G__74577 = null;
var G__74578 = (0);
var G__74579 = (0);
seq__74542_74555 = G__74576;
chunk__74543_74556 = G__74577;
count__74544_74557 = G__74578;
i__74545_74558 = G__74579;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq74540){
var G__74541 = cljs.core.first.call(null,seq74540);
var seq74540__$1 = cljs.core.next.call(null,seq74540);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74541,seq74540__$1);
});

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var args74580 = [];
var len__67420__auto___74599 = arguments.length;
var i__67421__auto___74600 = (0);
while(true){
if((i__67421__auto___74600 < len__67420__auto___74599)){
args74580.push((arguments[i__67421__auto___74600]));

var G__74601 = (i__67421__auto___74600 + (1));
i__67421__auto___74600 = G__74601;
continue;
} else {
}
break;
}

var G__74586 = args74580.length;
switch (G__74586) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args74580.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__67443__auto__);

}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.call(null,elem,k,dommy.utils.as_str.call(null,k));
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__74587 = elem;
(G__74587[k__$1] = v);

return G__74587;
} else {
var G__74588 = elem;
G__74588.setAttribute(k__$1,v);

return G__74588;
}
} else {
return null;
}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__74589_74603 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__74590_74604 = null;
var count__74591_74605 = (0);
var i__74592_74606 = (0);
while(true){
if((i__74592_74606 < count__74591_74605)){
var vec__74593_74607 = cljs.core._nth.call(null,chunk__74590_74604,i__74592_74606);
var k_74608__$1 = cljs.core.nth.call(null,vec__74593_74607,(0),null);
var v_74609__$1 = cljs.core.nth.call(null,vec__74593_74607,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_74608__$1,v_74609__$1);

var G__74610 = seq__74589_74603;
var G__74611 = chunk__74590_74604;
var G__74612 = count__74591_74605;
var G__74613 = (i__74592_74606 + (1));
seq__74589_74603 = G__74610;
chunk__74590_74604 = G__74611;
count__74591_74605 = G__74612;
i__74592_74606 = G__74613;
continue;
} else {
var temp__6753__auto___74614 = cljs.core.seq.call(null,seq__74589_74603);
if(temp__6753__auto___74614){
var seq__74589_74615__$1 = temp__6753__auto___74614;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74589_74615__$1)){
var c__67110__auto___74616 = cljs.core.chunk_first.call(null,seq__74589_74615__$1);
var G__74617 = cljs.core.chunk_rest.call(null,seq__74589_74615__$1);
var G__74618 = c__67110__auto___74616;
var G__74619 = cljs.core.count.call(null,c__67110__auto___74616);
var G__74620 = (0);
seq__74589_74603 = G__74617;
chunk__74590_74604 = G__74618;
count__74591_74605 = G__74619;
i__74592_74606 = G__74620;
continue;
} else {
var vec__74596_74621 = cljs.core.first.call(null,seq__74589_74615__$1);
var k_74622__$1 = cljs.core.nth.call(null,vec__74596_74621,(0),null);
var v_74623__$1 = cljs.core.nth.call(null,vec__74596_74621,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_74622__$1,v_74623__$1);

var G__74624 = cljs.core.next.call(null,seq__74589_74615__$1);
var G__74625 = null;
var G__74626 = (0);
var G__74627 = (0);
seq__74589_74603 = G__74624;
chunk__74590_74604 = G__74625;
count__74591_74605 = G__74626;
i__74592_74606 = G__74627;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq74581){
var G__74582 = cljs.core.first.call(null,seq74581);
var seq74581__$1 = cljs.core.next.call(null,seq74581);
var G__74583 = cljs.core.first.call(null,seq74581__$1);
var seq74581__$2 = cljs.core.next.call(null,seq74581__$1);
var G__74584 = cljs.core.first.call(null,seq74581__$2);
var seq74581__$3 = cljs.core.next.call(null,seq74581__$2);
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74582,G__74583,G__74584,seq74581__$3);
});

dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var args74628 = [];
var len__67420__auto___74638 = arguments.length;
var i__67421__auto___74639 = (0);
while(true){
if((i__67421__auto___74639 < len__67420__auto___74638)){
args74628.push((arguments[i__67421__auto___74639]));

var G__74640 = (i__67421__auto___74639 + (1));
i__67421__auto___74639 = G__74640;
continue;
} else {
}
break;
}

var G__74633 = args74628.length;
switch (G__74633) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args74628.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67443__auto__);

}
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_74642__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_74642__$1))){
dommy.core.set_class_BANG_.call(null,elem,"");
} else {
elem.removeAttribute(k_74642__$1);
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__74634_74643 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__74635_74644 = null;
var count__74636_74645 = (0);
var i__74637_74646 = (0);
while(true){
if((i__74637_74646 < count__74636_74645)){
var k_74647__$1 = cljs.core._nth.call(null,chunk__74635_74644,i__74637_74646);
dommy.core.remove_attr_BANG_.call(null,elem,k_74647__$1);

var G__74648 = seq__74634_74643;
var G__74649 = chunk__74635_74644;
var G__74650 = count__74636_74645;
var G__74651 = (i__74637_74646 + (1));
seq__74634_74643 = G__74648;
chunk__74635_74644 = G__74649;
count__74636_74645 = G__74650;
i__74637_74646 = G__74651;
continue;
} else {
var temp__6753__auto___74652 = cljs.core.seq.call(null,seq__74634_74643);
if(temp__6753__auto___74652){
var seq__74634_74653__$1 = temp__6753__auto___74652;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74634_74653__$1)){
var c__67110__auto___74654 = cljs.core.chunk_first.call(null,seq__74634_74653__$1);
var G__74655 = cljs.core.chunk_rest.call(null,seq__74634_74653__$1);
var G__74656 = c__67110__auto___74654;
var G__74657 = cljs.core.count.call(null,c__67110__auto___74654);
var G__74658 = (0);
seq__74634_74643 = G__74655;
chunk__74635_74644 = G__74656;
count__74636_74645 = G__74657;
i__74637_74646 = G__74658;
continue;
} else {
var k_74659__$1 = cljs.core.first.call(null,seq__74634_74653__$1);
dommy.core.remove_attr_BANG_.call(null,elem,k_74659__$1);

var G__74660 = cljs.core.next.call(null,seq__74634_74653__$1);
var G__74661 = null;
var G__74662 = (0);
var G__74663 = (0);
seq__74634_74643 = G__74660;
chunk__74635_74644 = G__74661;
count__74636_74645 = G__74662;
i__74637_74646 = G__74663;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq74629){
var G__74630 = cljs.core.first.call(null,seq74629);
var seq74629__$1 = cljs.core.next.call(null,seq74629);
var G__74631 = cljs.core.first.call(null,seq74629__$1);
var seq74629__$2 = cljs.core.next.call(null,seq74629__$1);
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74630,G__74631,seq74629__$2);
});

dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var args74664 = [];
var len__67420__auto___74667 = arguments.length;
var i__67421__auto___74668 = (0);
while(true){
if((i__67421__auto___74668 < len__67420__auto___74667)){
args74664.push((arguments[i__67421__auto___74668]));

var G__74669 = (i__67421__auto___74668 + (1));
i__67421__auto___74668 = G__74669;
continue;
} else {
}
break;
}

var G__74666 = args74664.length;
switch (G__74666) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74664.length)].join('')));

}
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.call(null,elem,k);
} else {
return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});

dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var args74671 = [];
var len__67420__auto___74689 = arguments.length;
var i__67421__auto___74690 = (0);
while(true){
if((i__67421__auto___74690 < len__67420__auto___74689)){
args74671.push((arguments[i__67421__auto___74690]));

var G__74691 = (i__67421__auto___74690 + (1));
i__67421__auto___74690 = G__74691;
continue;
} else {
}
break;
}

var G__74676 = args74671.length;
switch (G__74676) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args74671.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67443__auto__);

}
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);
if(cljs.core.seq.call(null,classes__$1)){
var temp__6751__auto___74693 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___74693)){
var class_list_74694 = temp__6751__auto___74693;
var seq__74677_74695 = cljs.core.seq.call(null,classes__$1);
var chunk__74678_74696 = null;
var count__74679_74697 = (0);
var i__74680_74698 = (0);
while(true){
if((i__74680_74698 < count__74679_74697)){
var c_74699 = cljs.core._nth.call(null,chunk__74678_74696,i__74680_74698);
class_list_74694.add(c_74699);

var G__74700 = seq__74677_74695;
var G__74701 = chunk__74678_74696;
var G__74702 = count__74679_74697;
var G__74703 = (i__74680_74698 + (1));
seq__74677_74695 = G__74700;
chunk__74678_74696 = G__74701;
count__74679_74697 = G__74702;
i__74680_74698 = G__74703;
continue;
} else {
var temp__6753__auto___74704 = cljs.core.seq.call(null,seq__74677_74695);
if(temp__6753__auto___74704){
var seq__74677_74705__$1 = temp__6753__auto___74704;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74677_74705__$1)){
var c__67110__auto___74706 = cljs.core.chunk_first.call(null,seq__74677_74705__$1);
var G__74707 = cljs.core.chunk_rest.call(null,seq__74677_74705__$1);
var G__74708 = c__67110__auto___74706;
var G__74709 = cljs.core.count.call(null,c__67110__auto___74706);
var G__74710 = (0);
seq__74677_74695 = G__74707;
chunk__74678_74696 = G__74708;
count__74679_74697 = G__74709;
i__74680_74698 = G__74710;
continue;
} else {
var c_74711 = cljs.core.first.call(null,seq__74677_74705__$1);
class_list_74694.add(c_74711);

var G__74712 = cljs.core.next.call(null,seq__74677_74705__$1);
var G__74713 = null;
var G__74714 = (0);
var G__74715 = (0);
seq__74677_74695 = G__74712;
chunk__74678_74696 = G__74713;
count__74679_74697 = G__74714;
i__74680_74698 = G__74715;
continue;
}
} else {
}
}
break;
}
} else {
var seq__74681_74716 = cljs.core.seq.call(null,classes__$1);
var chunk__74682_74717 = null;
var count__74683_74718 = (0);
var i__74684_74719 = (0);
while(true){
if((i__74684_74719 < count__74683_74718)){
var c_74720 = cljs.core._nth.call(null,chunk__74682_74717,i__74684_74719);
var class_name_74721 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_74721,c_74720))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_74721 === ""))?c_74720:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_74721),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_74720)].join('')));
}

var G__74722 = seq__74681_74716;
var G__74723 = chunk__74682_74717;
var G__74724 = count__74683_74718;
var G__74725 = (i__74684_74719 + (1));
seq__74681_74716 = G__74722;
chunk__74682_74717 = G__74723;
count__74683_74718 = G__74724;
i__74684_74719 = G__74725;
continue;
} else {
var temp__6753__auto___74726 = cljs.core.seq.call(null,seq__74681_74716);
if(temp__6753__auto___74726){
var seq__74681_74727__$1 = temp__6753__auto___74726;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74681_74727__$1)){
var c__67110__auto___74728 = cljs.core.chunk_first.call(null,seq__74681_74727__$1);
var G__74729 = cljs.core.chunk_rest.call(null,seq__74681_74727__$1);
var G__74730 = c__67110__auto___74728;
var G__74731 = cljs.core.count.call(null,c__67110__auto___74728);
var G__74732 = (0);
seq__74681_74716 = G__74729;
chunk__74682_74717 = G__74730;
count__74683_74718 = G__74731;
i__74684_74719 = G__74732;
continue;
} else {
var c_74733 = cljs.core.first.call(null,seq__74681_74727__$1);
var class_name_74734 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_74734,c_74733))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_74734 === ""))?c_74733:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_74734),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_74733)].join('')));
}

var G__74735 = cljs.core.next.call(null,seq__74681_74727__$1);
var G__74736 = null;
var G__74737 = (0);
var G__74738 = (0);
seq__74681_74716 = G__74735;
chunk__74682_74717 = G__74736;
count__74683_74718 = G__74737;
i__74684_74719 = G__74738;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__74685_74739 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__74686_74740 = null;
var count__74687_74741 = (0);
var i__74688_74742 = (0);
while(true){
if((i__74688_74742 < count__74687_74741)){
var c_74743 = cljs.core._nth.call(null,chunk__74686_74740,i__74688_74742);
dommy.core.add_class_BANG_.call(null,elem,c_74743);

var G__74744 = seq__74685_74739;
var G__74745 = chunk__74686_74740;
var G__74746 = count__74687_74741;
var G__74747 = (i__74688_74742 + (1));
seq__74685_74739 = G__74744;
chunk__74686_74740 = G__74745;
count__74687_74741 = G__74746;
i__74688_74742 = G__74747;
continue;
} else {
var temp__6753__auto___74748 = cljs.core.seq.call(null,seq__74685_74739);
if(temp__6753__auto___74748){
var seq__74685_74749__$1 = temp__6753__auto___74748;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74685_74749__$1)){
var c__67110__auto___74750 = cljs.core.chunk_first.call(null,seq__74685_74749__$1);
var G__74751 = cljs.core.chunk_rest.call(null,seq__74685_74749__$1);
var G__74752 = c__67110__auto___74750;
var G__74753 = cljs.core.count.call(null,c__67110__auto___74750);
var G__74754 = (0);
seq__74685_74739 = G__74751;
chunk__74686_74740 = G__74752;
count__74687_74741 = G__74753;
i__74688_74742 = G__74754;
continue;
} else {
var c_74755 = cljs.core.first.call(null,seq__74685_74749__$1);
dommy.core.add_class_BANG_.call(null,elem,c_74755);

var G__74756 = cljs.core.next.call(null,seq__74685_74749__$1);
var G__74757 = null;
var G__74758 = (0);
var G__74759 = (0);
seq__74685_74739 = G__74756;
chunk__74686_74740 = G__74757;
count__74687_74741 = G__74758;
i__74688_74742 = G__74759;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq74672){
var G__74673 = cljs.core.first.call(null,seq74672);
var seq74672__$1 = cljs.core.next.call(null,seq74672);
var G__74674 = cljs.core.first.call(null,seq74672__$1);
var seq74672__$2 = cljs.core.next.call(null,seq74672__$1);
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74673,G__74674,seq74672__$2);
});

dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var args74760 = [];
var len__67420__auto___74770 = arguments.length;
var i__67421__auto___74771 = (0);
while(true){
if((i__67421__auto___74771 < len__67420__auto___74770)){
args74760.push((arguments[i__67421__auto___74771]));

var G__74772 = (i__67421__auto___74771 + (1));
i__67421__auto___74771 = G__74772;
continue;
} else {
}
break;
}

var G__74765 = args74760.length;
switch (G__74765) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args74760.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67443__auto__);

}
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto___74774 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___74774)){
var class_list_74775 = temp__6751__auto___74774;
class_list_74775.remove(c__$1);
} else {
var class_name_74776 = dommy.core.class$.call(null,elem);
var new_class_name_74777 = dommy.utils.remove_class_str.call(null,class_name_74776,c__$1);
if((class_name_74776 === new_class_name_74777)){
} else {
dommy.core.set_class_BANG_.call(null,elem,new_class_name_74777);
}
}

return elem;
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__74766 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__74767 = null;
var count__74768 = (0);
var i__74769 = (0);
while(true){
if((i__74769 < count__74768)){
var c = cljs.core._nth.call(null,chunk__74767,i__74769);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__74778 = seq__74766;
var G__74779 = chunk__74767;
var G__74780 = count__74768;
var G__74781 = (i__74769 + (1));
seq__74766 = G__74778;
chunk__74767 = G__74779;
count__74768 = G__74780;
i__74769 = G__74781;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__74766);
if(temp__6753__auto__){
var seq__74766__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74766__$1)){
var c__67110__auto__ = cljs.core.chunk_first.call(null,seq__74766__$1);
var G__74782 = cljs.core.chunk_rest.call(null,seq__74766__$1);
var G__74783 = c__67110__auto__;
var G__74784 = cljs.core.count.call(null,c__67110__auto__);
var G__74785 = (0);
seq__74766 = G__74782;
chunk__74767 = G__74783;
count__74768 = G__74784;
i__74769 = G__74785;
continue;
} else {
var c = cljs.core.first.call(null,seq__74766__$1);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__74786 = cljs.core.next.call(null,seq__74766__$1);
var G__74787 = null;
var G__74788 = (0);
var G__74789 = (0);
seq__74766 = G__74786;
chunk__74767 = G__74787;
count__74768 = G__74788;
i__74769 = G__74789;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq74761){
var G__74762 = cljs.core.first.call(null,seq74761);
var seq74761__$1 = cljs.core.next.call(null,seq74761);
var G__74763 = cljs.core.first.call(null,seq74761__$1);
var seq74761__$2 = cljs.core.next.call(null,seq74761__$1);
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74762,G__74763,seq74761__$2);
});

dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var args74790 = [];
var len__67420__auto___74793 = arguments.length;
var i__67421__auto___74794 = (0);
while(true){
if((i__67421__auto___74794 < len__67420__auto___74793)){
args74790.push((arguments[i__67421__auto___74794]));

var G__74795 = (i__67421__auto___74794 + (1));
i__67421__auto___74794 = G__74795;
continue;
} else {
}
break;
}

var G__74792 = args74790.length;
switch (G__74792) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74790.length)].join('')));

}
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__6751__auto___74797 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___74797)){
var class_list_74798 = temp__6751__auto___74797;
class_list_74798.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.call(null,elem,class$);
} else {
dommy.core.remove_class_BANG_.call(null,elem,class$);
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var args74799 = [];
var len__67420__auto___74802 = arguments.length;
var i__67421__auto___74803 = (0);
while(true){
if((i__67421__auto___74803 < len__67420__auto___74802)){
args74799.push((arguments[i__67421__auto___74803]));

var G__74804 = (i__67421__auto___74803 + (1));
i__67421__auto___74803 = G__74804;
continue;
} else {
}
break;
}

var G__74801 = args74799.length;
switch (G__74801) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74799.length)].join('')));

}
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});

dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var args74806 = [];
var len__67420__auto___74809 = arguments.length;
var i__67421__auto___74810 = (0);
while(true){
if((i__67421__auto___74810 < len__67420__auto___74809)){
args74806.push((arguments[i__67421__auto___74810]));

var G__74811 = (i__67421__auto___74810 + (1));
i__67421__auto___74810 = G__74811;
continue;
} else {
}
break;
}

var G__74808 = args74806.length;
switch (G__74808) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74806.length)].join('')));

}
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$lang$maxFixedArity = 2;

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var args74813 = [];
var len__67420__auto___74824 = arguments.length;
var i__67421__auto___74825 = (0);
while(true){
if((i__67421__auto___74825 < len__67420__auto___74824)){
args74813.push((arguments[i__67421__auto___74825]));

var G__74826 = (i__67421__auto___74825 + (1));
i__67421__auto___74825 = G__74826;
continue;
} else {
}
break;
}

var G__74818 = args74813.length;
switch (G__74818) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args74813.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67443__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__74819 = parent;
G__74819.appendChild(child);

return G__74819;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__74820_74828 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__74821_74829 = null;
var count__74822_74830 = (0);
var i__74823_74831 = (0);
while(true){
if((i__74823_74831 < count__74822_74830)){
var c_74832 = cljs.core._nth.call(null,chunk__74821_74829,i__74823_74831);
dommy.core.append_BANG_.call(null,parent,c_74832);

var G__74833 = seq__74820_74828;
var G__74834 = chunk__74821_74829;
var G__74835 = count__74822_74830;
var G__74836 = (i__74823_74831 + (1));
seq__74820_74828 = G__74833;
chunk__74821_74829 = G__74834;
count__74822_74830 = G__74835;
i__74823_74831 = G__74836;
continue;
} else {
var temp__6753__auto___74837 = cljs.core.seq.call(null,seq__74820_74828);
if(temp__6753__auto___74837){
var seq__74820_74838__$1 = temp__6753__auto___74837;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74820_74838__$1)){
var c__67110__auto___74839 = cljs.core.chunk_first.call(null,seq__74820_74838__$1);
var G__74840 = cljs.core.chunk_rest.call(null,seq__74820_74838__$1);
var G__74841 = c__67110__auto___74839;
var G__74842 = cljs.core.count.call(null,c__67110__auto___74839);
var G__74843 = (0);
seq__74820_74828 = G__74840;
chunk__74821_74829 = G__74841;
count__74822_74830 = G__74842;
i__74823_74831 = G__74843;
continue;
} else {
var c_74844 = cljs.core.first.call(null,seq__74820_74838__$1);
dommy.core.append_BANG_.call(null,parent,c_74844);

var G__74845 = cljs.core.next.call(null,seq__74820_74838__$1);
var G__74846 = null;
var G__74847 = (0);
var G__74848 = (0);
seq__74820_74828 = G__74845;
chunk__74821_74829 = G__74846;
count__74822_74830 = G__74847;
i__74823_74831 = G__74848;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq74814){
var G__74815 = cljs.core.first.call(null,seq74814);
var seq74814__$1 = cljs.core.next.call(null,seq74814);
var G__74816 = cljs.core.first.call(null,seq74814__$1);
var seq74814__$2 = cljs.core.next.call(null,seq74814__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74815,G__74816,seq74814__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var args74849 = [];
var len__67420__auto___74860 = arguments.length;
var i__67421__auto___74861 = (0);
while(true){
if((i__67421__auto___74861 < len__67420__auto___74860)){
args74849.push((arguments[i__67421__auto___74861]));

var G__74862 = (i__67421__auto___74861 + (1));
i__67421__auto___74861 = G__74862;
continue;
} else {
}
break;
}

var G__74854 = args74849.length;
switch (G__74854) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args74849.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67443__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__74855 = parent;
G__74855.insertBefore(child,parent.firstChild);

return G__74855;
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__74856_74864 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__74857_74865 = null;
var count__74858_74866 = (0);
var i__74859_74867 = (0);
while(true){
if((i__74859_74867 < count__74858_74866)){
var c_74868 = cljs.core._nth.call(null,chunk__74857_74865,i__74859_74867);
dommy.core.prepend_BANG_.call(null,parent,c_74868);

var G__74869 = seq__74856_74864;
var G__74870 = chunk__74857_74865;
var G__74871 = count__74858_74866;
var G__74872 = (i__74859_74867 + (1));
seq__74856_74864 = G__74869;
chunk__74857_74865 = G__74870;
count__74858_74866 = G__74871;
i__74859_74867 = G__74872;
continue;
} else {
var temp__6753__auto___74873 = cljs.core.seq.call(null,seq__74856_74864);
if(temp__6753__auto___74873){
var seq__74856_74874__$1 = temp__6753__auto___74873;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74856_74874__$1)){
var c__67110__auto___74875 = cljs.core.chunk_first.call(null,seq__74856_74874__$1);
var G__74876 = cljs.core.chunk_rest.call(null,seq__74856_74874__$1);
var G__74877 = c__67110__auto___74875;
var G__74878 = cljs.core.count.call(null,c__67110__auto___74875);
var G__74879 = (0);
seq__74856_74864 = G__74876;
chunk__74857_74865 = G__74877;
count__74858_74866 = G__74878;
i__74859_74867 = G__74879;
continue;
} else {
var c_74880 = cljs.core.first.call(null,seq__74856_74874__$1);
dommy.core.prepend_BANG_.call(null,parent,c_74880);

var G__74881 = cljs.core.next.call(null,seq__74856_74874__$1);
var G__74882 = null;
var G__74883 = (0);
var G__74884 = (0);
seq__74856_74864 = G__74881;
chunk__74857_74865 = G__74882;
count__74858_74866 = G__74883;
i__74859_74867 = G__74884;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq74850){
var G__74851 = cljs.core.first.call(null,seq74850);
var seq74850__$1 = cljs.core.next.call(null,seq74850);
var G__74852 = cljs.core.first.call(null,seq74850__$1);
var seq74850__$2 = cljs.core.next.call(null,seq74850__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74851,G__74852,seq74850__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent.call(null,other);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__6751__auto___74885 = other.nextSibling;
if(cljs.core.truth_(temp__6751__auto___74885)){
var next_74886 = temp__6751__auto___74885;
dommy.core.insert_before_BANG_.call(null,elem,next_74886);
} else {
dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var args74887 = [];
var len__67420__auto___74891 = arguments.length;
var i__67421__auto___74892 = (0);
while(true){
if((i__67421__auto___74892 < len__67420__auto___74891)){
args74887.push((arguments[i__67421__auto___74892]));

var G__74893 = (i__67421__auto___74892 + (1));
i__67421__auto___74892 = G__74893;
continue;
} else {
}
break;
}

var G__74889 = args74887.length;
switch (G__74889) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74887.length)].join('')));

}
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Target element must have a parent"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("p")].join('')));
}

return dommy.core.remove_BANG_.call(null,p,elem);
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__74890 = p;
G__74890.removeChild(elem);

return G__74890;
});

dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__74895){
var vec__74896 = p__74895;
var special_mouse_event = cljs.core.nth.call(null,vec__74896,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__74896,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,((function (vec__74896,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__74896,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__66199__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__66187__auto__ = related_target;
if(cljs.core.truth_(and__66187__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__66187__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__74896,special_mouse_event,real_mouse_event))
});})(vec__74896,special_mouse_event,real_mouse_event))
])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,elem,event.target,selector);
if(cljs.core.truth_((function (){var and__66187__auto__ = selected_target;
if(cljs.core.truth_(and__66187__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__66187__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__66199__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___74902 = arguments.length;
var i__67421__auto___74903 = (0);
while(true){
if((i__67421__auto___74903 < len__67420__auto___74902)){
args__67427__auto__.push((arguments[i__67421__auto___74903]));

var G__74904 = (i__67421__auto___74903 + (1));
i__67421__auto___74903 = G__74904;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((2) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__67428__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq74899){
var G__74900 = cljs.core.first.call(null,seq74899);
var seq74899__$1 = cljs.core.next.call(null,seq74899);
var G__74901 = cljs.core.first.call(null,seq74899__$1);
var seq74899__$2 = cljs.core.next.call(null,seq74899__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74900,G__74901,seq74899__$2);
});

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___74944 = arguments.length;
var i__67421__auto___74945 = (0);
while(true){
if((i__67421__auto___74945 < len__67420__auto___74944)){
args__67427__auto__.push((arguments[i__67421__auto___74945]));

var G__74946 = (i__67421__auto___74945 + (1));
i__67421__auto___74945 = G__74946;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__74907_74947 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_74948 = cljs.core.nth.call(null,vec__74907_74947,(0),null);
var selector_74949 = cljs.core.nth.call(null,vec__74907_74947,(1),null);
var seq__74910_74950 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__74917_74951 = null;
var count__74918_74952 = (0);
var i__74919_74953 = (0);
while(true){
if((i__74919_74953 < count__74918_74952)){
var vec__74926_74954 = cljs.core._nth.call(null,chunk__74917_74951,i__74919_74953);
var orig_type_74955 = cljs.core.nth.call(null,vec__74926_74954,(0),null);
var f_74956 = cljs.core.nth.call(null,vec__74926_74954,(1),null);
var seq__74920_74957 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_74955,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_74955,cljs.core.identity])));
var chunk__74922_74958 = null;
var count__74923_74959 = (0);
var i__74924_74960 = (0);
while(true){
if((i__74924_74960 < count__74923_74959)){
var vec__74929_74961 = cljs.core._nth.call(null,chunk__74922_74958,i__74924_74960);
var actual_type_74962 = cljs.core.nth.call(null,vec__74929_74961,(0),null);
var factory_74963 = cljs.core.nth.call(null,vec__74929_74961,(1),null);
var canonical_f_74964 = (cljs.core.truth_(selector_74949)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74948,selector_74949):cljs.core.identity).call(null,factory_74963.call(null,f_74956));
dommy.core.update_event_listeners_BANG_.call(null,elem_74948,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74949,actual_type_74962,f_74956], null),canonical_f_74964);

if(cljs.core.truth_(elem_74948.addEventListener)){
elem_74948.addEventListener(cljs.core.name.call(null,actual_type_74962),canonical_f_74964);
} else {
elem_74948.attachEvent(cljs.core.name.call(null,actual_type_74962),canonical_f_74964);
}

var G__74965 = seq__74920_74957;
var G__74966 = chunk__74922_74958;
var G__74967 = count__74923_74959;
var G__74968 = (i__74924_74960 + (1));
seq__74920_74957 = G__74965;
chunk__74922_74958 = G__74966;
count__74923_74959 = G__74967;
i__74924_74960 = G__74968;
continue;
} else {
var temp__6753__auto___74969 = cljs.core.seq.call(null,seq__74920_74957);
if(temp__6753__auto___74969){
var seq__74920_74970__$1 = temp__6753__auto___74969;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74920_74970__$1)){
var c__67110__auto___74971 = cljs.core.chunk_first.call(null,seq__74920_74970__$1);
var G__74972 = cljs.core.chunk_rest.call(null,seq__74920_74970__$1);
var G__74973 = c__67110__auto___74971;
var G__74974 = cljs.core.count.call(null,c__67110__auto___74971);
var G__74975 = (0);
seq__74920_74957 = G__74972;
chunk__74922_74958 = G__74973;
count__74923_74959 = G__74974;
i__74924_74960 = G__74975;
continue;
} else {
var vec__74932_74976 = cljs.core.first.call(null,seq__74920_74970__$1);
var actual_type_74977 = cljs.core.nth.call(null,vec__74932_74976,(0),null);
var factory_74978 = cljs.core.nth.call(null,vec__74932_74976,(1),null);
var canonical_f_74979 = (cljs.core.truth_(selector_74949)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74948,selector_74949):cljs.core.identity).call(null,factory_74978.call(null,f_74956));
dommy.core.update_event_listeners_BANG_.call(null,elem_74948,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74949,actual_type_74977,f_74956], null),canonical_f_74979);

if(cljs.core.truth_(elem_74948.addEventListener)){
elem_74948.addEventListener(cljs.core.name.call(null,actual_type_74977),canonical_f_74979);
} else {
elem_74948.attachEvent(cljs.core.name.call(null,actual_type_74977),canonical_f_74979);
}

var G__74980 = cljs.core.next.call(null,seq__74920_74970__$1);
var G__74981 = null;
var G__74982 = (0);
var G__74983 = (0);
seq__74920_74957 = G__74980;
chunk__74922_74958 = G__74981;
count__74923_74959 = G__74982;
i__74924_74960 = G__74983;
continue;
}
} else {
}
}
break;
}

var G__74984 = seq__74910_74950;
var G__74985 = chunk__74917_74951;
var G__74986 = count__74918_74952;
var G__74987 = (i__74919_74953 + (1));
seq__74910_74950 = G__74984;
chunk__74917_74951 = G__74985;
count__74918_74952 = G__74986;
i__74919_74953 = G__74987;
continue;
} else {
var temp__6753__auto___74988 = cljs.core.seq.call(null,seq__74910_74950);
if(temp__6753__auto___74988){
var seq__74910_74989__$1 = temp__6753__auto___74988;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74910_74989__$1)){
var c__67110__auto___74990 = cljs.core.chunk_first.call(null,seq__74910_74989__$1);
var G__74991 = cljs.core.chunk_rest.call(null,seq__74910_74989__$1);
var G__74992 = c__67110__auto___74990;
var G__74993 = cljs.core.count.call(null,c__67110__auto___74990);
var G__74994 = (0);
seq__74910_74950 = G__74991;
chunk__74917_74951 = G__74992;
count__74918_74952 = G__74993;
i__74919_74953 = G__74994;
continue;
} else {
var vec__74935_74995 = cljs.core.first.call(null,seq__74910_74989__$1);
var orig_type_74996 = cljs.core.nth.call(null,vec__74935_74995,(0),null);
var f_74997 = cljs.core.nth.call(null,vec__74935_74995,(1),null);
var seq__74911_74998 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_74996,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_74996,cljs.core.identity])));
var chunk__74913_74999 = null;
var count__74914_75000 = (0);
var i__74915_75001 = (0);
while(true){
if((i__74915_75001 < count__74914_75000)){
var vec__74938_75002 = cljs.core._nth.call(null,chunk__74913_74999,i__74915_75001);
var actual_type_75003 = cljs.core.nth.call(null,vec__74938_75002,(0),null);
var factory_75004 = cljs.core.nth.call(null,vec__74938_75002,(1),null);
var canonical_f_75005 = (cljs.core.truth_(selector_74949)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74948,selector_74949):cljs.core.identity).call(null,factory_75004.call(null,f_74997));
dommy.core.update_event_listeners_BANG_.call(null,elem_74948,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74949,actual_type_75003,f_74997], null),canonical_f_75005);

if(cljs.core.truth_(elem_74948.addEventListener)){
elem_74948.addEventListener(cljs.core.name.call(null,actual_type_75003),canonical_f_75005);
} else {
elem_74948.attachEvent(cljs.core.name.call(null,actual_type_75003),canonical_f_75005);
}

var G__75006 = seq__74911_74998;
var G__75007 = chunk__74913_74999;
var G__75008 = count__74914_75000;
var G__75009 = (i__74915_75001 + (1));
seq__74911_74998 = G__75006;
chunk__74913_74999 = G__75007;
count__74914_75000 = G__75008;
i__74915_75001 = G__75009;
continue;
} else {
var temp__6753__auto___75010__$1 = cljs.core.seq.call(null,seq__74911_74998);
if(temp__6753__auto___75010__$1){
var seq__74911_75011__$1 = temp__6753__auto___75010__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74911_75011__$1)){
var c__67110__auto___75012 = cljs.core.chunk_first.call(null,seq__74911_75011__$1);
var G__75013 = cljs.core.chunk_rest.call(null,seq__74911_75011__$1);
var G__75014 = c__67110__auto___75012;
var G__75015 = cljs.core.count.call(null,c__67110__auto___75012);
var G__75016 = (0);
seq__74911_74998 = G__75013;
chunk__74913_74999 = G__75014;
count__74914_75000 = G__75015;
i__74915_75001 = G__75016;
continue;
} else {
var vec__74941_75017 = cljs.core.first.call(null,seq__74911_75011__$1);
var actual_type_75018 = cljs.core.nth.call(null,vec__74941_75017,(0),null);
var factory_75019 = cljs.core.nth.call(null,vec__74941_75017,(1),null);
var canonical_f_75020 = (cljs.core.truth_(selector_74949)?cljs.core.partial.call(null,dommy.core.live_listener,elem_74948,selector_74949):cljs.core.identity).call(null,factory_75019.call(null,f_74997));
dommy.core.update_event_listeners_BANG_.call(null,elem_74948,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_74949,actual_type_75018,f_74997], null),canonical_f_75020);

if(cljs.core.truth_(elem_74948.addEventListener)){
elem_74948.addEventListener(cljs.core.name.call(null,actual_type_75018),canonical_f_75020);
} else {
elem_74948.attachEvent(cljs.core.name.call(null,actual_type_75018),canonical_f_75020);
}

var G__75021 = cljs.core.next.call(null,seq__74911_75011__$1);
var G__75022 = null;
var G__75023 = (0);
var G__75024 = (0);
seq__74911_74998 = G__75021;
chunk__74913_74999 = G__75022;
count__74914_75000 = G__75023;
i__74915_75001 = G__75024;
continue;
}
} else {
}
}
break;
}

var G__75025 = cljs.core.next.call(null,seq__74910_74989__$1);
var G__75026 = null;
var G__75027 = (0);
var G__75028 = (0);
seq__74910_74950 = G__75025;
chunk__74917_74951 = G__75026;
count__74918_74952 = G__75027;
i__74919_74953 = G__75028;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq74905){
var G__74906 = cljs.core.first.call(null,seq74905);
var seq74905__$1 = cljs.core.next.call(null,seq74905);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__74906,seq74905__$1);
});

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75068 = arguments.length;
var i__67421__auto___75069 = (0);
while(true){
if((i__67421__auto___75069 < len__67420__auto___75068)){
args__67427__auto__.push((arguments[i__67421__auto___75069]));

var G__75070 = (i__67421__auto___75069 + (1));
i__67421__auto___75069 = G__75070;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__75031_75071 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_75072 = cljs.core.nth.call(null,vec__75031_75071,(0),null);
var selector_75073 = cljs.core.nth.call(null,vec__75031_75071,(1),null);
var seq__75034_75074 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__75041_75075 = null;
var count__75042_75076 = (0);
var i__75043_75077 = (0);
while(true){
if((i__75043_75077 < count__75042_75076)){
var vec__75050_75078 = cljs.core._nth.call(null,chunk__75041_75075,i__75043_75077);
var orig_type_75079 = cljs.core.nth.call(null,vec__75050_75078,(0),null);
var f_75080 = cljs.core.nth.call(null,vec__75050_75078,(1),null);
var seq__75044_75081 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_75079,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_75079,cljs.core.identity])));
var chunk__75046_75082 = null;
var count__75047_75083 = (0);
var i__75048_75084 = (0);
while(true){
if((i__75048_75084 < count__75047_75083)){
var vec__75053_75085 = cljs.core._nth.call(null,chunk__75046_75082,i__75048_75084);
var actual_type_75086 = cljs.core.nth.call(null,vec__75053_75085,(0),null);
var __75087 = cljs.core.nth.call(null,vec__75053_75085,(1),null);
var keys_75088 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_75073,actual_type_75086,f_75080], null);
var canonical_f_75089 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_75072),keys_75088);
dommy.core.update_event_listeners_BANG_.call(null,elem_75072,dommy.utils.dissoc_in,keys_75088);

if(cljs.core.truth_(elem_75072.removeEventListener)){
elem_75072.removeEventListener(cljs.core.name.call(null,actual_type_75086),canonical_f_75089);
} else {
elem_75072.detachEvent(cljs.core.name.call(null,actual_type_75086),canonical_f_75089);
}

var G__75090 = seq__75044_75081;
var G__75091 = chunk__75046_75082;
var G__75092 = count__75047_75083;
var G__75093 = (i__75048_75084 + (1));
seq__75044_75081 = G__75090;
chunk__75046_75082 = G__75091;
count__75047_75083 = G__75092;
i__75048_75084 = G__75093;
continue;
} else {
var temp__6753__auto___75094 = cljs.core.seq.call(null,seq__75044_75081);
if(temp__6753__auto___75094){
var seq__75044_75095__$1 = temp__6753__auto___75094;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__75044_75095__$1)){
var c__67110__auto___75096 = cljs.core.chunk_first.call(null,seq__75044_75095__$1);
var G__75097 = cljs.core.chunk_rest.call(null,seq__75044_75095__$1);
var G__75098 = c__67110__auto___75096;
var G__75099 = cljs.core.count.call(null,c__67110__auto___75096);
var G__75100 = (0);
seq__75044_75081 = G__75097;
chunk__75046_75082 = G__75098;
count__75047_75083 = G__75099;
i__75048_75084 = G__75100;
continue;
} else {
var vec__75056_75101 = cljs.core.first.call(null,seq__75044_75095__$1);
var actual_type_75102 = cljs.core.nth.call(null,vec__75056_75101,(0),null);
var __75103 = cljs.core.nth.call(null,vec__75056_75101,(1),null);
var keys_75104 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_75073,actual_type_75102,f_75080], null);
var canonical_f_75105 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_75072),keys_75104);
dommy.core.update_event_listeners_BANG_.call(null,elem_75072,dommy.utils.dissoc_in,keys_75104);

if(cljs.core.truth_(elem_75072.removeEventListener)){
elem_75072.removeEventListener(cljs.core.name.call(null,actual_type_75102),canonical_f_75105);
} else {
elem_75072.detachEvent(cljs.core.name.call(null,actual_type_75102),canonical_f_75105);
}

var G__75106 = cljs.core.next.call(null,seq__75044_75095__$1);
var G__75107 = null;
var G__75108 = (0);
var G__75109 = (0);
seq__75044_75081 = G__75106;
chunk__75046_75082 = G__75107;
count__75047_75083 = G__75108;
i__75048_75084 = G__75109;
continue;
}
} else {
}
}
break;
}

var G__75110 = seq__75034_75074;
var G__75111 = chunk__75041_75075;
var G__75112 = count__75042_75076;
var G__75113 = (i__75043_75077 + (1));
seq__75034_75074 = G__75110;
chunk__75041_75075 = G__75111;
count__75042_75076 = G__75112;
i__75043_75077 = G__75113;
continue;
} else {
var temp__6753__auto___75114 = cljs.core.seq.call(null,seq__75034_75074);
if(temp__6753__auto___75114){
var seq__75034_75115__$1 = temp__6753__auto___75114;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__75034_75115__$1)){
var c__67110__auto___75116 = cljs.core.chunk_first.call(null,seq__75034_75115__$1);
var G__75117 = cljs.core.chunk_rest.call(null,seq__75034_75115__$1);
var G__75118 = c__67110__auto___75116;
var G__75119 = cljs.core.count.call(null,c__67110__auto___75116);
var G__75120 = (0);
seq__75034_75074 = G__75117;
chunk__75041_75075 = G__75118;
count__75042_75076 = G__75119;
i__75043_75077 = G__75120;
continue;
} else {
var vec__75059_75121 = cljs.core.first.call(null,seq__75034_75115__$1);
var orig_type_75122 = cljs.core.nth.call(null,vec__75059_75121,(0),null);
var f_75123 = cljs.core.nth.call(null,vec__75059_75121,(1),null);
var seq__75035_75124 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_75122,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_75122,cljs.core.identity])));
var chunk__75037_75125 = null;
var count__75038_75126 = (0);
var i__75039_75127 = (0);
while(true){
if((i__75039_75127 < count__75038_75126)){
var vec__75062_75128 = cljs.core._nth.call(null,chunk__75037_75125,i__75039_75127);
var actual_type_75129 = cljs.core.nth.call(null,vec__75062_75128,(0),null);
var __75130 = cljs.core.nth.call(null,vec__75062_75128,(1),null);
var keys_75131 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_75073,actual_type_75129,f_75123], null);
var canonical_f_75132 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_75072),keys_75131);
dommy.core.update_event_listeners_BANG_.call(null,elem_75072,dommy.utils.dissoc_in,keys_75131);

if(cljs.core.truth_(elem_75072.removeEventListener)){
elem_75072.removeEventListener(cljs.core.name.call(null,actual_type_75129),canonical_f_75132);
} else {
elem_75072.detachEvent(cljs.core.name.call(null,actual_type_75129),canonical_f_75132);
}

var G__75133 = seq__75035_75124;
var G__75134 = chunk__75037_75125;
var G__75135 = count__75038_75126;
var G__75136 = (i__75039_75127 + (1));
seq__75035_75124 = G__75133;
chunk__75037_75125 = G__75134;
count__75038_75126 = G__75135;
i__75039_75127 = G__75136;
continue;
} else {
var temp__6753__auto___75137__$1 = cljs.core.seq.call(null,seq__75035_75124);
if(temp__6753__auto___75137__$1){
var seq__75035_75138__$1 = temp__6753__auto___75137__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__75035_75138__$1)){
var c__67110__auto___75139 = cljs.core.chunk_first.call(null,seq__75035_75138__$1);
var G__75140 = cljs.core.chunk_rest.call(null,seq__75035_75138__$1);
var G__75141 = c__67110__auto___75139;
var G__75142 = cljs.core.count.call(null,c__67110__auto___75139);
var G__75143 = (0);
seq__75035_75124 = G__75140;
chunk__75037_75125 = G__75141;
count__75038_75126 = G__75142;
i__75039_75127 = G__75143;
continue;
} else {
var vec__75065_75144 = cljs.core.first.call(null,seq__75035_75138__$1);
var actual_type_75145 = cljs.core.nth.call(null,vec__75065_75144,(0),null);
var __75146 = cljs.core.nth.call(null,vec__75065_75144,(1),null);
var keys_75147 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_75073,actual_type_75145,f_75123], null);
var canonical_f_75148 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_75072),keys_75147);
dommy.core.update_event_listeners_BANG_.call(null,elem_75072,dommy.utils.dissoc_in,keys_75147);

if(cljs.core.truth_(elem_75072.removeEventListener)){
elem_75072.removeEventListener(cljs.core.name.call(null,actual_type_75145),canonical_f_75148);
} else {
elem_75072.detachEvent(cljs.core.name.call(null,actual_type_75145),canonical_f_75148);
}

var G__75149 = cljs.core.next.call(null,seq__75035_75138__$1);
var G__75150 = null;
var G__75151 = (0);
var G__75152 = (0);
seq__75035_75124 = G__75149;
chunk__75037_75125 = G__75150;
count__75038_75126 = G__75151;
i__75039_75127 = G__75152;
continue;
}
} else {
}
}
break;
}

var G__75153 = cljs.core.next.call(null,seq__75034_75115__$1);
var G__75154 = null;
var G__75155 = (0);
var G__75156 = (0);
seq__75034_75074 = G__75153;
chunk__75041_75075 = G__75154;
count__75042_75076 = G__75155;
i__75043_75077 = G__75156;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq75029){
var G__75030 = cljs.core.first.call(null,seq75029);
var seq75029__$1 = cljs.core.next.call(null,seq75029);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__75030,seq75029__$1);
});

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75172 = arguments.length;
var i__67421__auto___75173 = (0);
while(true){
if((i__67421__auto___75173 < len__67420__auto___75172)){
args__67427__auto__.push((arguments[i__67421__auto___75173]));

var G__75174 = (i__67421__auto___75173 + (1));
i__67421__auto___75173 = G__75174;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__75159_75175 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_75176 = cljs.core.nth.call(null,vec__75159_75175,(0),null);
var selector_75177 = cljs.core.nth.call(null,vec__75159_75175,(1),null);
var seq__75162_75178 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__75163_75179 = null;
var count__75164_75180 = (0);
var i__75165_75181 = (0);
while(true){
if((i__75165_75181 < count__75164_75180)){
var vec__75166_75182 = cljs.core._nth.call(null,chunk__75163_75179,i__75165_75181);
var type_75183 = cljs.core.nth.call(null,vec__75166_75182,(0),null);
var f_75184 = cljs.core.nth.call(null,vec__75166_75182,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_75183,((function (seq__75162_75178,chunk__75163_75179,count__75164_75180,i__75165_75181,vec__75166_75182,type_75183,f_75184,vec__75159_75175,elem_75176,selector_75177){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_75183,dommy$core$this_fn);

return f_75184.call(null,e);
});})(seq__75162_75178,chunk__75163_75179,count__75164_75180,i__75165_75181,vec__75166_75182,type_75183,f_75184,vec__75159_75175,elem_75176,selector_75177))
);

var G__75185 = seq__75162_75178;
var G__75186 = chunk__75163_75179;
var G__75187 = count__75164_75180;
var G__75188 = (i__75165_75181 + (1));
seq__75162_75178 = G__75185;
chunk__75163_75179 = G__75186;
count__75164_75180 = G__75187;
i__75165_75181 = G__75188;
continue;
} else {
var temp__6753__auto___75189 = cljs.core.seq.call(null,seq__75162_75178);
if(temp__6753__auto___75189){
var seq__75162_75190__$1 = temp__6753__auto___75189;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__75162_75190__$1)){
var c__67110__auto___75191 = cljs.core.chunk_first.call(null,seq__75162_75190__$1);
var G__75192 = cljs.core.chunk_rest.call(null,seq__75162_75190__$1);
var G__75193 = c__67110__auto___75191;
var G__75194 = cljs.core.count.call(null,c__67110__auto___75191);
var G__75195 = (0);
seq__75162_75178 = G__75192;
chunk__75163_75179 = G__75193;
count__75164_75180 = G__75194;
i__75165_75181 = G__75195;
continue;
} else {
var vec__75169_75196 = cljs.core.first.call(null,seq__75162_75190__$1);
var type_75197 = cljs.core.nth.call(null,vec__75169_75196,(0),null);
var f_75198 = cljs.core.nth.call(null,vec__75169_75196,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_75197,((function (seq__75162_75178,chunk__75163_75179,count__75164_75180,i__75165_75181,vec__75169_75196,type_75197,f_75198,seq__75162_75190__$1,temp__6753__auto___75189,vec__75159_75175,elem_75176,selector_75177){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_75197,dommy$core$this_fn);

return f_75198.call(null,e);
});})(seq__75162_75178,chunk__75163_75179,count__75164_75180,i__75165_75181,vec__75169_75196,type_75197,f_75198,seq__75162_75190__$1,temp__6753__auto___75189,vec__75159_75175,elem_75176,selector_75177))
);

var G__75199 = cljs.core.next.call(null,seq__75162_75190__$1);
var G__75200 = null;
var G__75201 = (0);
var G__75202 = (0);
seq__75162_75178 = G__75199;
chunk__75163_75179 = G__75200;
count__75164_75180 = G__75201;
i__75165_75181 = G__75202;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq75157){
var G__75158 = cljs.core.first.call(null,seq75157);
var seq75157__$1 = cljs.core.next.call(null,seq75157);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__75158,seq75157__$1);
});


//# sourceMappingURL=core.js.map