// Compiled by ClojureScript 1.9.494 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__66187__auto__ = v;
if(cljs.core.truth_(and__66187__auto__)){
return (v > (0));
} else {
return and__66187__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__75309_SHARP_,p2__75308_SHARP_){
var vec__75313 = clojure.string.split.call(null,p2__75308_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__75313,(0),null);
var v = cljs.core.nth.call(null,vec__75313,(1),null);
return cljs.core.assoc.call(null,p1__75309_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__75316_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__75316_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__75317){
var vec__75321 = p__75317;
var k = cljs.core.nth.call(null,vec__75321,(0),null);
var v = cljs.core.nth.call(null,vec__75321,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__75324_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__75324_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__66187__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__66187__auto__){
var and__66187__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__66187__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__66187__auto____$1;
}
} else {
return and__66187__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__6751__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6751__auto__)){
var params = temp__6751__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__75325_SHARP_){
return cljs_http.client.decode_body.call(null,p1__75325_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75332 = arguments.length;
var i__67421__auto___75333 = (0);
while(true){
if((i__67421__auto___75333 < len__67420__auto___75332)){
args__67427__auto__.push((arguments[i__67421__auto___75333]));

var G__75334 = (i__67421__auto___75333 + (1));
i__67421__auto___75333 = G__75334;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__75328){
var vec__75329 = p__75328;
var default_headers = cljs.core.nth.call(null,vec__75329,(0),null);
return ((function (vec__75329,default_headers){
return (function (request){
var temp__6751__auto__ = (function (){var or__66199__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__6751__auto__)){
var default_headers__$1 = temp__6751__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__75329,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq75326){
var G__75327 = cljs.core.first.call(null,seq75326);
var seq75326__$1 = cljs.core.next.call(null,seq75326);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__75327,seq75326__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75341 = arguments.length;
var i__67421__auto___75342 = (0);
while(true){
if((i__67421__auto___75342 < len__67420__auto___75341)){
args__67427__auto__.push((arguments[i__67421__auto___75342]));

var G__75343 = (i__67421__auto___75342 + (1));
i__67421__auto___75342 = G__75343;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__75337){
var vec__75338 = p__75337;
var accept = cljs.core.nth.call(null,vec__75338,(0),null);
return ((function (vec__75338,accept){
return (function (request){
var temp__6751__auto__ = (function (){var or__66199__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__6751__auto__)){
var accept__$1 = temp__6751__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__75338,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq75335){
var G__75336 = cljs.core.first.call(null,seq75335);
var seq75335__$1 = cljs.core.next.call(null,seq75335);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__75336,seq75335__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75350 = arguments.length;
var i__67421__auto___75351 = (0);
while(true){
if((i__67421__auto___75351 < len__67420__auto___75350)){
args__67427__auto__.push((arguments[i__67421__auto___75351]));

var G__75352 = (i__67421__auto___75351 + (1));
i__67421__auto___75351 = G__75352;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__75346){
var vec__75347 = p__75346;
var content_type = cljs.core.nth.call(null,vec__75347,(0),null);
return ((function (vec__75347,content_type){
return (function (request){
var temp__6751__auto__ = (function (){var or__66199__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__6751__auto__)){
var content_type__$1 = temp__6751__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__75347,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq75344){
var G__75345 = cljs.core.first.call(null,seq75344);
var seq75344__$1 = cljs.core.next.call(null,seq75344);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__75345,seq75344__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__6751__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6751__auto__)){
var params = temp__6751__auto__;
var map__75355 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__75355__$1 = ((((!((map__75355 == null)))?((((map__75355.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75355.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75355):map__75355);
var encoding = cljs.core.get.call(null,map__75355__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__75355__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__75361 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__75361__$1 = ((((!((map__75361 == null)))?((((map__75361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75361.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75361):map__75361);
var decoding = cljs.core.get.call(null,map__75361__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__75361__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__75361,map__75361__$1,decoding,decoding_opts){
return (function (p1__75357_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__75357_SHARP_,decoding,decoding_opts);
});})(map__75361,map__75361__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__75361,map__75361__$1,decoding,decoding_opts,transit_decode){
return (function (p1__75358_SHARP_){
return cljs_http.client.decode_body.call(null,p1__75358_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__75361,map__75361__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__6751__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6751__auto__)){
var params = temp__6751__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__75363_SHARP_){
return cljs_http.client.decode_body.call(null,p1__75363_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__75367){
var map__75368 = p__75367;
var map__75368__$1 = ((((!((map__75368 == null)))?((((map__75368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75368.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75368):map__75368);
var req = map__75368__$1;
var query_params = cljs.core.get.call(null,map__75368__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__75373){
var map__75374 = p__75373;
var map__75374__$1 = ((((!((map__75374 == null)))?((((map__75374.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75374.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75374):map__75374);
var request = map__75374__$1;
var form_params = cljs.core.get.call(null,map__75374__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__75374__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__75374__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__66187__auto__ = form_params;
if(cljs.core.truth_(and__66187__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__66187__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__75386_75396 = cljs.core.seq.call(null,params);
var chunk__75387_75397 = null;
var count__75388_75398 = (0);
var i__75389_75399 = (0);
while(true){
if((i__75389_75399 < count__75388_75398)){
var vec__75390_75400 = cljs.core._nth.call(null,chunk__75387_75397,i__75389_75399);
var k_75401 = cljs.core.nth.call(null,vec__75390_75400,(0),null);
var v_75402 = cljs.core.nth.call(null,vec__75390_75400,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_75402)){
form_data.append(cljs.core.name.call(null,k_75401),cljs.core.first.call(null,v_75402),cljs.core.second.call(null,v_75402));
} else {
form_data.append(cljs.core.name.call(null,k_75401),v_75402);
}

var G__75403 = seq__75386_75396;
var G__75404 = chunk__75387_75397;
var G__75405 = count__75388_75398;
var G__75406 = (i__75389_75399 + (1));
seq__75386_75396 = G__75403;
chunk__75387_75397 = G__75404;
count__75388_75398 = G__75405;
i__75389_75399 = G__75406;
continue;
} else {
var temp__6753__auto___75407 = cljs.core.seq.call(null,seq__75386_75396);
if(temp__6753__auto___75407){
var seq__75386_75408__$1 = temp__6753__auto___75407;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__75386_75408__$1)){
var c__67110__auto___75409 = cljs.core.chunk_first.call(null,seq__75386_75408__$1);
var G__75410 = cljs.core.chunk_rest.call(null,seq__75386_75408__$1);
var G__75411 = c__67110__auto___75409;
var G__75412 = cljs.core.count.call(null,c__67110__auto___75409);
var G__75413 = (0);
seq__75386_75396 = G__75410;
chunk__75387_75397 = G__75411;
count__75388_75398 = G__75412;
i__75389_75399 = G__75413;
continue;
} else {
var vec__75393_75414 = cljs.core.first.call(null,seq__75386_75408__$1);
var k_75415 = cljs.core.nth.call(null,vec__75393_75414,(0),null);
var v_75416 = cljs.core.nth.call(null,vec__75393_75414,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_75416)){
form_data.append(cljs.core.name.call(null,k_75415),cljs.core.first.call(null,v_75416),cljs.core.second.call(null,v_75416));
} else {
form_data.append(cljs.core.name.call(null,k_75415),v_75416);
}

var G__75417 = cljs.core.next.call(null,seq__75386_75408__$1);
var G__75418 = null;
var G__75419 = (0);
var G__75420 = (0);
seq__75386_75396 = G__75417;
chunk__75387_75397 = G__75418;
count__75388_75398 = G__75419;
i__75389_75399 = G__75420;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__75424){
var map__75425 = p__75424;
var map__75425__$1 = ((((!((map__75425 == null)))?((((map__75425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75425.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75425):map__75425);
var request = map__75425__$1;
var multipart_params = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__75425__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__66187__auto__ = multipart_params;
if(cljs.core.truth_(and__66187__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__66187__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__6751__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6751__auto__)){
var m = temp__6751__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__75427_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__75427_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__75432){
var map__75433 = p__75432;
var map__75433__$1 = ((((!((map__75433 == null)))?((((map__75433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75433.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75433):map__75433);
var req = map__75433__$1;
var query_params = cljs.core.get.call(null,map__75433__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__6751__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__6751__auto__)){
var spec = temp__6751__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__6751__auto__,map__75433,map__75433__$1,req,query_params){
return (function (p1__75428_SHARP_){
return cljs.core.merge.call(null,p1__75428_SHARP_,query_params);
});})(spec,temp__6751__auto__,map__75433,map__75433__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75441 = arguments.length;
var i__67421__auto___75442 = (0);
while(true){
if((i__67421__auto___75442 < len__67420__auto___75441)){
args__67427__auto__.push((arguments[i__67421__auto___75442]));

var G__75443 = (i__67421__auto___75442 + (1));
i__67421__auto___75442 = G__75443;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__75437){
var vec__75438 = p__75437;
var credentials = cljs.core.nth.call(null,vec__75438,(0),null);
return ((function (vec__75438,credentials){
return (function (req){
var credentials__$1 = (function (){var or__66199__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__75438,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq75435){
var G__75436 = cljs.core.first.call(null,seq75435);
var seq75435__$1 = cljs.core.next.call(null,seq75435);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__75436,seq75435__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__6751__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6751__auto__)){
var oauth_token = temp__6751__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__6751__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__6751__auto__)){
var custom_channel = temp__6751__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75450 = arguments.length;
var i__67421__auto___75451 = (0);
while(true){
if((i__67421__auto___75451 < len__67420__auto___75450)){
args__67427__auto__.push((arguments[i__67421__auto___75451]));

var G__75452 = (i__67421__auto___75451 + (1));
i__67421__auto___75451 = G__75452;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75446){
var vec__75447 = p__75446;
var req = cljs.core.nth.call(null,vec__75447,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq75444){
var G__75445 = cljs.core.first.call(null,seq75444);
var seq75444__$1 = cljs.core.next.call(null,seq75444);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__75445,seq75444__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75459 = arguments.length;
var i__67421__auto___75460 = (0);
while(true){
if((i__67421__auto___75460 < len__67420__auto___75459)){
args__67427__auto__.push((arguments[i__67421__auto___75460]));

var G__75461 = (i__67421__auto___75460 + (1));
i__67421__auto___75460 = G__75461;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75455){
var vec__75456 = p__75455;
var req = cljs.core.nth.call(null,vec__75456,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq75453){
var G__75454 = cljs.core.first.call(null,seq75453);
var seq75453__$1 = cljs.core.next.call(null,seq75453);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__75454,seq75453__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75468 = arguments.length;
var i__67421__auto___75469 = (0);
while(true){
if((i__67421__auto___75469 < len__67420__auto___75468)){
args__67427__auto__.push((arguments[i__67421__auto___75469]));

var G__75470 = (i__67421__auto___75469 + (1));
i__67421__auto___75469 = G__75470;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75464){
var vec__75465 = p__75464;
var req = cljs.core.nth.call(null,vec__75465,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq75462){
var G__75463 = cljs.core.first.call(null,seq75462);
var seq75462__$1 = cljs.core.next.call(null,seq75462);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__75463,seq75462__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75477 = arguments.length;
var i__67421__auto___75478 = (0);
while(true){
if((i__67421__auto___75478 < len__67420__auto___75477)){
args__67427__auto__.push((arguments[i__67421__auto___75478]));

var G__75479 = (i__67421__auto___75478 + (1));
i__67421__auto___75478 = G__75479;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75473){
var vec__75474 = p__75473;
var req = cljs.core.nth.call(null,vec__75474,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq75471){
var G__75472 = cljs.core.first.call(null,seq75471);
var seq75471__$1 = cljs.core.next.call(null,seq75471);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__75472,seq75471__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75486 = arguments.length;
var i__67421__auto___75487 = (0);
while(true){
if((i__67421__auto___75487 < len__67420__auto___75486)){
args__67427__auto__.push((arguments[i__67421__auto___75487]));

var G__75488 = (i__67421__auto___75487 + (1));
i__67421__auto___75487 = G__75488;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75482){
var vec__75483 = p__75482;
var req = cljs.core.nth.call(null,vec__75483,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq75480){
var G__75481 = cljs.core.first.call(null,seq75480);
var seq75480__$1 = cljs.core.next.call(null,seq75480);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__75481,seq75480__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75495 = arguments.length;
var i__67421__auto___75496 = (0);
while(true){
if((i__67421__auto___75496 < len__67420__auto___75495)){
args__67427__auto__.push((arguments[i__67421__auto___75496]));

var G__75497 = (i__67421__auto___75496 + (1));
i__67421__auto___75496 = G__75497;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75491){
var vec__75492 = p__75491;
var req = cljs.core.nth.call(null,vec__75492,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq75489){
var G__75490 = cljs.core.first.call(null,seq75489);
var seq75489__$1 = cljs.core.next.call(null,seq75489);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__75490,seq75489__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75504 = arguments.length;
var i__67421__auto___75505 = (0);
while(true){
if((i__67421__auto___75505 < len__67420__auto___75504)){
args__67427__auto__.push((arguments[i__67421__auto___75505]));

var G__75506 = (i__67421__auto___75505 + (1));
i__67421__auto___75505 = G__75506;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75500){
var vec__75501 = p__75500;
var req = cljs.core.nth.call(null,vec__75501,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq75498){
var G__75499 = cljs.core.first.call(null,seq75498);
var seq75498__$1 = cljs.core.next.call(null,seq75498);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__75499,seq75498__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75513 = arguments.length;
var i__67421__auto___75514 = (0);
while(true){
if((i__67421__auto___75514 < len__67420__auto___75513)){
args__67427__auto__.push((arguments[i__67421__auto___75514]));

var G__75515 = (i__67421__auto___75514 + (1));
i__67421__auto___75514 = G__75515;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75509){
var vec__75510 = p__75509;
var req = cljs.core.nth.call(null,vec__75510,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq75507){
var G__75508 = cljs.core.first.call(null,seq75507);
var seq75507__$1 = cljs.core.next.call(null,seq75507);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__75508,seq75507__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__67427__auto__ = [];
var len__67420__auto___75522 = arguments.length;
var i__67421__auto___75523 = (0);
while(true){
if((i__67421__auto___75523 < len__67420__auto___75522)){
args__67427__auto__.push((arguments[i__67421__auto___75523]));

var G__75524 = (i__67421__auto___75523 + (1));
i__67421__auto___75523 = G__75524;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__75518){
var vec__75519 = p__75518;
var req = cljs.core.nth.call(null,vec__75519,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq75516){
var G__75517 = cljs.core.first.call(null,seq75516);
var seq75516__$1 = cljs.core.next.call(null,seq75516);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__75517,seq75516__$1);
});


//# sourceMappingURL=client.js.map