(ns talk.pearson
  (:require [cuerdas.core :as str]
            [garden.core :as garden]
            [garden.stylesheet :as gs]
            [mathdoc.cljs.svg :as svg]
            [reagent.core :as r]))

(def color
  {:yellow  "#b58900"
   :orange  "#cb4b16"
   :red     "#dc322f"
   :magenta "#d33682"
   :violet  "#6c71c4"
   :blue    "#268bd2"
   :cyan    "#2aa198"
   :green   "#859900"})

(def frags
  {:data 0
   :mixture 1
   :figure 2})

(defn style []
  [:style
   (garden/css
    ["#pearson"
     [:text.label {:fill       (:blue color)
                   :filter      "brightness(1.5)"
                   :font-weight "bold"
                   :font-size   "100px"}]
     [:.pearsonplot.fragment.visible
      {:animation "dash 2s linear forwards"}]
     [:.pearsonplot.fragment
      {:stroke-dashoffset 8000
       :stroke-dasharray  8000}]
     [:.pearsonplot
      {:opacity      0.7
       :stroke-width 15
       :fill         "none"
       :stroke       (:magenta color)}]])])

(defn point-sum [p q]
  (map + p q))

(defn negate-point [p]
  (map - p))

#_ (negate-point [1 2])

(defn point-deltas [deltas]
  (partition 2 deltas))

(defn total-delta [point-deltas]
  (reduce point-sum point-deltas))

(defn reverse-deltas [& deltas]
  (apply concat
         (total-delta (point-deltas deltas))
         (map negate-point (reverse (next (point-deltas deltas)))))

  #_(apply
   concat
   (total-delta deltas)
   (map negate-point (reverse deltas))))

#_(reduce #(map + %1 %2) (partition 2 [1 2 3 4 5 6 7 8 9 10]))

#_(apply reverse-deltas [10000 10000 1 2 3 4 5 6 7 8 9 10])

#_(total-delta [1 2 3 4 5 6 7 8 9 10])

(defn label []
  [:g.fragment
   {:data-fragment-index (:data frags)}
   [:text.label
    {:style {:transform "translate(-60px,-100px)"}}
    "forehead width"]
   [:path {:style {:stroke (:blue color)
                   :stroke-width "15px"}
           :d (svg/path-d :m
                          0,30
                          0,-60
                          0,30
                          500,0
                          0,30
                          0,-60)}]])

(defn pearson []
  [:div {:style {:position "absolute"}}
   [style]
   [:svg.fragment.fade-out
    {:viewBox "350 360 4355 2825"
     :height  "800"
     :style {:transition "all 0.7s ease 0.35s"}
     :data-fragment-index (:figure frags)}
    [:g {:style {:transform "translate(706px, 926px)"}}
     [label]]
    [:path.pearsonplot.fragment
     {:data-fragment-index (:data frags)
      :style {:stroke (:blue color)}
      :d (svg/path-d :m
                     (reverse-deltas
                      1068.6752,2493.5754
                      189.3855,-90.1835
                      87.9289,60.8739
                      90.1836,-124.0024
                      144.2937,-103.7111
                      72.1468,-126.257
                      94.6928,-29.3097
                      65.383,-117.2386
                      72.1469,-272.8053
                      81.1652,178.1126
                      47.3464,-286.3328
                      6.7637,-164.585
                      31.5643,-121.7478
                      72.1468,-47.3464
                      81.1652,153.312
                      40.5826,-238.9864
                      40.5826,-189.38546
                      54.1102,-155.56664
                      65.383,-24.80048
                      101.4566,-225.4589))}]
    [:path.pearsonplot.fragment
     {:data-fragment-index (:data frags)
      :style {:stroke (:blue color)}
      :d "m 2505.6752,577.5754  105.9656,322.40623 54.1102,189.38545 33.8188,254.7686 42.8372,232.2226 69.8923,92.4382 38.328,169.0942 33.8188,198.4038 99.2019,135.2753 49.601,178.1126 162.3304,160.0758 72.1468,-18.0367 92.4382,42.8372 171.3487,-27.0551"}]
    [:path.pearsonplot.fragment
     {:data-fragment-index (:mixture frags)
      :style {:stroke (:yellow color)}
      :d "m 2516.1213,983.0008 c -139.7845,0 -259.2777,692.1588 -306.6241,829.6887 -47.3464,137.53 -121.7478,680.8859 -543.3559,689.9043 -421.6082,9.0183 -604.2299,2.2546 -604.2299,2.2546"}]
    [:path.pearsonplot.fragment
     {:data-fragment-index (:mixture frags)
      :style {:stroke (:yellow color)}
      :d "m 2515.7263,983.0008 c 139.7845,0 259.2777,692.1588 306.6241,829.6887 47.3464,137.53 121.7478,680.8859 543.3559,689.9043"}]
    [:path.pearsonplot.fragment
     {:data-fragment-index (:mixture frags)
      :style {:stroke (:red color)}
      :d "m 2078.731,1747.3065 c 259.2778,0 257.0232,295.3511 459.9362,500.5187 202.913,205.1676 306.6241,250.2594 732.7414,254.7686"}]
    [:path.pearsonplot.fragment
     {:data-fragment-index (:mixture frags)
      :style {:stroke (:red color)}
      :d "m 2081.4139,1747.3065 c -259.2778,0 -257.0232,295.3511 -459.9362,500.5187 -202.913,205.1676 -306.6241,250.2594 -732.7414,254.7686"}]]])

(defn init []
  (some->> "pearson"
           (.getElementById js/document)
           (r/render [pearson])))

