// Compiled by ClojureScript 1.9.494 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.ratom');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(!((reagent.dom.imported == null))){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__66187__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_68092 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_68092){
return (function (){
var _STAR_always_update_STAR_68093 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(!((callback == null))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_68093;
}});})(_STAR_always_update_STAR_68092))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_68092;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args68094 = [];
var len__67408__auto___68097 = arguments.length;
var i__67409__auto___68098 = (0);
while(true){
if((i__67409__auto___68098 < len__67408__auto___68097)){
args68094.push((arguments[i__67409__auto___68098]));

var G__68099 = (i__67409__auto___68098 + (1));
i__67409__auto___68098 = G__68099;
continue;
} else {
}
break;
}

var G__68096 = args68094.length;
switch (G__68096) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args68094.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__68105_68109 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__68106_68110 = null;
var count__68107_68111 = (0);
var i__68108_68112 = (0);
while(true){
if((i__68108_68112 < count__68107_68111)){
var v_68113 = cljs.core._nth.call(null,chunk__68106_68110,i__68108_68112);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_68113);

var G__68114 = seq__68105_68109;
var G__68115 = chunk__68106_68110;
var G__68116 = count__68107_68111;
var G__68117 = (i__68108_68112 + (1));
seq__68105_68109 = G__68114;
chunk__68106_68110 = G__68115;
count__68107_68111 = G__68116;
i__68108_68112 = G__68117;
continue;
} else {
var temp__6753__auto___68118 = cljs.core.seq.call(null,seq__68105_68109);
if(temp__6753__auto___68118){
var seq__68105_68119__$1 = temp__6753__auto___68118;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__68105_68119__$1)){
var c__67098__auto___68120 = cljs.core.chunk_first.call(null,seq__68105_68119__$1);
var G__68121 = cljs.core.chunk_rest.call(null,seq__68105_68119__$1);
var G__68122 = c__67098__auto___68120;
var G__68123 = cljs.core.count.call(null,c__67098__auto___68120);
var G__68124 = (0);
seq__68105_68109 = G__68121;
chunk__68106_68110 = G__68122;
count__68107_68111 = G__68123;
i__68108_68112 = G__68124;
continue;
} else {
var v_68125 = cljs.core.first.call(null,seq__68105_68119__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_68125);

var G__68126 = cljs.core.next.call(null,seq__68105_68119__$1);
var G__68127 = null;
var G__68128 = (0);
var G__68129 = (0);
seq__68105_68109 = G__68126;
chunk__68106_68110 = G__68127;
count__68107_68111 = G__68128;
i__68108_68112 = G__68129;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map