(defproject org.dsteurer/mathdoc.dev "0.1.0-SNAPSHOT"
  :description "part of mathdoc project"
  :url "http://dsteurer.org"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies
  [[org.clojure/clojure "1.9.0-alpha14"]

   ;; webjars bower
   [org.webjars.bower/reveal.js "3.4.1"
    ;; avoid version range warning
    :exclusions [org.webjars.bower/headjs]]
   [org.webjars.bower/headjs "1.0.3"]
   [org.webjars.bower/lodash "4.17.4"]

   ;; webjars npm
   [org.webjars.npm/mathjax "2.7.0"]
   [org.webjars.npm/highlight.js "9.9.0"]
   [org.webjars.npm/bootstrap "4.0.0-alpha.6"
    ;; avoid version range warning
    :exclusions [org.webjars.npm/tether
                 org.webjars.npm/jquery]]
   [org.webjars.npm/tether "1.4.0"]
   [org.webjars.npm/jquery "3.1.1"]
   [org.webjars.npm/katex "0.7.1"
    ;; avoid version range warning
    :exclusions [org.webjars.npm/match-at]]
   [org.webjars.npm/match-at "0.1.0"]

   ;; webjars classic
   [org.webjars/font-awesome "4.7.0"]
   [org.webjars/normalize.css "5.0.0"]

   ;; mathdoc
   [mathdoc.cljs "0.1.0-SNAPSHOT"]
   [mathdoc.process "0.1.0-SNAPSHOT"]
   [mathdoc.main "0.1.0-SNAPSHOT"]
   [mathdoc.compiler "0.1.0-SNAPSHOT"]
   [mathdoc.server "0.1.0-SNAPSHOT"]
   [mathdoc.dependencies "0.1.2-SNAPSHOT"]
   [mathdoc.core "0.1.0-SNAPSHOT"]]

  :profiles
  {:dev
   {:dependencies [[integrant/repl "0.1.1"]
                   [com.cemerick/piggieback "0.2.1"]]
    :source-paths ["../../talks/cljs"]
    :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}})
