(ns mathdoc.compiler.cljs
  (:require cljs.build.api
            [clojure.spec :as s]
            [integrant.core :as ig]))

;;; specs

(s/def ::sources (s/coll-of string?))

(s/def ::output-dir string?)
(s/def ::output-to string?)
(s/def ::asset-path string?)

(s/def ::preloads (s/coll-of symbol?))
(s/def ::main symbol?)

(s/def ::config
  (s/keys :req-un [::sources ::output-dir
                   ::output-to ::asset-path
                   ::preloads ::main]))

(s/def ::public string?)

(defmethod ig/init-key
  ::public
  [_ v]
  {:pre [(s/assert ::public v)]}
  v)

;;; implementation

(defmethod ig/init-key
  :mathdoc.compiler/cljs
  [_ {:keys [sources output-dir output-to preloads main asset-path]
      :as   config}]
  {:pre [(s/assert ::config config)]}
  (cljs.build.api/build
   (apply cljs.build.api/inputs sources)
   (merge
    {:source-map    true
     :verbose       true
     :pretty-print  true
     :optimizations :none}
    (dissoc config :source))))

;;; tests

(comment

  (time
   (cljs.build.api/build
    "src" #_["src" "../../talks/cljs"]
    {:output-to     "resources/mathdoc/build/cljs/public/js/compiled/main.js"
     :output-dir    "resources/mathdoc/build/cljs/public/js/compiled/out"
     :main          'mathdoc.cljs.core
     :asset-path    "/js/compiled/out"
     :source-map    true
     :verbose       true
     :pretty-print  true
     :preloads      ['devtools.preload]
     :optimizations :none}))

  )
