(ns mathdoc.compiler
  (:gen-class)
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [clojure.spec.test :as stest]
            [duct.core :as duct]
            [integrant.core :as ig]))

(defn read-config [f]
  (duct/read-config
    (io/resource "mathdoc/core/config.edn")
    (io/resource "mathdoc/server/config.edn")
    (io/resource "mathdoc/compiler/config.edn")
    (io/resource "mathdoc/cljs/config.edn")
    (io/file f)))

(comment

  (read-config "config.edn")

  (first nil)
  )

(defn -main [& args]
  (stest/instrument (stest/instrumentable-syms))
  (s/check-asserts true)
  (-> (read-config (or (first args) "config.edn"))
      duct/prep
      (ig/init [:mathdoc.compiler/cljs]) ))

#_(-main)

