(ns mathdoc.cljs.core
  (:require [mathdoc.cljs.notes :as mnotes]
            [integrant.core :as ig]
            [taoensso.timbre :as log]
            [mathdoc.cljs.copynode :as cn]
            [mathdoc.cljs.drawmenu :as dm]
            [cljs.core.async :as a]
            [mathdoc.cljs.reveal :as reveal]
            [mathdoc.cljs.system :as system]
            [mathdoc.cljs.loadcanvas :as loadcanvas]
            [mathdoc.cljs.download :as download]))

(enable-console-print!)

(defonce reload-state
  (atom 0))

(defn on-js-reload []
  (swap! reload-state inc)
  (system/reset))

(defn config []
  (merge
   dm/config
   cn/config
   loadcanvas/config
   reveal/config
   download/config))

(defn init []
  (log/info ::init)
  (system/set-prep! config)
  (system/reset))

(comment

  (init)

  @system/system

  (methods )

  (println "test")
  (js/console.log (range 10))
  (js/console.log (zipmap (range 10) (map inc (range 10))))

  )
