(ns mathdoc.cljs.system
  (:require [integrant.core :as ig]))

(defonce system (atom nil))

(defonce prep (atom (constantly {})))

(defn set-prep! [f]
  (reset! prep f)
  ::prepped)

(defn reset []
  (when @system
    (ig/suspend! @system))
  (reset! system (if @system
                   (ig/resume (@prep) @system)
                   (ig/init (@prep))))
  ::reset)

(comment

  @system

  @(:mathdoc.cljs.loadcanvas/canvas-delay @system)

  (cljs.core.async/poll! (:mathdoc.cljs.reveal/ready @system))

  (promise )

  (reset! system nil)

  (reset)

  (set-prep! (constantly {}))

  )
