(ns latex-compile.core
  (:require [clojure.java.io :as io]
            [com.stuartsierra.component :as component]
            [latex-compile.config :as config]
            [latex-compile.system :as system]
            [latex-compile.helpers :as helpers]
            [text-decoration.core :as deco])
  (:gen-class))

(defn add-shutdown-hook! [^Runnable f]
  (.addShutdownHook (Runtime/getRuntime)
                    (Thread. f)))

(defn logged-shutdown [system]
  (helpers/printfln-deco [:yellow] "shutting down")
  (swap! system component/stop))

(defn run-forever []
  (let [forever (java.util.concurrent.Semaphore. 0)]
    (.acquire forever)))

(defn -main [& [configfile]]
  (let [config (config/config-from (io/file configfile))
        sys (atom (system/new-system config))]
    (helpers/printfln-deco [:cyan]
                           "[latex-compile] config-file: %s\nconfig: %s"
                           configfile (prn-str config))
    (add-shutdown-hook! (partial logged-shutdown sys))
    (swap! sys component/start)
    (run-forever)))
