(ns latex-compile.latex.log
  (:require [latex-compile.latex.regexp :refer [latex-regexs
                                                latex-regexs-pre]]
            [clojure.string :as str]))

(defn preprocess [log]
  (let [lines (str/split-lines log)
        {:keys [bad-pdftex-warning]} latex-regexs-pre]
    (->> lines
         (map
          (juxt identity (partial re-find (:re bad-pdftex-warning))))
         (map
          (fn [[old bad]]
            (if (nil? bad)
              (list old)
              (drop 1 bad))))
         (apply concat))))



(defn parse [log & {:keys [full?]}]
  (let [log (preprocess log)]
    (->> (for [line log]
           (->> (for [[key finder] latex-regexs
                      :let [match (finder line)]
                      :when (not (nil? match))]
                  [key match])
                (#(when (or full? (seq %)) ; add log only if it makes sense
                    (conj % [:log line])))
                (into {})
                ))
         (remove empty?)
         )))
