(ns doctex.core
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [doctex
             [specs :as specs]
             [util :as util]]))

(util/derive-all
 {::root              ::specs/assert
  ::output-dir        ::specs/assert
  ::content-dir       ::specs/assert
  ::template-dir      ::specs/assert
  ::bib-dir           ::specs/assert
  ::document-dir      ::specs/assert
  ::docs-file         ::specs/assert
  ::template-path     ::specs/conform
  ::content-path      ::specs/conform
  ::document-path     ::specs/join-paths
  ::template-path-url ::specs/conform
  ::bib-path          ::specs/join-paths})

(s/def ::template-path
  (s/and ::specs/join-paths
         ::specs/exists-path))

(s/def ::template-path-url
  ::specs/url)

(s/def ::content-path
  (s/and ::specs/join-paths
         ::specs/exists-path))

(s/def ::root
  (s/and ::specs/path-string
         ::specs/exists-path))

(s/def ::output-dir
  ::specs/path-string)

(s/def ::template-dir
  ::specs/path-string)

(s/def ::document-dir
  ::specs/path-string)

(s/def ::bib-dir
  ::specs/path-string)

(s/def ::content-dir
  ::specs/path-string)

(s/def ::docs-file
  ::specs/path-string)

(defn read-config [& sources]
  (->> sources
       (flatten)
       (partition 2)
       (map
        (fn [[variant source]]
          (case variant
            :resource (io/resource source)
            :file (io/file source))))
       (apply util/read-config)))
