(ns doctex.main
  (:gen-class)
  (:require [doctex.util :as util]
            [clojure.java.io :as io]
            [duct.core :as duct]
            [clojure.spec.test :as stest]
            [clojure.spec :as s]))

;; enable safety checks
(stest/instrument (stest/instrumentable-syms))
(s/check-asserts true)

(defn read-config [files]
  (apply util/read-config
   (io/resource "doctex/config.edn")
   files))

(defn -main [& files]
  (->> files
       (read-config)
       (duct/exec)))
