(ns doctex.main
  (:gen-class)
  (:require [doctex.util :as util]
            [clojure.java.io :as io]
            [duct.core :as duct]
            [clojure.spec.test.alpha :as stest]
            [clojure.spec.alpha :as s]
            [doctex.core :as core]))

;; enable safety checks
(stest/instrument (stest/instrumentable-syms))
(s/check-asserts true)

(defn read-config [files]
  (apply
   core/read-config
   :resource "doctex/config.edn"
   :resource "doctex/make/config.edn"
   :resource "doctex/document/config.edn"
   (map vector (repeat :file) files)))

(comment
  (read-config ["dev/resources/dev.edn"]))

(defn -main [& files]
  (try
    (->> files
         (read-config)
         (duct/exec))
    (catch Throwable t
      (println :fatal/exec (util/ex-messages t))
      ;; TODO: should try to start the logger and log the full exception
      )))
