(ns doctex.js
  (:require [clojure.java.io :as io]
            [integrant.core :as ig])
  (:import javax.script.ScriptEngineManager))

(defmethod ig/init-key
  ::engine
  [_ {}]
  (.getEngineByName (ScriptEngineManager.) "nashorn"))

;; TODO: use invoke method instead
;; no need for gensym business
;; https://pupeno.com/2015/09/14/isomorphic-clojurescript-javascript-for-pre-rendering-single-page-applications-part-2/

(defmethod ig/init-key
  ::requirejs-shim
  [_ {:keys [resource engine]}]
  (let [var (str (gensym))
        x (str (gensym))]
    (doto engine
      (.eval (format
              "var %s = {}; function define (%s) {%s = %s.call();}"
              var x var x))
      (.eval (io/reader (io/resource resource))))
    var))

(defmethod ig/init-key
  ::put
  [_ {:keys [file var engine]}]
  (let [var (str (gensym))]
    (doto engine
      (.put var (slurp file)))
    var))

(defmethod ig/init-key
  ::get
  [_ {:keys [expression-format engine]}]
  (let [var (str (gensym))]
    (.eval engine (str "var " var " = " (apply format expression-format)))
    (.get engine var)))
