(ns doctex.core
  (:require [clojure.spec :as s]
            [integrant.core :as ig]
            [doctex.util :as util]
            [clojure.java.io :as io]
            [doctex.specs :as specs]))

(util/derive-all
 {::root          ::specs/assert
  ::output-dir    ::specs/assert
  ::template-path ::specs/conform
  ::content-path  ::specs/conform
  ::document-path ::specs/join-paths
  ::bib-path      ::specs/join-paths})

(s/def ::template-path
  (s/and ::specs/join-paths
         ::specs/exists-path))

(s/def ::content-path
  (s/and ::specs/join-paths
         ::specs/exists-path))

(s/def ::root
  (s/and ::specs/path-string
         ::specs/exists-path))

(s/def ::output-dir
  (s/and ::specs/path-string))
